/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.cardiac.PolarPoint;
import com.mimvista.cardiac.SampledPolarTransformModel;
import com.mimvista.cardiac.UniformSampling;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    final UniformSampling sampling;
    LinkedHashMap<PolarPoint, Float> data;

    public DataModel(UniformSampling uniformSampling) {
        this.sampling = uniformSampling;
        this.data = Maps.newLinkedHashMap();
        for (PolarPoint polarPoint : uniformSampling.a()) {
            this.data.put(polarPoint, Float.valueOf(Float.NaN));
        }
    }

    public DataModel a() {
        DataModel dataModel = new DataModel(this.sampling);
        for (PolarPoint polarPoint : this.data.keySet()) {
            dataModel.data.replace(polarPoint, this.data.get(polarPoint));
        }
        return dataModel;
    }

    public UniformSampling b() {
        return this.sampling;
    }

    public List<SampledPolarTransformModel.Sample> c() {
        return this.data.entrySet().stream().map(entry -> new SampledPolarTransformModel.Sample((PolarPoint)entry.getKey(), ((Float)entry.getValue()).floatValue())).collect(Collectors.toList());
    }

    protected synchronized void a(Function<SampledPolarTransformModel.Sample, Float> function) {
        this.c().forEach(sample -> {
            Float cfr_ignored_0 = (Float)this.data.replace(sample.point, (Float)function.apply((SampledPolarTransformModel.Sample)sample));
        });
    }

    protected synchronized void a(UnaryOperator<Float> unaryOperator) {
        this.data.entrySet().forEach(entry -> {
            Float cfr_ignored_0 = (Float)entry.setValue(unaryOperator.apply((Float)entry.getValue()));
        });
    }

    protected void a(PolarPoint polarPoint, float f2) {
        this.data.replace(polarPoint, Float.valueOf(f2));
    }

    public List<PolarPoint> d() {
        return Collections.unmodifiableList(Lists.newArrayList(this.data.keySet()));
    }

    protected float a(PolarPoint polarPoint) {
        return this.data.get(polarPoint).floatValue();
    }

    protected boolean b(PolarPoint polarPoint) {
        return this.data.containsKey(polarPoint);
    }

    public float c(PolarPoint polarPoint) {
        return this.sampling.a(polarPoint, Collections.unmodifiableMap(this.data));
    }

    synchronized void a(Map<PolarPoint, Float> map) {
        if (!map.keySet().equals(this.data.keySet())) {
            throw new IllegalArgumentException("Data not compatible with sampling");
        }
        this.data.entrySet().forEach(entry -> {
            Float cfr_ignored_0 = (Float)entry.setValue(map.get(entry.getKey()));
        });
    }

    public boolean a(DataModel dataModel) {
        return dataModel.getClass() == this.getClass() && dataModel.sampling.a(this.sampling);
    }

    static DataModel a(BinaryOperator<Float> binaryOperator, DataModel ... dataModelArray) {
        for (int i2 = 1; i2 < dataModelArray.length; ++i2) {
            if (dataModelArray[0].a(dataModelArray[i2])) continue;
            throw new IllegalArgumentException("Incompatible models cannot be combined");
        }
        DataModel dataModel = dataModelArray[0].a();
        dataModel.data.entrySet().forEach(entry -> entry.setValue(Stream.of(dataModelArray).map(dataModel -> dataModel.data.get(entry.getKey())).reduce(binaryOperator).get()));
        return dataModel;
    }
}

