/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.google.common.collect.Lists;
import com.mimvista.cardiac.PolarPoint;
import com.mimvista.cardiac.UniformSampling;
import java.util.ArrayList;
import java.util.List;

class HemisphericalSampling
extends UniformSampling {
    private static final long serialVersionUID = 1L;
    public static final HemisphericalSampling a = new HemisphericalSampling(12, 120);
    private final float phiSpacing;
    final float rho;

    public HemisphericalSampling() {
        this.phiSpacing = 0.0f;
        this.rho = 0.0f;
    }

    private HemisphericalSampling(int n2, int n3) {
        this(n2, n3, 1.0f);
    }

    public HemisphericalSampling(int n2, int n3, float f2) {
        super(n2, n3, 0.0f, f2);
        this.phiSpacing = (float)(1.5707963267948966 / (double)(n2 - 1));
        this.rho = (float)((double)(2.0f * f2) / Math.PI);
    }

    @Override
    public List<PolarPoint> a() {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)(this.angularCount * this.radialCount));
        arrayList.add(new PolarPoint(0.0, 0.0));
        for (int i2 = 0; i2 < this.angularCount; ++i2) {
            for (int i3 = 1; i3 < this.radialCount; ++i3) {
                arrayList.add(new PolarPoint(this.radialSpacing * (float)i3, this.angularSpacing * (float)i2));
            }
        }
        return arrayList;
    }

    @Override
    PolarPoint a(int n2, int n3) {
        return n2 == 0 ? new PolarPoint(0.0, 0.0) : super.a(n2, n3);
    }

    @Override
    double a(PolarPoint polarPoint) {
        int n2 = (int)Math.round(this.c(polarPoint));
        float f2 = (float)n2 * this.phiSpacing;
        float f3 = f2 + this.phiSpacing;
        if (n2 == 0 || n2 == this.radialCount - 1) {
            f3 -= this.phiSpacing / 2.0f;
        } else {
            f2 -= this.phiSpacing / 2.0f;
            f3 -= this.phiSpacing / 2.0f;
        }
        double d2 = (double)this.rho * (1.0 - Math.cos(f3));
        double d3 = (double)this.rho * (1.0 - Math.cos(f2));
        double d4 = Math.abs(d2 - d3);
        if (n2 == 0) {
            return d4 / (double)this.rho;
        }
        return d4 / (double)this.angularCount / (double)this.rho;
    }

    public double a(double d2) {
        double d3 = d2 / (double)this.rho;
        double d4 = 1.0 - Math.cos(d3);
        return d4;
    }

    @Override
    public double a(double d2, double d3) {
        return this.b(d3);
    }

    double b(double d2) {
        double d3 = d2 / (double)this.phiSpacing;
        return d3 * (double)this.radialSpacing;
    }

    @Override
    public float b() {
        return 1.0f;
    }

    public static void a(String[] stringArray) {
        HemisphericalSampling hemisphericalSampling = new HemisphericalSampling(15, 25, 0.45f);
        for (int i2 = 0; i2 < hemisphericalSampling.radialCount; ++i2) {
            PolarPoint polarPoint = hemisphericalSampling.a(i2, 0);
            double d2 = hemisphericalSampling.a(polarPoint.r);
            double d3 = hemisphericalSampling.a(d2, 0.0);
            double d4 = hemisphericalSampling.a(polarPoint);
            boolean bl2 = false;
        }
    }
}

