/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;

public class PolarPoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final double r;
    public final double theta;

    public PolarPoint(double d2, double d3) {
        this.r = d2;
        this.theta = this.a(d3);
    }

    private double a(double d2) {
        return (d2 + Math.PI) % (Math.PI * 2) - Math.PI;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PolarPoint) {
            PolarPoint polarPoint = (PolarPoint)object;
            if ((int)(1024.0 * this.r) != (int)(1024.0 * polarPoint.r)) {
                return false;
            }
            return (int)(1024.0 * this.theta) == (int)(1024.0 * polarPoint.theta);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (int)(1024.0 * this.theta);
        n3 = 31 * n3 + (int)(1024.0 * this.r);
        return n3;
    }

    public String toString() {
        return this.r + "," + this.theta;
    }

    public static class a
    implements JsonDeserializer<PolarPoint>,
    JsonSerializer<PolarPoint> {
        public PolarPoint a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            String string = jsonElement.getAsString();
            int n2 = string.indexOf(44);
            return new PolarPoint(Double.parseDouble(string.substring(0, n2)), Double.parseDouble(string.substring(++n2)));
        }

        public JsonElement a(PolarPoint polarPoint, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(polarPoint.toString());
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.a((PolarPoint)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.a(jsonElement, type, jsonDeserializationContext);
        }
    }
}

