/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.google.common.collect.Maps;
import com.mimvista.cardiac.CardiacNormalization;
import com.mimvista.cardiac.CardiacNormaliztionType;
import com.mimvista.cardiac.CylindricalSampling;
import com.mimvista.cardiac.DataModel;
import com.mimvista.cardiac.PolarPoint;
import com.mimvista.cardiac.SampledPolarTransformModel;
import com.mimvista.cardiac.SphereCylinderSampling;
import com.mimvista.cardiac.UniformSampling;
import com.mimvista.cardiac.algorithm.CardiacPolarTransform;
import com.mimvista.cardiac.gui.CardiacSegments;
import com.mimvista.cardiac.gui.b;
import com.mimvista.d;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.DynamicVolumeRef3D;
import com.mimvista.internals.SimpleContour;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.internals.statistics.ContourStatistician;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.overlays.f;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.MultipliedIndexPoint3i;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.work.m;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.SwingUtilities;
import javax.vecmath.Tuple3f;
import org.apache.commons.math3.util.FastMath;

public class SampledCardiacTransform
extends SampledPolarTransformModel {
    private static final long serialVersionUID = 1L;
    private static boolean d = false;
    static final UniformSampling a = SphereCylinderSampling.a;
    private static final int e = 1;
    protected DynamicVolumeRef3D cardiacVcRef = null;
    protected transient WarpTransform b = null;
    VolumetricContourOverlayish epi;
    VolumetricContourOverlayish endo;
    VoxelPoint3f epiCenter;
    Contour basal;
    Contour mid;
    Contour apical;
    Contour apex;
    private SampledPolarTransformModel.PerSample<VoxelPoint3f> maxVoxels;
    private SampledPolarTransformModel.PerSample<Contour> sampleContours;

    public static SampledCardiacTransform a(ViewController3D viewController3D, CardiacNormaliztionType cardiacNormaliztionType, List<CardiacNormalization> list) {
        return new SampledCardiacTransform(viewController3D, null, null, cardiacNormaliztionType, list);
    }

    public static SampledCardiacTransform a(ViewController3D viewController3D, ViewController3D viewController3D2, WarpTransform warpTransform, CardiacNormaliztionType cardiacNormaliztionType, List<CardiacNormalization> list) {
        return new SampledCardiacTransform(viewController3D, viewController3D2, warpTransform, cardiacNormaliztionType, list);
    }

    public SampledCardiacTransform(SampledCardiacTransform sampledCardiacTransform, DataModel dataModel) {
        this(sampledCardiacTransform);
        this.a((SampledPolarTransformModel.Sample sample) -> Float.valueOf(dataModel.a(sample.point)));
    }

    SampledCardiacTransform(SampledCardiacTransform sampledCardiacTransform) {
        super(sampledCardiacTransform);
        this.maxVoxels = new SampledPolarTransformModel.PerSample();
        this.sampleContours = new SampledPolarTransformModel.PerSample();
        this.maxVoxels.a(sampledCardiacTransform.maxVoxels);
        this.sampleContours.a(sampledCardiacTransform.sampleContours);
        this.cardiacVcRef = sampledCardiacTransform.cardiacVcRef;
        this.b = sampledCardiacTransform.b;
        this.epi = sampledCardiacTransform.epi;
        this.endo = sampledCardiacTransform.endo;
        this.epiCenter = sampledCardiacTransform.epiCenter;
        this.basal = sampledCardiacTransform.basal;
        this.mid = sampledCardiacTransform.mid;
        this.apical = sampledCardiacTransform.apical;
        this.apex = sampledCardiacTransform.apex;
        for (CardiacNormalization cardiacNormalization : sampledCardiacTransform.normalizationOptions.values()) {
            this.a(cardiacNormalization);
        }
    }

    public SampledCardiacTransform(DataModel dataModel) {
        super(dataModel);
    }

    public SampledCardiacTransform(CardiacPolarTransform cardiacPolarTransform) {
        super(cardiacPolarTransform.c());
        this.maxVoxels = new SampledPolarTransformModel.PerSample(this.f().sampling);
        this.sampleContours = new SampledPolarTransformModel.PerSample(this.f().sampling);
        for (PolarPoint polarPoint : this.f().sampling.a()) {
            this.maxVoxels.a(this.f().sampling, polarPoint, cardiacPolarTransform.a(polarPoint));
            this.sampleContours.a(this.f().sampling, polarPoint, cardiacPolarTransform.b(polarPoint));
        }
        this.epi = cardiacPolarTransform.epi;
        this.endo = cardiacPolarTransform.endo;
        this.cardiacVcRef = cardiacPolarTransform.cardiacVcRef;
        this.epiCenter = cardiacPolarTransform.epiCenter;
        this.basal = cardiacPolarTransform.basal;
        this.mid = cardiacPolarTransform.mid;
        this.apical = cardiacPolarTransform.apical;
        this.apex = cardiacPolarTransform.apex;
    }

    private SampledCardiacTransform(ViewController3D viewController3D, @d ViewController3D viewController3D2, @d WarpTransform warpTransform, CardiacNormaliztionType cardiacNormaliztionType, List<CardiacNormalization> list) {
        this(list, cardiacNormaliztionType);
        this.cardiacVcRef = DynamicVolumeRef3D.a(viewController3D);
        this.b = viewController3D2 == null ? null : warpTransform;
        this.a(viewController3D2 == null ? viewController3D : viewController3D2);
    }

    protected SampledCardiacTransform(List<CardiacNormalization> list, CardiacNormaliztionType cardiacNormaliztionType) {
        this();
        this.a(new DataModel(CylindricalSampling.a));
        for (CardiacNormalization cardiacNormalization : list) {
            this.a(cardiacNormalization);
        }
        this.a(cardiacNormaliztionType);
    }

    private SampledCardiacTransform() {
        this(new DataModel(a));
    }

    private void a(ViewController3D viewController3D) {
        Object object3;
        Object object2;
        Object object322;
        long l2 = System.currentTimeMillis();
        this.c(viewController3D);
        float[] fArray = this.b(viewController3D);
        Contour contour = this.epi.aq().l();
        contour.e((SimpleContour)this.endo.aq());
        Pair<MultipliedIndexPoint3i, MultipliedIndexPoint3i> pair = contour.B();
        VoxelPoint3f voxelPoint3f = ((MultipliedIndexPoint3i)((Object)pair.x)).c().j();
        VoxelPoint3f voxelPoint3f2 = ((MultipliedIndexPoint3i)((Object)pair.y)).c().j();
        int n3 = ((MultipliedIndexPoint3i)((Object)pair.x)).z;
        int n4 = ((MultipliedIndexPoint3i)((Object)pair.y)).z;
        RescaleConverter rescaleConverter = viewController3D.cw().I().rescale;
        float f3 = rescaleConverter.removeRaw(0.0f);
        boolean bl2 = viewController3D != this.a() && this.b != null;
        SampledPolarTransformModel.PerSampling<ConcurrentMap> perSampling = new SampledPolarTransformModel.PerSampling<ConcurrentMap>();
        for (Object object322 : this.g()) {
            ((DataModel)this.datas.b((UniformSampling)object322)).a(f2 -> Float.valueOf(Float.NEGATIVE_INFINITY));
            perSampling.a((UniformSampling)object322, Maps.newConcurrentMap());
            object2 = (DataModel)this.datas.b((UniformSampling)object322);
            for (PolarPoint polarPoint : ((DataModel)object2).d()) {
                this.sampleContours.a((UniformSampling)object322, polarPoint, new Contour(this.a().cw()));
            }
        }
        SampledPolarTransformModel.PerSampling<VoxelPoint3f> perSampling2 = this.a(voxelPoint3f2.z, voxelPoint3f.z);
        object322 = this.c();
        FuncUtils.a((ThreadPoolExecutor)m.c, n4 - n3 + 1, new FuncUtils.e((VoxelPoint3f)((Object)object322), n3, contour, n4, viewController3D, voxelPoint3f, voxelPoint3f2, fArray, perSampling2, bl2, perSampling){
            final /* synthetic */ VoxelPoint3f a;
            final /* synthetic */ int b;
            final /* synthetic */ Contour c;
            final /* synthetic */ int d;
            final /* synthetic */ ViewController3D e;
            final /* synthetic */ VoxelPoint3f f;
            final /* synthetic */ VoxelPoint3f g;
            final /* synthetic */ float[] h;
            final /* synthetic */ SampledPolarTransformModel.PerSampling i;
            final /* synthetic */ boolean j;
            final /* synthetic */ SampledPolarTransformModel.PerSampling k;
            {
                this.a = voxelPoint3f;
                this.b = n2;
                this.c = contour;
                this.d = n3;
                this.e = viewController3D;
                this.f = voxelPoint3f2;
                this.g = voxelPoint3f3;
                this.h = fArray;
                this.i = perSampling;
                this.j = bl2;
                this.k = perSampling2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void f(int n2, int n3, int n4) {
                SampledPolarTransformModel.PerSample<Float> perSample = new SampledPolarTransformModel.PerSample<Float>(SampledCardiacTransform.this.g());
                SampledPolarTransformModel.PerSample<VoxelPoint3f> perSample2 = new SampledPolarTransformModel.PerSample<VoxelPoint3f>(SampledCardiacTransform.this.g());
                VoxelPoint3f voxelPoint3f = new VoxelPoint3f(SampledCardiacTransform.this.epiCenter);
                MultipliedIndexPoint3i multipliedIndexPoint3i = this.a.c().a(SampledCardiacTransform.this.epi.aq().v());
                for (int i2 = n2 + this.b; i2 < n3 + this.b; ++i2) {
                    multipliedIndexPoint3i.z = i2;
                    ContourSlice contourSlice = this.c.d(i2);
                    voxelPoint3f.z = ((float)multipliedIndexPoint3i.z + 0.5f) / (float)multipliedIndexPoint3i.a()[2];
                    float f2 = i2;
                    voxelPoint3f.z = ((float)multipliedIndexPoint3i.z + 0.5f) / (float)multipliedIndexPoint3i.a()[2];
                    double d3 = (double)((float)this.d - f2) / (double)(this.d - this.b);
                    float f4 = this.e.cw().a(this.a.x, this.a.y, voxelPoint3f.z);
                    for (float f5 = this.f.y; f5 < this.g.y; f5 += this.h[1]) {
                        voxelPoint3f.y = f5;
                        multipliedIndexPoint3i.y = Math.round(f5 * (float)multipliedIndexPoint3i.a()[1] - 0.5f);
                        ContourSlice.ScanLine scanLine = contourSlice.a((short)multipliedIndexPoint3i.y);
                        if (scanLine == null) continue;
                        for (ContourSlice.ScanLine.b b2 : scanLine.b()) {
                            float f6 = (0.5f + (float)b2.b().shortValue()) / (float)multipliedIndexPoint3i.a()[0];
                            float f7 = (0.5f + (float)b2.c().shortValue()) / (float)multipliedIndexPoint3i.a()[0];
                            for (float f8 = f6; f8 < f7; f8 += this.h[0]) {
                                voxelPoint3f.x = f8;
                                multipliedIndexPoint3i.x = Math.round(f8 * (float)multipliedIndexPoint3i.a()[0] - 0.5f);
                                float f9 = this.e.cw().a(voxelPoint3f.x, voxelPoint3f.y, voxelPoint3f.z);
                                float f10 = voxelPoint3f.x - this.a.x;
                                float f11 = voxelPoint3f.y - this.a.y;
                                double d4 = Math.sqrt(f10 * f10 + f11 * f11);
                                double d5 = -FastMath.atan2((double)f11, (double)f10);
                                for (UniformSampling uniformSampling : SampledCardiacTransform.this.g()) {
                                    float f12;
                                    double d6;
                                    PolarPoint polarPoint2;
                                    DataModel dataModel = (DataModel)SampledCardiacTransform.this.datas.b(uniformSampling);
                                    if (!dataModel.b(polarPoint2 = uniformSampling.b(new PolarPoint(uniformSampling.a(d3, d6 = FastMath.atan((double)(d4 / (double)(f12 = voxelPoint3f.z - ((VoxelPoint3f)((Object)this.i.b((UniformSampling)uniformSampling))).z)))), d5)))) {
                                        int n5 = 4;
                                    }
                                    SampledCardiacTransform.this.a((Contour)SampledCardiacTransform.this.sampleContours.a(uniformSampling, polarPoint2), multipliedIndexPoint3i, this.j);
                                    Float f13 = ((HashMap)perSample.b(uniformSampling)).computeIfAbsent(polarPoint2, polarPoint -> Float.valueOf(dataModel.a((PolarPoint)polarPoint)));
                                    if (f13 == null) {
                                        f13 = Float.valueOf(0.0f);
                                    }
                                    ((Map)this.k.b(uniformSampling)).compute(polarPoint2.r, (d2, f3) -> Float.valueOf(f3 == null ? f4 : Math.max(f4, f3.floatValue())));
                                    if (!(f9 > f13.floatValue())) continue;
                                    VoxelPoint3f voxelPoint3f2 = new VoxelPoint3f(voxelPoint3f);
                                    if (this.j) {
                                        MetricPoint3f metricPoint3f = new MetricPoint3f((Tuple3f)SampledCardiacTransform.this.b.a(voxelPoint3f2.b()), (SimpleImageFrame)SampledCardiacTransform.this.a().cw());
                                        voxelPoint3f2 = metricPoint3f.b();
                                    }
                                    perSample.a(uniformSampling, polarPoint2, Float.valueOf(f9));
                                    perSample2.a(uniformSampling, polarPoint2, voxelPoint3f2);
                                }
                            }
                        }
                    }
                }
                UniformSampling uniformSampling = SampledCardiacTransform.this.currentSampling;
                synchronized (uniformSampling) {
                    for (UniformSampling uniformSampling2 : SampledCardiacTransform.this.g()) {
                        for (PolarPoint polarPoint3 : ((HashMap)perSample.b(uniformSampling2)).keySet()) {
                            Float f14 = (Float)perSample.a(uniformSampling2, polarPoint3);
                            Float f15 = Float.valueOf(((DataModel)SampledCardiacTransform.this.datas.b(uniformSampling2)).a(polarPoint3));
                            if (!(f14.floatValue() > f15.floatValue())) continue;
                            ((DataModel)SampledCardiacTransform.this.datas.b(uniformSampling2)).a(polarPoint3, f14.floatValue());
                            SampledCardiacTransform.this.maxVoxels.a(uniformSampling2, polarPoint3, perSample2.a(uniformSampling2, polarPoint3));
                        }
                    }
                }
            }
        }, "CPP sampling");
        for (UniformSampling uniformSampling : this.g()) {
            DataModel dataModel = (DataModel)this.datas.b(uniformSampling);
            for (PolarPoint polarPoint : dataModel.d()) {
                if (Float.isFinite(dataModel.a(polarPoint))) continue;
                dataModel.a(polarPoint, ((Map)perSampling.b(uniformSampling)).computeIfAbsent(polarPoint.r, d2 -> Float.valueOf(f3)).floatValue());
            }
        }
        object2 = this.h();
        this.a(arg_0 -> SampledCardiacTransform.a((CardiacNormalization)object2, rescaleConverter, arg_0));
        if (d) {
            HashMap hashMap = Maps.newHashMap();
            for (Object object3 : ((HashMap)this.sampleContours.b(this.currentSampling)).keySet()) {
                VolumetricContourOverlay volumetricContourOverlay = hashMap.computeIfAbsent((int)Math.round(((PolarPoint)object3).r / (double)this.f().b().radialSpacing), n2 -> viewController3D.ba().g(false));
                volumetricContourOverlay.aq().d((SimpleContour)this.sampleContours.a(this.currentSampling, (PolarPoint)object3));
                volumetricContourOverlay.c(String.valueOf(((PolarPoint)object3).r));
            }
        }
        long l3 = System.currentTimeMillis();
        object3 = Thread.currentThread().getName();
        SwingUtilities.invokeLater(() -> SampledCardiacTransform.a(l3, l2, (String)object3));
    }

    private VoxelPoint3f c() {
        if (this.apex != null && !this.apex.Q()) {
            return this.apex.n().b();
        }
        return this.epiCenter;
    }

    private SampledPolarTransformModel.PerSampling<VoxelPoint3f> a(float f2, float f3) {
        SampledPolarTransformModel.PerSampling<VoxelPoint3f> perSampling = new SampledPolarTransformModel.PerSampling<VoxelPoint3f>();
        VoxelPoint3f voxelPoint3f = this.c().a();
        for (UniformSampling uniformSampling : this.g()) {
            VoxelPoint3f voxelPoint3f2 = voxelPoint3f.a();
            voxelPoint3f2.z = f2 - uniformSampling.b() * (f2 - f3);
            perSampling.a(uniformSampling, voxelPoint3f2);
        }
        return perSampling;
    }

    private void a(Contour contour, MultipliedIndexPoint3i multipliedIndexPoint3i, boolean bl2) {
        if (bl2) {
            MetricPoint3f metricPoint3f = new MetricPoint3f((Tuple3f)this.b.a(multipliedIndexPoint3i.c().d()), (SimpleImageFrame)this.a().cw());
            multipliedIndexPoint3i = metricPoint3f.c().a(contour.v());
        }
        contour.a(multipliedIndexPoint3i);
    }

    private float[] b(ViewController3D viewController3D) {
        float[] fArray = viewController3D.ao_();
        int[] nArray = viewController3D.cw().C();
        float[] fArray2 = MathUtils.b(fArray, nArray);
        return new float[]{fArray2[0] / (2.0f * fArray[0]), fArray2[1] / (2.0f * fArray[1])};
    }

    public VolumetricContourOverlay a(b b2) {
        this.c(this.a());
        Contour contour = this.e(b2);
        ViewController3D viewController3D = this.cardiacVcRef.e();
        VolumetricContourOverlay volumetricContourOverlay = f.a((ViewController)viewController3D, contour);
        volumetricContourOverlay.c(b2.d().toString());
        viewController3D.ba().a((Overlayish)volumetricContourOverlay, true);
        viewController3D.bD();
        viewController3D.g().Q();
        volumetricContourOverlay.aZ();
        return volumetricContourOverlay;
    }

    private Contour e(b b2) {
        Object object;
        Contour contour = this.epi.aq().l();
        contour.y();
        if (this.sampleContours != null && this.sampleContours.b(this.currentSampling) != null) {
            object = this.f().d().iterator();
            while (object.hasNext()) {
                PolarPoint polarPoint = (PolarPoint)object.next();
                if (!b2.a(polarPoint)) continue;
                contour.d((SimpleContour)this.sampleContours.a(this.currentSampling, polarPoint));
            }
            if (!contour.Q()) {
                return contour;
            }
        }
        contour = (object = b2.d().b()) == CardiacSegments.CardiacSegmentType.a ? this.basal : (object == CardiacSegments.CardiacSegmentType.b ? this.mid : (object == CardiacSegments.CardiacSegmentType.c ? this.apical : this.apex));
        double d2 = (Double)b2.b().x;
        double d3 = (Double)b2.b().y;
        if (d3 < d2) {
            d3 += Math.PI * 2;
        }
        Contour contour2 = this.a(contour, this.epiCenter, d2, d3);
        return contour2;
    }

    private Contour a(Contour contour, VoxelPoint3f voxelPoint3f, double d2, double d3) {
        Contour contour2 = new Contour(contour);
        VoxelPoint3f voxelPoint3f2 = new VoxelPoint3f(voxelPoint3f);
        voxelPoint3f2.a((Tuple3f)new Point3f(contour.v()[0], contour.v()[1], contour.v()[2]));
        short s2 = (short)Math.round(voxelPoint3f2.x);
        short s3 = (short)Math.round(voxelPoint3f2.y);
        MultipliedIndexPoint3i multipliedIndexPoint3i = contour.C().a(contour.v());
        MultipliedIndexPoint3i multipliedIndexPoint3i2 = contour.D().a(contour.v());
        for (int i2 = multipliedIndexPoint3i.z; i2 <= multipliedIndexPoint3i2.z; ++i2) {
            ContourSlice contourSlice = contour2.c(i2);
            for (short s4 = (short)multipliedIndexPoint3i.y; s4 <= multipliedIndexPoint3i2.y; s4 = (short)(s4 + 1)) {
                ContourSlice.ScanLine scanLine = contourSlice.c(s4);
                for (int i3 = multipliedIndexPoint3i.x; i3 <= multipliedIndexPoint3i2.x; ++i3) {
                    double d4 = Math.atan2(s3 - s4, i3 - s2);
                    if (!(d4 <= d2) && !(d4 > d3) || !scanLine.a(i3)) continue;
                    if (d3 > Math.PI) {
                        if (!(d4 <= d2 - Math.PI * 2) && !(d4 > d3 - Math.PI * 2)) continue;
                        scanLine.f(i3, i3 + 1);
                        continue;
                    }
                    scanLine.f(i3, i3 + 1);
                }
            }
        }
        return contour2;
    }

    private void c(ViewController3D viewController3D) {
        List<AbstractContourOverlayish> list = viewController3D.ba().a(OverlayishBase.InterpretedType.z, true);
        List<AbstractContourOverlayish> list2 = viewController3D.ba().a(OverlayishBase.InterpretedType.y, true);
        if (!viewController3D.e() || list.isEmpty() || list2.isEmpty()) {
            throw new IllegalArgumentException("Must run trasform on cardiac volume with endo and epi contours defined");
        }
        this.epi = (VolumetricContourOverlayish)list.get(0);
        this.endo = (VolumetricContourOverlayish)list2.get(0);
        this.epiCenter = this.a(this.epi);
        Contour contour = new Contour(this.epi.aq());
        contour.e((SimpleContour)this.endo.aq());
        int n2 = contour.C().a((int[])contour.v()).z - 1;
        int n3 = this.endo.aq().D().a((int[])contour.v()).z;
        int n4 = this.endo.aq().D().a((int[])contour.v()).z;
        int n5 = contour.D().a((int[])contour.v()).z + 1;
        this.basal = new Contour(contour);
        this.basal.y();
        this.mid = new Contour(this.basal);
        this.apical = new Contour(this.basal);
        this.apex = new Contour(this.basal);
        int n6 = Math.round((float)(n3 - n2) / 3.0f);
        for (int i2 = n2; i2 < n5; ++i2) {
            ContourSlice contourSlice = contour.d(i2);
            if (i2 > n4) {
                this.apex.d(contourSlice);
                continue;
            }
            if (i2 > n2 + n6 * 2) {
                this.apical.d(contourSlice);
                continue;
            }
            if (i2 > n2 + n6 * 1) {
                this.mid.d(contourSlice);
                continue;
            }
            if (i2 <= n2 + n6 * 0) continue;
            this.basal.d(contourSlice);
        }
    }

    private VoxelPoint3f a(VolumetricContourOverlayish volumetricContourOverlayish) {
        ContourStatistician contourStatistician = volumetricContourOverlayish.bF_();
        if (!contourStatistician.h()) {
            contourStatistician.b(false);
            while (contourStatistician.G()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return contourStatistician.m().b();
    }

    @Override
    void a(DataModel dataModel) {
        super.a(dataModel);
        if (this.maxVoxels == null) {
            this.maxVoxels = new SampledPolarTransformModel.PerSample(dataModel.sampling);
        } else {
            this.maxVoxels.a(dataModel.sampling);
        }
        if (this.sampleContours == null) {
            this.sampleContours = new SampledPolarTransformModel.PerSample(dataModel.sampling);
        } else {
            this.sampleContours.a(dataModel.sampling);
        }
    }

    public VoxelPoint3f a(PolarPoint polarPoint) {
        return this.maxVoxels.a(this.currentSampling, this.currentSampling.b(polarPoint));
    }

    public Contour b(PolarPoint polarPoint) {
        return this.sampleContours.a(this.currentSampling, this.currentSampling.b(polarPoint));
    }

    public ViewController3D a() {
        return this.cardiacVcRef.e();
    }

    public static SampledCardiacTransform b() {
        return new EmptyTransform();
    }

    public static void main(String[] stringArray) {
        SampledCardiacTransform sampledCardiacTransform = new SampledCardiacTransform(new DataModel(a));
        sampledCardiacTransform.a((SampledPolarTransformModel.Sample sample) -> Float.valueOf(1.0f));
        String string = sampledCardiacTransform.j();
        SampledPolarTransformModel sampledPolarTransformModel = SampledPolarTransformModel.c(string);
        int n2 = 5;
    }

    private static /* synthetic */ void a(long l2, long l3, String string) {
        ay.b((Object)("sampled for " + (l2 - l3) + " on " + string), SampledCardiacTransform.class);
    }

    private static /* synthetic */ Float a(CardiacNormalization cardiacNormalization, RescaleConverter rescaleConverter, SampledPolarTransformModel.Sample sample) {
        return Float.valueOf(cardiacNormalization.a(rescaleConverter.apply(sample.value)));
    }

    private static class EmptyTransform
    extends SampledCardiacTransform {
        private static final long serialVersionUID = 1L;

        private EmptyTransform() {
        }

        @Override
        public float c(PolarPoint polarPoint) {
            return 1.0f;
        }

        @Override
        public VolumetricContourOverlay a(b b2) {
            return null;
        }

        @Override
        public VoxelPoint3f a(PolarPoint polarPoint) {
            return null;
        }

        @Override
        CardiacNormaliztionType d() {
            return super.d();
        }
    }
}

