/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.cardiac.CylindricalSampling;
import com.mimvista.cardiac.HemisphericalSampling;
import com.mimvista.cardiac.PolarPoint;
import com.mimvista.cardiac.Sampling;
import com.mimvista.cardiac.UniformSampling;
import com.mimvista.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SphereCylinderSampling
extends UniformSampling {
    private static final long serialVersionUID = 1L;
    public static final SphereCylinderSampling a = new SphereCylinderSampling(30, 120);
    private static final float b = 0.43990085f;
    private final HemisphericalSampling sphere;
    private final CylindricalSampling cylinder;

    public SphereCylinderSampling() {
        this.sphere = null;
        this.cylinder = null;
    }

    public SphereCylinderSampling(int n2, int n3) {
        super(n2, n3);
        int n4 = Math.round(0.43990085f * (float)(n2 - 1));
        int n5 = 1 + n4;
        int n6 = 1 + n2 - n5;
        this.sphere = new HemisphericalSampling(n5, n3, (float)n4 / ((float)n2 - 1.0f));
        this.cylinder = new CylindricalSampling(n6, n3, (float)n4 / ((float)n2 - 1.0f));
    }

    @Override
    float a(PolarPoint polarPoint, Map<PolarPoint, Float> map) {
        Pair<UniformSampling, PolarPoint> pair = this.e(polarPoint);
        return ((UniformSampling)pair.x).a((PolarPoint)pair.y, map);
    }

    @Override
    public List<PolarPoint> a() {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        linkedHashSet.addAll(this.sphere.a());
        linkedHashSet.addAll(this.cylinder.a());
        return Lists.newArrayList((Iterable)linkedHashSet);
    }

    @Override
    PolarPoint a(int n2, int n3) {
        return this.sphere.a(n2, n3);
    }

    @Override
    public PolarPoint b(PolarPoint polarPoint) {
        Pair<UniformSampling, PolarPoint> pair = this.e(polarPoint);
        return ((UniformSampling)pair.x).b((PolarPoint)pair.y);
    }

    @Override
    double a(PolarPoint polarPoint) {
        Pair<UniformSampling, PolarPoint> pair = this.e(polarPoint);
        double d2 = 0.3333333333333333;
        double d3 = ((UniformSampling)pair.x).c((PolarPoint)pair.y);
        if (pair.x == this.sphere && d3 == (double)this.sphere.radialCount || pair.x == this.cylinder && d3 < 0.5) {
            d2 *= 2.0;
        }
        if (pair.x == this.cylinder) {
            d2 *= 2.0;
        }
        double d4 = d2 * ((UniformSampling)pair.x).a((PolarPoint)pair.y);
        return d4;
    }

    private Pair<UniformSampling, PolarPoint> e(PolarPoint polarPoint) {
        if (polarPoint.r >= (double)this.cylinder.rMin) {
            return Pair.get(this.cylinder, polarPoint);
        }
        return Pair.get(this.sphere, polarPoint);
    }

    @Override
    public double a(double d2, double d3) {
        if (d2 <= (double)this.sphere.rho) {
            return this.sphere.b(d3);
        }
        double d4 = (d2 - (double)this.sphere.rho) / (double)(1.0f - this.sphere.rho);
        return this.cylinder.a(d4);
    }

    @Override
    public float b() {
        return this.sphere.rho;
    }

    public double a(double d2) {
        if (d2 <= (double)this.sphere.rMax) {
            return (double)this.sphere.rho * this.sphere.a(d2);
        }
        double d3 = (d2 - (double)this.cylinder.rMin) / (double)(1.0f - this.cylinder.rMin);
        return (double)this.sphere.rho + (double)(1.0f - this.sphere.rho) * d3;
    }

    @Override
    public boolean a(Sampling sampling) {
        return sampling.getClass().equals(SphereCylinderSampling.class) && ((SphereCylinderSampling)SphereCylinderSampling.class.cast((Object)sampling)).cylinder.a(this.cylinder) && ((SphereCylinderSampling)SphereCylinderSampling.class.cast((Object)sampling)).sphere.a(this.sphere);
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = n2 * n3 + this.sphere.hashCode();
        n3 = n2 * n3 + this.cylinder.hashCode();
        return n3;
    }

    public static void main(String[] stringArray) {
        int n2;
        SphereCylinderSampling sphereCylinderSampling = a;
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        for (n2 = 0; n2 < sphereCylinderSampling.radialCount; ++n2) {
            PolarPoint polarPoint = sphereCylinderSampling.a(n2, 0);
            double d2 = polarPoint.r;
            double d3 = sphereCylinderSampling.a(d2);
            double d4 = sphereCylinderSampling.a(d3, 0.0);
            arrayList.add((int)(100000.0 * d4));
            arrayList2.add((int)(100000.0 * d3));
        }
        n2 = 1;
    }
}

