/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.mimvista.cardiac.PolarPoint;
import com.mimvista.cardiac.Sampling;
import com.mimvista.numerics.Interpolate;
import java.util.Map;

public abstract class UniformSampling
extends Sampling {
    private static final long serialVersionUID = 1L;
    public final float angularSpacing;
    public final float radialSpacing;
    public final int angularCount;
    public final int radialCount;
    public final float rMin;
    public final float rMax;

    public UniformSampling() {
        this.angularSpacing = 0.0f;
        this.radialSpacing = 0.0f;
        this.angularCount = 0;
        this.radialCount = 0;
        this.rMin = 0.0f;
        this.rMax = 0.0f;
    }

    protected UniformSampling(int n2, int n3) {
        this(n2, n3, 0.0f, 1.0f);
    }

    public UniformSampling(int n2, int n3, float f2, float f3) {
        this.rMax = f3;
        this.rMin = f2;
        this.radialCount = n2;
        this.angularCount = n3;
        this.angularSpacing = (float)(Math.PI * 2 / (double)n3);
        this.radialSpacing = (f3 - f2) / (float)(n2 - 1);
    }

    public double c(PolarPoint polarPoint) {
        return (polarPoint.r - (double)this.rMin) / (double)this.radialSpacing;
    }

    public double d(PolarPoint polarPoint) {
        return (polarPoint.theta + Math.PI * 2) % (Math.PI * 2) / (double)this.angularSpacing;
    }

    PolarPoint a(int n2, int n3) {
        return new PolarPoint(this.rMin + this.radialSpacing * (float)n2, this.angularSpacing * (float)n3);
    }

    public abstract double a(double var1, double var3);

    public abstract float b();

    @Override
    float a(PolarPoint polarPoint, Map<PolarPoint, Float> map) {
        float f2 = (float)this.d(polarPoint);
        float f3 = (float)this.c(polarPoint);
        int n2 = (int)Math.floor(f2);
        int n3 = (int)Math.ceil(f2);
        int n4 = (int)Math.floor(f3);
        int n5 = (int)Math.ceil(f3);
        float f4 = map.get(this.a(n4, n2)).floatValue();
        float f5 = map.get(this.a(n5, n2)).floatValue();
        float f6 = map.get(this.a(n5, n3 % this.angularCount)).floatValue();
        float f7 = map.get(this.a(n4, n3 % this.angularCount)).floatValue();
        return Interpolate.a(f2, f3, n2, n3, n4, n5, f4, f7, f5, f6);
    }

    @Override
    public PolarPoint b(PolarPoint polarPoint) {
        int n2 = (int)Math.round(this.c(polarPoint));
        int n3 = (int)Math.round(this.d(polarPoint));
        return this.a(n2, n3 % this.angularCount);
    }

    @Override
    public boolean a(Sampling sampling) {
        return sampling.getClass().equals(this.getClass()) && this.radialCount == ((UniformSampling)this.getClass().cast((Object)sampling)).radialCount && this.angularCount == ((UniformSampling)this.getClass().cast((Object)sampling)).angularCount && Math.round(8192.0f * this.rMin) == Math.round(8192.0f * ((UniformSampling)this.getClass().cast((Object)sampling)).rMin) && Math.round(8192.0f * this.rMax) == Math.round(8192.0f * ((UniformSampling)this.getClass().cast((Object)sampling)).rMax);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof UniformSampling && ((UniformSampling)object).a(this);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = n2 * n3 + this.radialCount;
        n3 = n2 * n3 + this.angularCount;
        n3 = n2 * n3 + Math.round(8192.0f * this.rMin);
        n3 = n2 * n3 + Math.round(8192.0f * this.rMax);
        return n3;
    }
}

