/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac.gui;

import com.google.common.collect.ImmutableList;
import com.mimvista.gui.util.MIMFormattedTextField;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.preferencesNew.CardiacPrefs;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ay;
import com.mimvista.util.bg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.math3.distribution.NormalDistribution;

public class CardiacAutoScoringCutoffEditor
extends JPanel {
    public static final ImmutableList<BigDecimal> a = new ImmutableList.Builder().add((Object)new BigDecimal(-0.5)).add((Object)new BigDecimal(-1.5)).add((Object)new BigDecimal(-2.5)).add((Object)new BigDecimal(-3.5)).build();
    private static final long serialVersionUID = 1L;
    private JFormattedTextField[] cutoffFields;
    private JSpinner[] pctFields;
    private JLabel errLabel;
    private boolean updating = false;

    public static BigDecimal[] a() {
        BigDecimal[] bigDecimalArray = (BigDecimal[])a.toArray((Object[])new BigDecimal[a.size()]);
        BigDecimal[] bigDecimalArray2 = CardiacPrefs.autoscoreThresholds.getValue();
        if (bigDecimalArray2.length != 4) {
            BigDecimal[] bigDecimalArray3 = (BigDecimal[])bigDecimalArray.clone();
            System.arraycopy(bigDecimalArray2, 0, bigDecimalArray3, 0, Math.min(bigDecimalArray2.length, bigDecimalArray3.length));
            bigDecimalArray2 = bigDecimalArray3;
        }
        Arrays.sort(bigDecimalArray2, Collections.reverseOrder());
        return bigDecimalArray2;
    }

    public CardiacAutoScoringCutoffEditor() {
        this.e();
    }

    private void e() {
        bg.a("build CardiacAutoScoringCutoffEditor", 500L);
        MIMSwingUtils.b(new Runnable(){

            @Override
            public void run() {
                CardiacAutoScoringCutoffEditor.this.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 5, 0, 5);
                Messages messages = Messages.a("GeneralPreferencesCollectionFactory");
                CardiacAutoScoringCutoffEditor.this.add((Component)CardiacAutoScoringCutoffEditor.this.a(new JLabel(messages.b("CARDIAC_SEGMENT_SCORE"))), gridBagConstraints);
                CardiacAutoScoringCutoffEditor.this.add((Component)CardiacAutoScoringCutoffEditor.this.a(new JLabel(messages.b("CARDIAC_ZSCORE_THRESHOLD"))), gridBagConstraints);
                CardiacAutoScoringCutoffEditor.this.add((Component)CardiacAutoScoringCutoffEditor.this.a(new JLabel(messages.b("CARDIAC_PERCENTILE"))), gridBagConstraints);
                BigDecimal[] bigDecimalArray = CardiacAutoScoringCutoffEditor.a();
                CardiacAutoScoringCutoffEditor.a(CardiacAutoScoringCutoffEditor.this, new JFormattedTextField[bigDecimalArray.length]);
                CardiacAutoScoringCutoffEditor.a(CardiacAutoScoringCutoffEditor.this, new JSpinner[bigDecimalArray.length]);
                DecimalFormat decimalFormat = new DecimalFormat();
                decimalFormat.setMinimumFractionDigits(3);
                decimalFormat.setMaximumFractionDigits(3);
                NumberFormatFactory.a(decimalFormat);
                for (int i2 = 0; i2 < bigDecimalArray.length; ++i2) {
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.weightx = 0.0;
                    CardiacAutoScoringCutoffEditor.this.add((Component)CardiacAutoScoringCutoffEditor.this.a(new JLabel(String.valueOf(i2 + 1))), gridBagConstraints);
                    gridBagConstraints.weightx = 1.0;
                    ((CardiacAutoScoringCutoffEditor)CardiacAutoScoringCutoffEditor.this).cutoffFields[i2] = new MIMFormattedTextField(decimalFormat);
                    CardiacAutoScoringCutoffEditor.this.cutoffFields[i2].setValue(bigDecimalArray[i2]);
                    CardiacAutoScoringCutoffEditor.this.cutoffFields[i2].setHorizontalAlignment(4);
                    CardiacAutoScoringCutoffEditor.this.cutoffFields[i2].addPropertyChangeListener("value", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            CardiacAutoScoringCutoffEditor.this.a(propertyChangeEvent.getSource());
                        }
                    });
                    CardiacAutoScoringCutoffEditor.this.add((Component)CardiacAutoScoringCutoffEditor.this.cutoffFields[i2], gridBagConstraints);
                    SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(CardiacAutoScoringCutoffEditor.this.a(bigDecimalArray[i2].doubleValue()), 0.0, 100.0, 0.1);
                    spinnerNumberModel.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            CardiacAutoScoringCutoffEditor.this.a(changeEvent.getSource());
                        }
                    });
                    ((CardiacAutoScoringCutoffEditor)CardiacAutoScoringCutoffEditor.this).pctFields[i2] = new JSpinner(spinnerNumberModel);
                    CardiacAutoScoringCutoffEditor.this.add((Component)CardiacAutoScoringCutoffEditor.this.pctFields[i2], gridBagConstraints);
                }
                ++gridBagConstraints.gridy;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 0;
                CardiacAutoScoringCutoffEditor.this.errLabel = new JLabel();
                CardiacAutoScoringCutoffEditor.this.errLabel.setForeground(Color.RED.brighter());
                CardiacAutoScoringCutoffEditor.this.add((Component)CardiacAutoScoringCutoffEditor.this.errLabel, gridBagConstraints);
            }
        });
        bg.a("build CardiacAutoScoringCutoffEditor");
    }

    private JLabel a(JLabel jLabel) {
        jLabel.setHorizontalAlignment(0);
        return jLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void a(Object object) {
        if (this.updating) {
            return;
        }
        try {
            this.updating = true;
            for (int i2 = 0; i2 < this.cutoffFields.length; ++i2) {
                JFormattedTextField jFormattedTextField = this.cutoffFields[i2];
                JSpinner jSpinner = this.pctFields[i2];
                if (jFormattedTextField == object && jFormattedTextField.getValue() instanceof Number) {
                    jSpinner.setValue(this.a(((Number)jFormattedTextField.getValue()).doubleValue()));
                    break;
                }
                if (jSpinner.getModel() != object) continue;
                jFormattedTextField.setValue(this.b(((Number)jSpinner.getValue()).doubleValue()));
                break;
            }
            this.b();
            this.c();
        }
        finally {
            this.updating = false;
        }
    }

    public boolean b() {
        if (!this.isEnabled()) {
            return true;
        }
        boolean bl2 = true;
        for (int i2 = 1; i2 < this.cutoffFields.length; ++i2) {
            double d2;
            double d3 = ((Number)this.cutoffFields[i2].getValue()).doubleValue();
            if (!(d3 > (d2 = ((Number)this.cutoffFields[i2 - 1].getValue()).doubleValue()))) continue;
            bl2 = false;
            break;
        }
        String string = null;
        if (!bl2) {
            string = Messages.a("GeneralPreferencesCollectionFactory", "CARDIAC_ZSCORE_THRESHOLD_ERROR");
        }
        this.errLabel.setText(string);
        return bl2;
    }

    protected void c() {
        this.firePropertyChange("mimPropertyModified", false, true);
    }

    @Override
    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        for (JFormattedTextField jComponent : this.cutoffFields) {
            jComponent.setEnabled(bl2);
        }
        for (JComponent jComponent : this.pctFields) {
            jComponent.setEnabled(bl2);
        }
    }

    public void d() {
        if (!this.isEnabled()) {
            return;
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[this.cutoffFields.length];
        for (int i2 = 0; i2 < this.cutoffFields.length; ++i2) {
            Object object = this.cutoffFields[i2].getValue();
            if (!(object instanceof Number)) {
                ay.d((Object)("Invalid input detected when saving cardiac auto-score thresholds! " + String.valueOf(object)), this);
                return;
            }
            bigDecimalArray[i2] = new BigDecimal(((Number)object).doubleValue());
        }
        Arrays.sort(bigDecimalArray, Collections.reverseOrder());
        CardiacPrefs.autoscoreThresholds.setValue(bigDecimalArray);
    }

    private double a(double d2) {
        NormalDistribution normalDistribution = new NormalDistribution(0.0, 1.0);
        return 100.0 * normalDistribution.cumulativeProbability(d2);
    }

    private double b(double d2) {
        NormalDistribution normalDistribution = new NormalDistribution(0.0, 1.0);
        return normalDistribution.inverseCumulativeProbability(d2 / 100.0);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        jPanel.add(new CardiacAutoScoringCutoffEditor());
        jFrame.add(jPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(new Dimension(600, 400));
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    static /* synthetic */ JFormattedTextField[] a(CardiacAutoScoringCutoffEditor cardiacAutoScoringCutoffEditor, JFormattedTextField[] jFormattedTextFieldArray) {
        cardiacAutoScoringCutoffEditor.cutoffFields = jFormattedTextFieldArray;
        return jFormattedTextFieldArray;
    }

    static /* synthetic */ JSpinner[] a(CardiacAutoScoringCutoffEditor cardiacAutoScoringCutoffEditor, JSpinner[] jSpinnerArray) {
        cardiacAutoScoringCutoffEditor.pctFields = jSpinnerArray;
        return jSpinnerArray;
    }
}

