/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac.gui;

import com.google.common.collect.Lists;
import com.mimvista.cardiac.CardiacAnalysisController;
import com.mimvista.cardiac.CardiacAnalysisControllerManager;
import com.mimvista.cardiac.CardiacZScoreCalculator;
import com.mimvista.cardiac.SampledCardiacTransform;
import com.mimvista.cardiac.ZScoreModel;
import com.mimvista.cardiac.b;
import com.mimvista.cardiac.gui.CardiacSegments;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.internals.ViewController;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.work.m;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class DefectTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private final CardiacAnalysisController cac;
    private final DefectTableModel tableModel;

    public DefectTable(DefectTable defectTable) {
        this.cac = defectTable.cac;
        this.tableModel = defectTable.tableModel;
        this.setModel(this.tableModel);
        this.setColumnSelectionAllowed(false);
        this.setAutoscrolls(false);
        this.setSelectionModel(new a());
    }

    public DefectTable(ViewController viewController, CardiacAnalysisController.PolarPlotType polarPlotType) {
        this.cac = viewController == null ? null : viewController.g().a(CardiacAnalysisControllerManager.class).getAnalysisController(viewController);
        this.tableModel = this.a(viewController, polarPlotType);
        this.setModel(this.tableModel);
        this.setColumnSelectionAllowed(false);
        this.setAutoscrolls(false);
        this.setSelectionModel(new a());
    }

    private DefectTableModel a(ViewController viewController, CardiacAnalysisController.PolarPlotType polarPlotType) {
        return new DefectTableModel(viewController, polarPlotType);
    }

    private void a(ViewController viewController) {
        if (viewController == null || !viewController.e()) {
            throw new IllegalArgumentException("Defect table cannot be generated for non-cardiac series.");
        }
        if (viewController.g().a(CardiacAnalysisControllerManager.class).getAnalysisController(viewController) == null) {
            throw new IllegalArgumentException("Defect table cannot be generated from series without a Cardiac Analysis");
        }
    }

    public JComponent a() {
        DefectTable defectTable = new DefectTable(this);
        return defectTable.c();
    }

    public JComponent b() {
        DefectTable defectTable = new DefectTable(this);
        JScrollPane jScrollPane = defectTable.c();
        defectTable.setForeground(Color.black);
        defectTable.setBackground(Color.white);
        defectTable.getTableHeader().setForeground(Color.black);
        defectTable.getTableHeader().setBackground(Color.white);
        return jScrollPane;
    }

    private JScrollPane c() {
        JScrollPane jScrollPane = new JScrollPane(this);
        TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster(this);
        tableColumnAdjuster.setColumnDataIncluded(true);
        tableColumnAdjuster.setLastColumnAdjusted(true);
        tableColumnAdjuster.setColumnHeaderIncluded(true);
        tableColumnAdjuster.setOnlyAdjustLarger(true);
        tableColumnAdjuster.adjustColumns();
        this.setPreferredSize(new Dimension(this.getColumnModel().getTotalColumnWidth(), (int)this.getPreferredSize().getHeight()));
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        jScrollPane.setAutoscrolls(false);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        this.setSize(this.getPreferredScrollableViewportSize());
        jScrollPane.setSize(this.getPreferredSize());
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        jScrollPane.setMaximumSize(jScrollPane.getPreferredSize());
        return jScrollPane;
    }

    public static class a
    implements ListSelectionModel {
        @Override
        public boolean isSelectionEmpty() {
            return true;
        }

        @Override
        public boolean isSelectedIndex(int n2) {
            return false;
        }

        @Override
        public int getMinSelectionIndex() {
            return -1;
        }

        @Override
        public int getMaxSelectionIndex() {
            return -1;
        }

        @Override
        public int getLeadSelectionIndex() {
            return -1;
        }

        @Override
        public int getAnchorSelectionIndex() {
            return -1;
        }

        @Override
        public void setSelectionInterval(int n2, int n3) {
        }

        @Override
        public void setLeadSelectionIndex(int n2) {
        }

        @Override
        public void setAnchorSelectionIndex(int n2) {
        }

        @Override
        public void addSelectionInterval(int n2, int n3) {
        }

        @Override
        public void insertIndexInterval(int n2, int n3, boolean bl2) {
        }

        @Override
        public void clearSelection() {
        }

        @Override
        public void removeSelectionInterval(int n2, int n3) {
        }

        @Override
        public void removeIndexInterval(int n2, int n3) {
        }

        @Override
        public void setSelectionMode(int n2) {
        }

        @Override
        public int getSelectionMode() {
            return 0;
        }

        @Override
        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        }

        @Override
        public void setValueIsAdjusting(boolean bl2) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }
    }

    public static class DefectTableModel
    extends DefaultTableModel
    implements b {
        private static final long serialVersionUID = 1L;
        private Map<CardiacSegments.CardiacVascularTerritory, Integer> defectPercentages;
        private final ViewController series;
        private final CardiacAnalysisController cac;
        private CardiacAnalysisController.PolarPlotType type;
        private Object calcLock = new Object();
        private CountDownLatch calcLatch;

        public DefectTableModel(ViewController viewController, CardiacAnalysisController.PolarPlotType polarPlotType) {
            this.defectPercentages = new TreeMap<CardiacSegments.CardiacVascularTerritory, Integer>();
            this.series = viewController;
            this.type = polarPlotType;
            this.cac = viewController == null ? null : viewController.g().a(CardiacAnalysisControllerManager.class).getAnalysisController(viewController);
            this.b(ZScoreModel.c());
            this.d();
            this.e();
            this.a(this.type);
        }

        protected void b(ZScoreModel zScoreModel) {
            for (CardiacSegments.CardiacVascularTerritory cardiacVascularTerritory : CardiacSegments.CardiacVascularTerritory.values()) {
                Integer n2 = null;
                if (zScoreModel != ZScoreModel.c()) {
                    Pair<Double, Double> pair = zScoreModel.a(cardiacVascularTerritory);
                    int n3 = pair == null ? 0 : (int)Math.round((Double)pair.x / (Double)pair.y * 100.0);
                    n2 = new Integer(n3);
                }
                this.defectPercentages.put(cardiacVascularTerritory, n2);
            }
            this.fireTableDataChanged();
        }

        private void d() {
            if (this.cac != null && this.series != null && this.cac.controls(this.series)) {
                this.cac.getAnalysis(this.series).b(this);
            }
        }

        private void e() {
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            this.a(n2, n3);
            Map.Entry entry = (Map.Entry)Lists.newLinkedList(this.defectPercentages.entrySet()).get(n2);
            if (n3 == 0) {
                return entry.getKey();
            }
            Integer n4 = (Integer)entry.getValue();
            return n4 == null ? Messages.a("InfoItem", "NA_STRING") : n4;
        }

        private void a(int n2, int n3) {
            this.a(n2);
            this.b(n3);
        }

        private void a(int n2) {
            if (n2 < 0 || n2 >= this.getRowCount()) {
                throw new IndexOutOfBoundsException("Invalid vascular territory referenced in defect table.");
            }
        }

        private void b(int n2) {
            if (n2 < 0 || n2 >= 2) {
                throw new IndexOutOfBoundsException("Invalid column referenced in defect table");
            }
        }

        @Override
        public int getRowCount() {
            return this.defectPercentages == null ? 0 : this.defectPercentages.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n2) {
            this.b(n2);
            switch (n2) {
                case 0: {
                    return Messages.a("Cardiac", "DEFECT_TABLE_TERRITORY_HEADER");
                }
                case 1: {
                    return Messages.a("Cardiac", "DEFECT_TABLE_PERCENTAGE_HEADER");
                }
            }
            return null;
        }

        @Override
        public void a(SampledCardiacTransform sampledCardiacTransform) {
        }

        @Override
        public void a(ZScoreModel zScoreModel) {
            this.a(this.type);
        }

        public void a(final CardiacAnalysisController.PolarPlotType polarPlotType) {
            m.b.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = calcLock;
                    synchronized (object) {
                        this.c();
                        calcLatch = new CountDownLatch(1);
                        type = polarPlotType;
                    }
                    try {
                        long l2 = System.currentTimeMillis();
                        ZScoreModel zScoreModel = null;
                        if (cac != null) {
                            zScoreModel = type == CardiacAnalysisController.PolarPlotType.b ? cac.getReversibilityAnalysis().g() : cac.getAnalysis(series).g();
                        }
                        ZScoreModel zScoreModel2 = zScoreModel == null ? ZScoreModel.c() : zScoreModel;
                        this.b(zScoreModel2);
                        CardiacAnalysisController.printDebug("recomputed table in " + (System.currentTimeMillis() - l2) + " on " + Thread.currentThread().getName());
                    }
                    finally {
                        calcLatch.countDown();
                    }
                }
            });
        }

        public void c() {
            if (this.calcLatch != null) {
                try {
                    this.calcLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    ay.d((Object)"Error.", (Throwable)interruptedException, DefectTableModel.class);
                }
            }
        }

        @Override
        public void b() {
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        @Override
        public void a() {
        }

        @Override
        public void a(CardiacZScoreCalculator.AppliedCardiacComparisonSet appliedCardiacComparisonSet) {
        }
    }
}

