/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac.gui;

import com.google.common.collect.Sets;
import com.mimvista.cardiac.CardiacAnalysisController;
import com.mimvista.cardiac.CardiacAnalysisControllerManager;
import com.mimvista.cardiac.CardiacZScoreCalculator;
import com.mimvista.cardiac.gui.PolarPlotGraph;
import com.mimvista.cardiac.gui.PolarPlotSectionation;
import com.mimvista.cardiac.gui.b;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.mui.Session;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.widget.MIMWidgetDrawable;
import com.mimvista.neuro.ComparisonSet;
import com.mimvista.neuro.ComparisonSetFactory;
import com.mimvista.report.gui.content.constraintsgraph.DoseIdentifier;
import com.mimvista.util.Messages;
import com.mimvista.util.work.m;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.workflow.backend.t;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PolarPlotConfigurator
extends MIMWidgetDrawable {
    private static final long serialVersionUID = 1L;
    private static final int b = 24;
    private EnumComboBox<CardiacAnalysisController.PolarPlotType> plotType;
    private EnumComboBox<PolarScoreType> scoreType;
    private EnumComboBox<PolarPlotSectionation.SectionationType> sectionationType;
    private JCheckBox showSections;
    private JCheckBox showBlackout;
    private JButton drawBlackoutContour;
    private JLabel cardiacSectionsLabel;
    private JComboBox cardiacSectionsCombo;
    private JComboBox comparisonSetCombo;
    private JButton drawContourBtn;
    private PolarPlotGraph graph;
    private Map<String, String> properties;
    private Runnable callback;
    public boolean ignoreEvents = false;

    public PolarPlotConfigurator(PolarPlotGraph polarPlotGraph) {
        this.graph = polarPlotGraph;
        this.properties = null;
        this.g();
        this.c();
        this.j();
    }

    public PolarPlotConfigurator(PolarPlotGraph polarPlotGraph, Map<String, String> map) {
        this(polarPlotGraph);
        this.properties = map;
        polarPlotGraph.b(map);
    }

    public void a(boolean bl2) {
        this.cardiacSectionsLabel.setVisible(bl2);
        this.drawContourBtn.setVisible(bl2);
        this.cardiacSectionsCombo.setVisible(bl2);
    }

    public void M_() {
        int n2 = this.cardiacSectionsCombo.getSelectedIndex();
        int n3 = this.sectionationType.getSelectedIndex();
        this.removeAll();
        this.g();
        this.c();
        this.j();
        this.sectionationType.setSelectedIndex(n3);
        this.cardiacSectionsCombo.setSelectedIndex(n2);
    }

    private void g() {
        this.plotType = new EnumComboBox((Enum[])this.i());
        this.scoreType = new EnumComboBox((Enum[])PolarScoreType.values());
        this.sectionationType = new EnumComboBox((Enum[])PolarPlotSectionation.SectionationType.values());
        this.showSections = new JCheckBox(Messages.a("Cardiac", "POLAR_PLOT_SHOW_SECTIONS"));
        this.showBlackout = new JCheckBox(Messages.a("Cardiac", "POLAR_PLOT_SHOW_BLACKOUT"));
        this.drawBlackoutContour = new JButton(Messages.a("Cardiac", "POLAR_PLOT_DRAW_BLACKOUT"), ImageManipulator.c("pencil", 24));
        this.cardiacSectionsLabel = new JLabel(Messages.a("Cardiac", "POLAR_PLOT_SELECT_CARDIAC_SEGMENT"));
        this.drawContourBtn = new JButton(Messages.a("Cardiac", "POLAR_PLOT_ADD_CONTOUR"), ImageManipulator.c("pencil", 24));
        this.cardiacSectionsCombo = new JComboBox(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.h();
        this.cardiacSectionsCombo.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                if (object instanceof b) {
                    object = ((b)object).b.getExternalizedString();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            }
        });
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.comparisonSetCombo = new JComboBox(defaultComboBoxModel){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.a(defaultComboBoxModel);
        Box box = Box.createVerticalBox();
        Box box2 = new Box(0);
        box2.add(new JLabel(Messages.a("Cardiac", "POLAR_PLOT_TYPE")));
        box2.add(Box.createHorizontalGlue());
        box2.add(this.plotType);
        box.add(box2);
        box.add(Box.createVerticalStrut(5));
        Box box3 = new Box(0);
        box3.add(new JLabel(Messages.a("Cardiac", "POLAR_PLOT_SECTIONATION_TYPE")));
        box3.add(Box.createHorizontalGlue());
        box3.add(this.sectionationType);
        box.add(box3);
        box.add(Box.createVerticalStrut(10));
        Box box4 = new Box(0);
        box4.add(new JLabel(Messages.a("Cardiac", "POLAR_PLOT_COMPARISON_SET")));
        box4.add(Box.createHorizontalGlue());
        box4.add(this.comparisonSetCombo);
        box.add(box4);
        box.add(Box.createVerticalStrut(10));
        Box box5 = new Box(0);
        box5.add(new JLabel(Messages.a("Cardiac", "POLAR_PLOT_SCORE_TYPE")));
        box5.add(Box.createHorizontalGlue());
        box5.add(this.scoreType);
        box.add(box5);
        box.add(Box.createVerticalStrut(10));
        Box box6 = new Box(1);
        box6.add(this.showSections);
        box6.add(Box.createVerticalStrut(5));
        box6.add(this.showBlackout);
        box6.add(this.drawBlackoutContour);
        Box box7 = new Box(0);
        box7.add(box6);
        box7.add(Box.createHorizontalGlue());
        box.add(box7);
        box.add(Box.createVerticalStrut(5));
        box7 = new Box(0);
        box7.add(this.cardiacSectionsLabel);
        box7.add(Box.createHorizontalGlue());
        box.add(box7);
        box7 = new Box(0);
        box7.add(this.cardiacSectionsCombo);
        box7.add(Box.createHorizontalGlue());
        box7.add(this.drawContourBtn);
        box.add(box7);
        Dimension dimension = box.getPreferredSize();
        box.setMaximumSize(dimension);
        this.add(box);
    }

    private void h() {
        this.cardiacSectionsCombo.removeAllItems();
        List<b> list = this.graph.c().b();
        Collections.sort(list, new Comparator<b>(){

            public int a(b b2, b b3) {
                return b2.b.a() - b3.b.a();
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((b)object, (b)object2);
            }
        });
        this.cardiacSectionsCombo.addItem(Messages.a("General", "SELECT_ALL_LABEL"));
        for (b b2 : list) {
            this.cardiacSectionsCombo.addItem(b2);
        }
        this.k();
    }

    private CardiacAnalysisController.PolarPlotType[] i() {
        CardiacAnalysisController.PolarPlotType[] polarPlotTypeArray = new CardiacAnalysisController.PolarPlotType[]{};
        if (this.graph != null && this.graph.m() != null) {
            Session session = this.graph.m().g();
            CardiacAnalysisControllerManager cardiacAnalysisControllerManager = CardiacAnalysisControllerManager.getForSession(session);
            CardiacAnalysisController cardiacAnalysisController = cardiacAnalysisControllerManager.getAnalysisController(this.graph.m());
            Set<CardiacAnalysisController.PolarPlotType> set = cardiacAnalysisController.getAvailablePlotTypes(this.graph.m());
            set.add(this.graph.h());
            polarPlotTypeArray = set.toArray(polarPlotTypeArray);
        }
        return polarPlotTypeArray;
    }

    public void b(final boolean bl2) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                long l2 = System.currentTimeMillis();
                if (!bl2) {
                    PolarPlotConfigurator.this.ignoreEvents = true;
                }
                DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
                PolarPlotConfigurator.this.a(defaultComboBoxModel);
                PolarPlotConfigurator.this.comparisonSetCombo.setModel(defaultComboBoxModel);
                if (!bl2) {
                    PolarPlotConfigurator.this.ignoreEvents = false;
                }
                CardiacAnalysisController.printDebug("Reset combobox in " + (System.currentTimeMillis() - l2) + " on " + Thread.currentThread().getName());
            }
        });
    }

    protected void a(DefaultComboBoxModel defaultComboBoxModel) {
        ComparisonSet[] comparisonSetArray = ComparisonSetFactory.a().b(ComparisonSetFactory.ComparisonSetType.b);
        ComparisonSet[] comparisonSetArray2 = ComparisonSetFactory.a().a(ComparisonSetFactory.ComparisonSetType.b);
        this.comparisonSetCombo.setRenderer(new CardiacComparisonSetComboBoxRenderer(this.graph.l()));
        this.comparisonSetCombo.removeAllItems();
        defaultComboBoxModel.addElement(Messages.a("Neuro", "NEUROSIDE_DYN_SET"));
        for (ComparisonSet comparisonSet : comparisonSetArray) {
            defaultComboBoxModel.addElement(comparisonSet);
        }
        defaultComboBoxModel.addElement(Messages.a("Neuro", "NEUROSIDE_STATIC_SET"));
        ComparisonSet[] comparisonSetArray3 = comparisonSetArray2;
        int n2 = comparisonSetArray3.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ComparisonSet comparisonSet;
            comparisonSet = comparisonSetArray3[i2];
            defaultComboBoxModel.addElement(comparisonSet);
        }
        this.comparisonSetCombo.setModel(defaultComboBoxModel);
        boolean bl2 = false;
        for (n2 = 0; n2 < defaultComboBoxModel.getSize(); ++n2) {
            ComparisonSet comparisonSet;
            if (!(defaultComboBoxModel.getElementAt(n2) instanceof ComparisonSet) || !(comparisonSet = (ComparisonSet)defaultComboBoxModel.getElementAt(n2)).getName().equals(this.graph.g().c())) continue;
            this.comparisonSetCombo.setSelectedItem(comparisonSet);
            bl2 = true;
        }
        if (!bl2 && this.comparisonSetCombo.getModel().getSize() != 0) {
            this.comparisonSetCombo.setSelectedIndex(0);
        }
    }

    private void j() {
        this.showSections.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((PolarPlotConfigurator)PolarPlotConfigurator.this).graph.displayState.b(PolarPlotConfigurator.this.showSections.isSelected());
                PolarPlotConfigurator.this.e();
            }
        });
        this.showBlackout.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((PolarPlotConfigurator)PolarPlotConfigurator.this).graph.displayState.d(PolarPlotConfigurator.this.showBlackout.isSelected());
                PolarPlotConfigurator.this.e();
            }
        });
        this.drawBlackoutContour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                m.e.a(new Runnable(){

                    @Override
                    public void run() {
                        PolarPlotConfigurator.this.graph.b();
                    }
                }, "blackout contour drawing");
            }
        });
        this.plotType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    PolarPlotConfigurator.this.graph.a((CardiacAnalysisController.PolarPlotType)PolarPlotConfigurator.this.plotType.a());
                    PolarPlotConfigurator.this.e();
                }
            }
        });
        this.scoreType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    PolarPlotConfigurator.this.d();
                }
            }
        });
        this.sectionationType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PolarPlotSectionation.SectionationType sectionationType;
                if (itemEvent.getStateChange() == 1 && (sectionationType = (PolarPlotSectionation.SectionationType)PolarPlotConfigurator.this.sectionationType.a()) != PolarPlotConfigurator.this.graph.c().c()) {
                    PolarPlotConfigurator.this.graph.a((PolarPlotSectionation.SectionationType)PolarPlotConfigurator.this.sectionationType.a());
                    PolarPlotConfigurator.this.h();
                    PolarPlotConfigurator.this.e();
                }
            }
        });
        this.cardiacSectionsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getItem() instanceof b) {
                    b b2 = (b)itemEvent.getItem();
                    if (itemEvent.getStateChange() == 1) {
                        PolarPlotConfigurator.this.graph.c(b2);
                    } else if (itemEvent.getStateChange() == 2) {
                        PolarPlotConfigurator.this.graph.d(b2);
                    }
                    PolarPlotConfigurator.this.k();
                }
            }
        });
        this.drawContourBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PolarPlotConfigurator.this.cardiacSectionsCombo.getSelectedIndex() == 0) {
                    List<b> list = PolarPlotConfigurator.this.graph.c().b();
                    Collections.sort(list, new Comparator<b>(){

                        public int a(b b2, b b3) {
                            return b2.b.a() - b3.b.a();
                        }

                        @Override
                        public /* synthetic */ int compare(Object object, Object object2) {
                            return this.a((b)object, (b)object2);
                        }
                    });
                    for (b b2 : list) {
                        if (PolarPlotConfigurator.this.graph.b(b2) != null) continue;
                        PolarPlotConfigurator.this.graph.a(b2);
                    }
                } else {
                    b b3 = (b)PolarPlotConfigurator.this.cardiacSectionsCombo.getSelectedItem();
                    VolumetricContourOverlayish volumetricContourOverlayish = PolarPlotConfigurator.this.graph.b(b3);
                    if (volumetricContourOverlayish == null) {
                        PolarPlotConfigurator.this.graph.a(b3);
                    } else {
                        volumetricContourOverlayish.aZ();
                    }
                }
                PolarPlotConfigurator.this.k();
            }
        });
        this.b();
    }

    protected void b() {
        this.comparisonSetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof ComparisonSet) {
                    final ComparisonSet comparisonSet = (ComparisonSet)object;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CardiacAnalysisControllerManager.getForSession(PolarPlotConfigurator.this.graph.m().g()).getAnalysisController(PolarPlotConfigurator.this.graph.m()).changeComparisonSet(comparisonSet);
                        }
                    });
                }
            }
        });
    }

    public void c() {
        if (!this.graph.displayState.c()) {
            this.scoreType.setSelectedItem(PolarScoreType.a);
        } else if (CardiacAnalysisController.PolarPlotScoreType.c == this.graph.f()) {
            this.scoreType.setSelectedItem(PolarScoreType.c);
        } else {
            this.scoreType.setSelectedItem(PolarScoreType.b);
        }
        this.plotType.setSelectedItem(this.graph.h());
        this.showSections.setSelected(this.graph.displayState.b());
        this.showBlackout.setSelected(this.graph.displayState.d());
        this.sectionationType.setSelectedItem(this.graph.displayState.f());
        this.e();
    }

    public void d() {
        PolarScoreType polarScoreType = this.scoreType.a();
        if (PolarScoreType.b == polarScoreType) {
            if (this.plotType.a() == CardiacAnalysisController.PolarPlotType.b) {
                this.graph.a(CardiacAnalysisController.PolarPlotScoreType.a);
            } else if (CardiacAnalysisController.CardiacSeriesType.a == this.graph.i()) {
                this.graph.a(CardiacAnalysisController.PolarPlotScoreType.a);
            } else if (CardiacAnalysisController.CardiacSeriesType.b == this.graph.i()) {
                this.graph.a(CardiacAnalysisController.PolarPlotScoreType.b);
            } else {
                this.graph.a((CardiacAnalysisController.PolarPlotScoreType)null);
            }
        } else if (PolarScoreType.c == polarScoreType) {
            this.graph.a(CardiacAnalysisController.PolarPlotScoreType.c);
        }
        this.graph.a(this.plotType.a());
        this.graph.displayState.c(PolarScoreType.a != polarScoreType);
        this.graph.displayState.b(this.showSections.isSelected());
        this.graph.displayState.d(this.showBlackout.isSelected());
        this.graph.displayState.a(this.sectionationType.a());
        this.e();
    }

    protected void e() {
        if (this.properties != null) {
            this.graph.b(this.properties);
        }
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public void a(Map<String, String> map) {
        this.properties = map;
    }

    public void a(Runnable runnable) {
        this.callback = runnable;
    }

    public String f() {
        CardiacZScoreCalculator.AppliedCardiacComparisonSet appliedCardiacComparisonSet = CardiacAnalysisControllerManager.getForSession(this.graph.m().g()).getAnalysisController(this.graph.m()).getAnalysis(this.graph.i()).o();
        CardiacComparisonSetComboBoxRenderer cardiacComparisonSetComboBoxRenderer = (CardiacComparisonSetComboBoxRenderer)this.comparisonSetCombo.getRenderer();
        return appliedCardiacComparisonSet == null ? "" : cardiacComparisonSetComboBoxRenderer.a(appliedCardiacComparisonSet);
    }

    private void k() {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                Object object = PolarPlotConfigurator.this.cardiacSectionsCombo.getSelectedItem();
                if (object instanceof b) {
                    b b2 = (b)object;
                    VolumetricContourOverlayish volumetricContourOverlayish = PolarPlotConfigurator.this.graph.b(b2);
                    if (volumetricContourOverlayish != null) {
                        PolarPlotConfigurator.this.drawContourBtn.setIcon(ImageManipulator.c("localize_centroid", 24));
                        PolarPlotConfigurator.this.drawContourBtn.setText(Messages.a("Commands", "LOCALIZE_CONTOUR_NAME"));
                    } else {
                        PolarPlotConfigurator.this.drawContourBtn.setIcon(ImageManipulator.c("pencil", 24));
                        PolarPlotConfigurator.this.drawContourBtn.setText(Messages.a("Cardiac", "POLAR_PLOT_ADD_CONTOUR"));
                    }
                } else {
                    PolarPlotConfigurator.this.drawContourBtn.setIcon(ImageManipulator.c("pencil", 24));
                    PolarPlotConfigurator.this.drawContourBtn.setText(Messages.a("Cardiac", "POLAR_PLOT_ADD_CONTOUR"));
                }
                PolarPlotConfigurator.this.drawContourBtn.revalidate();
                PolarPlotConfigurator.this.drawContourBtn.repaint();
            }
        });
    }

    public static class EnumComboBox<EnumType extends Enum<?>>
    extends JComboBox {
        private static final long serialVersionUID = 1L;

        public EnumType a() {
            return (EnumType)((Enum)super.getSelectedItem());
        }

        public EnumComboBox(Class<EnumType> clazz) {
            this((Enum[])clazz.getEnumConstants());
        }

        public EnumComboBox(Class<EnumType> clazz, EnumType EnumType) {
            this((Enum[])clazz.getEnumConstants());
            this.setSelectedItem(EnumType);
        }

        public EnumComboBox(EnumType[] EnumTypeArray, EnumType EnumType) {
            this((Enum[])EnumTypeArray);
            if (!Sets.newHashSet((Object[])EnumTypeArray).contains(EnumType)) {
                throw new IllegalArgumentException("Selected value is not available.");
            }
            this.setSelectedItem(EnumType);
        }

        public EnumComboBox(EnumType[] EnumTypeArray) {
            super(EnumTypeArray);
            this.setRenderer(new EnumComboRenderer());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public /* synthetic */ Object getSelectedItem() {
            return this.a();
        }

        class EnumComboRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;

            EnumComboRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                Enum enum_ = (Enum)object;
                Component component = super.getListCellRendererComponent((JList<?>)jList, ((t)((Object)enum_)).getExternalizedString(), n2, bl2, bl3);
                if (enum_ instanceof DoseIdentifier && component instanceof JComponent) {
                    ((JComponent)component).setToolTipText(((DoseIdentifier)enum_).b());
                }
                return component;
            }
        }
    }

    private static class CardiacComparisonSetComboBoxRenderer
    extends DefaultListCellRenderer {
        private SeriesInfo info;

        public CardiacComparisonSetComboBoxRenderer(SeriesInfo seriesInfo) {
            this.info = seriesInfo;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            if (object instanceof ComparisonSet) {
                String string = this.a(CardiacZScoreCalculator.AppliedCardiacComparisonSet.a((ComparisonSet)object, this.info));
                return super.getListCellRendererComponent((JList<?>)jList, string, n2, bl2, bl3);
            }
            return super.getListCellRendererComponent((JList<?>)jList, object.toString(), n2, bl2, bl3);
        }

        String a(CardiacZScoreCalculator.AppliedCardiacComparisonSet appliedCardiacComparisonSet) {
            String string = "    " + appliedCardiacComparisonSet.c();
            string = string + "  (\u2006" + appliedCardiacComparisonSet.d().size() + "\u2006)";
            return string;
        }
    }

    public static enum PolarScoreType implements t
    {
        a(Messages.a("Cardiac", "POLAR_PLOT_SCORE_TYPE_NONE")),
        b(Messages.a("Cardiac", "POLAR_PLOT_SCORE_TYPE_SEGMENT")),
        c(CardiacAnalysisController.PolarPlotScoreType.c.getExternalizedString());

        private final String displayString;

        private PolarScoreType(String string2) {
            this.displayString = string2;
        }

        @Override
        public String getExternalizedString() {
            return this.displayString;
        }

        @Override
        public Icon getIcon(int n2) {
            return null;
        }
    }
}

