/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac.gui;

import com.google.common.collect.ImmutableList;
import com.mimvista.cardiac.CardiacAnalysisController;
import com.mimvista.cardiac.CardiacAnalysisControllerManager;
import com.mimvista.cardiac.CardiacAnalysisState;
import com.mimvista.cardiac.CardiacReversibilityAnalysisState;
import com.mimvista.cardiac.CardiacZScoreCalculator;
import com.mimvista.cardiac.PolarPoint;
import com.mimvista.cardiac.SampledCardiacTransform;
import com.mimvista.cardiac.SegmentalScores;
import com.mimvista.cardiac.ZScoreModel;
import com.mimvista.cardiac.a;
import com.mimvista.cardiac.b;
import com.mimvista.cardiac.gui.DefectTable;
import com.mimvista.cardiac.gui.PolarPlotConfigurator;
import com.mimvista.cardiac.gui.PolarPlotDisplayState;
import com.mimvista.cardiac.gui.PolarPlotSectionation;
import com.mimvista.commands.workflow.FourDeeFrameSelection;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.ContrastState;
import com.mimvista.internals.SimpleContour;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewControllerEdits;
import com.mimvista.internals.linking.ViewLink;
import com.mimvista.mui.ColorTable;
import com.mimvista.mui.bm;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.contourtools.n;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.swing.widgets.SpinnyLabel;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.q;
import com.mimvista.util.work.m;
import com.mimvista.viewer.ColorTableFactory;
import com.mimvista.viewer.SeriesInfo;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PolarPlotGraph
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static boolean a = false;
    protected static Messages b = Messages.a("Cardiac");
    private boolean needsRerender = true;
    private boolean scoringEnabled = true;
    private BufferedImage image;
    private TexturePaint blackoutFill;
    protected ColorTable colorTable = ColorTableFactory.a();
    protected ColorTable zScoreColorTable = ColorTableFactory.a();
    protected ColorTable wallThickeningColorTable = ColorTableFactory.a();
    protected SampledCardiacTransform model = SampledCardiacTransform.b();
    protected ZScoreModel zScores = ZScoreModel.c();
    protected PolarPlotDisplayState displayState = new PolarPlotDisplayState();
    protected PolarPlotSectionation sectionation = PolarPlotSectionation.a();
    private CardiacAnalysisController.PolarPlotType plotType = CardiacAnalysisController.PolarPlotType.a;
    private CardiacAnalysisController.CardiacSeriesType seriesType;
    private CardiacAnalysisController cac;
    private b analysisListener;
    private a cacListener;
    private ActionListener colorTableListener;
    protected DelayedActionRunner colorTableChanger;
    private PolarPlotConfigurator configurator;
    private JLabel scoreSumLabel;
    private SpinnyLabel spinner;
    private final AtomicInteger spinCounter;
    private JLabel mousePosition = new JLabel();
    private DefectTable.DefectTableModel defectTable = null;
    private Progress loadProgress;
    private static final String d = "scoring_enabled";
    private static final String e = "color_table";
    private static final String f = "z_color_table";
    private static final String g = "wall_thickening_color_table";
    public static final String c = "plot_type";
    private static final String h = "series_type";

    public PolarPlotGraph(ViewController viewController) {
        this(viewController, (Progress)new q());
    }

    public PolarPlotGraph(ViewController viewController, Progress progress) {
        this(progress);
        if (viewController != null) {
            this.a(viewController);
        }
    }

    public PolarPlotGraph(Progress progress) {
        this(CardiacAnalysisController.PolarPlotType.a, progress);
        this.repaint();
    }

    public static Map<String, String> a(ViewController viewController, CardiacAnalysisController.PolarPlotType polarPlotType) {
        CardiacAnalysisController cardiacAnalysisController = CardiacAnalysisControllerManager.getForSession(viewController.g()).getAnalysisController(viewController);
        if (cardiacAnalysisController == null) {
            return new HashMap<String, String>();
        }
        CardiacAnalysisController.CardiacSeriesType cardiacSeriesType = cardiacAnalysisController.getSeriesType(viewController);
        PolarPlotDisplayState polarPlotDisplayState = new PolarPlotDisplayState();
        polarPlotDisplayState.a(cardiacSeriesType == CardiacAnalysisController.CardiacSeriesType.b ? CardiacAnalysisController.PolarPlotScoreType.b : polarPlotDisplayState.e());
        if (polarPlotType == CardiacAnalysisController.PolarPlotType.c) {
            polarPlotDisplayState.c(true);
            if (cardiacSeriesType == CardiacAnalysisController.CardiacSeriesType.a) {
                polarPlotDisplayState.a(CardiacAnalysisController.PolarPlotScoreType.a);
            } else if (cardiacSeriesType == CardiacAnalysisController.CardiacSeriesType.b) {
                polarPlotDisplayState.a(CardiacAnalysisController.PolarPlotScoreType.b);
            }
        } else if (polarPlotType == CardiacAnalysisController.PolarPlotType.b) {
            polarPlotDisplayState.d(true);
        }
        ColorTable colorTable = ColorTableFactory.b("Functional", "Invert B-W");
        ColorTable colorTable2 = ColorTableFactory.b("Z-score", "Hypo 1-tail 95-99-99.9");
        ColorTable colorTable3 = ColorTableFactory.b("Functional", "Rainbow 10");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        polarPlotDisplayState.b(hashMap);
        hashMap.put(d, String.valueOf(true));
        hashMap.put(e, colorTable.name);
        hashMap.put(f, colorTable2.name);
        hashMap.put(g, colorTable3.name);
        hashMap.put(c, polarPlotType.name());
        hashMap.put(h, cardiacSeriesType == null ? "" : cardiacSeriesType.name());
        return hashMap;
    }

    private PolarPlotGraph(CardiacAnalysisController.PolarPlotType polarPlotType, Progress progress) {
        this.loadProgress = progress;
        this.configurator = null;
        this.sectionation = PolarPlotSectionation.a(this, PolarPlotSectionation.SectionationType.a);
        this.model = SampledCardiacTransform.b();
        this.colorTable = ColorTableFactory.b("Functional", "Invert B-W");
        this.zScoreColorTable = ColorTableFactory.b("Z-score", "Hypo 1-tail 95-99-99.9");
        this.wallThickeningColorTable = ColorTableFactory.b("Functional", "Rainbow 10");
        this.displayState = new PolarPlotDisplayState();
        this.plotType = polarPlotType;
        this.scoreSumLabel = new JLabel();
        this.spinner = new SpinnyLabel(){
            private static final long serialVersionUID = 1L;
            private Dimension dim = new Dimension(50, 50);

            @Override
            public Dimension getMinimumSize() {
                return this.dim;
            }

            @Override
            public Dimension getPreferredSize() {
                return this.dim;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.dim;
            }
        };
        this.spinCounter = new AtomicInteger(0);
        BufferedImage bufferedImage = this.p();
        this.blackoutFill = new TexturePaint(bufferedImage, new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
        this.q();
        this.r();
        this.o();
    }

    public static PolarPlotGraph a(Map<String, String> map, Progress progress) {
        PolarPlotGraph polarPlotGraph = new PolarPlotGraph((CardiacAnalysisController.PolarPlotType)null, progress);
        polarPlotGraph.d(map);
        return polarPlotGraph;
    }

    private void o() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.scoreSumLabel.setBackground(Color.red);
        this.scoreSumLabel.setForeground(Color.white);
        this.scoreSumLabel.setAlignmentY(0.0f);
        Box box = Box.createHorizontalBox();
        box.add(this.scoreSumLabel);
        box.add(Box.createHorizontalGlue());
        box.add(this.spinner);
        this.add((Component)box, "North");
        this.mousePosition.setBackground(Color.black);
        this.mousePosition.setForeground(Color.white);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.mousePosition, "East");
        this.add((Component)jPanel, "South");
        this.spinner.setVisible(false);
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return new Dimension(400, 400);
        }
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.scoreSumLabel != null) {
            this.scoreSumLabel.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.scoreSumLabel != null) {
            this.scoreSumLabel.setForeground(color);
        }
    }

    private BufferedImage p() {
        BufferedImage bufferedImage = new BufferedImage(5, 5, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.red);
        graphics.drawLine(0, 0, 4, 4);
        graphics.drawLine(0, 4, 4, 0);
        return bufferedImage;
    }

    private void q() {
        this.analysisListener = new b.a(){

            @Override
            public void a(SampledCardiacTransform sampledCardiacTransform) {
                if (PolarPlotGraph.this.plotType == CardiacAnalysisController.PolarPlotType.a) {
                    PolarPlotGraph.this.a(sampledCardiacTransform);
                }
            }

            @Override
            public void a(ZScoreModel zScoreModel) {
                long l2 = System.currentTimeMillis();
                PolarPlotGraph.this.v();
                l2 = System.currentTimeMillis() - l2;
                if (l2 > 2L) {
                    CardiacAnalysisController.printDebug("PPG Zscore changed in " + l2 + " on " + Thread.currentThread().getName());
                }
            }

            @Override
            public void b() {
                if (PolarPlotGraph.this.sectionation != null) {
                    PolarPlotGraph.this.repaint();
                }
            }

            @Override
            public void a() {
                if (PolarPlotGraph.this.configurator != null) {
                    MIMSwingUtils.a(new Runnable(){

                        @Override
                        public void run() {
                            PolarPlotGraph.this.configurator.b(false);
                        }
                    });
                }
            }

            @Override
            public void a(CardiacZScoreCalculator.AppliedCardiacComparisonSet appliedCardiacComparisonSet) {
                PolarPlotGraph.this.v();
            }
        };
        this.cacListener = new a(){

            @Override
            public void a(CardiacReversibilityAnalysisState cardiacReversibilityAnalysisState) {
                if (PolarPlotGraph.this.plotType == CardiacAnalysisController.PolarPlotType.b) {
                    PolarPlotGraph.this.a(cardiacReversibilityAnalysisState.e());
                }
            }

            @Override
            public void a(CardiacAnalysisController.CardiacSeriesType cardiacSeriesType, CardiacAnalysisState cardiacAnalysisState) {
                if (cardiacSeriesType == PolarPlotGraph.this.seriesType && cardiacAnalysisState.c() != PolarPlotGraph.this.m().aV()) {
                    PolarPlotGraph.this.a((ViewController)null);
                }
            }
        };
        this.colorTableListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewController viewController = PolarPlotGraph.this.m();
                if (viewController != null && PolarPlotGraph.this.plotType != CardiacAnalysisController.PolarPlotType.c && PolarPlotGraph.this.plotType != CardiacAnalysisController.PolarPlotType.d) {
                    PolarPlotGraph.this.a(viewController.bb());
                }
            }
        };
    }

    private void r() {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                PolarPlotGraph.this.a(mouseEvent);
                if (a) {
                    PolarPoint polarPoint = PolarPlotGraph.this.a(mouseEvent.getPoint());
                    for (com.mimvista.cardiac.gui.b b2 : PolarPlotGraph.this.sectionation.b()) {
                        if (b2.a(polarPoint)) {
                            PolarPlotGraph.this.sectionation.a(b2);
                            continue;
                        }
                        PolarPlotGraph.this.sectionation.b(b2);
                    }
                    NumberFormat numberFormat = NumberFormatFactory.a();
                    PolarPlotGraph.this.mousePosition.setText("r:\t" + numberFormat.format(polarPoint.r) + "\nt:\t" + numberFormat.format(polarPoint.theta));
                    PolarPlotGraph.this.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PolarPlotGraph.this.a(mouseEvent);
                if (PolarPlotGraph.this.displayState.c() && PolarPlotGraph.this.scoringEnabled && (PolarPlotGraph.this.displayState.e() == CardiacAnalysisController.PolarPlotScoreType.b || PolarPlotGraph.this.displayState.e() == CardiacAnalysisController.PolarPlotScoreType.a) && mouseEvent.isControlDown()) {
                    mouseEvent.setSource(PolarPlotGraph.this);
                    PolarPlotGraph.this.sectionation.a(mouseEvent);
                } else {
                    PolarPoint polarPoint = PolarPlotGraph.this.a(mouseEvent.getPoint());
                    VoxelPoint3f voxelPoint3f = PolarPlotGraph.this.model.a(polarPoint);
                    ViewController viewController = PolarPlotGraph.this.m();
                    if (PolarPlotGraph.this.plotType == CardiacAnalysisController.PolarPlotType.b) {
                        viewController = PolarPlotGraph.this.cac.getSeries(CardiacAnalysisController.CardiacSeriesType.a);
                    }
                    if (voxelPoint3f != null) {
                        List<Integer> list;
                        if (PolarPlotGraph.this.plotType == CardiacAnalysisController.PolarPlotType.d && (list = FourDeeFrameSelection.a(viewController, FourDeeFrameSelection.e, 0)).get(0) >= 0) {
                            int n2 = list.get(0);
                            viewController.b(n2);
                        }
                        new ViewControllerEdits.LocalizeEdit(voxelPoint3f.b(), viewController);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PolarPlotGraph.this.mousePosition.setText("");
            }
        });
        this.displayState.a(new PolarPlotDisplayState.a(){

            @Override
            public void a(PolarPlotDisplayState.State state) {
                switch (state) {
                    case d: {
                        PolarPlotGraph.this.a();
                        break;
                    }
                    case f: {
                        PolarPlotGraph.this.sectionation = PolarPlotSectionation.a(PolarPlotGraph.this, PolarPlotGraph.this.displayState.f());
                        PolarPlotGraph.this.repaint();
                        break;
                    }
                    default: {
                        PolarPlotGraph.this.repaint();
                    }
                }
            }
        });
        if (this.cac != null) {
            this.cac.addListener(this.cacListener);
            if (this.seriesType != null) {
                this.cac.getAnalysis(this.seriesType).b(this.analysisListener);
            }
        }
    }

    protected String a(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        String string = "";
        PolarPoint polarPoint = this.a(point);
        if (polarPoint.r <= 1.0) {
            NumberFormat numberFormat = NumberFormatFactory.a();
            if (this.plotType == CardiacAnalysisController.PolarPlotType.c) {
                float f2 = this.model.c(polarPoint);
                string = numberFormat.format(f2);
            } else if (this.plotType == CardiacAnalysisController.PolarPlotType.d) {
                float f3 = this.model.c(polarPoint) * 100.0f;
                string = numberFormat.format(f3) + "%";
            } else {
                VoxelPoint3f voxelPoint3f = this.model.a(polarPoint);
                if (voxelPoint3f != null) {
                    float f4 = this.m().a(voxelPoint3f);
                    string = numberFormat.format(f4);
                }
            }
        }
        this.mousePosition.setText(string + " ");
        this.mousePosition.setSize(this.mousePosition.getPreferredSize());
        return string;
    }

    @Override
    public void reshape(int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n4, n5);
        super.reshape(n2 + (int)Math.round(0.5 * (double)(n4 - n6)), n3 + (int)Math.round(0.5 * (double)(n5 - n6)), n6, n6);
        this.a(true);
    }

    public void a() {
        this.c(true);
    }

    private synchronized void c(boolean bl2) {
        long l2 = System.currentTimeMillis();
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            this.a(true);
            return;
        }
        if (this.image == null || this.image.getWidth() != this.getWidth()) {
            this.s();
        }
        WritableRaster writableRaster = this.image.getRaster();
        this.a(writableRaster);
        this.a(false);
        if (bl2) {
            this.repaint();
        }
        CardiacAnalysisController.printDebug("PPG rerender in " + (System.currentTimeMillis() - l2) + " on " + Thread.currentThread());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.needsRerender) {
            this.c(false);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.a(graphics2D);
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.b(graphics2D);
        this.c(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    synchronized void a(WritableRaster writableRaster) {
        Float f2;
        Float f3;
        ImmutableList<ColorTable.RGB> immutableList = this.n().palette.f();
        Color color = this.getBackground();
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue(), 255};
        int[] nArray2 = new int[]{0, 0, 0, 255};
        ColorTable.RGB rGB = new ColorTable.RGB(color.getRed(), color.getGreen(), color.getBlue());
        if (this.plotType == CardiacAnalysisController.PolarPlotType.c) {
            f3 = this.zScoreColorTable.contrastUpper;
            f2 = this.zScoreColorTable.contrastLower;
            if (f3 == null || f2 == null) {
                f3 = Float.valueOf(5.0f);
                f2 = Float.valueOf(-5.0f);
            }
        } else if (this.plotType == CardiacAnalysisController.PolarPlotType.d) {
            f3 = this.wallThickeningColorTable.contrastUpper;
            f2 = this.wallThickeningColorTable.contrastLower;
            if (f3 == null || f2 == null) {
                f3 = Float.valueOf(1.0f);
                f2 = Float.valueOf(0.0f);
            }
        } else {
            ViewController viewController = this.plotType == CardiacAnalysisController.PolarPlotType.b ? (this.cac != null ? this.cac.getSeries(CardiacAnalysisController.CardiacSeriesType.a) : null) : this.m();
            if (viewController == null) {
                for (int i2 = 0; i2 < writableRaster.getHeight(); ++i2) {
                    for (int i3 = 0; i3 < writableRaster.getWidth(); ++i3) {
                        writableRaster.setPixel(i3, i2, nArray);
                    }
                }
                return;
            }
            ContrastState contrastState = viewController.av();
            f3 = Float.valueOf(contrastState.g());
            f2 = Float.valueOf(contrastState.f());
        }
        for (int i4 = 0; i4 < writableRaster.getHeight(); ++i4) {
            for (int i5 = 0; i5 < writableRaster.getWidth(); ++i5) {
                PolarPoint polarPoint = this.a(new Point(i5, i4));
                if (polarPoint.r <= 1.0) {
                    int n2 = this.displayState.d() && this.zScores.d(polarPoint) ? 0 : 255;
                    float f4 = this.model.h().b(this.model.c(polarPoint));
                    boolean bl2 = this.zScores.e(polarPoint);
                    boolean bl3 = true;
                    if (bl3) {
                        float f5 = (f4 - f2.floatValue()) / (f3.floatValue() - f2.floatValue());
                        int n3 = Math.round(f5 * (float)(immutableList.size() - 1));
                        n3 = MathUtils.b(n3, 0, immutableList.size() - 1);
                        ColorTable.RGB rGB2 = bl2 ? rGB : (ColorTable.RGB)immutableList.get(n3);
                        nArray2[0] = rGB2.red;
                        nArray2[1] = rGB2.green;
                        nArray2[2] = rGB2.blue;
                        nArray2[3] = n2;
                    } else {
                        if (f4 < 0.0f) {
                            nArray2[0] = 0;
                            nArray2[2] = (int)Math.floor(Math.min(Math.abs(f4), 3.0f) * 255.0f * 0.33333334f);
                        } else {
                            nArray2[0] = (int)Math.floor(Math.min(Math.abs(f4), 3.0f) * 255.0f * 0.33333334f);
                            nArray2[2] = 0;
                        }
                        nArray2[1] = 0;
                        nArray2[3] = n2;
                    }
                    writableRaster.setPixel(i5, i4, nArray2);
                    continue;
                }
                writableRaster.setPixel(i5, i4, nArray);
            }
        }
    }

    public void b() {
        VolumetricContourOverlay volumetricContourOverlay = this.zScores.a().ba().g(false);
        volumetricContourOverlay.c(b.getProperty("POLAR_PLOT_BLACKOUT_REGION_NAME"));
        this.zScores.f().d().forEach(polarPoint -> {
            if (this.zScores.d((PolarPoint)polarPoint)) {
                volumetricContourOverlay.aq().d((SimpleContour)this.model.b((PolarPoint)polarPoint));
            }
        });
        n.a a2 = new n.a();
        a2.a(volumetricContourOverlay);
        volumetricContourOverlay.au().bD();
        volumetricContourOverlay.aD().Q();
    }

    public void a(boolean bl2) {
        this.needsRerender = bl2;
    }

    public void a(PolarPlotSectionation.SectionationType sectionationType) {
        this.displayState.a(sectionationType);
    }

    public PolarPlotSectionation c() {
        return this.sectionation;
    }

    public void a(SampledCardiacTransform sampledCardiacTransform) {
        if (sampledCardiacTransform == null) {
            sampledCardiacTransform = SampledCardiacTransform.b();
        }
        if (sampledCardiacTransform != this.model) {
            this.model = sampledCardiacTransform;
            this.a();
        }
    }

    public void a(ZScoreModel zScoreModel) {
        if (zScoreModel == null) {
            zScoreModel = ZScoreModel.c();
        }
        if (this.zScores != zScoreModel) {
            this.zScores = zScoreModel;
            this.a();
            this.z();
        }
    }

    public void a(com.mimvista.cardiac.gui.b b2) {
        this.model.a(b2);
    }

    public VolumetricContourOverlayish b(com.mimvista.cardiac.gui.b b2) {
        for (VolumetricContourOverlayish volumetricContourOverlayish : this.model.a().ba().Q()) {
            if (!volumetricContourOverlayish.getName().equals(b2.d().toString())) continue;
            return volumetricContourOverlayish;
        }
        return null;
    }

    public void a(ColorTable colorTable) {
        if (this.plotType == CardiacAnalysisController.PolarPlotType.c) {
            if (colorTable != this.zScoreColorTable) {
                if (colorTable != null && this.zScoreColorTable != null) {
                    colorTable = colorTable.a(this.zScoreColorTable.contrastLower, this.zScoreColorTable.contrastUpper);
                }
                this.zScoreColorTable = colorTable == null ? ColorTableFactory.a() : colorTable;
                this.a();
            }
        } else if (this.plotType == CardiacAnalysisController.PolarPlotType.d) {
            if (colorTable != this.wallThickeningColorTable) {
                if (colorTable != null && this.wallThickeningColorTable != null) {
                    colorTable = colorTable.a(this.wallThickeningColorTable.contrastLower, this.wallThickeningColorTable.contrastUpper);
                }
                this.wallThickeningColorTable = colorTable == null ? ColorTableFactory.a() : colorTable;
                this.a();
            }
        } else if (colorTable != this.colorTable) {
            this.colorTable = colorTable == null ? ColorTableFactory.a() : colorTable;
            this.a();
        }
        if (this.configurator != null) {
            this.configurator.e();
        }
    }

    private void s() {
        this.image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.a(true);
    }

    private void a(Graphics2D graphics2D) {
        Paint paint = graphics2D.getPaint();
        Point2D point2D = this.d();
        double d2 = this.e();
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - d2, point2D.getY() - d2, 2.0 * d2, 2.0 * d2);
        if (this.plotType == CardiacAnalysisController.PolarPlotType.b) {
            graphics2D.setPaint(this.blackoutFill);
        } else {
            graphics2D.setPaint(Color.BLACK);
        }
        graphics2D.fill(double_);
        graphics2D.setPaint(paint);
    }

    private synchronized void b(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(10, 1.0f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        graphics2D.setComposite(composite);
    }

    private void c(Graphics2D graphics2D) {
        if (this.displayState.b()) {
            this.sectionation.a(graphics2D);
        }
        if (this.displayState.c()) {
            this.sectionation.b(graphics2D);
            this.t();
        } else {
            this.scoreSumLabel.setText("");
        }
        if (this.displayState.a()) {
            graphics2D.drawOval(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void t() {
        SegmentalScores.ScoreMap scoreMap = this.u();
        String string = "";
        if (!scoreMap.isEmpty()) {
            int n2 = scoreMap.a();
            switch (this.f()) {
                case a: {
                    string = b.getProperty("SUM_SCORE_STRESS") + "\u200a" + String.valueOf(n2);
                    break;
                }
                case b: {
                    string = b.getProperty("SUM_SCORE_REST") + "\u200a" + String.valueOf(n2);
                    break;
                }
                case c: {
                    string = b.getProperty("SUM_SCORE_DIFFERENCE") + "\u200a" + String.valueOf(n2);
                    break;
                }
                default: {
                    string = "";
                }
            }
        }
        if (this.scoreSumLabel.getFont().getSize2D() != 11.5f) {
            this.scoreSumLabel.setFont(this.scoreSumLabel.getFont().deriveFont(11.5f));
        }
        if (!cn.a(this.scoreSumLabel.getText(), string, true)) {
            this.scoreSumLabel.setText(string);
        }
        Dimension dimension = this.scoreSumLabel.getPreferredSize();
        if (!this.scoreSumLabel.getSize().equals(dimension)) {
            this.scoreSumLabel.setSize(dimension);
        }
    }

    public PolarPoint a(Point2D point2D) {
        Point2D point2D2 = this.d();
        double d2 = point2D.distance(point2D2) / this.e();
        double d3 = Math.atan2(point2D2.getY() - point2D.getY(), point2D.getX() - point2D2.getX());
        return new PolarPoint(d2, d3);
    }

    public Point2D a(PolarPoint polarPoint) {
        double d2 = polarPoint.r * this.e();
        double d3 = d2 * Math.cos(polarPoint.theta);
        double d4 = d2 * Math.sin(polarPoint.theta);
        Point2D point2D = this.d();
        return new Point2D.Double(point2D.getX() + d3, point2D.getY() - d4);
    }

    public Point2D d() {
        double d2 = 0.5 * (double)this.getWidth();
        double d3 = 0.5 * (double)this.getHeight();
        return new Point2D.Double(d2, d3);
    }

    public double e() {
        double d2 = Math.min(this.getWidth(), this.getHeight());
        return 0.5 * (d2 - 2.0);
    }

    public void b(boolean bl2) {
        this.scoringEnabled = bl2;
    }

    public CardiacAnalysisController.PolarPlotScoreType f() {
        return this.displayState.e();
    }

    public CardiacZScoreCalculator.AppliedCardiacComparisonSet g() {
        return this.cac.getAnalysis(this.seriesType).o();
    }

    public void a(CardiacAnalysisController.PolarPlotType polarPlotType) {
        if (this.plotType == CardiacAnalysisController.PolarPlotType.c ^ polarPlotType == CardiacAnalysisController.PolarPlotType.c) {
            this.a(true);
        }
        this.plotType = polarPlotType;
        this.v();
        if (this.cac != null && this.seriesType != null) {
            if (this.plotType == CardiacAnalysisController.PolarPlotType.d) {
                this.a(ColorTableFactory.a("Rainbow 10"));
            } else if (this.plotType != CardiacAnalysisController.PolarPlotType.c) {
                this.a(this.m().bb());
            }
        }
    }

    public void a(CardiacAnalysisController.PolarPlotScoreType polarPlotScoreType) {
        this.displayState.a(polarPlotScoreType);
    }

    public CardiacAnalysisController.PolarPlotType h() {
        return this.plotType;
    }

    public CardiacAnalysisController.CardiacSeriesType i() {
        return this.seriesType;
    }

    public String j() {
        if (this.h() == CardiacAnalysisController.PolarPlotType.b) {
            return this.h().getExternalizedString();
        }
        return MIMFormat.a(Messages.a("Cardiac", "POLAR_PLOT_HEADING_FORMAT"), this.i().getExternalizedString(), this.h().getExternalizedString());
    }

    public PolarPlotConfigurator k() {
        if (this.configurator == null) {
            this.configurator = new PolarPlotConfigurator(this);
        }
        return this.configurator;
    }

    public PolarPlotConfigurator a(Map<String, String> map) {
        if (this.configurator == null) {
            this.configurator = new PolarPlotConfigurator(this, map);
        }
        this.configurator.a(map);
        return this.configurator;
    }

    private SegmentalScores.ScoreMap u() {
        if (this.sectionation != null) {
            return this.b(this.sectionation.c());
        }
        return SegmentalScores.ScoreMap.b();
    }

    public SegmentalScores.ScoreMap b(PolarPlotSectionation.SectionationType sectionationType) {
        if (this.cac == null) {
            return SegmentalScores.ScoreMap.b();
        }
        CardiacAnalysisController.PolarPlotScoreType polarPlotScoreType = this.displayState.e();
        if (polarPlotScoreType == CardiacAnalysisController.PolarPlotScoreType.b && this.h() == CardiacAnalysisController.PolarPlotType.b) {
            polarPlotScoreType = CardiacAnalysisController.PolarPlotScoreType.a;
        }
        return this.cac.getScores(polarPlotScoreType, sectionationType);
    }

    public void a(ViewController viewController) {
        CardiacAnalysisController cardiacAnalysisController;
        CardiacAnalysisController cardiacAnalysisController2 = cardiacAnalysisController = viewController == null ? null : CardiacAnalysisControllerManager.getForSession(viewController.g()).getAnalysisController(viewController);
        if (cardiacAnalysisController == null) {
            if (viewController != null) {
                ay.c((Object)"Polar plot cannot display series because it has no Cardiac Analysis", this);
            }
            this.a((CardiacAnalysisController)null);
        } else {
            this.a(cardiacAnalysisController);
            this.b(viewController);
        }
    }

    private void a(CardiacAnalysisController cardiacAnalysisController) {
        if (this.cac != null) {
            this.cac.removeListener(this.cacListener);
            if (this.seriesType != null) {
                this.cac.getAnalysis(this.seriesType).a(this.analysisListener);
                this.m().b(this.colorTableListener, ViewLink.ViewEvent.v);
            }
        }
        if (cardiacAnalysisController != null) {
            cardiacAnalysisController.addListener(this.cacListener);
            if (this.seriesType != null) {
                cardiacAnalysisController.getAnalysis(this.seriesType).b(this.analysisListener);
            }
        }
        this.cac = cardiacAnalysisController;
    }

    @Deprecated
    public void a(CardiacAnalysisController.CardiacSeriesType cardiacSeriesType) {
        this.seriesType = cardiacSeriesType;
    }

    private void b(ViewController viewController) {
        this.b(this.cac.getSeriesType(viewController));
        this.colorTable = viewController.bb();
        viewController.a(this.colorTableListener, ViewLink.ViewEvent.v);
        this.y();
        this.v();
        if (this.configurator != null) {
            this.configurator.d();
        }
    }

    private void b(CardiacAnalysisController.CardiacSeriesType cardiacSeriesType) {
        if (this.cac != null && this.seriesType != null) {
            this.cac.getAnalysis(this.seriesType).a(this.analysisListener);
        }
        if (this.cac != null && cardiacSeriesType != null) {
            this.cac.getAnalysis(cardiacSeriesType).b(this.analysisListener);
        }
        this.seriesType = cardiacSeriesType;
        if (this.plotType == CardiacAnalysisController.PolarPlotType.c) {
            this.displayState.c(true);
            if (cardiacSeriesType == CardiacAnalysisController.CardiacSeriesType.a) {
                this.displayState.a(CardiacAnalysisController.PolarPlotScoreType.a);
            } else if (cardiacSeriesType == CardiacAnalysisController.CardiacSeriesType.b) {
                this.displayState.a(CardiacAnalysisController.PolarPlotScoreType.b);
            }
        } else if (this.plotType == CardiacAnalysisController.PolarPlotType.b) {
            this.displayState.d(true);
        }
    }

    public SeriesInfo l() {
        if (this.cac != null && this.seriesType != null) {
            return this.cac.getAnalysis(this.seriesType).d().aP();
        }
        return null;
    }

    private void v() {
        this.b(this.plotType);
    }

    private void b(final CardiacAnalysisController.PolarPlotType polarPlotType) {
        if (this.cac == null) {
            return;
        }
        m.e.a(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Future<SampledCardiacTransform> future = PolarPlotGraph.this.cac.getTransform(PolarPlotGraph.this.seriesType, polarPlotType);
                Future<ZScoreModel> future2 = PolarPlotGraph.this.cac.getZScoreTransform(PolarPlotGraph.this.seriesType, polarPlotType);
                boolean bl2 = false;
                if (!future.isDone() || !future2.isDone()) {
                    PolarPlotGraph.this.w();
                    bl2 = true;
                }
                try {
                    SampledCardiacTransform sampledCardiacTransform = future.get();
                    if (PolarPlotGraph.this.plotType == polarPlotType) {
                        PolarPlotGraph.this.a(sampledCardiacTransform);
                    }
                    ZScoreModel zScoreModel = future2.get();
                    if (PolarPlotGraph.this.plotType == polarPlotType) {
                        PolarPlotGraph.this.a(zScoreModel);
                    }
                }
                catch (Exception exception) {
                    ay.d((Object)exception, PolarPlotGraph.this);
                }
                finally {
                    if (bl2) {
                        PolarPlotGraph.this.x();
                    }
                }
            }
        }, "transform update");
    }

    private void w() {
        if (this.spinCounter.incrementAndGet() == 1) {
            this.spinner.setVisible(true);
            this.spinner.a();
            this.loadProgress.a();
            this.repaint();
        }
    }

    private void x() {
        if (this.spinCounter.decrementAndGet() == 0) {
            this.spinner.setVisible(false);
            this.spinner.c();
            this.loadProgress.b();
            this.repaint();
        }
    }

    private void y() {
        this.b(CardiacAnalysisController.PolarPlotType.c);
    }

    public ViewController m() {
        if (this.cac == null) {
            return null;
        }
        return this.cac.getSeries(this.seriesType);
    }

    public void b(Map<String, String> map) {
        this.displayState.b(map);
        map.put(d, String.valueOf(this.scoringEnabled));
        map.put(e, this.colorTable.name);
        map.put(f, this.zScoreColorTable.name);
        map.put(g, this.wallThickeningColorTable.name);
        map.put(c, this.plotType.name());
        map.put(h, this.seriesType == null ? "" : this.seriesType.name());
    }

    public void c(Map<String, String> map) {
        this.displayState.c(map);
        this.scoringEnabled = Boolean.valueOf(map.get(d));
        this.colorTable = ColorTableFactory.a(map.get(e));
        ColorTable colorTable = ColorTableFactory.a(map.get(f));
        ColorTable colorTable2 = ColorTableFactory.a(map.get(g));
        this.zScoreColorTable = colorTable.a(this.zScoreColorTable.contrastLower, this.zScoreColorTable.contrastUpper);
        this.wallThickeningColorTable = colorTable2.a(this.wallThickeningColorTable.contrastLower, this.wallThickeningColorTable.contrastUpper);
        this.plotType = CardiacAnalysisController.PolarPlotType.valueOf(map.get(c));
        this.seriesType = CardiacAnalysisController.CardiacSeriesType.valueOf(map.get(h));
        ViewController viewController = null;
        for (CardiacAnalysisController cardiacAnalysisController : CardiacAnalysisControllerManager.getForSession(bm.b()).getAnalysisControllers()) {
            if (cardiacAnalysisController.getSeries(this.seriesType) == null) continue;
            viewController = cardiacAnalysisController.getSeries(this.seriesType);
            break;
        }
        this.a(viewController);
        this.a();
    }

    private void d(Map<String, String> map) {
        this.displayState.a(map);
        this.scoringEnabled = Boolean.valueOf(map.get(d));
        ColorTable colorTable = ColorTableFactory.a(map.get(e));
        ColorTable colorTable2 = ColorTableFactory.a(map.get(f));
        ColorTable colorTable3 = ColorTableFactory.a(map.get(g));
        this.colorTable = colorTable == null ? this.colorTable : colorTable;
        this.zScoreColorTable = colorTable2 == null ? this.zScoreColorTable : colorTable2.a(this.zScoreColorTable.contrastLower, this.zScoreColorTable.contrastUpper);
        this.wallThickeningColorTable = colorTable3 == null ? this.wallThickeningColorTable : colorTable3.a(this.wallThickeningColorTable.contrastLower, this.wallThickeningColorTable.contrastUpper);
        this.plotType = CardiacAnalysisController.PolarPlotType.a(map.get(c));
        this.seriesType = CardiacAnalysisController.CardiacSeriesType.a(map.get(h));
        this.cac = null;
        this.sectionation = PolarPlotSectionation.a(this, this.displayState.f());
        CardiacAnalysisController.CardiacSeriesType cardiacSeriesType = this.seriesType = CardiacAnalysisController.CardiacSeriesType.a(map.get(h));
        if (cardiacSeriesType != null) {
            for (CardiacAnalysisController cardiacAnalysisController : CardiacAnalysisControllerManager.getForSession(bm.b()).getAnalysisControllers()) {
                if (cardiacAnalysisController.getSeries(cardiacSeriesType) == null) continue;
                this.a(cardiacAnalysisController);
                this.b(cardiacSeriesType);
                ViewController viewController = cardiacAnalysisController.getSeries(cardiacSeriesType);
                viewController.a(this.colorTableListener, ViewLink.ViewEvent.v);
            }
        }
    }

    public void c(com.mimvista.cardiac.gui.b b2) {
        if (b2 != null) {
            this.sectionation.a(b2);
            this.repaint();
        }
    }

    public void d(com.mimvista.cardiac.gui.b b2) {
        if (b2 != null) {
            this.sectionation.b(b2);
            this.repaint();
        }
    }

    public ColorTable n() {
        if (this.plotType == CardiacAnalysisController.PolarPlotType.c) {
            return this.zScoreColorTable;
        }
        if (this.plotType == CardiacAnalysisController.PolarPlotType.d) {
            this.wallThickeningColorTable = this.wallThickeningColorTable.a(Float.valueOf(0.0f), Float.valueOf(1.0f));
            return this.wallThickeningColorTable;
        }
        return this.colorTable;
    }

    public void a(DefectTable defectTable) {
        if (defectTable == null) {
            this.defectTable = null;
            return;
        }
        this.defectTable = (DefectTable.DefectTableModel)defectTable.getModel();
        this.z();
    }

    private void z() {
        if (this.defectTable == null) {
            return;
        }
        this.defectTable.a(this.plotType);
    }
}

