/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.cardiac.CardiacAnalysisController;
import com.mimvista.cardiac.SegmentalScores;
import com.mimvista.cardiac.gui.CardiacSegments;
import com.mimvista.cardiac.gui.PolarPlotGraph;
import com.mimvista.cardiac.gui.b;
import com.mimvista.mui.bm;
import com.mimvista.mui.presenters.ProtocolPage;
import com.mimvista.util.Messages;
import com.mimvista.workflow.backend.t;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class PolarPlotSectionation {
    private final Set<b> a;
    private final Set<b> b;
    private final SectionationType c;
    private PolarPlotGraph d;

    public static PolarPlotSectionation a(SectionationType sectionationType) {
        return PolarPlotSectionation.a(null, sectionationType);
    }

    public static PolarPlotSectionation a(PolarPlotGraph polarPlotGraph, SectionationType sectionationType) {
        switch (sectionationType) {
            case a: {
                return PolarPlotSectionation.a(polarPlotGraph);
            }
            case b: {
                return PolarPlotSectionation.b(polarPlotGraph);
            }
            case c: {
                return PolarPlotSectionation.c(polarPlotGraph);
            }
            case d: {
                return PolarPlotSectionation.d(polarPlotGraph);
            }
        }
        return PolarPlotSectionation.a();
    }

    public static final PolarPlotSectionation a() {
        PolarPlotSectionation polarPlotSectionation = new PolarPlotSectionation();
        return polarPlotSectionation;
    }

    private PolarPlotSectionation() {
        this.a = Collections.emptySet();
        this.b = Collections.emptySet();
        this.c = null;
    }

    private PolarPlotSectionation(SectionationType sectionationType) {
        this.a = Sets.newHashSet();
        this.b = Sets.newHashSet();
        this.c = sectionationType;
    }

    public PolarPlotSectionation(SectionationType sectionationType, PolarPlotGraph polarPlotGraph) {
        this(sectionationType);
        this.d = polarPlotGraph;
    }

    public List<b> b() {
        return Lists.newArrayList(this.a);
    }

    private void c(b b2) {
        this.a.add(b2);
    }

    public void a(b b2) {
        if (this.a.contains(b2)) {
            this.b.add(b2);
        }
    }

    public void b(b b2) {
        this.b.remove(b2);
    }

    public void a(Graphics graphics) {
        Object object2;
        Sets.SetView setView = Sets.difference(this.a, this.b);
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (Object object2 : setView) {
            ((b)object2).a(graphics2D);
        }
        Stroke stroke = graphics2D.getStroke();
        object2 = graphics2D.getColor();
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.setColor(Color.blue.brighter());
        for (b b2 : this.b) {
            b2.a(graphics2D);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setColor((Color)object2);
    }

    public void b(Graphics graphics) {
        if (this.d == null) {
            return;
        }
        SegmentalScores.ScoreMap scoreMap = this.d.b(this.c);
        if (scoreMap.isEmpty() || scoreMap.keySet().size() != this.a.size()) {
            return;
        }
        for (b b2 : this.a) {
            b2.a((Graphics2D)graphics, (Integer)scoreMap.get(b2.d()), this.d.n());
        }
    }

    public void c(Graphics graphics) {
        if (this.d == null) {
            return;
        }
        for (b b2 : this.a) {
            int n2 = b2.b.a();
            b2.a((Graphics2D)graphics, n2, this.d.n());
        }
    }

    public void a(MouseEvent mouseEvent) {
        PolarPlotGraph polarPlotGraph = (PolarPlotGraph)mouseEvent.getSource();
        CardiacAnalysisController.PolarPlotScoreType polarPlotScoreType = polarPlotGraph.f();
        if (CardiacAnalysisController.PolarPlotScoreType.c == polarPlotScoreType) {
            return;
        }
        SegmentalScores.ScoreMap scoreMap = polarPlotGraph.b(this.c);
        if (scoreMap.isEmpty()) {
            return;
        }
        for (b object : this.a) {
            if (!object.a(mouseEvent.getPoint())) continue;
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                scoreMap.b(object.d());
                continue;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) continue;
            scoreMap.a(object.d());
        }
        for (ProtocolPage protocolPage : bm.b().ab()) {
            if (!protocolPage.j()) continue;
            protocolPage.d().repaint();
        }
    }

    private static final PolarPlotSectionation a(PolarPlotGraph polarPlotGraph) {
        return PolarPlotSectionation.a(polarPlotGraph, 0.25);
    }

    public static final PolarPlotSectionation a(PolarPlotGraph polarPlotGraph, double d2) {
        PolarPlotSectionation polarPlotSectionation = new PolarPlotSectionation(SectionationType.a, polarPlotGraph);
        polarPlotSectionation.c(new b.b(polarPlotGraph, CardiacSegments.Cardiac17Segment.q, d2));
        CardiacSegments.CardiacSegment[] cardiacSegmentArray = new CardiacSegments.CardiacSegment[]{CardiacSegments.Cardiac17Segment.p, CardiacSegments.Cardiac17Segment.m, CardiacSegments.Cardiac17Segment.n, CardiacSegments.Cardiac17Segment.o};
        CardiacSegments.CardiacSegment[] cardiacSegmentArray2 = new CardiacSegments.CardiacSegment[]{CardiacSegments.Cardiac17Segment.l, CardiacSegments.Cardiac17Segment.g, CardiacSegments.Cardiac17Segment.h, CardiacSegments.Cardiac17Segment.i, CardiacSegments.Cardiac17Segment.j, CardiacSegments.Cardiac17Segment.k};
        CardiacSegments.CardiacSegment[] cardiacSegmentArray3 = new CardiacSegments.CardiacSegment[]{CardiacSegments.Cardiac17Segment.f, CardiacSegments.Cardiac17Segment.a, CardiacSegments.Cardiac17Segment.b, CardiacSegments.Cardiac17Segment.c, CardiacSegments.Cardiac17Segment.d, CardiacSegments.Cardiac17Segment.e};
        double d3 = d2 + (1.0 - d2) / 3.0;
        for (int i2 = 0; i2 < 4; ++i2) {
            double d4 = 1.5707963267948966 * (double)i2;
            polarPlotSectionation.c(new b.e(polarPlotGraph, cardiacSegmentArray[i2], d2, d3, d4 - 0.7853981633974483, d4 + 0.7853981633974483));
        }
        double d5 = d2 + 2.0 * (1.0 - d2) / 3.0;
        for (int i3 = 0; i3 < 6; ++i3) {
            double d6 = 1.0471975511965976 * (double)i3;
            polarPlotSectionation.c(new b.e(polarPlotGraph, cardiacSegmentArray2[i3], d3, d5, d6, d6 + 1.0471975511965976));
            polarPlotSectionation.c(new b.e(polarPlotGraph, cardiacSegmentArray3[i3], d5, 1.0, d6, d6 + 1.0471975511965976));
        }
        return polarPlotSectionation;
    }

    private static final PolarPlotSectionation b(PolarPlotGraph polarPlotGraph) {
        return PolarPlotSectionation.b(polarPlotGraph, 0.25);
    }

    public static final PolarPlotSectionation b(PolarPlotGraph polarPlotGraph, double d2) {
        PolarPlotSectionation polarPlotSectionation = new PolarPlotSectionation(SectionationType.b, polarPlotGraph);
        polarPlotSectionation.c(new b.b(polarPlotGraph, CardiacSegments.Cardiac19Segment.s, d2));
        double d3 = d2 + (1.0 - d2) / 3.0;
        double d4 = d2 + 2.0 * (1.0 - d2) / 3.0;
        CardiacSegments.CardiacSegment[] cardiacSegmentArray = new CardiacSegments.CardiacSegment[]{CardiacSegments.Cardiac19Segment.c, CardiacSegments.Cardiac19Segment.d, CardiacSegments.Cardiac19Segment.e, CardiacSegments.Cardiac19Segment.f, CardiacSegments.Cardiac19Segment.a, CardiacSegments.Cardiac19Segment.b};
        CardiacSegments.CardiacSegment[] cardiacSegmentArray2 = new CardiacSegments.CardiacSegment[]{CardiacSegments.Cardiac19Segment.i, CardiacSegments.Cardiac19Segment.j, CardiacSegments.Cardiac19Segment.k, CardiacSegments.Cardiac19Segment.l, CardiacSegments.Cardiac19Segment.g, CardiacSegments.Cardiac19Segment.h};
        CardiacSegments.CardiacSegment[] cardiacSegmentArray3 = new CardiacSegments.CardiacSegment[]{CardiacSegments.Cardiac19Segment.o, CardiacSegments.Cardiac19Segment.p, CardiacSegments.Cardiac19Segment.q, CardiacSegments.Cardiac19Segment.r, CardiacSegments.Cardiac19Segment.m, CardiacSegments.Cardiac19Segment.n};
        for (int i2 = 0; i2 < 6; ++i2) {
            double d5 = 1.0471975511965976 * (double)i2;
            polarPlotSectionation.c(new b.e(polarPlotGraph, cardiacSegmentArray3[i2], d2, d3, d5, d5 + 1.0471975511965976));
            polarPlotSectionation.c(new b.e(polarPlotGraph, cardiacSegmentArray2[i2], d3, d4, d5, d5 + 1.0471975511965976));
            polarPlotSectionation.c(new b.e(polarPlotGraph, cardiacSegmentArray[i2], d4, 1.0, d5, d5 + 1.0471975511965976));
        }
        return polarPlotSectionation;
    }

    private static final PolarPlotSectionation c(PolarPlotGraph polarPlotGraph) {
        return PolarPlotSectionation.c(polarPlotGraph, 0.25);
    }

    public static final PolarPlotSectionation c(PolarPlotGraph polarPlotGraph, double d2) {
        PolarPlotSectionation polarPlotSectionation = new PolarPlotSectionation(SectionationType.c, polarPlotGraph);
        polarPlotSectionation.c(new b.d(polarPlotGraph, CardiacSegments.Cardiac20Segment.s, d2, 1.5707963267948966));
        polarPlotSectionation.c(new b.d(polarPlotGraph, CardiacSegments.Cardiac20Segment.t, d2, -1.5707963267948966));
        double d3 = d2 + (1.0 - d2) / 3.0;
        double d4 = d2 + 2.0 * (1.0 - d2) / 3.0;
        CardiacSegments.CardiacSegment[] cardiacSegmentArray = new CardiacSegments.CardiacSegment[]{CardiacSegments.Cardiac20Segment.c, CardiacSegments.Cardiac20Segment.d, CardiacSegments.Cardiac20Segment.e, CardiacSegments.Cardiac20Segment.f, CardiacSegments.Cardiac20Segment.a, CardiacSegments.Cardiac20Segment.b};
        CardiacSegments.CardiacSegment[] cardiacSegmentArray2 = new CardiacSegments.CardiacSegment[]{CardiacSegments.Cardiac20Segment.i, CardiacSegments.Cardiac20Segment.j, CardiacSegments.Cardiac20Segment.k, CardiacSegments.Cardiac20Segment.l, CardiacSegments.Cardiac20Segment.g, CardiacSegments.Cardiac20Segment.h};
        CardiacSegments.CardiacSegment[] cardiacSegmentArray3 = new CardiacSegments.CardiacSegment[]{CardiacSegments.Cardiac20Segment.o, CardiacSegments.Cardiac20Segment.p, CardiacSegments.Cardiac20Segment.q, CardiacSegments.Cardiac20Segment.r, CardiacSegments.Cardiac20Segment.m, CardiacSegments.Cardiac20Segment.n};
        for (int i2 = 0; i2 < 6; ++i2) {
            double d5 = 1.0471975511965976 * (double)i2;
            polarPlotSectionation.c(new b.e(polarPlotGraph, cardiacSegmentArray3[i2], d2, d3, d5, d5 + 1.0471975511965976));
            polarPlotSectionation.c(new b.e(polarPlotGraph, cardiacSegmentArray2[i2], d3, d4, d5, d5 + 1.0471975511965976));
            polarPlotSectionation.c(new b.e(polarPlotGraph, cardiacSegmentArray[i2], d4, 1.0, d5, d5 + 1.0471975511965976));
        }
        return polarPlotSectionation;
    }

    private static PolarPlotSectionation d(PolarPlotGraph polarPlotGraph) {
        PolarPlotSectionation polarPlotSectionation = new PolarPlotSectionation(SectionationType.d, polarPlotGraph);
        polarPlotSectionation.c(new b.e(polarPlotGraph, CardiacSegments.CardiacVascularSegment.b, 0.25, 1.0, Math.toRadians(-48.0), Math.toRadians(30.0)));
        polarPlotSectionation.c(new b.e(polarPlotGraph, CardiacSegments.CardiacVascularSegment.a, 0.25, 1.0, Math.toRadians(197.0), Math.toRadians(288.0)));
        polarPlotSectionation.c(new b.a(polarPlotGraph, CardiacSegments.CardiacVascularSegment.c, 1.0, 0.2, Math.toRadians(60.0), Math.toRadians(175.0)));
        return polarPlotSectionation;
    }

    public List<b> a(int[] nArray) {
        LinkedList linkedList = Lists.newLinkedList();
        for (int n2 : nArray) {
            for (b b2 : this.a) {
                if (b2.b.a() != n2) continue;
                linkedList.add(b2);
            }
        }
        return linkedList;
    }

    public List<b> a(CardiacSegments.CardiacVascularTerritory cardiacVascularTerritory) {
        LinkedList linkedList = Lists.newLinkedList();
        if (cardiacVascularTerritory != null) {
            for (b b2 : this.a) {
                if (b2.d().c() != cardiacVascularTerritory && cardiacVascularTerritory != CardiacSegments.CardiacVascularTerritory.d) continue;
                linkedList.add(b2);
            }
        }
        return linkedList;
    }

    public SectionationType c() {
        return this.c;
    }

    public static enum SectionationType implements t
    {
        a(Messages.a("Cardiac", "SECTIONATION_TYPE_SEVENTEEN"), CardiacSegments.Cardiac17Segment.class),
        b(Messages.a("Cardiac", "SECTIONATION_TYPE_NINETEEN"), CardiacSegments.Cardiac19Segment.class),
        c(Messages.a("Cardiac", "SECTIONATION_TYPE_TWENTY"), CardiacSegments.Cardiac20Segment.class),
        d(Messages.a("Cardiac", "SECTIONATION_TYPE_VASCULAR"), CardiacSegments.CardiacVascularSegment.class);

        private final String displayString;
        private final Class<? extends CardiacSegments.CardiacSegment> segmentType;

        private SectionationType(String string2, Class<? extends CardiacSegments.CardiacSegment> clazz) {
            this.displayString = string2;
            this.segmentType = clazz;
        }

        public Class<? extends CardiacSegments.CardiacSegment> a() {
            return this.segmentType;
        }

        public static SectionationType a(Class<? extends CardiacSegments.CardiacSegment> clazz) {
            for (SectionationType sectionationType : SectionationType.values()) {
                if (!sectionationType.segmentType.equals(clazz)) continue;
                return sectionationType;
            }
            return null;
        }

        @Override
        public String getExternalizedString() {
            return this.displayString;
        }

        @Override
        public Icon getIcon(int n2) {
            return null;
        }
    }
}

