/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cloud.shared.common;

import com.mimvista.ExternallyVisible;
import com.mimvista.MimJsonSerializable;
import com.mimvista.cloud.shared.common.AccountInfo;
import com.mimvista.cloud.shared.common.AddressInfo;
import com.mimvista.cloud.shared.common.FoxUtil;
import com.mimvista.cloud.shared.common.NotificationInfo;
import com.mimvista.cloud.shared.common.RoleInfo;
import com.mimvista.cloud.shared.common.c;
import com.mimvista.cloud.shared.common.enums.NotificationEnums;
import com.mimvista.cloud.shared.common.enums.RolePermissions;
import com.mimvista.cloud.shared.common.f;
import com.mimvista.cloud.shared.common.mim.StudyDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

@ExternallyVisible
@MimJsonSerializable
public class AccountSummary
implements c,
f,
Serializable {
    private static final long serialVersionUID = 1L;
    private AccountInfo actor;
    private AddressInfo address;
    private AccountInfo.ContractInfo contract;
    private String creditCardNo;
    private Date creditCardExpiration;
    private Set<AccountInfo> accounts = new HashSet<AccountInfo>();
    private List<AccountInfo> ancestors = new ArrayList<AccountInfo>();
    private Set<NotificationInfo> notifications = new HashSet<NotificationInfo>();
    private Set<RoleInfo> rolesList = new HashSet<RoleInfo>();
    private Map<Long, String> roleMap = new HashMap<Long, String>();
    private String adminRoleKey;
    private List<RoleInfo> ancestorAdminRoles = new ArrayList<RoleInfo>();

    public AccountSummary() {
    }

    public AccountSummary(AccountSummary accountSummary) {
        this.setAccounts(accountSummary.getAccounts());
        this.setActor(accountSummary.getActor());
        this.setAddress(accountSummary.getAddress());
        this.setAdminRoleKey(accountSummary.getAdminRoleKey());
        this.setAncestorAdminRoles(accountSummary.getAncestorAdminRoles());
        this.setAncestors(accountSummary.getAncestors());
        this.setNotifications(accountSummary.getNotifications());
        this.setRoleMap(accountSummary.getRoleMap());
        this.setRolesList(accountSummary.getRolesList());
        if (accountSummary.getCreditCardNo() != null) {
            this.setCreditCardNo(accountSummary.getCreditCardNo());
        }
    }

    public AccountInfo getActor() {
        return this.actor;
    }

    public void setActor(AccountInfo accountInfo) {
        this.actor = accountInfo;
    }

    public void setAddress(AddressInfo addressInfo) {
        this.address = addressInfo;
    }

    public AddressInfo getAddress() {
        return this.address;
    }

    public void setSubscription(AccountInfo.ContractInfo contractInfo) {
        this.contract = contractInfo;
    }

    public AccountInfo.ContractInfo getSubscription() {
        return this.contract;
    }

    public void setCreditCardNo(String string, boolean bl2) {
        if (!bl2 && string.length() > 4) {
            int n2 = string.length();
            string = string.substring(n2 - 4, n2);
        }
        this.creditCardNo = string;
    }

    public void setCreditCardNo(String string) {
        this.setCreditCardNo(string, false);
    }

    public String getCreditCardNo() {
        return this.creditCardNo;
    }

    public void setCreditCardExpiration(Date date) {
        this.creditCardExpiration = date;
    }

    public Date getCreditCardExpiration() {
        return this.creditCardExpiration;
    }

    public void updateAccount(AccountInfo accountInfo) {
        if (this.accounts.remove(accountInfo)) {
            this.accounts.add(accountInfo);
        }
    }

    public void setAccounts(Set<AccountInfo> set) {
        this.accounts = set;
    }

    public Set<AccountInfo> getAccounts() {
        return this.accounts;
    }

    public void setAncestors(List<AccountInfo> list) {
        this.ancestors = list;
    }

    public List<AccountInfo> getAncestors() {
        return this.ancestors;
    }

    public List<AccountInfo> getValidNonRobotUsers() {
        ArrayList<AccountInfo> arrayList = new ArrayList<AccountInfo>();
        for (AccountInfo accountInfo : this.accounts) {
            if (!accountInfo.isUser() || accountInfo.isRobotUser() || accountInfo.isCancelled()) continue;
            arrayList.add(accountInfo);
        }
        Collections.sort(arrayList, FoxUtil.f);
        return arrayList;
    }

    public List<AccountInfo> getUsers() {
        ArrayList<AccountInfo> arrayList = new ArrayList<AccountInfo>();
        for (AccountInfo accountInfo : this.accounts) {
            if (!accountInfo.isUser()) continue;
            arrayList.add(accountInfo);
        }
        Collections.sort(arrayList, FoxUtil.f);
        return arrayList;
    }

    public List<AccountInfo> getGroups() {
        ArrayList<AccountInfo> arrayList = new ArrayList<AccountInfo>();
        for (AccountInfo accountInfo : this.accounts) {
            if (!accountInfo.isGroup()) continue;
            arrayList.add(accountInfo);
        }
        Collections.sort(arrayList, FoxUtil.f);
        return arrayList;
    }

    public List<AccountInfo> getUploadableAccounts() {
        ArrayList<AccountInfo> arrayList = new ArrayList<AccountInfo>();
        for (AccountInfo accountInfo : this.accounts) {
            RoleInfo roleInfo;
            if (!accountInfo.isGroup() || (roleInfo = this.getRoleFor(accountInfo)) == null || !roleInfo.hasAllPermissions(RolePermissions.StudyPermission.a)) continue;
            arrayList.add(accountInfo);
        }
        Collections.sort(arrayList, FoxUtil.f);
        if (!this.actor.isManaged()) {
            arrayList.add(0, this.actor);
        }
        return arrayList;
    }

    public AccountInfo getAccountById(Long l2) {
        if (this.actor.getId().equals(l2)) {
            return this.actor;
        }
        for (AccountInfo accountInfo : this.accounts) {
            if (!accountInfo.getId().equals(l2)) continue;
            return accountInfo;
        }
        return null;
    }

    public AccountInfo getAccountByKeystring(String string) {
        if (this.actor.getKeyAsString().equals(string)) {
            return this.actor;
        }
        for (AccountInfo accountInfo : this.accounts) {
            if (!accountInfo.getKeyAsString().equals(string)) continue;
            return accountInfo;
        }
        return null;
    }

    public AccountInfo getUserAccountByEmail(String string) {
        if (!this.actor.isUser()) {
            return null;
        }
        if (this.actor.getUserInfo().a().equalsIgnoreCase(string)) {
            return this.actor;
        }
        for (AccountInfo accountInfo : this.accounts) {
            if (!accountInfo.isUser() || !accountInfo.getUserInfo().a().equalsIgnoreCase(string)) continue;
            return accountInfo;
        }
        return null;
    }

    public AccountInfo getRootAccount() {
        AccountInfo accountInfo = this.actor;
        ListIterator<AccountInfo> listIterator = this.getAncestors().listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
        }
        while (listIterator.hasPrevious()) {
            AccountInfo accountInfo2 = listIterator.previous();
            if (accountInfo2 == null) continue;
            accountInfo = accountInfo2;
            break;
        }
        return accountInfo;
    }

    public Set<AccountInfo> getAdmins() {
        RoleInfo roleInfo = this.getAdminRole();
        HashSet<AccountInfo> hashSet = new HashSet<AccountInfo>();
        for (AccountInfo accountInfo : this.accounts) {
            if (!accountInfo.isUser()) continue;
            if (roleInfo.equals(this.getRoleFor(accountInfo))) {
                hashSet.add(accountInfo);
                continue;
            }
            for (RoleInfo roleInfo2 : this.ancestorAdminRoles) {
                if (!roleInfo2.equals(this.getRoleFor(accountInfo))) continue;
                hashSet.add(accountInfo);
            }
        }
        return hashSet;
    }

    public boolean isUserAdminOf(AccountInfo accountInfo) {
        if (accountInfo == null) {
            return false;
        }
        Set<AccountInfo> set = this.getAdmins();
        if (FoxUtil.a(set)) {
            return false;
        }
        return set.contains(accountInfo);
    }

    public boolean isUserAdminOf(long l2) {
        return this.isUserAdminOf(this.getAccountById(l2));
    }

    public boolean isUserAdminOf(String string) {
        return this.isUserAdminOf(this.getAccountByKeystring(string));
    }

    public boolean isUserInheritedAdmin(long l2) {
        RoleInfo roleInfo = this.getRoleFor(l2);
        if (roleInfo == null) {
            return false;
        }
        if (this.ancestorAdminRoles == null) {
            return false;
        }
        if (roleInfo.getKeyAsString().equals(this.adminRoleKey)) {
            return false;
        }
        return this.ancestorAdminRoles.contains(roleInfo);
    }

    public boolean isMemberOf(AccountSummary accountSummary) {
        if (!accountSummary.getActor().isGroup()) {
            return false;
        }
        return accountSummary.getAccounts().contains(this.getActor());
    }

    public void setRolesList(Set<RoleInfo> set) {
        this.rolesList = set;
    }

    public Set<RoleInfo> getRolesList() {
        return this.rolesList;
    }

    public RoleInfo getRoleById(Long l2) {
        for (RoleInfo roleInfo : this.rolesList) {
            if (!roleInfo.getId().equals(l2)) continue;
            return roleInfo;
        }
        return null;
    }

    public RoleInfo getRoleByShare(StudyDetails.StudyShareInfo studyShareInfo) {
        return this.getRoleById(studyShareInfo.e());
    }

    public RoleInfo getRoleByKey(String string) {
        for (RoleInfo roleInfo : this.rolesList) {
            if (!roleInfo.getKeyAsString().equals(string)) continue;
            return roleInfo;
        }
        return null;
    }

    public void setAdminRoleKey(String string) {
        this.adminRoleKey = string;
    }

    public String getAdminRoleKey() {
        return this.adminRoleKey;
    }

    public RoleInfo getAdminRole() {
        if (this.adminRoleKey == null) {
            return null;
        }
        for (RoleInfo roleInfo : this.getOwnedRoles()) {
            if (!roleInfo.getKeyAsString().equals(this.adminRoleKey)) continue;
            return roleInfo;
        }
        return null;
    }

    public void setAncestorAdminRoles(List<RoleInfo> list) {
        this.ancestorAdminRoles = list;
    }

    public List<RoleInfo> getAncestorAdminRoles() {
        return this.ancestorAdminRoles;
    }

    public boolean isChildOf(AccountSummary accountSummary) {
        return this.getAncestors() != null && this.getAncestors().contains(accountSummary.getActor());
    }

    public void setRoleMap(Map<Long, String> map) {
        this.roleMap = map;
    }

    public Map<Long, String> getRoleMap() {
        return this.roleMap;
    }

    public RoleInfo getRoleFor(Long l2) {
        if (this.actor.getId().equals(l2)) {
            return this.getAdminRole();
        }
        String string = this.roleMap.get(l2);
        for (RoleInfo roleInfo : this.rolesList) {
            if (!roleInfo.getKeyAsString().equals(string)) continue;
            return roleInfo;
        }
        return null;
    }

    public RoleInfo getRoleFor(AccountInfo accountInfo) {
        return this.getRoleFor(accountInfo.getId());
    }

    public Set<RoleInfo> getOwnedRoles() {
        HashSet<RoleInfo> hashSet = new HashSet<RoleInfo>();
        for (RoleInfo roleInfo : this.rolesList) {
            if (!roleInfo.getOwnerId().equals(this.actor.getId())) continue;
            hashSet.add(roleInfo);
        }
        return hashSet;
    }

    public Set<RoleInfo> getRolesAssignableByUser(Long l2) {
        RoleInfo roleInfo = this.getRoleFor(l2);
        if (roleInfo == null) {
            return Collections.emptySet();
        }
        Set<RoleInfo> set = this.getAdminRole() == roleInfo || this.getAncestorAdminRoles().contains(roleInfo) ? this.getOwnedRoles() : this.getRolesAssignableByUserNoAdmin();
        set.remove(this.a());
        return set;
    }

    public Set<RoleInfo> getRolesAssignableByUser(Long l2, AccountInfo accountInfo) {
        Set<RoleInfo> set = this.getRolesAssignableByUser(l2);
        if (accountInfo.isManaged()) {
            set.remove(this.getAdminRole());
        }
        return set;
    }

    public Set<RoleInfo> getRolesAssignableByUserNoAdmin() {
        Set<RoleInfo> set = this.getOwnedRoles();
        set.remove(this.getAdminRole());
        return set;
    }

    public List<RoleInfo> getAssignedRoles() {
        ArrayList<RoleInfo> arrayList = new ArrayList<RoleInfo>();
        for (RoleInfo roleInfo : this.rolesList) {
            if (roleInfo.getOwnerId().equals(this.actor.getId())) continue;
            arrayList.add(roleInfo);
        }
        Collections.sort(arrayList, FoxUtil.g);
        return arrayList;
    }

    private RoleInfo a() {
        for (RoleInfo roleInfo : this.getOwnedRoles()) {
            if (!roleInfo.isRobotRole()) continue;
            return roleInfo;
        }
        for (RoleInfo roleInfo : this.getAssignedRoles()) {
            if (!roleInfo.isRobotRole()) continue;
            return roleInfo;
        }
        return null;
    }

    public void setNotifications(Set<NotificationInfo> set) {
        this.notifications = set;
    }

    public Set<NotificationInfo> getNotifications() {
        return this.notifications;
    }

    public List<NotificationInfo> getNotifications(NotificationEnums.NotificationType notificationType, NotificationEnums.NotificationLocation notificationLocation, NotificationEnums.NotificationStatus notificationStatus) {
        ArrayList<NotificationInfo> arrayList = new ArrayList<NotificationInfo>();
        block0: for (NotificationInfo notificationInfo : this.notifications) {
            if (notificationType != null && notificationInfo.m() != notificationType) continue;
            for (NotificationInfo.NotificationParticipantInfo notificationParticipantInfo : notificationInfo.n()) {
                if (!notificationParticipantInfo.a().equals(this.getActor().getKeyAsString())) continue;
                if (notificationLocation != null && notificationParticipantInfo.e() != notificationLocation || notificationStatus != null && notificationParticipantInfo.d() != notificationStatus) continue block0;
                arrayList.add(notificationInfo);
                continue block0;
            }
        }
        return arrayList;
    }

    public NotificationInfo getNotification(Long l2) {
        if (l2 == null) {
            return null;
        }
        for (NotificationInfo notificationInfo : this.notifications) {
            if (!notificationInfo.getId().equals(l2)) continue;
            return notificationInfo;
        }
        return null;
    }

    public List<NotificationInfo> getInboxNotifications() {
        return this.getNotifications(null, NotificationEnums.NotificationLocation.a, null);
    }

    public List<NotificationInfo> getUnreadInboxNotifications() {
        return this.getNotifications(null, NotificationEnums.NotificationLocation.a, NotificationEnums.NotificationStatus.a);
    }

    public List<NotificationInfo> getSentNotifications() {
        return this.getNotifications(null, NotificationEnums.NotificationLocation.b, null);
    }

    @Override
    public Long getId() {
        return this.actor.getId();
    }

    @Override
    public String getKeyAsString() {
        return this.actor.getKeyAsString();
    }

    @Override
    public String getDebugSuffix() {
        return this.actor.getDebugSuffix();
    }
}

