/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cloud.shared.common;

import com.mimvista.cloud.shared.common.AccountInfo;
import com.mimvista.cloud.shared.common.AccountSummary;
import com.mimvista.cloud.shared.common.FoxUtil;
import com.mimvista.cloud.shared.common.RoleInfo;
import com.mimvista.cloud.shared.common.enums.AccountEnums;
import com.mimvista.cloud.shared.common.enums.RolePermissions;
import com.mimvista.cloud.shared.common.enums.StudyEnums;
import com.mimvista.cloud.shared.common.mim.StudyAction;
import com.mimvista.cloud.shared.common.mim.StudyDetails;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class StudyActionRules
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AccountSummary actor;
    private AccountSummary studyOwner;
    private StudyDetails studyDetails;
    private RolePermissions.b actorRole;
    private AccountEnums.UserType actorType;
    private boolean actorIsOwner;
    private Set<RoleInfo> assignableRoles;
    private Set<AccountInfo> allowableRecipients;
    private Set<AccountInfo> viewableRecipients;
    private Set<StudyEnums.StudyActionType> availableActions;
    private Set<StudyEnums.StudyModifyType> availableModifies;

    private StudyActionRules() {
    }

    public StudyActionRules(AccountSummary accountSummary, AccountSummary accountSummary2) {
        this(accountSummary, accountSummary2, null);
    }

    public StudyActionRules(AccountSummary accountSummary, AccountSummary accountSummary2, StudyDetails studyDetails) {
        this.actor = accountSummary;
        this.studyOwner = accountSummary2;
        this.studyDetails = studyDetails;
        this.actorIsOwner = accountSummary2.getActor().getKeyAsString().equals(accountSummary.getActor().getKeyAsString());
        this.o();
        this.assignableRoles = this.r();
        this.actorType = accountSummary.getActor().getUserInfo().e();
        this.allowableRecipients = this.p();
        this.viewableRecipients = this.q();
        this.availableActions = this.s();
        this.availableModifies = this.t();
    }

    public AccountSummary a() {
        return this.actor;
    }

    public AccountSummary b() {
        return this.studyOwner;
    }

    public RolePermissions.b c() {
        return this.actorRole;
    }

    public AccountEnums.UserType d() {
        return this.actorType;
    }

    public boolean e() {
        return this.actorIsOwner;
    }

    public Set<AccountInfo> f() {
        return this.allowableRecipients;
    }

    public Set<RoleInfo> g() {
        return this.assignableRoles;
    }

    public Set<StudyEnums.StudyActionType> h() {
        return this.availableActions;
    }

    public Set<StudyEnums.StudyModifyType> i() {
        return this.availableModifies;
    }

    private void o() {
        if (this.actorIsOwner) {
            this.actorRole = this.actor.getAdminRole();
        }
        if (this.actorRole == null) {
            this.actorRole = this.studyOwner.getRoleFor(this.actor.getActor());
        }
        if (this.studyDetails != null) {
            this.actorRole = this.studyDetails.z();
            if (this.actorRole == null) {
                for (StudyDetails.StudyShareInfo studyShareInfo : this.studyDetails.y()) {
                    if (!studyShareInfo.b().equals(this.actor.getActor().getKeyAsString())) continue;
                    this.actorRole = this.c(studyShareInfo.d());
                }
            }
        }
    }

    public AccountInfo a(String string) {
        if (FoxUtil.a(string)) {
            return null;
        }
        for (AccountInfo accountInfo : this.allowableRecipients) {
            if (!accountInfo.getKeyAsString().equals(string)) continue;
            return accountInfo;
        }
        return null;
    }

    public AccountInfo b(String string) {
        if (FoxUtil.a(string)) {
            return null;
        }
        for (AccountInfo accountInfo : this.viewableRecipients) {
            if (!accountInfo.getKeyAsString().equals(string)) continue;
            return accountInfo;
        }
        return null;
    }

    public AccountInfo a(Long l2) {
        if (l2 == null) {
            return null;
        }
        for (AccountInfo accountInfo : this.allowableRecipients) {
            if (!accountInfo.getId().equals(l2)) continue;
            return accountInfo;
        }
        return null;
    }

    public RoleInfo c(String string) {
        if (FoxUtil.a(string)) {
            return null;
        }
        for (RoleInfo roleInfo : this.studyOwner.getOwnedRoles()) {
            if (!roleInfo.getKeyAsString().equals(string)) continue;
            return roleInfo;
        }
        return null;
    }

    public RoleInfo b(Long l2) {
        if (l2 == null) {
            return null;
        }
        for (RoleInfo roleInfo : this.studyOwner.getOwnedRoles()) {
            if (!roleInfo.getId().equals(l2)) continue;
            return roleInfo;
        }
        return null;
    }

    public StudyAction.StudyActionQuickie a(StudyDetails.StudyShareInfo studyShareInfo) {
        if (studyShareInfo == null) {
            return null;
        }
        AccountInfo accountInfo = this.a(studyShareInfo.b());
        RoleInfo roleInfo = this.c(studyShareInfo.d());
        if (accountInfo == null) {
            return null;
        }
        return new StudyAction.StudyActionQuickie(accountInfo, roleInfo, StudyEnums.StudyActionType.b);
    }

    public boolean a(StudyAction.StudyActionQuickie studyActionQuickie) {
        return this.a(studyActionQuickie.a(), studyActionQuickie.b(), studyActionQuickie.c());
    }

    public boolean a(StudyAction.StudyModifyBlip studyModifyBlip) {
        if (this.actorIsOwner) {
            return true;
        }
        return this.availableModifies.contains(studyModifyBlip.c());
    }

    public boolean a(AccountInfo accountInfo, RoleInfo roleInfo, StudyEnums.StudyActionType studyActionType) {
        AccountEnums.UserType userType;
        if (!this.actorIsOwner && this.actorType == AccountEnums.UserType.a) {
            return false;
        }
        if (!this.availableActions.contains(studyActionType)) {
            return false;
        }
        if (!this.allowableRecipients.contains(accountInfo)) {
            return false;
        }
        if (roleInfo != null && !this.assignableRoles.contains(roleInfo)) {
            return false;
        }
        if (studyActionType == StudyEnums.StudyActionType.b && accountInfo.isUser() && this.actorType != (userType = accountInfo.getUserInfo().e())) {
            if (this.actorType == AccountEnums.UserType.b && userType == AccountEnums.UserType.a) {
                return false;
            }
            if (this.actorType == AccountEnums.UserType.a && userType != AccountEnums.UserType.a) {
                return false;
            }
        }
        return true;
    }

    private Set<AccountInfo> p() {
        HashSet<AccountInfo> hashSet = new HashSet<AccountInfo>();
        if (this.actorType == AccountEnums.UserType.a) {
            hashSet.addAll(this.actor.getUsers());
        } else if (this.actorRole != null) {
            if (this.actorRole.hasAnyPermissions(RolePermissions.StudyPermission.f, RolePermissions.StudyPermission.h, RolePermissions.StudyPermission.d)) {
                hashSet.addAll(this.actor.getValidNonRobotUsers());
            }
            if (this.actorRole.hasAnyPermissions(RolePermissions.StudyPermission.g, RolePermissions.StudyPermission.i, RolePermissions.StudyPermission.e)) {
                hashSet.addAll(this.actor.getGroups());
            }
        }
        if (!this.actor.getActor().isRobotUser()) {
            hashSet.add(this.actor.getActor());
        }
        hashSet.remove(this.studyOwner.getActor());
        return hashSet;
    }

    private Set<AccountInfo> q() {
        HashSet<AccountInfo> hashSet = new HashSet<AccountInfo>();
        hashSet.addAll(this.actor.getValidNonRobotUsers());
        if (this.actorType != AccountEnums.UserType.a) {
            hashSet.addAll(this.actor.getGroups());
        }
        if (!this.actor.getActor().isRobotUser()) {
            hashSet.add(this.actor.getActor());
        }
        hashSet.remove(this.studyOwner.getActor());
        return hashSet;
    }

    private Set<RoleInfo> r() {
        HashSet<RoleInfo> hashSet = new HashSet<RoleInfo>();
        if (this.actorRole == null) {
            return hashSet;
        }
        for (RoleInfo roleInfo : this.studyOwner.getOwnedRoles()) {
            if (!this.actorRole.hasAllPermissions(roleInfo.getPerms().toArray(new RolePermissions.a[0])) || roleInfo.isRobotRole()) continue;
            hashSet.add(roleInfo);
        }
        return hashSet;
    }

    public Set<RoleInfo> j() {
        Set<RoleInfo> set = new HashSet<RoleInfo>();
        if (this.actorRole == null) {
            return set;
        }
        RoleInfo roleInfo = this.studyOwner.getRoleFor(this.actor.getActor());
        if (this.studyOwner.getAdminRole() == roleInfo || this.studyOwner.getAncestorAdminRoles().contains(roleInfo)) {
            set = this.studyOwner.getOwnedRoles();
        } else {
            Set<RoleInfo> set2 = this.studyOwner.getOwnedRoles();
            set2.remove(this.studyOwner.getAdminRole());
            set = set2;
        }
        return set;
    }

    private Set<StudyEnums.StudyActionType> s() {
        HashSet<StudyEnums.StudyActionType> hashSet = new HashSet<StudyEnums.StudyActionType>();
        if (this.studyDetails != null && this.studyDetails.s() == null) {
            return hashSet;
        }
        if (this.actorType == AccountEnums.UserType.a) {
            hashSet.add(StudyEnums.StudyActionType.c);
            hashSet.add(StudyEnums.StudyActionType.d);
            return hashSet;
        }
        if (this.actorRole != null) {
            if (this.actorRole.hasAnyPermissions(RolePermissions.StudyPermission.g, RolePermissions.StudyPermission.f)) {
                hashSet.add(StudyEnums.StudyActionType.c);
            }
            if (this.actorRole.hasAnyPermissions(RolePermissions.StudyPermission.i, RolePermissions.StudyPermission.h)) {
                hashSet.add(StudyEnums.StudyActionType.d);
            }
            if (this.actorRole.hasAnyPermissions(RolePermissions.StudyPermission.e, RolePermissions.StudyPermission.d)) {
                hashSet.add(StudyEnums.StudyActionType.b);
            }
        }
        return hashSet;
    }

    private Set<StudyEnums.StudyModifyType> t() {
        HashSet<StudyEnums.StudyModifyType> hashSet = new HashSet<StudyEnums.StudyModifyType>();
        if (this.actorRole != null && this.actorRole.hasAnyPermissions(RolePermissions.StudyPermission.b, RolePermissions.GroupPermission.c)) {
            hashSet.add(StudyEnums.StudyModifyType.a);
            hashSet.add(StudyEnums.StudyModifyType.b);
            hashSet.add(StudyEnums.StudyModifyType.c);
        }
        return hashSet;
    }

    public boolean k() {
        return (this.e() || this.c().hasAllPermissions(RolePermissions.GroupPermission.b)) && this.studyDetails.v() != StudyEnums.StudyStatus.c;
    }

    public boolean l() {
        return (this.e() || this.c().hasAnyPermissions(RolePermissions.StudyPermission.b())) && this.studyDetails.v() != StudyEnums.StudyStatus.c;
    }

    public boolean m() {
        return (this.e() || this.c().hasAllPermissions(RolePermissions.StudyPermission.c)) && this.studyDetails.v() != StudyEnums.StudyStatus.c;
    }

    public boolean a(StudyDetails studyDetails, AccountSummary accountSummary) {
        StudyActionRules studyActionRules = new StudyActionRules(this.actor, accountSummary, studyDetails);
        this.assignableRoles.retainAll(studyActionRules.g());
        if (this.assignableRoles.isEmpty()) {
            this.availableActions.remove(StudyEnums.StudyActionType.b);
        }
        this.availableActions.retainAll(studyActionRules.h());
        this.allowableRecipients.retainAll(studyActionRules.f());
        this.availableModifies.retainAll(studyActionRules.i());
        this.actorIsOwner = this.actorIsOwner && studyActionRules.actorIsOwner;
        return this.n();
    }

    public boolean n() {
        return !this.availableActions.isEmpty() && !this.allowableRecipients.isEmpty();
    }

    public void a(AccountInfo accountInfo) {
        this.allowableRecipients.add(accountInfo);
        this.viewableRecipients.add(accountInfo);
    }
}

