/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cloud.shared.common.enums;

import com.mimvista.cloud.shared.common.enums.FoxEnums;
import com.mimvista.cloud.shared.common.enums.StudyEnums;
import com.mimvista.cloud.shared.common.i;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum EventType implements FoxEnums.a
{
    a("Cancelled account"),
    b("Shared study"),
    c("Copy study"),
    d("Move study"),
    e("Shared study"),
    f("Study share received"),
    g("Copied study"),
    h("Study copy received"),
    i("Moved study"),
    j("Study move received"),
    k("Delete study"),
    l("Status study"),
    m("Locate study"),
    n("Subscription study"),
    o("Update series status"),
    p("Download an audit view"),
    q("Placeholder transaction"),
    r("Append Series to Study"),
    s("View study; charged earlier, or always free."),
    t("View study using MIM"),
    u("View study using MIMviewer Pro"),
    v("View study using MIMviewer Ref"),
    w("View study using VueMe iPhone"),
    x("View study using VueMe iPad"),
    y("View study using Mobile MIM iPhone"),
    z("View study using Mobile MIM iPad"),
    A("View of Encapsulated Doc", false),
    B("Billed account cannot pay to extend study storage."),
    C("Member added to Group"),
    D("Member removed from Group"),
    E("Member role modified in Group"),
    F("Demo account converted to paid subscription", false),
    G("Demo account converted to credit card", false),
    H("Demo account extended", false),
    I("Free transfer", false),
    J("Free upload", true),
    K("Free view", true),
    L("Upload fee", true),
    M("Transfer fee", false),
    N("Storage renewals", true),
    O("View charge using MIMviewer Pro", true),
    P("View charge using MIMviewer", true),
    Q("View charge using Mobile MIM iPhone", true),
    R("View charge using Mobile MIM iPad", true),
    S("Credit", true),
    T("An update email was sent through the MIMcloud admin interface", false),
    U("Storage Renewal (Prior to June 2011)", true),
    V("Study Transfer (Prior to June 2011)", true),
    W("View charge using Mobile MIM iPad (Prior to June 2011)", true),
    X("View credit using Mobile MIM iPad (Prior to June 2011)", true);

    private static List<EventType> Y;
    private static List<EventType> Z;
    private static List<EventType> aa;
    public final String description;
    public final boolean billingRelated;

    private EventType(String string2) {
        this(string2, false);
    }

    private EventType(String string2, boolean bl2) {
        this.description = com.mimvista.cloud.shared.common.i.a("en", EventType.class, this.toString(), string2);
        this.billingRelated = bl2;
    }

    @Override
    public String getListName() {
        return this.description;
    }

    @Override
    public String getListValue() {
        return this.toString();
    }

    public static List<EventType> a() {
        if (Y == null) {
            Y = new ArrayList<EventType>();
            for (EventType eventType : EventType.values()) {
                if (!eventType.billingRelated) continue;
                Y.add(eventType);
            }
        }
        return Y;
    }

    public static List<EventType> b() {
        return Z;
    }

    public static List<EventType> c() {
        return aa;
    }

    public EventType d() {
        switch (this) {
            case u: {
                return O;
            }
            case v: {
                return P;
            }
            case y: {
                return Q;
            }
            case z: {
                return R;
            }
        }
        return s;
    }

    public boolean e() {
        switch (this) {
            case u: 
            case v: 
            case y: 
            case z: 
            case t: 
            case w: 
            case x: {
                return true;
            }
        }
        return false;
    }

    public static EventType a(StudyEnums.StudyActionType studyActionType) {
        switch (studyActionType) {
            case b: {
                return e;
            }
            case c: {
                return g;
            }
            case d: {
                return i;
            }
        }
        throw new RuntimeException("Cannot translate a StudyAction of type " + studyActionType + " to appropriate 'send' EventType.");
    }

    public static EventType b(StudyEnums.StudyActionType studyActionType) {
        switch (studyActionType) {
            case b: {
                return f;
            }
            case c: {
                return h;
            }
            case d: {
                return j;
            }
        }
        throw new RuntimeException("Cannot translate a StudyAction of type " + studyActionType + " to appropriate 'receive' EventType.");
    }

    public static EventType a(StudyEnums.StudyModifyType studyModifyType) {
        switch (studyModifyType) {
            case b: {
                return m;
            }
            case a: {
                return l;
            }
            case c: {
                return n;
            }
            case f: {
                return o;
            }
        }
        throw new RuntimeException("Cannot translate a StudyModify of type " + studyModifyType + " to an EventType.");
    }

    static {
        Z = Arrays.asList(Q, W, R, P, O);
        aa = Arrays.asList(t, u, v, y, z, j, h, f, L, k);
    }
}

