/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cloud.shared.common.version;

import com.mimvista.ExternallyVisible;
import com.mimvista.cloud.shared.common.FoxUtil;
import java.io.Serializable;
import java.util.Arrays;

@ExternallyVisible
public class VersionNumberCore
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIM_4_VERSION_STRING_PREIFX = "MIM ";
    public static final String DEVELOPMENT_BUILD_NUMBER = "DEVEL";
    public static final String VERSION_NUMBER_SEPARATOR = ".";
    private int majorVersion;
    private int minorVersion;
    private int bugFixVersion;
    private String buildNumber;

    public VersionNumberCore() {
    }

    public VersionNumberCore(int n2, int n3, int n4, String string) {
        this.majorVersion = n2;
        this.minorVersion = n3;
        this.bugFixVersion = n4;
        this.buildNumber = string;
    }

    public VersionNumberCore(String[] stringArray) {
        try {
            this.majorVersion = Integer.valueOf(stringArray[0]);
            this.minorVersion = Integer.valueOf(stringArray[1]);
            this.bugFixVersion = stringArray.length > 2 ? Integer.valueOf(stringArray[2]) : 0;
            this.buildNumber = stringArray.length > 3 ? stringArray[3] : "";
        }
        catch (Throwable throwable) {
            System.err.println("Unable to parse version String: " + FoxUtil.b(Arrays.asList(stringArray), VERSION_NUMBER_SEPARATOR));
            this.majorVersion = Math.max(this.majorVersion, 4);
        }
    }

    public VersionNumberCore(String string) {
        this(FoxUtil.a(VersionNumberCore.a(string), VERSION_NUMBER_SEPARATOR));
    }

    public int getMajor() {
        return this.majorVersion;
    }

    public void setMajor(int n2) {
        this.majorVersion = n2;
    }

    public int getMinor() {
        return this.minorVersion;
    }

    public void setMinor(int n2) {
        this.minorVersion = n2;
    }

    public int getBugFix() {
        return this.bugFixVersion;
    }

    public void setBugFix(int n2) {
        this.bugFixVersion = n2;
    }

    public String getBuild() {
        return this.buildNumber;
    }

    public void setBuild(String string) {
        this.buildNumber = string;
    }

    public boolean isDevel() {
        return DEVELOPMENT_BUILD_NUMBER.equals(this.buildNumber);
    }

    public static boolean isValidVersionNumber(String string) {
        try {
            String[] stringArray = FoxUtil.a(string, VERSION_NUMBER_SEPARATOR);
            int n2 = Integer.valueOf(stringArray[0]);
            int n3 = Integer.valueOf(stringArray[1]);
            int n4 = stringArray.length > 2 ? Integer.valueOf(stringArray[2]) : 0;
            String string2 = stringArray.length > 3 ? stringArray[3] : "";
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static String a(String string) {
        if (string != null && string.startsWith(MIM_4_VERSION_STRING_PREIFX)) {
            string = string.substring(MIM_4_VERSION_STRING_PREIFX.length());
        }
        return string;
    }

    public String toString() {
        return this.majorVersion + VERSION_NUMBER_SEPARATOR + this.minorVersion + VERSION_NUMBER_SEPARATOR + this.bugFixVersion + VERSION_NUMBER_SEPARATOR + this.buildNumber;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.bugFixVersion;
        n3 = 31 * n3 + (this.buildNumber == null ? 0 : this.buildNumber.hashCode());
        n3 = 31 * n3 + this.majorVersion;
        n3 = 31 * n3 + this.minorVersion;
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VersionNumberCore versionNumberCore = (VersionNumberCore)object;
        if (this.bugFixVersion != versionNumberCore.bugFixVersion) {
            return false;
        }
        if (this.buildNumber == null ? versionNumberCore.buildNumber != null : !this.buildNumber.equals(versionNumberCore.buildNumber)) {
            return false;
        }
        if (this.majorVersion != versionNumberCore.majorVersion) {
            return false;
        }
        return this.minorVersion == versionNumberCore.minorVersion;
    }
}

