/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.contour;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.contour.localize.LocalizationStrategy;
import com.mimvista.commands.e;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.contouring.RecistPerpCalculator;
import com.mimvista.f.a;
import com.mimvista.f.g;
import com.mimvista.f.h;
import com.mimvista.internals.Contour;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.mouse.mode.contour.PetEdgeManualSettingsState;
import com.mimvista.mui.mouse.mode.contour.k;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.Overlay;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.contourtools.l;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

@e(e="PetEdge_Refine", f="petEdge_Refine_command", b="petEdge_Refine_name", a="Commands", h="pet_refine", k=MIMFeatureCategory.CONTOURING, l={MIMFeatureType.Workflow}, i={k.class}, n={SessionPredicate.NonNull}, j={LicenseOption.CONTOURING_OR_MAESTRO_OR_ENCORE})
public class PetEdgeRefineCommand
extends WorkflowCommand {
    private final List<VolumetricContourOverlay> a;

    public PetEdgeRefineCommand(List<AbstractContourOverlayish> list) {
        this.a = list != null && Iterables.all(list, (Predicate)Predicates.instanceOf(VolumetricContourOverlay.class)) ? Lists.newArrayList((Iterable)Iterables.filter(list, VolumetricContourOverlay.class)) : null;
    }

    @Override
    public Object execute() {
        if (this.a == null) {
            return null;
        }
        this.q.a(this.a.size());
        ArrayList arrayList = Lists.newArrayList();
        for (VolumetricContourOverlay object : this.a) {
            Object object2 = null;
            try {
                object2 = this.getPETEdgePoints(object);
            }
            catch (NullPointerException nullPointerException) {
                ay.d((Object)"Error redefining contour", (Throwable)nullPointerException, nullPointerException.getClass());
                arrayList.add(object);
                continue;
            }
            VoxelPoint3f voxelPoint3f = PetEdgeRefineCommand.getCentroid(object, object2);
            g g2 = h.a();
            PetEdgeManualSettingsState.a(MathUtils.a((List<? extends Point3f>)object2));
            ImageVolumeShort imageVolumeShort = object.aq().e();
            Contour contour = g2.a(voxelPoint3f, (List<VoxelPoint3f>)object2, imageVolumeShort, (Progress)new com.mimvista.util.progress.u(this.q, 1));
            if (contour == null) continue;
            com.mimvista.mui.mouse.mode.measure.builders.e e2 = new com.mimvista.mui.mouse.mode.measure.builders.e();
            e2.a(object.au(), contour, object);
            object.a(new PetEdgeManualSettingsState());
        }
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object2 : arrayList) {
                stringBuilder.append(((Overlay)object2).getName() + ", ");
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.b, MIMFormat.a(Messages.a("Commands", "PETEDGE_REFINE_ERROR"), stringBuilder.toString()), new Notification.a());
            u.b().c(basicNotification);
        }
        return null;
    }

    private static VoxelPoint3f getCentroid(VolumetricContourOverlayish volumetricContourOverlayish, List<VoxelPoint3f> list) {
        return new VoxelPoint3f(l.a((Iterable<? extends Point3f>)FluentIterable.from(list).skip(1)), list.get(0).i());
    }

    private List<VoxelPoint3f> getPETEdgePoints(VolumetricContourOverlayish volumetricContourOverlayish) {
        VoxelPoint3f[] voxelPoint3fArray = PetEdgeRefineCommand.getRecistPoints(volumetricContourOverlayish);
        VoxelPoint3f[] voxelPoint3fArray2 = this.getPointsForEdgeDetector(voxelPoint3fArray, volumetricContourOverlayish.aq());
        voxelPoint3fArray2 = PetEdgeRefineCommand.refinePointsWithEdgeDetector(voxelPoint3fArray2, volumetricContourOverlayish);
        return Lists.newArrayList((Object[])voxelPoint3fArray2);
    }

    private static VoxelPoint3f[] refinePointsWithEdgeDetector(VoxelPoint3f[] voxelPoint3fArray, VolumetricContourOverlayish volumetricContourOverlayish) {
        a a2 = h.b();
        SimpleImageVolume simpleImageVolume = (SimpleImageVolume)((Object)volumetricContourOverlayish.au().aw());
        a2.a(simpleImageVolume);
        a2.a(1.0f / MathUtils.u(simpleImageVolume.b()));
        return a2.a(voxelPoint3fArray);
    }

    private static VoxelPoint3f[] getRecistPoints(VolumetricContourOverlayish volumetricContourOverlayish) {
        RecistPerpCalculator recistPerpCalculator = new RecistPerpCalculator(volumetricContourOverlayish, true);
        recistPerpCalculator.a(LocalizationStrategy.a);
        RecistPerpCalculator.b b2 = recistPerpCalculator.a(true);
        MetricPoint3f[] metricPoint3fArray = b2.a();
        VoxelPoint3f[] voxelPoint3fArray = new VoxelPoint3f[metricPoint3fArray.length];
        for (int i2 = 0; i2 < metricPoint3fArray.length; ++i2) {
            voxelPoint3fArray[i2] = metricPoint3fArray[i2].b();
        }
        return voxelPoint3fArray;
    }

    private VoxelPoint3f[] getPointsForEdgeDetector(VoxelPoint3f[] voxelPoint3fArray, Contour contour) {
        VoxelPoint3f[] voxelPoint3fArray2 = new VoxelPoint3f[7];
        System.arraycopy(voxelPoint3fArray, 0, voxelPoint3fArray2, 1, voxelPoint3fArray.length);
        Point3f point3f = l.a((Point3f)voxelPoint3fArray2[1], (Point3f)voxelPoint3fArray2[2], (Point3f)voxelPoint3fArray2[3], voxelPoint3fArray2[4]);
        voxelPoint3fArray2[0] = new VoxelPoint3f(point3f, voxelPoint3fArray2[1].i());
        Vector3f vector3f = l.b(voxelPoint3fArray2[0], voxelPoint3fArray2[1], voxelPoint3fArray2[3]);
        voxelPoint3fArray2[5] = PetEdgeRefineCommand.rayCastContourIntersection(contour, voxelPoint3fArray2[0], vector3f, 0.25f);
        vector3f.negate();
        voxelPoint3fArray2[6] = PetEdgeRefineCommand.rayCastContourIntersection(contour, voxelPoint3fArray2[0], vector3f, 0.25f);
        return voxelPoint3fArray2;
    }

    private static VoxelPoint3f rayCastContourIntersection(Contour contour, VoxelPoint3f voxelPoint3f, Vector3f vector3f, float f2) {
        Vector3f vector3f2 = new Vector3f(vector3f);
        vector3f2.normalize();
        VoxelPoint3f voxelPoint3f2 = voxelPoint3f.a();
        boolean bl2 = contour.b(voxelPoint3f);
        float f3 = contour.b(voxelPoint3f) ? (float)(6 * MathUtils.m(contour.O())) : (float)(6 * MathUtils.m(contour.a().a()));
        for (float f4 = f2; f4 < f3; f4 += f2) {
            voxelPoint3f2.scaleAdd(f4, (Tuple3f)vector3f2, (Tuple3f)voxelPoint3f);
            if (!(contour.b(voxelPoint3f2) ^ bl2)) continue;
            return voxelPoint3f2;
        }
        return null;
    }
}

