/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.keyboard;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.d;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.statistics.ContourStatistician;
import com.mimvista.internals.statistics.HausdroffDistanceDeriver;
import com.mimvista.internals.statistics.i;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.Polylines;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.at;
import com.mimvista.numerics.au;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.c;
import com.mimvista.util.s;
import com.mimvista.util.work.m;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;

@e(e="hausdorffdistances", f="hausdorffdistances", b="hausdorffdistances_name", a="Commands", h="calculate_registration_metrics", l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.CONTOURING_OR_MAESTRO_OR_ENCORE, LicenseOption.SURE_PLAN})
public class HausdorffDistancesCommand
extends WorkflowCommand {
    public static boolean a = false;
    private List<VolumetricContourOverlayish> b;
    private List<VolumetricContourOverlayish> c;

    public HausdorffDistancesCommand(List<VolumetricContourOverlayish> list, List<VolumetricContourOverlayish> list2) {
        this.b = list;
        this.c = list2;
    }

    @Override
    public Object execute() {
        if (!s.a(new List[]{this.b, this.c})) {
            throw new IllegalStateException("Could not compare the list of contours. Either the sizes don't match or they are from different Series");
        }
        Map<VolumetricContourOverlayish, VolumetricContourOverlayish> map = s.a(this.b, this.c);
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            VolumetricContourOverlayish volumetricContourOverlayish = this.b.get(i2);
            VolumetricContourOverlayish volumetricContourOverlayish2 = map.get(volumetricContourOverlayish);
            HausdorffDistancesCommand.deriveStats(volumetricContourOverlayish, volumetricContourOverlayish2);
            this.q.N_();
        }
        this.q.b();
        return null;
    }

    public static i.f deriveStats(VolumetricContourOverlayish volumetricContourOverlayish, VolumetricContourOverlayish volumetricContourOverlayish2) {
        HausdroffDistanceDeriver hausdroffDistanceDeriver = HausdroffDistanceDeriver.a(volumetricContourOverlayish, volumetricContourOverlayish2);
        ContourStatistician contourStatistician = volumetricContourOverlayish2.bF_();
        contourStatistician.a(hausdroffDistanceDeriver, true);
        contourStatistician.w();
        return contourStatistician.a(hausdroffDistanceDeriver);
    }

    protected static List<List<Point3f>> buildEdgeList(Contour contour, Point3f.PointVolumeInfo pointVolumeInfo, float f2) {
        ArrayList arrayList = Lists.newArrayList();
        for (ContourSlice contourSlice : contour.t()) {
            VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(0.0f, 0.0f, (float)contourSlice.zPosition, pointVolumeInfo);
            float f3 = voxelIndexPoint3f.j().b().z;
            HausdorffDistancesCommand.processPolygonsForSlice(contourSlice.c(pointVolumeInfo, PresentationType.a), f3, f2, arrayList);
        }
        return arrayList;
    }

    protected static void processPolygonsForSlice(List<Polylines.MetricPolyline2f> list, float f2, float f3, List<List<Point3f>> list2) {
        for (Polylines.MetricPolyline2f metricPolyline2f : list) {
            ArrayList arrayList = Lists.newArrayList();
            for (int i2 = 0; i2 < metricPolyline2f.h(); ++i2) {
                int n2 = (i2 + 1) % metricPolyline2f.h();
                Point2f point2f = metricPolyline2f.a(i2);
                Point2f point2f2 = metricPolyline2f.a(n2);
                float f4 = point2f.distance(point2f2);
                arrayList.add(new Point3f(point2f.x, point2f.y, f2));
                if (!(f4 > f3)) continue;
                int n3 = (int)(f4 / f3);
                Vector2f vector2f = new Vector2f((Tuple2f)point2f2);
                vector2f.sub((Tuple2f)point2f);
                vector2f.normalize();
                vector2f.scale(f3);
                Point2f point2f3 = new Point2f((Tuple2f)point2f);
                for (int i3 = 0; i3 < n3; ++i3) {
                    point2f3.add((Tuple2f)vector2f);
                    arrayList.add(new Point3f(point2f3.x, point2f3.y, f2));
                }
            }
            list2.add(arrayList);
        }
    }

    public static b getDistances(ViewController viewController, Contour contour, Contour contour2, Progress progress) {
        return HausdorffDistancesCommand.getDistances(new Point3f.PointVolumeInfo(viewController.aw()), viewController.aw().C(), contour, contour2, progress);
    }

    public static b getDistances(ViewController viewController, VolumetricContourOverlayish volumetricContourOverlayish, VolumetricContourOverlayish volumetricContourOverlayish2, Progress progress) {
        return HausdorffDistancesCommand.getDistances(new Point3f.PointVolumeInfo(viewController.aw()), viewController.aw().C(), volumetricContourOverlayish.aq(), volumetricContourOverlayish2.aq(), progress);
    }

    public static b getDistances(Point3f.PointVolumeInfo pointVolumeInfo, int[] nArray, Contour contour, Contour contour2, Progress progress) {
        float f2 = pointVolumeInfo.voxel[0] / (float)nArray[0];
        List<List<Point3f>> list = HausdorffDistancesCommand.buildEdgeList(contour, pointVolumeInfo, f2);
        List<List<Point3f>> list2 = HausdorffDistancesCommand.buildEdgeList(contour2, pointVolumeInfo, f2);
        return HausdorffDistancesCommand.getDistances(list, list2, false, progress);
    }

    public static b getDistances2D(List<Polylines.MetricPolyline2f> list, List<Polylines.MetricPolyline2f> list2, float f2, boolean bl2, Progress progress) {
        ArrayList arrayList = Lists.newArrayList();
        HausdorffDistancesCommand.processPolygonsForSlice(list, 0.0f, f2, arrayList);
        ArrayList arrayList2 = Lists.newArrayList();
        HausdorffDistancesCommand.processPolygonsForSlice(list2, 0.0f, f2, arrayList2);
        return HausdorffDistancesCommand.getDistances(arrayList, arrayList2, bl2, progress);
    }

    protected static b getDistances(List<List<Point3f>> list, List<List<Point3f>> list2, boolean bl2, Progress progress) {
        if (list.size() == 0 || list2.size() == 0) {
            return null;
        }
        progress.a(1000);
        b b2 = null;
        b b3 = null;
        try {
            long l2 = System.nanoTime();
            com.mimvista.util.progress.b b4 = new com.mimvista.util.progress.b(progress);
            a a2 = HausdorffDistancesCommand.calculateUsingOctree(list, list2, new c(b4, 0.5));
            if (a2 == null) {
                return null;
            }
            Object object = HausdorffDistancesCommand.calculateUsingOctree(list2, list, new c(b4, 0.5));
            if (object == null) {
                return null;
            }
            Object object2 = com.mimvista.commands.keyboard.HausdorffDistancesCommand$a.a(a2, (a)object);
            b2 = new b(((a)object2).a, bl2, ((a)object2).b);
            FuncUtils.a(l2, "Hausdorff Octree");
            if (a) {
                long l3 = System.nanoTime();
                object = HausdorffDistancesCommand.calculateUsingBruteForce(list, list2);
                object2 = HausdorffDistancesCommand.calculateUsingBruteForce(list2, list);
                b3 = new b(MathUtils.a((float[])object, new float[][]{(float[])object2}), false, null);
                FuncUtils.a(l3, "Hausdorff Brute");
                if (!MathUtils.b((double)b3.c(), (double)b2.c(), 1.0E-4)) {
                    ay.d((Object)"Error calculating hausdorff distance", HausdorffDistancesCommand.class);
                    progress.k();
                    return null;
                }
                ay.e((Object)"Octree calc passes the test", HausdorffDistancesCommand.class);
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, HausdorffDistancesCommand.class);
            return null;
        }
        System.out.println("OctreeResult: " + b2.b());
        progress.b();
        return b2;
    }

    private static int countPoints(List<List<Point3f>> list) {
        int n2 = 0;
        for (List<Point3f> list2 : list) {
            n2 += list2.size();
        }
        return n2;
    }

    protected static float[] calculateUsingBruteForce(List<List<Point3f>> list, List<List<Point3f>> list2) {
        float[] fArray = new float[HausdorffDistancesCommand.countPoints(list)];
        int n2 = 0;
        for (List<Point3f> list3 : list) {
            for (Point3f point3f : list3) {
                float f2 = Float.POSITIVE_INFINITY;
                for (List<Point3f> list4 : list2) {
                    for (Point3f point3f2 : list4) {
                        float f3 = point3f.distance(point3f2);
                        if (!(f3 < f2)) continue;
                        f2 = f3;
                    }
                }
                fArray[n2] = f2;
                ++n2;
            }
        }
        return fArray;
    }

    protected static a calculateUsingOctree(final List<List<Point3f>> list, List<List<Point3f>> list2, final Progress progress) {
        final at at2 = new at(list2, 4, 1.0f);
        final int n2 = list.size();
        int n3 = 0;
        final int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = n3;
            n3 += list.get(i2).size();
        }
        progress.a(n3);
        final a a2 = new a();
        a2.a = new float[n3];
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        final ConcurrentLinkedQueue concurrentLinkedQueue = Queues.newConcurrentLinkedQueue();
        FuncUtils.e e2 = new FuncUtils.e(){

            @Override
            public void f(int n22, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                int n5;
                Point3f point3f = null;
                float f2 = 0.0f;
                List<au.a> list3 = at2.b();
                while ((n5 = atomicInteger.getAndIncrement()) < n2) {
                    int n6 = nArray[n5];
                    List list2 = (List)list.get(n5);
                    for (Point3f point3f2 : list2) {
                        Point3f point3f3 = at2.a(point3f2, list3);
                        float f3 = point3f3.distance(point3f2);
                        a2.a[n6++] = f3;
                        if (!(f3 > f2)) continue;
                        point3f = point3f3;
                        f2 = f3;
                    }
                    progress.c(list2.size());
                    if (progress.n() != Progress.Status.e) continue;
                    return;
                }
                if (point3f != null) {
                    concurrentLinkedQueue.add(Pair.get(point3f, Float.valueOf(f2)));
                }
            }
        };
        boolean bl2 = true;
        if (bl2) {
            FuncUtils.a((ThreadPoolExecutor)com.mimvista.util.work.m.c, n2, e2);
        } else {
            e2.f(0, n2, 0);
        }
        if (progress.n() == Progress.Status.e) {
            return null;
        }
        concurrentLinkedQueue.stream().max((pair, pair2) -> Float.compare(((Float)pair.y).floatValue(), ((Float)pair2.y).floatValue())).ifPresent(pair -> {
            a2.b = (Point3f)((Object)((Object)pair.x));
            a2.c = ((Float)pair.y).floatValue();
        });
        return a2;
    }

    private static class a {
        float[] a;
        Point3f b = null;
        float c = -1.0f;

        private a() {
        }

        public static a a(a a2, a a3) {
            a a4 = new a();
            a4.a = MathUtils.a(a2.a, new float[][]{a3.a});
            if (a2.b != null && a3.b != null) {
                if (a2.c >= a3.c) {
                    a4.c = a2.c;
                    a4.b = a2.b;
                } else {
                    a4.c = a3.c;
                    a4.b = a3.b;
                }
            }
            return a4;
        }
    }

    public static class b {
        private float a;
        private float b;
        private float c;
        private float d;
        private float e;
        private float[] f = null;
        private Point3f g;

        public b(float[] fArray, boolean bl2, @d Point3f point3f) {
            this.a(fArray);
            this.g = point3f;
            if (bl2) {
                this.f = fArray;
            }
        }

        private void a(float[] fArray) {
            Arrays.sort(fArray);
            this.b = MathUtils.F(fArray);
            this.a = MathUtils.C(fArray);
            this.e = MathUtils.a(false, fArray);
            this.c = MathUtils.z(fArray);
            this.d = MathUtils.b(fArray, this.c, false);
        }

        public float a() {
            return this.a;
        }

        public void a(float f2) {
            this.a = f2;
        }

        public float b() {
            return this.b;
        }

        public void b(float f2) {
            this.b = f2;
        }

        public float c() {
            return this.c;
        }

        public void c(float f2) {
            this.c = f2;
        }

        public float d() {
            return this.d;
        }

        public void d(float f2) {
            this.d = f2;
        }

        public float e() {
            return this.e;
        }

        public void e(float f2) {
            this.e = f2;
        }

        public Point3f f() {
            return this.g;
        }

        @d
        public float[] g() {
            return this.f;
        }
    }
}

