/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.keyboard;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureInfo;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.keyboard.KBDShortcutDialog;
import com.mimvista.commands.keyboard.KeyCommand;
import com.mimvista.commands.keyboard.al;
import com.mimvista.commands.keyboard.am;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.c;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.widgets.MIMJTextArea;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class KeyCommandPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static Messages a = Messages.a("Commands");
    private static final a b = new a(null){

        @Override
        public String toString() {
            return a.getProperty("KEYCOMMAND_ALL_LABEL");
        }
    };
    private al config;
    private BiMap<KeyStroke, KeyCommand> keybindingMap;
    private List<KeyCommand> allCommands;
    private ArrayListMultimap<MIMFeatureCategory, KeyCommand> categoryToCommands;
    private KeyBindingTableModel kbtModel;
    private List<a> selectableCategories;
    private JXTable bindingsTable;
    private TableColumnAdjuster columnAdjuster;
    private JTextField sBar;
    private JPanel tablePanel;
    private JCheckBox commandCB;
    private JCheckBox categoryCB;
    private JCheckBox keybindingCB;
    private JLabel categoryLabel;
    private JComboBox categoryList;
    private JScrollPane scrollPane;

    public KeyCommandPanel() {
        this.d();
        this.j();
    }

    private void d() {
        this.selectableCategories = new ArrayList<a>();
        this.selectableCategories.add(b);
        this.selectableCategories.addAll(com.mimvista.commands.keyboard.KeyCommandPanel$a.a());
        this.config = al.a();
        this.keybindingMap = this.config.d();
        this.allCommands = this.config.c();
        this.e();
        this.categoryToCommands = ArrayListMultimap.create();
        for (Object object : this.keybindingMap.entrySet()) {
            this.categoryToCommands.put((Object)((KeyCommand)object.getValue()).g(), object.getValue());
        }
        for (Object object : this.categoryToCommands.keySet()) {
            List list = this.categoryToCommands.get(object);
            Collections.sort(list, new KeyCommand.a());
        }
    }

    private void e() {
        Iterator<Object> iterator = this.keybindingMap.entrySet().iterator();
        while (iterator.hasNext()) {
            if (((KeyCommand)((Map.Entry)iterator.next()).getValue()).f()) continue;
            iterator.remove();
        }
        iterator = this.allCommands.iterator();
        while (iterator.hasNext()) {
            if (((KeyCommand)iterator.next()).f()) continue;
            iterator.remove();
        }
    }

    public void a() {
        Object object;
        a a2 = (a)this.categoryList.getSelectedItem();
        ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>(this.allCommands);
        HashBiMap hashBiMap = HashBiMap.create(this.keybindingMap);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (KeyCommand)iterator.next();
            if (a2 != b && a2.a != object.g()) {
                iterator.remove();
                continue;
            }
            if (this.a((KeyCommand)object)) continue;
            iterator.remove();
        }
        iterator = hashBiMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            if (a2 != b && a2.a != ((KeyCommand)object.getValue()).g()) {
                iterator.remove();
                continue;
            }
            if (this.a((KeyCommand)object.getValue())) continue;
            iterator.remove();
        }
        this.kbtModel.a(arrayList, (BiMap<KeyStroke, KeyCommand>)hashBiMap);
    }

    private boolean a(KeyCommand keyCommand) {
        String string = this.sBar.getText().toLowerCase();
        if (this.commandCB.isSelected() && keyCommand.getExternalizedString().toLowerCase().contains(string) || this.categoryCB.isSelected() && keyCommand.g().toString().toLowerCase().contains(string) || this.keybindingCB.isSelected() && al.b((KeyStroke)this.keybindingMap.inverse().get((Object)keyCommand)).toLowerCase().contains(string)) {
            return true;
        }
        return !this.commandCB.isSelected() && !this.categoryCB.isSelected() && !this.keybindingCB.isSelected() && keyCommand.getExternalizedString().toLowerCase().contains(string);
    }

    private void f() {
        int n2 = this.bindingsTable.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        int n3 = this.bindingsTable.convertRowIndexToModel(n2);
        KeyCommand keyCommand = this.kbtModel.a(n3);
        if (!keyCommand.f()) {
            return;
        }
        KeyStroke keyStroke = this.b(keyCommand);
        KeyEditDialog keyEditDialog = new KeyEditDialog(keyCommand, keyStroke, this);
        keyEditDialog.setVisible(true);
    }

    private void g() {
        int n2 = this.bindingsTable.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        int n3 = this.bindingsTable.convertRowIndexToModel(n2);
        KeyCommand keyCommand = this.kbtModel.a(n3);
        if (!keyCommand.f()) {
            return;
        }
        if (this.keybindingMap.containsValue((Object)keyCommand)) {
            this.keybindingMap.inverse().remove((Object)keyCommand);
            this.i();
        }
    }

    private void a(KeyStroke keyStroke, KeyCommand keyCommand) {
        if (keyStroke == null) {
            this.keybindingMap.inverse().forcePut((Object)keyCommand, null);
        } else {
            this.keybindingMap.forcePut((Object)keyStroke, (Object)keyCommand);
        }
        this.i();
    }

    private KeyCommand a(KeyStroke keyStroke) {
        return (KeyCommand)this.keybindingMap.get((Object)keyStroke);
    }

    private KeyStroke b(KeyCommand keyCommand) {
        return (KeyStroke)this.keybindingMap.inverse().get((Object)keyCommand);
    }

    public void b() {
        this.config.a((Map<KeyStroke, KeyCommand>)this.keybindingMap);
    }

    private void h() {
        this.keybindingMap = HashBiMap.create(this.config.e());
        this.i();
    }

    private void i() {
        int[] nArray = this.bindingsTable.getSelectedRows();
        this.kbtModel.a(this.kbtModel.commands, this.keybindingMap);
        this.bindingsTable.clearSelection();
        for (int n2 : nArray) {
            this.bindingsTable.setRowSelectionInterval(n2, n2);
        }
        this.firePropertyChange("mimPropertyModified", null, null);
    }

    private void j() {
        this.kbtModel = new KeyBindingTableModel(this.allCommands, this.keybindingMap);
        this.bindingsTable = new JXTable((TableModel)this.kbtModel);
        this.bindingsTable.setSelectionMode(0);
        this.bindingsTable.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                int n4 = jTable.convertRowIndexToModel(n2);
                KeyCommand keyCommand = KeyCommandPanel.this.kbtModel.a(n4);
                boolean bl4 = true;
                if (keyCommand != null && !keyCommand.f()) {
                    bl4 = false;
                }
                super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                this.setEnabled(bl4);
                if (!bl4) {
                    this.setBackground(null);
                    this.setBorder(null);
                    this.setFont(this.getFont().deriveFont(2));
                }
                return this;
            }
        });
        this.k();
        this.commandCB = new JCheckBox(a.getProperty("KEYCOMMAND_COMNAME"), true);
        this.categoryCB = new JCheckBox(a.getProperty("KEYCOMMAND_CATEGORY"), false);
        this.keybindingCB = new JCheckBox(a.getProperty("KEYCOMMAND_BINDING"), false);
        this.c();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 300));
        this.sBar = new JTextField("");
        this.sBar.setMaximumSize(new Dimension(150, 30));
        this.sBar.setMinimumSize(new Dimension(150, 30));
        this.sBar.setPreferredSize(new Dimension(150, 30));
        this.sBar.setSize(new Dimension(150, 30));
        this.categoryLabel = new JLabel(a.getProperty("KEYCOMMAND_CAT_LABEL"), 4);
        this.categoryLabel.setMaximumSize(new Dimension(50, 30));
        this.categoryLabel.setMinimumSize(new Dimension(50, 30));
        this.sBar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                KeyCommandPanel.this.a();
            }
        });
        this.categoryList = new JComboBox<Object>(this.selectableCategories.toArray());
        jPanel.add(this.categoryLabel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.categoryList);
        jPanel.add(Box.createHorizontalGlue());
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel2.add(this.sBar);
        jPanel2.add(Box.createRigidArea(new Dimension(50, 0)));
        jPanel2.add(this.l());
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        jPanel4.add(new JLabel(a.getProperty("KEYCOMMAND_CRITERIA")));
        jPanel4.add(this.commandCB);
        jPanel4.add(this.categoryCB);
        jPanel4.add(this.keybindingCB);
        this.categoryList.setMaximumSize(new Dimension(150, 30));
        this.categoryList.setMinimumSize(new Dimension(150, 30));
        this.categoryLabel.setMaximumSize(new Dimension(150, 30));
        this.categoryLabel.setMinimumSize(new Dimension(150, 30));
        this.categoryList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                KeyCommandPanel.this.sBar.setText("");
                KeyCommandPanel.this.a();
            }
        });
        this.scrollPane = new JScrollPane((Component)this.bindingsTable);
        this.scrollPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 280));
        this.scrollPane.setMinimumSize(new Dimension(Short.MIN_VALUE, 280));
        this.scrollPane.setPreferredSize(new Dimension(Short.MIN_VALUE, 280));
        this.scrollPane.setSize(new Dimension(Short.MIN_VALUE, 280));
        this.tablePanel.add(this.scrollPane);
        this.add((Component)jPanel3, "North");
        this.add((Component)this.tablePanel, "Center");
        this.add((Component)jPanel4, "South");
        this.columnAdjuster = new TableColumnAdjuster((JTable)this.bindingsTable);
        this.columnAdjuster.setOnlyAdjustLarger(true);
        this.columnAdjuster.adjustColumns();
    }

    private void k() {
        this.bindingsTable.addKeyListener((KeyListener)new KeyAdapter(){
            private KeyStroke b = KeyStroke.getKeyStroke(127, 0);
            private KeyStroke c = KeyStroke.getKeyStroke(8, 0);
            private KeyStroke d = KeyStroke.getKeyStroke(10, 0);

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                if (keyStroke.equals(this.b) || keyStroke.equals(this.c)) {
                    KeyCommandPanel.this.g();
                    keyEvent.consume();
                } else if (keyStroke.equals(this.d)) {
                    KeyCommandPanel.this.f();
                    keyEvent.consume();
                }
            }
        });
        this.bindingsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    KeyCommandPanel.this.f();
                }
            }
        });
    }

    public void c() {
        this.commandCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyCommandPanel.this.a();
            }
        });
        this.categoryCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyCommandPanel.this.a();
            }
        });
        this.keybindingCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyCommandPanel.this.a();
            }
        });
    }

    private Box l() {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        JButton jButton = new JButton(a.getProperty("KEYCOMMAND_RESET_DEFAULTS"), ImageManipulator.c("rotate", 18));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyCommandPanel.this.h();
            }
        });
        box.add(jButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(c.a("edit", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyCommandPanel.this.f();
            }
        }, null));
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(5));
        box.add(c.a("generic_export", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyBindingTableModel keyBindingTableModel = new KeyBindingTableModel(KeyCommandPanel.this.kbtModel);
                keyBindingTableModel.commands.retainAll(keyBindingTableModel.bindingMap.values());
                KBDShortcutDialog kBDShortcutDialog = new KBDShortcutDialog(KeyCommandPanel.this, keyBindingTableModel);
                MIMSwingUtils.a((Component)kBDShortcutDialog);
                kBDShortcutDialog.setVisible(true);
            }
        }, a.getProperty("KEYCOMMAND_EXPORT_PDF_TOOLTIP")));
        box.add(Box.createHorizontalStrut(5));
        Box box2 = Box.createVerticalBox();
        box2.add(Box.createVerticalStrut(5));
        box2.add(box);
        box2.add(Box.createVerticalStrut(5));
        return box2;
    }

    private static class a {
        MIMFeatureCategory a;

        public a(MIMFeatureCategory mIMFeatureCategory) {
            this.a = mIMFeatureCategory;
        }

        public String toString() {
            return this.a.getExternalizedString();
        }

        public static List<a> a() {
            return Lists.transform(MIMFeatureCategory.a(), (Function)new Function<MIMFeatureCategory, a>(){

                public a a(MIMFeatureCategory mIMFeatureCategory) {
                    return new a(mIMFeatureCategory);
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((MIMFeatureCategory)object);
                }
            });
        }
    }

    private static class KeyBindingSlurper
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private KeyStroke current;

        public KeyBindingSlurper(KeyStroke keyStroke) {
            this.a(keyStroke);
            this.setFocusable(true);
            this.setAlignmentX(0.5f);
            this.setOpaque(true);
            this.setBackground(MIMLookAndFeel.E());
            this.setBorder(BorderFactory.createCompoundBorder(MIMLookAndFeel.H(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    this.a(am.b(keyEvent));
                    this.grabFocus();
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (current == null || am.b(current.getKeyCode()) != 0) {
                        this.a(null);
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.requestFocusInWindow();
                }
            });
        }

        public void a(KeyStroke keyStroke) {
            this.current = keyStroke;
            if (keyStroke != null) {
                this.setText(al.b(keyStroke));
            } else {
                this.setText(a.getProperty("KEYCOMMAND_UNASSIGNED"));
            }
        }

        public KeyStroke a() {
            return this.current;
        }
    }

    private static class KeyEditDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private final KeyCommand keyCommand;
        private final KeyCommandPanel keyCommandPanel;
        private KeyBindingSlurper slurper;
        private MIMJTextArea errorLabel;

        private KeyEditDialog(KeyCommand keyCommand, KeyStroke keyStroke, KeyCommandPanel keyCommandPanel) {
            super(SwingUtilities.getWindowAncestor(keyCommandPanel));
            this.keyCommand = keyCommand;
            this.keyCommandPanel = keyCommandPanel;
            this.a(keyStroke);
        }

        private void a(KeyStroke keyStroke) {
            this.setTitle(a.getProperty("KEYCOMMAND_EDIT_BIND"));
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.setModal(true);
            ImageManipulator.a(this);
            this.add(Box.createVerticalStrut(5));
            JLabel jLabel = new JLabel(a.getProperty("KEYCOMMAND_INPUT"));
            jLabel.setAlignmentX(0.5f);
            this.add(jLabel);
            this.add(Box.createVerticalStrut(5));
            JLabel jLabel2 = new JLabel(this.keyCommand.getExternalizedString());
            jLabel2.setFont(jLabel2.getFont().deriveFont(1));
            jLabel2.setAlignmentX(0.5f);
            this.add(jLabel2);
            this.add(Box.createVerticalStrut(10));
            this.slurper = new KeyBindingSlurper(keyStroke);
            this.add(this.slurper);
            this.slurper.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    KeyCommand keyCommand = keyCommandPanel.a(slurper.a());
                    if (keyCommand != null && keyCommand != keyCommand) {
                        errorLabel.setText(MIMFormat.a(a.getProperty("KEYCOMMAND_REPLACE"), al.b(slurper.a()), "\n" + keyCommand.getExternalizedString()));
                    } else {
                        errorLabel.setText("");
                    }
                    errorLabel.a();
                    this.pack();
                }
            });
            this.add(Box.createVerticalStrut(10));
            this.errorLabel = new MIMJTextArea("", false);
            this.errorLabel.setForeground(Color.red);
            this.errorLabel.setAlignmentX(0.5f);
            this.errorLabel.setMinimumSize(new Dimension(0, 30));
            this.add(this.errorLabel);
            this.add(Box.createVerticalStrut(10));
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            JButton jButton = new JButton(a.b("KEYCOMMAND_SET_UNBIND"), ImageManipulator.c("link", 18));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    slurper.a(null);
                }
            });
            box.add(Box.createHorizontalStrut(5));
            box.add(jButton);
            box.add(Box.createHorizontalStrut(5));
            box.add(c.c(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    keyCommandPanel.a(slurper.a(), keyCommand);
                    this.dispose();
                }
            }, ""));
            box.add(Box.createHorizontalStrut(5));
            box.add(c.a(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.dispose();
                }
            }, ""));
            box.add(Box.createHorizontalStrut(5));
            this.add(box);
            this.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowLostFocus(WindowEvent windowEvent) {
                }

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    slurper.grabFocus();
                }
            });
            ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pack();
            MIMSwingUtils.a((Component)this);
        }
    }

    public static class KeyBindingTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final String[] a = new String[]{a.getProperty("KEYCOMMAND_NAME"), a.getProperty("KEYCOMMAND_CATEGORY"), a.getProperty("KEYCOMMAND_SCOPE"), a.getProperty("KEYCOMMAND_BINDING")};
        protected BiMap<KeyStroke, KeyCommand> bindingMap;
        protected List<KeyCommand> commands;

        public KeyBindingTableModel(KeyBindingTableModel keyBindingTableModel) {
            this(keyBindingTableModel.commands, keyBindingTableModel.bindingMap);
        }

        public KeyBindingTableModel(List<KeyCommand> list, BiMap<KeyStroke, KeyCommand> biMap) {
            this.a(list, biMap);
        }

        public void a(List<KeyCommand> list, BiMap<KeyStroke, KeyCommand> biMap) {
            this.commands = new ArrayList<KeyCommand>(list);
            this.bindingMap = HashBiMap.create(biMap);
            Collections.sort(this.commands, new KeyCommand.a());
            this.fireTableDataChanged();
        }

        public KeyCommand a(int n2) {
            return this.commands.get(n2);
        }

        @Override
        public int getColumnCount() {
            return a.length;
        }

        @Override
        public int getRowCount() {
            return this.commands.size();
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            KeyCommand keyCommand = this.a(n2);
            String string = "";
            if (n3 == 0) {
                string = keyCommand.getExternalizedString();
            } else if (n3 == 1) {
                string = keyCommand.g().getExternalizedString();
            } else if (n3 == 2) {
                string = this.a(keyCommand);
            } else if (n3 == 3) {
                string = al.b((KeyStroke)this.bindingMap.inverse().get((Object)keyCommand));
            }
            if (!keyCommand.f()) {
                // empty if block
            }
            return string;
        }

        @Override
        public String getColumnName(int n2) {
            return a[n2];
        }

        private String a(KeyCommand keyCommand) {
            boolean bl2;
            boolean bl3 = bl2 = keyCommand.k() instanceof MIMFeatureInfo && ((MIMFeatureInfo)keyCommand.k()).a(MIMFeatureType.c);
            return keyCommand.b() ? a.getProperty("KEYCOMMAND_SERIES") : (bl2 ? a.getProperty("KEYCOMMAND_MOUSE_MODE") : a.getProperty("KEYCOMMAND_SESSION"));
        }
    }
}

