/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.primitives.Doubles;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.gui.j;
import com.mimvista.archive.m;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.ProblemType;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.binning.BadTTLException;
import com.mimvista.dicom.binning.BadTimingException;
import com.mimvista.dicom.binning.BinningParams;
import com.mimvista.dicom.binning.BinningTarget;
import com.mimvista.dicom.binning.RPMLoader;
import com.mimvista.dicom.binning.TargetType;
import com.mimvista.dicom.util.EncapsulateDocumentFrame;
import com.mimvista.dicom.util.EncapsulateDocumentHandler;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.k;
import com.mimvista.gui.util.l;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.mui.Session;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.BinningPrefs;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.o;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.workflow.gui.args.h;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import net.tomahawk.ExtensionsFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

@e(e="bin4dct", f="bin4dct", b="bin4dct_name", a="Commands", h="ui_sessions", k=MIMFeatureCategory.MISCELLANEOUS, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.MAESTRO_OR_SYMPHONY})
public class Bin4DCTCommand
extends WorkflowCommand {
    private final com.mimvista.commands.workflow.a b = new com.mimvista.commands.workflow.a();
    private final boolean c;
    private final File d;
    Consumer<ViewController> a;
    private static final FileFilter e = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return "vxp".equals(FilenameUtils.getExtension((String)file.getName()));
        }
    };

    public Bin4DCTCommand(ViewController viewController, boolean bl2, @d File file) {
        this.c = bl2;
        this.d = file;
        if (viewController != null) {
            this.b.a(viewController);
        }
    }

    public void setSeries(DcmSeries dcmSeries) {
        this.b.a(dcmSeries);
    }

    @Override
    public void setSession(Session session) {
        super.setSession(session);
        this.b.a(session);
    }

    public void setCompletionCallback(Consumer<ViewController> consumer) {
        this.b.a(consumer);
    }

    @Override
    public ViewController execute() {
        ViewController viewController = null;
        File file = this.getRPMFileToUse().orElse(null);
        if (file == null) {
            this.cancel();
            return null;
        }
        if (!this.rpmFileMatchesSeries(file) && this.indicateProblem(m.getProperty("BIN4DCT_MISMATCH_WARN"), ProblemType.b)) {
            return null;
        }
        try {
            BinningParams binningParams;
            block10: {
                binningParams = this.buildParams(file);
                try {
                    binningParams.getRPM().validate();
                }
                catch (BadTimingException badTimingException) {
                    boolean bl2 = BinningPrefs.strictRPMValidation.getValue();
                    String string = m.getProperty(bl2 ? "BIN4DCT_BAD_TIMING" : "BIN4DCT_BAD_TIMING_MEH");
                    if (!this.indicateProblem(string, bl2 ? ProblemType.c : ProblemType.b)) break block10;
                    return null;
                }
            }
            viewController = this.b.a(binningParams, this.q);
            if (viewController != null && BinningPrefs.encapsulateRPM.getValue().booleanValue()) {
                this.encapsulateRPM(file, viewController.getUncopiedMutableInfo());
            }
        }
        catch (BadTimingException badTimingException) {
            this.indicateProblem(m.getProperty("BIN4DCT_BAD_TIMING"), ProblemType.c);
            return null;
        }
        catch (BadTTLException badTTLException) {
            this.indicateProblem(m.getProperty("BIN4DCT_UNCORRECTABLE_TTL"), ProblemType.c);
            return null;
        }
        catch (Exception exception) {
            if (this.o == null) {
                this.q.j();
            }
            ay.d((Object)"Binning failed", (Throwable)exception, this);
            throw new RuntimeException(exception);
        }
        return viewController;
    }

    private Optional<File> getRPMFileToUse() {
        List<File> list = this.searchForRPMFile();
        if (list.size() == 1) {
            return Optional.of(Iterables.getOnlyElement(list));
        }
        if (list.size() > 1) {
            return Optional.ofNullable(this.promptForClarification(list)).orElseGet(() -> this.promptForFile());
        }
        return this.promptForFile();
    }

    private Optional<File> promptForFile() {
        if (!this.allowGui()) {
            return Optional.empty();
        }
        return new a().a();
    }

    private List<File> searchForRPMFile() {
        Object object = this.c ? Lists.newArrayList((Object[])new File[]{this.d}) : BinningPrefs.rpmDirectories.getValue();
        LinkedList linkedList = Lists.newLinkedList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists() || !file.isDirectory()) continue;
            for (File file2 : file.listFiles(e)) {
                if (!RPMLoader.matchesSeriesInfo(this.b.a.e(), this.b.a.patientId, file2)) continue;
                linkedList.add(file2);
            }
        }
        return linkedList;
    }

    private Optional<File> promptForClarification(List<File> list) {
        if (!this.allowGui()) {
            ay.c((Object)("Ambiguous RPM files not resolvable in headless context.  Can't decide among " + Arrays.toString(list.toArray())), this);
            return Optional.empty();
        }
        return new c(list).a();
    }

    private BinningParams buildParams(File file) {
        RPMLoader.RPMInfo rPMInfo = RPMLoader.load(file);
        List<BinningTarget> list = this.getTargetsToUse(rPMInfo);
        TargetType targetType = TargetType.getForPref(BinningPrefs.targetMode.getValue());
        boolean bl2 = BinningPrefs.anatomicCorrection.getValue();
        BinningParams binningParams = new BinningParams(list, rPMInfo, targetType, bl2);
        return binningParams;
    }

    private List<BinningTarget> getTargetsToUse(RPMLoader.RPMInfo rPMInfo) {
        TargetType targetType = TargetType.getForPref(BinningPrefs.targetMode.getValue());
        List<BinningTarget> list = targetType.getTargetsFromPrefs(rPMInfo);
        list = targetType.correctTargets(list, string -> this.indicateProblem((String)string, ProblemType.a));
        return list;
    }

    private boolean rpmFileMatchesSeries(File file) {
        return RPMLoader.matchesSeriesInfo(this.b.a.e(), this.b.a.patientId, file);
    }

    private void encapsulateRPM(File file, SeriesInfo seriesInfo) {
        HashMap<String, String> hashMap = com.mimvista.archive.m.a("", "", this.b.a.patientId, "", this.b.a.M(), this.b.a.M(), "");
        List<DcmSeries> list = this.b.c.b(hashMap);
        boolean bl2 = Iterables.any(list, dcmSeries -> Modality.DOC.isSameModality(dcmSeries.getActualModality()) && file.getName().equals(dcmSeries.getSeriesDescription()));
        if (!bl2) {
            try {
                DcmSeries dcmSeries2 = (DcmSeries)Iterables.find(list, dcmSeries -> Modality.CT.isSameModality(dcmSeries.getActualModality()) && seriesInfo.ag().equals(dcmSeries.getSeriesInstanceUID()));
                TreeMap<Integer, String> treeMap = j.a(dcmSeries2);
                treeMap.put(528725, seriesInfo.sopInstanceUID);
                EncapsulateDocumentHandler encapsulateDocumentHandler = new EncapsulateDocumentHandler(treeMap, new o());
                encapsulateDocumentHandler.setModality(Modality.DOC.get());
                encapsulateDocumentHandler.setSeriesDescription(file.getName());
                SendToDestination sendToDestination = ag.a(this.b.c);
                if (sendToDestination == null) {
                    ay.c((Object)("Cannot encapsulate RPM for search source: " + this.b.c.getExternalizedString()), this);
                } else {
                    EncapsulateDocumentFrame.encapsulate(encapsulateDocumentHandler, Lists.newArrayList((Object[])new File[]{file}), this.b.c, ag.a(this.b.c));
                }
            }
            catch (Exception exception) {
                ay.c((Object)("RPM Encapsulation failed for " + file.getName()), (Throwable)exception, this);
            }
        }
    }

    @Override
    public com.mimvista.workflow.gui.args.a<WorkflowCommand>[] createArgumentViews(com.mimvista.workflow.gui.c<WorkflowCommand> c2) {
        com.mimvista.workflow.gui.args.a<WorkflowCommand>[] aArray = super.createArgumentViews(c2);
        aArray[1] = new com.mimvista.workflow.gui.args.b<WorkflowCommand>(c2, 1){

            @Override
            public String h_() {
                return WorkflowCommand.m.getProperty("BIN4DCT_ARG2_TRUE");
            }

            @Override
            public String i_() {
                return WorkflowCommand.m.getProperty("BIN4DCT_ARG2_FALSE");
            }
        };
        aArray[2] = new h<WorkflowCommand>(c2, 2);
        aArray[1].b(true, aArray[2]);
        aArray[1].a((Object)false, aArray[2]);
        return aArray;
    }

    public static void generateUID(ViewController3D viewController3D) {
        CRC32 cRC32 = new CRC32();
        for (ImageVolumeShort imageVolumeShort2 : viewController3D.cE().l()) {
            imageVolumeShort2.ab().forEach(sliceInfo -> cRC32.update(sliceInfo.sopInstanceUID.getBytes()));
        }
        viewController3D.cE().l().forEach(imageVolumeShort -> {
            imageVolumeShort.getUncopiedMutableInfo().binnedID = (int)cRC32.getValue();
        });
    }

    public static void main(String[] stringArray) throws IOException {
        File file = null;
        for (File file2 : FileUtils.listFiles(file, (String[])new String[]{"vxp"}, (boolean)false)) {
            HistogramDataset histogramDataset = new HistogramDataset();
            ArrayList arrayList = Lists.newArrayList();
            RPMLoader.Direction direction = null;
            try {
                Object object2;
                for (Object object2 : RPMLoader.load((File)file2).data) {
                    if (((RPMLoader.RPMPacket)object2).validity == RPMLoader.Validity.VALID && ((RPMLoader.RPMPacket)object2).ttl && direction != ((RPMLoader.RPMPacket)object2).direction && direction != null) {
                        arrayList.add(((RPMLoader.RPMPacket)object2).amplitude);
                    }
                    direction = ((RPMLoader.RPMPacket)object2).direction;
                }
                Object object3 = Doubles.toArray((Collection)arrayList);
                object2 = Files.getNameWithoutExtension((String)file2.getName());
                histogramDataset.addSeries((Comparable)object2, (double[])object3, 15);
                JFreeChart jFreeChart = ChartFactory.createHistogram((String)"vals", (String)"amplitude", (String)"freq", (IntervalXYDataset)histogramDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                BufferedImage bufferedImage = jFreeChart.createBufferedImage(800, 600);
                ImageIO.write((RenderedImage)bufferedImage, "png", new File(file, (String)object2 + ".png"));
            }
            catch (Exception exception) {}
        }
    }

    private static class a
    extends b {
        public a() {
            super(Messages.a("Commands", "BIN4DCT_DIALOG_TITLE"));
            this.addTextAreaAsLabel(Messages.a("Commands", "BIN4DCT_DIALOG_MEMO"));
            this.b = this.addFileBrowser(Messages.a("Commands", "BIN4DCT_DIALOG_LABEL"), MIMFileDialog.FileDialogType.a, new ExtensionsFilter(Messages.a("Commands", "BIN4DCT_FILE_FILTER"), "vxp"));
            this.b.a(new k(){

                @Override
                public String validate(Object object) {
                    String string;
                    File file;
                    if (object instanceof String && (file = new File(string = (String)object)).exists()) {
                        return null;
                    }
                    return "";
                }
            });
        }
    }

    private static class c
    extends b {
        List<File> d;
        String[] e;

        public c(List<File> list) {
            super(Messages.a("Commands", "BIN4DCT_DIALOG_TITLE"));
            this.d = list;
            this.e = Lists.transform(list, File::getName).toArray(new String[list.size() + 1]);
            this.e[list.size()] = Messages.a("ButtonFactory", "BROWSE_BUTTON");
            this.addTextAreaAsLabel(Messages.a("Commands", "BIN4DCT_AMBIGUOUS_RPM_MEMO"));
            this.b = this.addComboBox(Messages.a("Commands", "BIN4DCT_AMBIGUOUS_RPM_LABEL"), this.e);
        }

        @Override
        Optional<File> b() {
            int n2 = ArrayUtils.indexOf((Object[])this.e, this.b.b());
            if (n2 == this.d.size()) {
                return null;
            }
            return Optional.of(this.d.get(n2));
        }
    }

    private static abstract class b
    extends InputNotification {
        final FuncUtils.f a = new FuncUtils.f();
        l<String> b;
        Optional<File> c = this.c();

        public b(String string) {
            super(new Notification.a(), Messages.a("Commands", "BIN4DCT_DIALOG_TITLE"), "ui_sessions");
            this.d();
        }

        Optional<File> a() {
            u.b().c(this);
            this.a.a();
            return this.c;
        }

        private void d() {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!a.isDone()) {
                        c = this.c();
                        a.b();
                    }
                }
            };
            ActionListener actionListener2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    c = this.b();
                    a.b();
                }
            };
            this.addCancelListener(actionListener);
            this.setDismissActionListener(actionListener);
            this.addOkListener(actionListener2);
        }

        Optional<File> b() {
            return Optional.of(new File(this.b.b()));
        }

        Optional<File> c() {
            return Optional.empty();
        }
    }
}

