/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow;

import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.atlas.management.AtlasDBManager;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.d;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.internals.FusionViewControllerEdits;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.linking.CompositeTransform;
import com.mimvista.internals.linking.PositionTransform;
import com.mimvista.internals.linking.ViewLinker;
import com.mimvista.internals.s;
import com.mimvista.mui.ActivateAndPossiblyCreatePageEdit;
import com.mimvista.mui.AutoFusionEdit;
import com.mimvista.mui.Session;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.presenters.display.p;
import com.mimvista.state.b;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.state.ProtocolPresenterAddress;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.workflow.backend.VariableReference;
import com.mimvista.workflow.backend.t;
import com.mimvista.workflow.gui.args.a;
import com.mimvista.workflow.gui.args.v;
import com.mimvista.workflow.gui.c;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.Icon;
import javax.swing.event.UndoableEditEvent;
import javax.vecmath.Matrix4f;

@e(e="fusion", f="fusion_command", b="fusion_name", a="Commands", h="fusion", k=MIMFeatureCategory.REGISTRATION, l={MIMFeatureType.Workflow}, i={com.mimvista.mui.mouse.b.class}, n={SessionPredicate.NonNull}, j={LicenseOption.BASE, LicenseOption.ULTRASOUND_3D, LicenseOption.ENAD_BASE})
public class FusionCommand
extends WorkflowCommand {
    ViewController a;
    ViewController b;
    AlignmentMode c;
    List<VolumetricContourOverlayish> d;
    private static final int e = 2;
    private static final int f = 3;

    public FusionCommand(ViewController viewController, ViewController viewController2, @d AlignmentMode alignmentMode, @d List<VolumetricContourOverlayish> list) {
        this.a = viewController;
        this.b = viewController2;
        this.c = alignmentMode != null ? alignmentMode : AlignmentMode.a;
        this.d = list != null && list.isEmpty() ? null : list;
    }

    @Override
    public a<WorkflowCommand>[] createArgumentViews(c<WorkflowCommand> c2) {
        a[] aArray = super.createArgumentViews(c2);
        aArray[3].a(() -> {
            VariableReference variableReference = this.n.getInputVarReference(this, 2);
            AlignmentMode alignmentMode = (AlignmentMode)variableReference.a();
            return alignmentMode != AlignmentMode.d;
        });
        v v2 = (v)FusionCommand.getArg(aArray, 2);
        v2.a(() -> aArray[3].n().setVisible(v2.i() == AlignmentMode.d));
        return aArray;
    }

    @Override
    public ViewController execute() {
        return this.execute(null);
    }

    @Override
    public LicenseOption[] getRequiredLicense() {
        return com.mimvista.mui.mouse.b.k.toArray(new LicenseOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public s execute(@d Matrix4f matrix4f) {
        Object object;
        Object object2;
        if (this.shouldBailBecauseOfAtlas() || this.shouldBailBecauseOfWarp()) {
            return null;
        }
        if (!com.mimvista.mui.mouse.b.a(this.a, this.b)) {
            throw new FusionLicensingException();
        }
        ProtocolPresenterAddress protocolPresenterAddress = null;
        ViewController viewController = this.a;
        ViewController viewController2 = this.b;
        if (this.allowGui()) {
            this.doGuiOnlySetup();
            protocolPresenterAddress = this.getPageToLoadFusion();
            object2 = this.lookForFusionOnCurrentPage(protocolPresenterAddress);
            if (object2 != null && matrix4f != null) {
                ((s)object2).a(matrix4f);
                return object2;
            }
            object = protocolPresenterAddress.a();
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.a.bW() == null && !this.a.aU()) {
                bl2 = true;
            }
            if (this.b.bW() == null && !this.b.aU()) {
                bl3 = true;
            }
            for (ViewController viewController3 : ((com.mimvista.mui.presenters.protocol.a)object).e()) {
                if (viewController3.U()) continue;
                if (!bl2 && viewController3.au() == this.a.au()) {
                    bl2 = true;
                    viewController = viewController3;
                }
                if (bl3 || viewController3.au() != this.b.au()) continue;
                bl3 = true;
                viewController2 = viewController3;
            }
            if (!bl2) {
                viewController = this.a.a(-1L, true);
            }
            if (!bl3) {
                viewController2 = this.b.a(-1L, true);
            }
        }
        object2 = new FusionViewControllerEdits.FusionState(viewController, viewController2);
        ((FusionViewControllerEdits.FusionState)object2).a(true);
        ((FusionViewControllerEdits.FusionState)object2).a(this.q);
        ((FusionViewControllerEdits.FusionState)object2).a(this.c);
        ((FusionViewControllerEdits.FusionState)object2).a(this.d);
        ((FusionViewControllerEdits.FusionState)object2).a(this.getWorkflowEngine());
        if (matrix4f != null) {
            ((FusionViewControllerEdits.FusionState)object2).a(matrix4f);
        }
        object = null;
        BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.c, Messages.a("Modes").getProperty("BOX_BASED_ASSISTED_ALIGNMENT_WORKFLOW_PAUSE"), new Notification.a(this.p));
        if (this.c == AlignmentMode.e) {
            object = new CountDownLatch(1);
            ((FusionViewControllerEdits.FusionState)object2).a((CountDownLatch)object);
        }
        AutoFusionEdit autoFusionEdit = new AutoFusionEdit(Lists.newArrayList((Object[])new FusionViewControllerEdits.FusionState[]{object2}), protocolPresenterAddress);
        this.p.r().undoableEditHappened(new UndoableEditEvent(this, autoFusionEdit));
        if (object != null) {
            try {
                basicNotification.setPriority(999);
                u.b().c(basicNotification);
                ((CountDownLatch)object).await();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                u.b().d(basicNotification);
            }
        }
        if (autoFusionEdit.a().size() == 0) {
            return null;
        }
        return (s)this.p.b(autoFusionEdit.a().get(0));
    }

    private ProtocolPresenterAddress getPageToLoadFusion() {
        ActivateAndPossiblyCreatePageEdit activateAndPossiblyCreatePageEdit = new ActivateAndPossiblyCreatePageEdit(this.p);
        this.p.r().a(activateAndPossiblyCreatePageEdit);
        ProtocolPresenterAddress protocolPresenterAddress = activateAndPossiblyCreatePageEdit.a();
        return protocolPresenterAddress;
    }

    private void doGuiOnlySetup() {
        if (this.a.aw() == this.b.aw()) {
            u.b().c(new BasicNotification(BasicNotification.NotificationType.b, m.getProperty("FUSION_WARN"), new Notification.a(), Notification.NotificationTimeoutType.b, 5000L));
        }
        this.a.g().d(this.a);
    }

    private s lookForFusionOnCurrentPage(ProtocolPresenterAddress protocolPresenterAddress) {
        this.q.a();
        this.q.a(protocolPresenterAddress.a().e().size());
        for (ViewController viewController : protocolPresenterAddress.a().e()) {
            s s2;
            if (viewController instanceof s && (s2 = (s)viewController).V() == this.a && s2.W() == this.b) {
                s2.bX();
                return s2;
            }
            this.q.N_();
        }
        this.q.b();
        return null;
    }

    public static boolean canAutoFuse(ViewController viewController, ViewController viewController2) {
        if (!MIMContext.i() && !com.mimvista.mui.mouse.b.a(viewController, viewController2)) {
            return false;
        }
        if (viewController == viewController2) {
            return false;
        }
        if (viewController.bg() || viewController2.bg()) {
            return false;
        }
        if (viewController2 instanceof s || viewController instanceof s) {
            return false;
        }
        String string = viewController2.getUncopiedMutableInfo().modality;
        String string2 = viewController.getUncopiedMutableInfo().modality;
        if ("RTImage".equalsIgnoreCase(string) || "RTImage".equalsIgnoreCase(string2)) {
            return false;
        }
        if (string.compareTo(string2) < 1 && !FusionCommand.shouldFuseUltrasound3d(viewController, viewController2)) {
            return false;
        }
        if (viewController.getNumberOfImages().equals("1") || viewController2.getNumberOfImages().equals("1")) {
            return false;
        }
        List<s> list = com.mimvista.mui.presenters.display.p.i(viewController2);
        if (!list.isEmpty()) {
            return false;
        }
        List<s> list2 = com.mimvista.mui.presenters.display.p.i(viewController);
        if (!list2.isEmpty()) {
            return false;
        }
        if (!viewController2.bu()) {
            return false;
        }
        SeriesInfo seriesInfo = viewController.getUncopiedMutableInfo();
        SeriesInfo seriesInfo2 = viewController2.getUncopiedMutableInfo();
        boolean bl2 = false;
        if (!seriesInfo2.frameOfRefUID.equals(seriesInfo.frameOfRefUID) && seriesInfo2.frameOfRefUID.length() > 0) {
            bl2 = true;
        }
        if (SeriesIdentifier.isNAC(seriesInfo2)) {
            return false;
        }
        if (SeriesIdentifier.isNAC(seriesInfo)) {
            return false;
        }
        if (seriesInfo2.modality.equals("PT") && seriesInfo2.scatterCorrection.equals("NONE") && seriesInfo2.manufacturer.toLowerCase().indexOf("philips") > -1) {
            System.out.println("PREVIEW PET");
            return false;
        }
        if (seriesInfo.modality.equals("PT") && seriesInfo.scatterCorrection.equals("NONE") && seriesInfo.manufacturer.toLowerCase().indexOf("philips") > -1) {
            System.out.println("PREVIEW PET");
            return false;
        }
        boolean bl3 = true;
        if (seriesInfo2.studyUID == null || !seriesInfo2.studyUID.equals(seriesInfo.studyUID)) {
            bl3 = false;
        } else {
            ay.e("Same Study UID");
        }
        if (!(!bl2 || SeriesIdentifier.quasiAllowed(seriesInfo2) && SeriesIdentifier.quasiAllowed(seriesInfo) && bl3)) {
            return false;
        }
        if (bl2 && Math.abs(Integer.valueOf(seriesInfo2.P()) - Integer.valueOf(seriesInfo.P())) < 20000 && ("NM".equals(seriesInfo.modality) || "NM".equals(seriesInfo2.modality))) {
            ay.e("Quasi FOR failed");
            return false;
        }
        if (SeriesIdentifier.areInSameModalityGroup(viewController.getModality().toUpperCase(), viewController2.getModality().toUpperCase())) {
            System.out.println("Functional modalities don't fuse with each other.And neither do anatomic ones.");
            ViewLinker.a(viewController, viewController2, false);
            return false;
        }
        return true;
    }

    private static boolean shouldFuseUltrasound3d(ViewController viewController, ViewController viewController2) {
        return viewController.getUncopiedMutableInfo().Z() && viewController2.getUncopiedMutableInfo().Z();
    }

    public static boolean areWarpLinkedInAWayThatPreventsFusion(Session session, ImageFrame imageFrame, ImageFrame imageFrame2) {
        PositionTransform positionTransform = session.q().a(imageFrame, imageFrame2);
        if (positionTransform == null) {
            return false;
        }
        if (positionTransform instanceof CompositeTransform) {
            CompositeTransform compositeTransform = (CompositeTransform)positionTransform;
            List<PositionTransform> list = compositeTransform.c();
            if (list.size() != 1) {
                return false;
            }
            positionTransform = list.get(0);
        }
        return positionTransform.g();
    }

    private boolean isWarpLinked() {
        return FusionCommand.areWarpLinkedInAWayThatPreventsFusion(this.p, this.a.aw(), this.b.aw());
    }

    private boolean shouldBailBecauseOfAtlas() {
        if (AtlasDBManager.e(this.a) || AtlasDBManager.e(this.b)) {
            ay.b((Object)"Prevented fusion command involving an atlas subject.", this);
            if (this.allowGui()) {
                AtlasDBManager.c(this.a);
            }
            return true;
        }
        return false;
    }

    private boolean shouldBailBecauseOfWarp() {
        if (this.isWarpLinked()) {
            if (this.allowGui()) {
                String string = m.getProperty("CANT_FUSE_DEFORMABLY_LINKED_VOLUMES");
                BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.b, string, new Notification.a(this.p));
                u.b().c(basicNotification);
            }
            return true;
        }
        return false;
    }

    public static enum AlignmentMode implements b,
    t
    {
        a("run_assisted_alignment"),
        b("run_assisted_alignment"),
        c("run_dicom_based_alignment"),
        d("run_contour_based_alignment"),
        e("run_box_based_alignment"),
        f("run_point_based_alignment"),
        g("");

        final String iconName;

        private AlignmentMode(String string2) {
            this.iconName = string2;
        }

        @Override
        public String getExternalizedString() {
            return WorkflowCommand.m.getProperty("FUSION_ALIGNMENT_MODE_" + this.name());
        }

        @Override
        public Icon getIcon(int n2) {
            if (cn.h(this.iconName)) {
                return null;
            }
            return ImageManipulator.c(this.iconName, n2);
        }

        @Override
        public String convertOldValue(String string) {
            if ("ASSISTED".equals(string)) {
                return "AUTOMATIC";
            }
            return string;
        }
    }

    public static class FusionLicensingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

