/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow;

import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.d;
import com.mimvista.exodus.MIM;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.c;
import com.mimvista.gui.util.u;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.ak;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.mui.overlays.PointContourOverlay;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.IECFixedPoint3f;
import com.mimvista.numerics.IECFixedVector;
import com.mimvista.numerics.IECOrientationPair;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.TypedMatrix;
import com.mimvista.patientpositioning.HarmonySessionStateManager;
import com.mimvista.patientpositioning.HarmonyState;
import com.mimvista.report.automated.ARTAssistSessionState;
import com.mimvista.report.cbct.FractionInfoKey;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.h;
import com.mimvista.report.cbct.config.l;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.workflow.backend.t;
import com.mimvista.workflow.gui.args.v;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

@e(e="isocenter_align", f="isocenter_align", b="isocenter_align_name", a="Commands", h="align_box", k=MIMFeatureCategory.MANIPULATION, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.CONTOURING_ADVANCED, LicenseOption.HARMONY, LicenseOption.ENAD_FULL})
public class IsocenterAlignCommand
extends WorkflowCommand {
    private ViewController a;
    private ViewController b;
    private InitAlignOption c;
    private IECOrientationPair d = null;

    public IsocenterAlignCommand(ViewController viewController, ViewController viewController2, InitAlignOption initAlignOption) {
        this.a = viewController;
        this.b = viewController2;
        this.c = initAlignOption;
    }

    public void setShift(IECOrientationPair iECOrientationPair) {
        this.d = iECOrientationPair;
    }

    @Override
    public ViewController execute() {
        Serializable serializable;
        Serializable serializable2;
        TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> typedMatrix = null;
        FractionInformation fractionInformation = this.getFractionInformation();
        if (fractionInformation != null && fractionInformation.getShiftMatrix() != null) {
            typedMatrix = fractionInformation.getShiftMatrix();
        }
        if (typedMatrix == null && (serializable2 = ((ARTAssistSessionState)(serializable = this.getSessionState())).getManualShift(this.b)) != null) {
            typedMatrix = IECOrientationPair.a((IECOrientationPair)serializable2);
        }
        if ((serializable = this.d) == null) {
            serializable = this.askForShiftValues(typedMatrix);
        }
        if (serializable != null) {
            typedMatrix = IECOrientationPair.a((IECOrientationPair)serializable);
            serializable2 = this.getSessionState();
            ((ARTAssistSessionState)serializable2).setManualShift(this.b, (IECOrientationPair)serializable);
        }
        if (typedMatrix == null) {
            this.showErrorMsg(Messages.a("Commands", "ISOCENTER_ALIGN_NO_MATCH"));
            return null;
        }
        serializable2 = HarmonySessionStateManager.getForSession(this.a.g()).getOrCreateState(this.a.aw(), this.b.aw());
        ((HarmonyState)serializable2).a(this.c, IsocenterAlignCommand.getIsocenterLocation(this.a), IsocenterAlignCommand.getIsocenterLocation(this.b), this::showErrorMsg);
        return HarmonyState.a((HarmonyState)serializable2, this.a, this.b, typedMatrix, this::showErrorMsg);
    }

    private ARTAssistSessionState getSessionState() {
        return this.a.g().a(ARTAssistSessionState.class);
    }

    @Override
    public com.mimvista.workflow.gui.args.a<WorkflowCommand>[] createArgumentViews(com.mimvista.workflow.gui.c<WorkflowCommand> c2) {
        com.mimvista.workflow.gui.args.a<WorkflowCommand>[] aArray = super.createArgumentViews(c2);
        aArray[2] = new v(c2, 2, (Enum[])InitAlignOption.values());
        return aArray;
    }

    private FractionInformation getFractionInformation() {
        try {
            SearchSource searchSource = this.b.bJ();
            if (!searchSource.s()) {
                return null;
            }
            String string = this.b.getUncopiedMutableInfo().ag();
            if (cn.h(string)) {
                ay.d((Object)"Fraction series UID is null/empty", this);
                return null;
            }
            h h2 = (h)((Object)searchSource);
            List<ArtAssistConfig> list = l.d(h2, string);
            Date date = ArtAssistConfig.a(this.b);
            for (ArtAssistConfig artAssistConfig : list) {
                FractionInformation fractionInformation = artAssistConfig.a(string, date, -1, -1);
                if (fractionInformation == null || fractionInformation.getShiftMatrix() == null) continue;
                return fractionInformation;
            }
            ay.d((Object)("Unable to find associated ART Assist Config with Fraction: " + string), this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ay.d((Object)illegalArgumentException, IsocenterAlignCommand.class);
        }
        return null;
    }

    @d
    public static DicomPoint3f getIsocenterLocation(ViewController viewController) {
        DicomPoint3f dicomPoint3f = null;
        PointContourOverlay pointContourOverlay = IsocenterAlignCommand.getIsocenter(viewController);
        if (pointContourOverlay != null) {
            dicomPoint3f = pointContourOverlay.a().get(0);
        }
        return dicomPoint3f;
    }

    public static PointContourOverlay getIsocenter(ViewController viewController) {
        PointContourOverlay pointContourOverlay = null;
        Object object = viewController.ba().a(OverlayishBase.InterpretedType.w, false, false).iterator();
        while (object.hasNext()) {
            Overlayish overlayish = object.next();
            if (!(overlayish instanceof PointContourOverlay) || ((PointContourOverlay)overlayish).a().size() <= 0) continue;
            pointContourOverlay = (PointContourOverlay)overlayish;
            break;
        }
        if (pointContourOverlay == null && (object = viewController.ba().b("Isocenter")) instanceof PointContourOverlay && ((PointContourOverlay)object).a().size() > 0) {
            pointContourOverlay = (PointContourOverlay)object;
        }
        return pointContourOverlay;
    }

    private void showErrorMsg(String string) {
        if (this.o == null) {
            ay.d((Object)string, this);
        } else {
            this.o.d(string);
        }
    }

    public static JFrame displayShiftInfoDialog() {
        if (MIM.isHeadless()) {
            return null;
        }
        JFrame jFrame = new JFrame();
        jFrame.setTitle(Messages.a("Commands", "ISOCENTER_ALIGN_SHIFT_INFO_TITLE"));
        jFrame.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        Image image = ImageManipulator.c("CBCT_Orientation.png");
        JLabel jLabel = new JLabel(new ImageIcon(image));
        jLabel.setMaximumSize(new Dimension(800, 542));
        jLabel.setMinimumSize(new Dimension(800, 542));
        jLabel.setPreferredSize(new Dimension(800, 542));
        jFrame.add((Component)jPanel, "Center");
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JButton jButton = com.mimvista.gui.util.c.c(actionEvent -> jFrame.setVisible(false), "");
        jPanel2.add((Component)jButton, "East");
        jFrame.add((Component)jPanel2, "South");
        jFrame.setMinimumSize(new Dimension(800, 600));
        return jFrame;
    }

    private IECOrientationPair askForShiftValues(TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> typedMatrix) {
        if (MIM.isHeadless()) {
            return null;
        }
        IECFixedVector iECFixedVector = new IECFixedVector();
        IECFixedVector iECFixedVector2 = new IECFixedVector();
        if (typedMatrix != null) {
            iECFixedVector = SimpleOrientationHelper.a(typedMatrix);
            iECFixedVector2 = SimpleOrientationHelper.b(typedMatrix);
        }
        InputNotification inputNotification = new InputNotification(new Notification.a(this.b), Messages.a("Report", "SHIFT_EDITOR_TITLE"), "align_box");
        inputNotification.addTitle(Messages.a("Report", "SHIFT_EDITOR_TITLE"));
        inputNotification.addLabel(Messages.a("Commands", "ISOCENTER_ALIGN_ENTER_SHIFT"));
        a a2 = (fractionInfoKey, f2) -> inputNotification.addFloatField(fractionInfoKey.b()).c(Float.valueOf(MathUtils.b(f2, 3)));
        u<Float> u2 = a2.addFloat(FractionInfoKey.f, iECFixedVector.b());
        u<Float> u3 = a2.addFloat(FractionInfoKey.g, iECFixedVector.c());
        u<Float> u4 = a2.addFloat(FractionInfoKey.h, iECFixedVector.a());
        u<Float> u5 = a2.addFloat(FractionInfoKey.i, iECFixedVector2.e());
        u<Float> u6 = a2.addFloat(FractionInfoKey.j, iECFixedVector2.d());
        u<Float> u7 = a2.addFloat(FractionInfoKey.k, iECFixedVector2.f());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Icon icon = ImageManipulator.c("align_box", 20);
        JButton jButton = new JButton(Messages.a("Commands", "ISOCENTER_ALIGN_SHOW_SHIFT_FORMAT"), icon);
        jButton.addActionListener(actionEvent -> {
            JFrame jFrame = IsocenterAlignCommand.displayShiftInfoDialog();
            jFrame.setLocationRelativeTo(ak.b().O());
            jFrame.setVisible(true);
        });
        jPanel.add((Component)jButton, "West");
        inputNotification.addComponent("", jPanel);
        inputNotification.addLabel(Messages.a("Commands", "ISOCENTER_ALIGN_ROTATION_ORDER"));
        inputNotification.addToGrandNotifier();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        inputNotification.setDismissActionListener(actionEvent -> countDownLatch.countDown());
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (u2.a() && u3.a() && u4.a() && u5.a() && u6.a() && u7.a()) {
            IECFixedVector iECFixedVector3 = new IECFixedVector();
            iECFixedVector3.c(((Float)u3.b()).floatValue());
            iECFixedVector3.b(((Float)u2.b()).floatValue());
            iECFixedVector3.a(((Float)u4.b()).floatValue());
            IECFixedVector iECFixedVector4 = new IECFixedVector();
            iECFixedVector4.d(((Float)u6.b()).floatValue());
            iECFixedVector4.f(((Float)u7.b()).floatValue());
            iECFixedVector4.e(((Float)u5.b()).floatValue());
            return new IECOrientationPair(iECFixedVector3, iECFixedVector4);
        }
        return null;
    }

    public static enum InitAlignOption implements t
    {
        a,
        b,
        c,
        d,
        e;


        @Override
        public Icon getIcon(int n2) {
            return null;
        }

        @Override
        public String getExternalizedString() {
            return Messages.a("Commands", "ISOCENTER_ALIGN_" + this.name());
        }
    }

    @FunctionalInterface
    static interface a {
        public u<Float> addFloat(FractionInfoKey var1, float var2);
    }
}

