/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow;

import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.remote.SeriesQuery;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.FusionCommand;
import com.mimvista.commands.workflow.WorkflowLoadCommand;
import com.mimvista.commands.workflow.e;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.internals.DicomDeformableRegistration;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.m;
import com.mimvista.internals.s;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4f;
import org.dcm4che2.data.DicomObject;

@com.mimvista.commands.e(e="load_reg", f="load_reg_wf_command", b="load_reg_name", a="Commands", h="folder", k=MIMFeatureCategory.REGISTRATION, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.BASE, LicenseOption.ENAD_BASE})
public class LoadRegWorkflowCommand
extends WorkflowLoadCommand {
    private final ViewController d;
    private final ViewController e;

    public LoadRegWorkflowCommand(ViewController viewController, ViewController viewController2, String string, int n2) {
        this.d = viewController;
        this.e = viewController2;
        this.c = string;
        this.a = n2;
        this.b = Modality.REG.get();
    }

    @Override
    public ViewController execute() {
        DcmSeries dcmSeries = this.findDcmSeries(this.d);
        if (dcmSeries == null) {
            this.error(Messages.a("Commands", "LOAD_REG_ERROR"));
            return null;
        }
        DicomObject dicomObject = dcmSeries.getDataProvider().getFirstDicomObj(2145386512);
        String string = null;
        if (dicomObject != null) {
            string = dicomObject.getString(524310);
        }
        ViewController viewController = null;
        if ("1.2.840.10008.5.1.4.1.1.66.3".equals(string)) {
            long l2;
            DicomDeformableRegistration dicomDeformableRegistration = new DicomDeformableRegistration(this.p, dcmSeries.getDataProvider());
            if (dicomDeformableRegistration.a() && (l2 = dicomDeformableRegistration.b()) >= 0L) {
                viewController = this.p.b(l2);
            }
        } else {
            m m2 = new m(this.p, dcmSeries.getDataProvider());
            m.b b2 = m2.d();
            if (b2 instanceof m.a && (viewController = this.createFusion((m.a)b2)) != null && m2.g()) {
                m2.h();
            }
        }
        if (viewController == null) {
            this.error(Messages.a("Commands", "LOAD_REG_ERROR"));
            return null;
        }
        return viewController;
    }

    @Override
    public List<DcmSeries> findAllMatchingDcmSeries(ViewController viewController, String string, String string2) {
        List<DcmSeries> list = this.getByMatchingIds();
        List<Object> list2 = Lists.newArrayList();
        if (cn.g(string)) {
            list2 = list;
        } else {
            String string3 = com.mimvista.commands.workflow.e.a(string);
            Matcher matcher = Pattern.compile(string3, 66).matcher("");
            for (DcmSeries dcmSeries3 : list) {
                matcher.reset(cn.i(dcmSeries3.getSeriesDescription()));
                if (!matcher.matches()) continue;
                list2.add(dcmSeries3);
            }
        }
        return list2.stream().sorted((dcmSeries, dcmSeries2) -> {
            if (cn.a(dcmSeries.getFrameOfReferenceUID(), dcmSeries2.getFrameOfReferenceUID(), false)) {
                return 0;
            }
            if (cn.a(dcmSeries.getFrameOfReferenceUID(), viewController.getUncopiedMutableInfo().frameOfRefUID, false)) {
                return -1;
            }
            if (cn.a(dcmSeries2.getFrameOfReferenceUID(), viewController.getUncopiedMutableInfo().frameOfRefUID, false)) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    private List<DcmSeries> getByMatchingIds() {
        SeriesParameters seriesParameters = new SeriesParameters();
        seriesParameters.searchType = 2;
        seriesParameters.contentDate = "";
        seriesParameters.name = "";
        seriesParameters.uidList = Lists.newArrayList((Object[])new String[]{this.d.aP().ag(), this.e.aP().ag()});
        seriesParameters.modality = this.b;
        SeriesQuery seriesQuery = new SeriesQuery(seriesParameters);
        seriesQuery.setSearchSource(this.d.bG());
        return seriesQuery.search();
    }

    private s createFusion(m.a a2) {
        FusionCommand fusionCommand = new FusionCommand(this.d, this.e, FusionCommand.AlignmentMode.a, null);
        fusionCommand.setSession(this.p);
        fusionCommand.setWorkflow(this.n);
        fusionCommand.setWorkflowEngine(this.o);
        Matrix4f matrix4f = a2.a;
        if (this.shouldReverseReg(a2)) {
            matrix4f = new Matrix4f(matrix4f);
            matrix4f.invert();
        }
        return fusionCommand.execute(matrix4f);
    }

    private boolean shouldReverseReg(m.a a2) {
        ViewController viewController = this.p.b(a2.b);
        ViewController viewController2 = this.p.b(a2.c);
        return viewController.aT() == this.e.aT() && viewController2.aT() == this.d.aT();
    }
}

