/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow;

import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.o;
import com.mimvista.archive.remote.SeriesQuery;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.WorkflowLoadCommand;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.read.LoadTaskRtStruct;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.util.progress.d;
import com.mimvista.viewer.SeriesInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

@e(e="load_rtst", f="load_rtstruct_workflow_command", b="load_rtst_name", a="Commands", h="folder_RTstruct", k=MIMFeatureCategory.CONTOURING, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.BASE, LicenseOption.ULTRASOUND_3D, LicenseOption.ENAD_BASE})
public class LoadRtStructWorkflowCommand
extends WorkflowLoadCommand {
    private ViewController d;

    public LoadRtStructWorkflowCommand(ViewController viewController, String string, int n2) {
        this.d = viewController;
        this.c = string;
        this.a = n2;
        this.b = Modality.RTST.get();
    }

    @Override
    public List<AbstractContourOverlayish> execute() {
        DcmSeries dcmSeries;
        try {
            dcmSeries = this.findDcmSeries(this.d);
        }
        catch (NullPointerException nullPointerException) {
            return new ArrayList<AbstractContourOverlayish>();
        }
        List<AbstractContourOverlayish> list = this.d.ba().R();
        if (dcmSeries == null) {
            return new ArrayList<AbstractContourOverlayish>();
        }
        LoadTaskRtStruct loadTaskRtStruct = new LoadTaskRtStruct(this.p, dcmSeries.getDataProvider(), new d(), new o());
        loadTaskRtStruct.setOverridePromptAndAppend(true);
        loadTaskRtStruct.loadRTst();
        List<AbstractContourOverlayish> list2 = this.d.ba().R();
        list2.removeAll(list);
        return list2;
    }

    @Override
    public List<DcmSeries> findAllMatchingDcmSeries(ViewController viewController, String string, String string2) {
        ArrayList arrayList = Lists.newArrayList();
        SeriesQuery seriesQuery = this.buildQuery(viewController, string2);
        List<DcmSeries> list = seriesQuery.search();
        if (list != null && !list.isEmpty()) {
            for (DcmSeries dcmSeries : list) {
                if (string != null && !string.isEmpty() && !"*".equals(string) && !(dcmSeries.getSeriesDescription() == null ? "" : dcmSeries.getSeriesDescription()).contains(string)) continue;
                arrayList.add(dcmSeries);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (this.a > arrayList.size()) {
            this.o.d(m.getProperty("LOAD_RTST_ERROR"));
            return null;
        }
        Collections.sort(arrayList, DcmSeries.SERIES_INSTANCE_DATE_TIME_COMPARE);
        return arrayList;
    }

    public SeriesQuery buildQuery(ViewController viewController, String string) {
        SeriesInfo seriesInfo = viewController.getUncopiedMutableInfo();
        SeriesParameters seriesParameters = new SeriesParameters();
        if (Modality.RTST.get().equals(string)) {
            seriesParameters.searchType = 1;
        }
        seriesParameters.modality = string;
        seriesParameters.studyDate = seriesInfo.N();
        seriesParameters.contentDate = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime());
        seriesParameters.name = seriesInfo.patientNameRaw;
        seriesParameters.uidList = new ArrayList<String>(1);
        seriesParameters.uidList.add(seriesInfo.ag());
        SeriesQuery seriesQuery = new SeriesQuery(seriesParameters);
        seriesQuery.setSearchSource(viewController.bJ());
        return seriesQuery;
    }
}

