/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.contour.ContourOverlayCommand;
import com.mimvista.commands.e;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.Propagate4DCTROICommand;
import com.mimvista.commands.workflow.PropagateCardiacROICommand;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.commands.workflow.d;
import com.mimvista.internals.ContourEdits;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.ViewController3D;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.ChrontourOverlay;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.workflow.backend.t;
import com.mimvista.workflow.gui.args.a;
import com.mimvista.workflow.gui.c;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;

@e(e="propagate_contours", f="propagate_contours", b="propagate_contours_name", a="Commands", h="contour_to_frames", k=MIMFeatureCategory.CONTOURING, l={MIMFeatureType.Workflow}, i={i.class}, j={LicenseOption.CONTOURING_ADVANCED, LicenseOption.SURE_PLAN}, n={SessionPredicate.NonNull})
public class PropagateContoursCommand
extends WorkflowCommand {
    private List<AbstractContourOverlayish> a;
    private PropagationType b;
    private Integer c;
    private Integer d;
    private PropagationDeformOptions e = PropagationDeformOptions.a;
    private List<Integer> f = null;

    public PropagateContoursCommand(List<AbstractContourOverlayish> list, PropagationType propagationType, Integer n2, Integer n3, PropagationDeformOptions propagationDeformOptions) {
        this.a = list;
        this.b = propagationType;
        this.c = n2;
        this.d = n3;
        this.e = propagationDeformOptions;
    }

    @Override
    public List<AbstractContourOverlayish> execute() {
        return this.propagate();
    }

    public void setFrameOverride(@com.mimvista.d List<Integer> list) {
        this.f = list == null ? null : Lists.newArrayList(list);
    }

    private List<AbstractContourOverlayish> propagate() {
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter(this.a, ChrontourOverlay.class));
        switch (this.b) {
            case a: {
                return this.propagateAll(arrayList);
            }
            case b: {
                return this.propagateToEnd(arrayList, this.c);
            }
            case c: {
                return this.propagateRange(arrayList, this.c, this.d);
            }
        }
        return new ArrayList<AbstractContourOverlayish>();
    }

    private List<AbstractContourOverlayish> propagateAll(List<ChrontourOverlay> list) {
        return this.propagateRange(list, -1, -1);
    }

    private List<AbstractContourOverlayish> propagateToEnd(List<ChrontourOverlay> list, Integer n2) {
        return this.propagateRange(list, n2, -1);
    }

    private List<AbstractContourOverlayish> propagateRange(List<ChrontourOverlay> list, Integer n2, Integer n3) {
        List<Integer> list2;
        ArrayList<AbstractContourOverlayish> arrayList = new ArrayList<AbstractContourOverlayish>();
        if (list.size() == 0) {
            return arrayList;
        }
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = list.get(0).bR_().n();
        }
        if (n2 < 0 || n2 > list.get(0).bR_().n()) {
            this.throwError(MIMFormat.a(Messages.a("Commands").getProperty("PROPAGATE_CONTOURS_ERROR_START_FRAME"), n2));
            return arrayList;
        }
        if (n3 < 0 || n3 > list.get(0).bR_().n()) {
            this.throwError(MIMFormat.a(Messages.a("Commands").getProperty("PROPAGATE_CONTOURS_ERROR_END_FRAME"), n3));
            return arrayList;
        }
        if (this.f != null) {
            list2 = this.f;
        } else {
            list2 = new ArrayList<Integer>();
            int n4 = list.get(0).bR_().n();
            for (int i2 = n2.intValue(); i2 <= n3; ++i2) {
                if (i2 < 0 || i2 >= n4) continue;
                list2.add(i2);
            }
        }
        ViewController3D viewController3D = list.get(0).bQ_();
        if (PropagationDeformOptions.a == this.e) {
            arrayList.addAll(this.performCopy(list2));
            return arrayList;
        }
        d d2 = null;
        if (viewController3D.e() && viewController3D.bM()) {
            d2 = new PropagateCardiacROICommand(this.getWorkflowEngine(), this.q, viewController3D, list2, true);
        } else if (viewController3D.bL()) {
            d2 = new Propagate4DCTROICommand(this.getWorkflowEngine(), this.q, viewController3D, list2, true);
        }
        if (d2 == null) {
            return arrayList;
        }
        d2.setOverwrite(true);
        ArrayList arrayList2 = Lists.newArrayList(list);
        ContourOverlayCommand.a a2 = new ContourOverlayCommand.a();
        d2.setContours(arrayList2.stream().map(chrontourOverlay -> (ChrontourOverlay)a2.b((AbstractContourOverlayish)chrontourOverlay)).collect(Collectors.toList()));
        d2.setSequential(PropagationDeformOptions.c == this.e);
        Object object = d2.checkAndExecute();
        if (object instanceof Collection) {
            for (Object e2 : (Collection)object) {
                if (!(e2 instanceof AbstractContourOverlayish)) continue;
                arrayList.add((AbstractContourOverlayish)e2);
            }
        }
        return arrayList;
    }

    private void throwError(String string) {
        if (this.getWorkflowEngine() != null) {
            this.getWorkflowEngine().d(string);
        } else {
            u.b().c(new BasicNotification(BasicNotification.NotificationType.a, string, new Notification.a()));
        }
    }

    private List<AbstractContourOverlayish> performCopy(List<Integer> list) {
        ArrayList<AbstractContourOverlayish> arrayList = new ArrayList<AbstractContourOverlayish>();
        for (AbstractContourOverlayish abstractContourOverlayish : this.a) {
            if (!(abstractContourOverlayish instanceof ChrontourOverlay)) continue;
            ChrontourOverlay chrontourOverlay = (ChrontourOverlay)new ContourOverlayCommand.a().b(abstractContourOverlayish);
            int n2 = chrontourOverlay.bQ_().cl();
            Object object = new Object();
            List<ContourSlice> list2 = chrontourOverlay.a((Integer)n2).c();
            for (Integer n3 : list) {
                ChrontourOverlay chrontourOverlay2 = chrontourOverlay.e(n3);
                List<ContourSlice> list3 = chrontourOverlay2.aq().c();
                ContourEdits.ContourEdit contourEdit = new ContourEdits.ContourEdit(list3, list2, chrontourOverlay2, Messages.a("Contour").getProperty("CONT_COLL_PANEL_UNDOCOPY"));
                contourEdit.a(object);
                contourEdit.a();
                chrontourOverlay.aD().r().a(contourEdit);
            }
            arrayList.add(chrontourOverlay);
        }
        return arrayList;
    }

    @Override
    public a<WorkflowCommand>[] createArgumentViews(c<WorkflowCommand> c2) {
        a<WorkflowCommand>[] aArray = super.createArgumentViews(c2);
        aArray[1].a((Object)PropagationType.a, aArray[2], aArray[3]);
        aArray[1].a((Object)PropagationType.b, aArray[3]);
        aArray[1].b(PropagationType.b, aArray[2]);
        aArray[1].b(PropagationType.c, aArray[2], aArray[3]);
        return aArray;
    }

    public static enum PropagationDeformOptions implements t
    {
        a("CONT_COLL_PANEL_DOCOPY"),
        b("CONT_COLL_PANEL_SELECTED"),
        c("CONT_COLL_PANEL_PROP_SEQUENTIAL");

        private String propKey;

        private PropagationDeformOptions(String string2) {
            this.propKey = string2;
        }

        @Override
        public String getExternalizedString() {
            return Messages.a("Contour").getProperty(this.propKey);
        }

        @Override
        public Icon getIcon(int n2) {
            return null;
        }
    }

    public static enum PropagationType implements t
    {
        a("FourD", "PROPAGATE_WF_COMMAND_ARG_ALL_FRAMES"),
        b("FourD", "PROPAGATE_WF_COMMAND_ARG_SELECTED_TO_LAST"),
        c("FourD", "PROPAGATE_WF_COMMAND_ARG_SELECTED_RANGE");

        private String key;
        private String propFile;

        private PropagationType(String string2, String string3) {
            this.propFile = string2;
            this.key = string3;
        }

        @Override
        public String getExternalizedString() {
            return Messages.a(this.propFile).getProperty(this.key);
        }

        @Override
        public Icon getIcon(int n2) {
            return null;
        }
    }
}

