/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow;

import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.gui.SameAsSourceDestination;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.g;
import com.mimvista.atlas.management.AtlasDBManager;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.i;
import com.mimvista.commands.keyboard.bi;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.dicom.SeriesEqualityHasher;
import com.mimvista.dicom.gui.DicomRtStructSaveInputFactory;
import com.mimvista.dicom.write.DcmWriterFactory;
import com.mimvista.dicom.write.rtst.DicomRtStructCreator;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.FractionUpdate;
import com.mimvista.report.cbct.config.h;
import com.mimvista.report.cbct.config.l;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.viewer.SeriesInfo;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;

@e(e="save_rtstruct", f="save_rtstruct_wf_command", b="save_rtstruct_name", a="Commands", h="save_RTstruct", k=MIMFeatureCategory.CONTOURING, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.BASE, LicenseOption.ULTRASOUND_3D, LicenseOption.ENAD_BASE})
public class SaveRTStructWorkflowCommand
extends WorkflowCommand {
    private ViewController a;
    private SendToDestination b;
    private String c;
    private CountDownLatch d = null;

    public SaveRTStructWorkflowCommand(ViewController viewController, SendToDestination sendToDestination, String string) {
        this.a = viewController;
        if (sendToDestination instanceof SameAsSourceDestination) {
            this.b = ag.a(this.a.bJ());
            if (this.b == null) {
                this.b = ag.f();
            }
        } else {
            this.b = sendToDestination;
        }
        this.c = string;
    }

    @Override
    public Object execute() {
        if (this.a.g().T()) {
            if (this.b == null) {
                this.o.d(Messages.a("Workflow", "NO_PRIMARY_PL_SAVE"));
                return null;
            }
            this.executeHeadlessly();
        } else {
            this.executeWithGUI();
        }
        return null;
    }

    private void executeHeadlessly() {
        if (!(this.a instanceof ViewController3D)) {
            ay.c((Object)"Must be a 3D volume", this);
            return;
        }
        if (AtlasDBManager.d(this.a)) {
            ay.c((Object)"Not saving atlas contours.", this);
            return;
        }
        DicomRtStructCreator dicomRtStructCreator = DicomRtStructSaveInputFactory.get((ViewController3D)this.a, null, this.c, this.c, DcmWriterFactory.getPNString(DicomRtStructCreator.getLastOperatorName()), false);
        ProgressPanel progressPanel = new ProgressPanel();
        progressPanel.c(actionEvent -> {
            switch (progressPanel.n()) {
                case d: {
                    this.o.d(Messages.a("Dicom", "DICOM_SAVE_FAIL"));
                }
                case f: {
                    this.o.e("");
                }
            }
        });
        dicomRtStructCreator.writeTo(this.b, (Progress)progressPanel);
        this.saveArtAssistInfo(new UniqueSeriesPointer(dicomRtStructCreator.getSeriesInstanceUID(), SeriesEqualityHasher.hashSopUidStrings(Arrays.asList(dicomRtStructCreator.getSopInstanceUID())).toString()));
    }

    private void saveArtAssistInfo(UniqueSeriesPointer uniqueSeriesPointer) {
        if (!MIMContext.r()) {
            return;
        }
        SearchSource searchSource = g.a(this.b);
        if (searchSource == null || !searchSource.s()) {
            ay.d((Object)"Unable to save ART Assist RTstruct info, source does not support ART Assist", this);
            return;
        }
        h h2 = (h)((Object)searchSource);
        SeriesInfo seriesInfo = this.a.aP();
        if (seriesInfo == null) {
            ay.d((Object)"Unable to save ART Assist RTstruct info, volume info not found", this);
            return;
        }
        ArtAssistConfig artAssistConfig = l.d(h2, seriesInfo.ag()).stream().findFirst().orElse(null);
        if (artAssistConfig == null) {
            ay.d((Object)("Unable to save ART Assist RTstruct info, configuration not found: " + seriesInfo.ag()), this);
            return;
        }
        FractionInformation fractionInformation = artAssistConfig.a(seriesInfo.ag(), seriesInfo.e());
        if (fractionInformation == null) {
            ay.d((Object)("Unable to save ART Assist RTstruct info, fraction information not found: " + artAssistConfig.J() + " " + seriesInfo.ag()), this);
            return;
        }
        List<UniqueSeriesPointer> list = fractionInformation.getRelatedSeries();
        list.add(uniqueSeriesPointer);
        FractionUpdate fractionUpdate = new FractionUpdate(artAssistConfig, fractionInformation);
        fractionUpdate.a(list);
        h2.a(fractionUpdate);
    }

    private void executeWithGUI() {
        this.d = new CountDownLatch(1);
        bi bi2 = new bi();
        bi2.a(this.a, this.b, this.c, uniqueSeriesPointer -> {
            if (uniqueSeriesPointer != null) {
                this.saveArtAssistInfo((UniqueSeriesPointer)uniqueSeriesPointer);
            } else {
                this.d.countDown();
            }
        });
        try {
            this.d.await();
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)"Unexpected exception", (Throwable)interruptedException, this);
        }
    }
}

