/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow.dose;

import com.google.common.base.Predicate;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.exodus.MIM;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.intensitybasedwarp.IntensityWarpSettings;
import com.mimvista.intensitybasedwarp.v;
import com.mimvista.intensitybasedwarp.w;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.linking.AffineTransform;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.internals.o;
import com.mimvista.internals.q;
import com.mimvista.internals.s;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.Session;
import com.mimvista.mui.ak;
import com.mimvista.mui.ao;
import com.mimvista.mui.bm;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.Overlay;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.numerics.IsodoseOverlayAccumulator;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.ay;
import com.mimvista.util.progress.CompositeProgressPanel;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.g;
import com.mimvista.util.work.m;
import com.mimvista.viewer.ColorTableFactory;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.algo.BestContrastor;
import com.mimvista.workflow.backend.f;
import com.mimvista.workflow.gui.args.b;
import com.mimvista.workflow.gui.c;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

@e(e="4ddoseaccumulation", f="4ddoseaccumulation", b="4ddoseaccumulation_name", a="Commands", h="subtract_add", k=MIMFeatureCategory.DOSE, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.CONTOURING_ADVANCED, LicenseOption.SURE_PLAN})
public class Dose4DAccmulationCommand
extends WorkflowCommand {
    protected ViewController a;
    protected boolean b = true;
    protected boolean c;
    protected boolean d;
    private boolean e;
    private IntensityWarpSettings f = null;

    public Dose4DAccmulationCommand(ViewController viewController, boolean bl2, boolean bl3) {
        this.a = viewController;
        this.e = bl2;
        this.c = bl3;
    }

    public boolean isBlocking() {
        return this.b;
    }

    public void setBlocking(boolean bl2) {
        this.b = bl2;
    }

    public void setWarpSettingsOverride(IntensityWarpSettings intensityWarpSettings) {
        this.f = intensityWarpSettings;
    }

    @Override
    public com.mimvista.workflow.gui.args.a<WorkflowCommand>[] createArgumentViews(c<WorkflowCommand> c2) {
        com.mimvista.workflow.gui.args.a<WorkflowCommand>[] aArray = super.createArgumentViews(c2);
        aArray[1] = new b<WorkflowCommand>(c2, 1, false){

            @Override
            protected String h_() {
                return WorkflowCommand.m.getProperty("4DDOSEACCUMULATION_SEQUENTIAL");
            }

            @Override
            protected String i_() {
                return WorkflowCommand.m.getProperty("4DDOSEACCUMULATION_NORMAL");
            }
        };
        aArray[2] = new b<WorkflowCommand>(c2, 2, true){

            @Override
            protected String h_() {
                return WorkflowCommand.m.getProperty("4DDOSEACCUMULATION_USE_ONE_FOR_ALL");
            }

            @Override
            protected String i_() {
                return WorkflowCommand.m.getProperty("4DDOSEACCUMULATION_SET_FRACTIONS_MANUALLY");
            }
        };
        return aArray;
    }

    @Override
    public IsodoseOverlay execute() {
        this.d = this.a.g().T();
        if (!this.c && this.d) {
            ay.d((Object)"Cannot get dose fractions from user in a headless session. Construct this command with useOneForAllFractions = true.", this);
            String string = m.getProperty("4DDOSEACCUMULATION_ASSISTANT_ERROR");
            if (this.o != null) {
                this.o.d(string);
            }
            return null;
        }
        if (!this.a.bl()) {
            ay.d((Object)"Attempted to perform 4D dose accumulation with non-4D data!", this);
            return null;
        }
        Map<ImageFrame, Map<IsodoseOverlay, Float>> map = new LinkedHashMap<ImageFrame, Map<IsodoseOverlay, Float>>();
        for (ImageFrame imageFrame : ((ViewController3D)this.a).cE()) {
            List<IsodoseOverlay> list = imageFrame.n().K();
            if (list == null || list.size() <= 0) continue;
            LinkedHashMap<IsodoseOverlay, Float> linkedHashMap = new LinkedHashMap<IsodoseOverlay, Float>();
            for (IsodoseOverlay isodoseOverlay : list) {
                linkedHashMap.put(isodoseOverlay, Float.valueOf(1.0f));
            }
            map.put(imageFrame, linkedHashMap);
        }
        if (map.size() == 0) {
            ay.d((Object)"No Dose objects were loaded, so no dose accumulation was performed.", this);
            if (!this.d) {
                Dose4DAccmulationCommand.msgNotification(this.a, m.b("DOSEACCUMULATION_NO_DOSE"));
            }
            return null;
        }
        if (!this.c) {
            map = this.getDoseFactors(map);
        }
        if (map.size() == 0) {
            ay.d((Object)"All dose fractions were set to zero, so no dose accumulation was performed", this);
            return null;
        }
        return this.performAccumulation(map, true);
    }

    protected WarpTransform getWarpTransform(ViewController3D viewController3D, ViewController3D viewController3D2, Progress progress) {
        s s2 = new s(viewController3D, viewController3D2);
        s2.a(MatrixMultiplier.b());
        AffineTransform affineTransform = viewController3D.aG().d(viewController3D.cw(), viewController3D2.cw());
        progress.a(false);
        progress.b(0);
        v v2 = new w(affineTransform, viewController3D.cw(), viewController3D2.cw()).a(this.f != null ? this.f : IntensityWarpSettings.getSettingsForStandardDeformable()).a();
        v2.a(progress);
        WarpTransform warpTransform = v2.a();
        if (progress.n() == Progress.Status.e) {
            return null;
        }
        WarpTransform warpTransform2 = new WarpTransform(viewController3D.cw(), viewController3D2.cw(), affineTransform.d());
        warpTransform2.a(warpTransform.B());
        warpTransform2.a(warpTransform.y());
        return warpTransform2;
    }

    protected ViewController3D getTempVC(Session session, ViewController3D viewController3D, int n2) {
        ViewController3D viewController3D2 = com.mimvista.util.w.a(session, viewController3D, n2, false);
        viewController3D2.a(ColorTableFactory.a("B-W Linear"));
        return viewController3D2;
    }

    private IsodoseOverlay performAccumulation(final Map<ImageFrame, Map<IsodoseOverlay, Float>> map, boolean bl2) {
        IsodoseOverlay isodoseOverlay;
        block5: {
            final o o2 = ((ViewController3D)this.a).cE();
            final ImageFrame imageFrame = this.a.aw();
            ((ImageVolumeShort)imageFrame).a(BestContrastor.SubtractionStrategy.d);
            final ArrayList<g> arrayList = new ArrayList<g>();
            int n2 = 0;
            n2 = this.e ? o2.n() - 1 : map.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(new ProgressPanel());
            }
            final CompositeProgressPanel compositeProgressPanel = new CompositeProgressPanel(arrayList);
            compositeProgressPanel.c(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    switch (compositeProgressPanel.n()) {
                        case a: {
                            break;
                        }
                        case b: {
                            Dose4DAccmulationCommand.this.q.a();
                            break;
                        }
                        case c: {
                            Dose4DAccmulationCommand.this.q.b();
                            break;
                        }
                        case d: {
                            Dose4DAccmulationCommand.this.q.k();
                            break;
                        }
                        case e: {
                            Dose4DAccmulationCommand.this.q.j();
                            break;
                        }
                        case f: {
                            Dose4DAccmulationCommand.this.q.l();
                            break;
                        }
                        case g: {
                            Dose4DAccmulationCommand.this.q.m();
                            break;
                        }
                    }
                }
            });
            compositeProgressPanel.d(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Dose4DAccmulationCommand.this.q.b(compositeProgressPanel.ah_());
                }
            });
            compositeProgressPanel.a(m.getProperty("DEFORM_DOSE"));
            compositeProgressPanel.a();
            ProgressQueueNotification.a(compositeProgressPanel);
            Future<IsodoseOverlay> future = com.mimvista.util.work.m.e.submit(new Callable<IsodoseOverlay>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IsodoseOverlay a() {
                    try {
                        if (Dose4DAccmulationCommand.this.e) {
                            IsodoseOverlay isodoseOverlay = Dose4DAccmulationCommand.this.sequentialDoseDeformAndAccumulate(map, imageFrame, compositeProgressPanel, arrayList, o2);
                            return isodoseOverlay;
                        }
                        IsodoseOverlay isodoseOverlay = Dose4DAccmulationCommand.this.normalDoseDeformAndAccumulate(map, imageFrame, compositeProgressPanel, arrayList, o2);
                        return isodoseOverlay;
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"Error deforming doses", throwable, Dose4DAccmulationCommand.class);
                        String string = WorkflowCommand.m.b("4DDOSEACCUMULATION_ERROR");
                        if (Dose4DAccmulationCommand.this.o != null) {
                            Dose4DAccmulationCommand.this.o.d(string);
                        } else if (!Dose4DAccmulationCommand.this.d) {
                            if (throwable instanceof OutOfMemoryError) {
                                MIM.showOutOfMemoryDialog();
                            } else {
                                Dose4DAccmulationCommand.msgNotification(Dose4DAccmulationCommand.this.a, string);
                            }
                        }
                        IsodoseOverlay isodoseOverlay = null;
                        return isodoseOverlay;
                    }
                    finally {
                        compositeProgressPanel.b();
                    }
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
            isodoseOverlay = null;
            if (this.b) {
                try {
                    isodoseOverlay = future.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    ay.d((Object)"Dose Deformation did not execute properly", (Throwable)exception, this);
                    String string = m.b("4DDOSEACCUMULATION_ERROR");
                    if (this.o != null) {
                        this.o.d(string);
                    }
                    if (this.d) break block5;
                    Dose4DAccmulationCommand.msgNotification(this.a, string);
                }
            }
        }
        bm.b().Q();
        return isodoseOverlay;
    }

    private IsodoseOverlay normalDoseDeformAndAccumulate(Map<ImageFrame, Map<IsodoseOverlay, Float>> map, ImageFrame imageFrame, CompositeProgressPanel compositeProgressPanel, List<g> list, o o2) {
        Session session = bm.a(this.a.g());
        ViewController3D viewController3D = this.getTempVC(session, (ViewController3D)this.a, this.a.cl());
        ArrayList<IsodoseOverlay> arrayList = new ArrayList<IsodoseOverlay>();
        ArrayList<Float> arrayList2 = new ArrayList<Float>();
        int n2 = -1;
        for (ImageFrame object2 : map.keySet()) {
            f f22;
            ++n2;
            ImageVolumeShort imageVolumeShort = (ImageVolumeShort)object2;
            imageVolumeShort.a(BestContrastor.SubtractionStrategy.d);
            Map<IsodoseOverlay, Float> map2 = map.get(object2);
            if (imageVolumeShort.equals(imageFrame)) {
                for (f f22 : map2.keySet()) {
                    arrayList.add(new IsodoseOverlay((ViewController)viewController3D, f22.C(), false));
                    arrayList2.add(map2.get(f22));
                }
                compositeProgressPanel.b(list.get(n2));
                continue;
            }
            String string = MIMFormat.a(m.getProperty("DEFORM_DOSE_FROM"), String.valueOf(o2.b((SimpleImageFrame)imageVolumeShort) + 1));
            compositeProgressPanel.b_(string);
            f22 = this.getTempVC(session, (ViewController3D)this.a, this.a.au().b(imageVolumeShort));
            WarpTransform warpTransform = this.getWarpTransform(viewController3D, (ViewController3D)f22, compositeProgressPanel.c(list.get(n2)));
            if (warpTransform == null) {
                ay.d((Object)"getWarpTransform returned a null pointer. The user might have cancelled the operation.", this);
                return null;
            }
            for (IsodoseOverlay isodoseOverlay : map2.keySet()) {
                IsodoseOverlay isodoseOverlay2 = warpTransform.M().a(new IsodoseOverlay((ViewController)f22, isodoseOverlay.C(), false), new Predicate(){

                    public boolean apply(Object object) {
                        return false;
                    }
                }, (Progress)com.mimvista.util.progress.o.o());
                arrayList.add(isodoseOverlay2);
                arrayList2.add(map2.get(isodoseOverlay));
            }
        }
        ArrayList arrayList3 = new ArrayList();
        for (IsodoseOverlay isodoseOverlay : arrayList) {
            arrayList3.add(new IsodoseOverlayAccumulator.a(isodoseOverlay, ((Float)arrayList2.get(arrayList.indexOf(isodoseOverlay))).floatValue(), 1.0f));
        }
        ProgressPanel progressPanel = new ProgressPanel();
        compositeProgressPanel.a(progressPanel);
        IsodoseOverlay isodoseOverlay = IsodoseOverlayAccumulator.a(this.a, arrayList3, (Progress)progressPanel, IsodoseOverlayAccumulator.RxDoseMode.a, null, true);
        session.V();
        return isodoseOverlay;
    }

    private IsodoseOverlay sequentialDoseDeformAndAccumulate(Map<ImageFrame, Map<IsodoseOverlay, Float>> map, ImageFrame imageFrame, CompositeProgressPanel compositeProgressPanel, List<g> list, o o2) {
        IsodoseOverlay isodoseOverlay;
        int n2 = imageFrame.am_();
        if (n2 == o2.n() - 1) {
            isodoseOverlay = this.sequentialDoseDeformAndAccumulateHelper(map, imageFrame, compositeProgressPanel, list, o2, 0, n2, true);
        } else if (n2 == 0) {
            isodoseOverlay = this.sequentialDoseDeformAndAccumulateHelper(map, imageFrame, compositeProgressPanel, list, o2, o2.n() - 1, 0, true);
        } else {
            ArrayList<IsodoseOverlayAccumulator.a> arrayList = new ArrayList<IsodoseOverlayAccumulator.a>();
            IsodoseOverlay isodoseOverlay2 = this.sequentialDoseDeformAndAccumulateHelper(map, imageFrame, compositeProgressPanel, list, o2, 0, n2, true);
            if (isodoseOverlay2 == null) {
                ay.d((Object)"Accumulation of doses before the current frame returned a null pointer. The user might have canceled the operation.", this);
                return null;
            }
            arrayList.add(new IsodoseOverlayAccumulator.a(isodoseOverlay2, 1.0f, 1.0f));
            IsodoseOverlay isodoseOverlay3 = this.sequentialDoseDeformAndAccumulateHelper(map, imageFrame, compositeProgressPanel, list, o2, o2.n() - 1, n2, false);
            if (isodoseOverlay3 == null) {
                ay.d((Object)"Accumulation of doses after the current frame returned a null pointer. The user might have canceled the operation.", this);
                return null;
            }
            arrayList.add(new IsodoseOverlayAccumulator.a(isodoseOverlay3, 1.0f, 1.0f));
            isodoseOverlay = IsodoseOverlayAccumulator.a(this.a, arrayList, this.q, IsodoseOverlayAccumulator.RxDoseMode.a, null, false);
            isodoseOverlay2.a(false);
            this.a.aG().c(isodoseOverlay2.C());
            isodoseOverlay3.a(false);
            this.a.aG().c(isodoseOverlay3.C());
        }
        if (isodoseOverlay != null) {
            this.a.aw().n().a((Overlayish)isodoseOverlay, true);
        } else {
            ay.d((Object)"4D Dose accumulation returned a null pointer.", this);
        }
        return isodoseOverlay;
    }

    private IsodoseOverlay sequentialDoseDeformAndAccumulateHelper(Map<ImageFrame, Map<IsodoseOverlay, Float>> map, ImageFrame imageFrame, CompositeProgressPanel compositeProgressPanel, List<g> list, o o2, int n2, int n3, boolean bl2) {
        Session session = bm.a(this.a.g());
        ViewController3D viewController3D = this.getTempVC(session, (ViewController3D)this.a, n2);
        IsodoseOverlay isodoseOverlay = null;
        boolean bl3 = n2 < n3;
        int n4 = bl3 ? 1 : -1;
        int n5 = bl3 ? 0 : list.size() - 1;
        int n6 = n2;
        while (n4 * (n6 - n3) <= 0) {
            IsodoseOverlay isodoseOverlay2;
            Object object;
            ImageFrame imageFrame2 = (ImageFrame)o2.c(n6);
            Map<IsodoseOverlay, Float> map2 = map.get(imageFrame2);
            ArrayList<IsodoseOverlayAccumulator.a> arrayList = new ArrayList<IsodoseOverlayAccumulator.a>();
            if (n6 != n2) {
                object = MIMFormat.a(m.getProperty("DEFORM_DOSE_FROM"), n6 - n4 + 1);
                compositeProgressPanel.b_((String)object);
            }
            if (map2 != null && (n6 != n3 || bl2)) {
                for (IsodoseOverlay isodoseOverlay3 : map2.keySet()) {
                    isodoseOverlay2 = new IsodoseOverlay((ViewController)viewController3D, isodoseOverlay3.C(), false);
                    float f2 = map2.get(isodoseOverlay3).floatValue();
                    arrayList.add(new IsodoseOverlayAccumulator.a(isodoseOverlay2, f2, 1.0f));
                }
            }
            if (isodoseOverlay != null) {
                object = this.getTempVC(session, (ViewController3D)this.a, n6);
                WarpTransform warpTransform = this.getWarpTransform((ViewController3D)object, viewController3D, compositeProgressPanel.c(list.get(n5)));
                n5 += n4;
                if (warpTransform == null) {
                    ay.d((Object)"getWarpTransform returned a null pointer. The user might have cancelled the operation.", this);
                    return null;
                }
                isodoseOverlay2 = warpTransform.M().a(new IsodoseOverlay((ViewController)viewController3D, isodoseOverlay.C(), false), new Predicate(){

                    public boolean apply(Object object) {
                        return false;
                    }
                }, (Progress)com.mimvista.util.progress.o.o());
                arrayList.add(new IsodoseOverlayAccumulator.a(isodoseOverlay2, 1.0f, 1.0f));
                viewController3D = this.getTempVC(session, (ViewController3D)object, ((ViewController)object).cl());
            }
            if (!arrayList.isEmpty()) {
                object = isodoseOverlay;
                isodoseOverlay = IsodoseOverlayAccumulator.a(this.a, arrayList, (Progress)new ProgressPanel(), IsodoseOverlayAccumulator.RxDoseMode.a, null, false);
                if (object != null) {
                    ((Overlay)object).a(false);
                    this.a.aG().c(((IsodoseOverlay)object).C());
                }
            }
            n6 += n4;
        }
        session.V();
        return isodoseOverlay;
    }

    protected static void msgNotification(ViewController viewController, String string) {
        BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.b, string, new Notification.a(viewController));
        basicNotification.setPriority(1001);
        u.b().c(basicNotification);
    }

    private Map<ImageFrame, Map<IsodoseOverlay, Float>> getDoseFactors(Map<ImageFrame, Map<IsodoseOverlay, Float>> map) {
        a a2 = new a(ak.b().O(), this.a, map);
        a2.a();
        return a2.b();
    }

    class a {
        static final int a = 400;
        InputNotification b;
        FuncUtils.f c;
        ViewController d;
        boolean e;
        JTextField[] f;
        JTextField[] g;
        JCheckBox[] h;
        JCheckBox i;
        JCheckBox j;
        Map<ImageFrame, Map<IsodoseOverlay, Float>> k;

        a(Window window, ViewController viewController, Map<ImageFrame, Map<IsodoseOverlay, Float>> map) {
            this.d = viewController;
            this.k = map;
            this.c();
        }

        public void a() {
            this.e = true;
            this.c = new FuncUtils.f();
            u.b().c(this.b);
            this.c.a();
        }

        Map<ImageFrame, Map<IsodoseOverlay, Float>> b() {
            return this.k;
        }

        private void c() {
            int n2;
            Serializable serializable;
            Object object;
            this.b = new InputNotification(new Notification.a(this.d), WorkflowCommand.m.getProperty("DOSEACCUMULATION_NAME"), "subtract_add");
            this.b.setShowReset(false);
            this.b.addTitle(WorkflowCommand.m.getProperty("DOSEACCUMULATION_NAME"));
            int n3 = 0;
            for (ImageFrame imageFrame : this.k.keySet()) {
                object = this.k.get(imageFrame);
                n3 += object.size();
            }
            this.f = new JTextField[n3];
            this.g = new JTextField[n3];
            this.h = new JCheckBox[n3];
            Box box = new Box(1);
            int n4 = 0;
            object = ((ViewController3D)this.d).cE();
            for (int i2 = 0; i2 < ((q)object).n(); ++i2) {
                serializable = (ImageFrame)((q)object).c(i2);
                Map<IsodoseOverlay, Float> map = this.k.get(serializable);
                if (map == null) continue;
                SeriesInfo seriesInfo = serializable.getUncopiedMutableInfo();
                n2 = seriesInfo.isMultiSeries4d ? seriesInfo.frameNumFromSeriesDesc.a() : ((q)object).b((ImageVolumeShort)serializable) + 1;
                int n5 = seriesInfo.isMultiSeries4d ? seriesInfo.maxFramesFromSeriesDesc : ((q)object).n();
                String string = "F" + n2 + "/" + n5;
                if (seriesInfo.frameDesc != null && !seriesInfo.frameDesc.isEmpty()) {
                    string = string + " (" + seriesInfo.frameDesc + ")";
                }
                for (IsodoseOverlay isodoseOverlay : map.keySet()) {
                    String string2 = isodoseOverlay.getName() + " - " + string;
                    this.h[n4] = new JCheckBox("<html>" + string2 + "</html>");
                    this.h[n4].setSelected(true);
                    Box box2 = new Box(0);
                    box2.add(this.h[n4]);
                    box2.add(Box.createHorizontalGlue());
                    box.add(box2);
                    box.add(Box.createVerticalStrut(3));
                    Box box3 = new Box(0);
                    box3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
                    box3.add(new JLabel(WorkflowCommand.m.b("DOSEACCUMULATION_FACTOR")));
                    box3.add(Box.createRigidArea(new Dimension(10, 0)));
                    this.f[n4] = new JTextField("1.0", 10);
                    box3.add(this.f[n4]);
                    box3.add(new JLabel("   /   "));
                    this.g[n4] = new JTextField("1.0", 10);
                    box3.add(this.g[n4]);
                    box3.add(Box.createRigidArea(new Dimension(10, 0)));
                    box3.add(Box.createHorizontalGlue());
                    box.add(box3);
                    box.add(Box.createVerticalStrut(8));
                    final int n6 = n4;
                    this.h[n4].addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (actionEvent.getSource() instanceof JCheckBox) {
                                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                                a.this.f[n6].setEnabled(jCheckBox.isSelected());
                                a.this.g[n6].setEnabled(jCheckBox.isSelected());
                            }
                        }
                    });
                    this.f[n4].addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyTyped(KeyEvent keyEvent) {
                            Thread thread = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Thread.sleep(50L);
                                        if (a.this.i.isSelected()) {
                                            String string = a.this.f[n6].getText();
                                            for (int i2 = 0; i2 < a.this.f.length; ++i2) {
                                                if (i2 == n6) continue;
                                                a.this.f[i2].setText(string);
                                            }
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interruptedException.printStackTrace();
                                    }
                                }
                            });
                            thread.start();
                        }
                    });
                    this.g[n4].addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyTyped(KeyEvent keyEvent) {
                            Thread thread = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Thread.sleep(50L);
                                        if (a.this.i.isSelected()) {
                                            String string = a.this.g[n6].getText();
                                            for (int i2 = 0; i2 < a.this.g.length; ++i2) {
                                                if (i2 == n6) continue;
                                                a.this.g[i2].setText(string);
                                            }
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interruptedException.printStackTrace();
                                    }
                                }
                            });
                            thread.start();
                        }
                    });
                    ++n4;
                }
            }
            Box box4 = new Box(0);
            this.i = new JCheckBox(WorkflowCommand.m.b("4DDOSEACCUMULATION_CHANGE_ALL_FRACTIONS"));
            this.i.setSelected(true);
            box4.add(this.i);
            box4.add(Box.createHorizontalGlue());
            serializable = new Box(0);
            this.j = new JCheckBox(WorkflowCommand.m.b("4DDOSEACCUMULATION_USE_SEQUENTIAL_DEFORMATION"));
            this.j.setSelected(Dose4DAccmulationCommand.this.e);
            ((Container)serializable).add(this.j);
            ((Container)serializable).add(Box.createHorizontalGlue());
            int n7 = u.b().f();
            int n8 = u.b().g();
            n2 = MIMSwingUtils.b(box, n8);
            box.setPreferredSize(new Dimension(n8, n2));
            JScrollPane jScrollPane = new JScrollPane(box);
            jScrollPane.setBorder(null);
            jScrollPane.setMinimumSize(new Dimension(n7, Math.min(n2, 400)));
            jScrollPane.setPreferredSize(new Dimension(n7, Math.min(n2, 400)));
            this.b.addComponent("", jScrollPane);
            this.b.addComponent("", box4);
            this.b.addComponent("", (Component)serializable);
            this.b.setOkActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (a.this.d()) {
                        a.this.e = false;
                        u.b().d(a.this.b);
                    }
                }
            });
            this.b.setCancelActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    a.this.e = false;
                    a.this.k.clear();
                    u.b().d(a.this.b);
                }
            });
            this.b.setDismissActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    a.this.c.b();
                }
            });
        }

        private boolean d() {
            try {
                o o2 = ((ViewController3D)this.d).cE();
                int n2 = 0;
                for (int i2 = 0; i2 < o2.n(); ++i2) {
                    ImageFrame imageFrame = (ImageFrame)o2.c(i2);
                    Map<IsodoseOverlay, Float> map = this.k.get(imageFrame);
                    if (map == null) continue;
                    for (IsodoseOverlay isodoseOverlay : map.keySet()) {
                        if (this.h[n2].isSelected()) {
                            float f2 = Float.parseFloat(this.g[n2].getText());
                            if (f2 == 0.0f) {
                                JOptionPane.showMessageDialog(ao.Q().O(), WorkflowCommand.m.b("DOSEACCUMULATION_INPUT_ZERO"), WorkflowCommand.m.b("DOSEACCUMULATION_INPUT_INVALID_TITLE"), 0);
                                return false;
                            }
                            float f3 = Float.parseFloat(this.f[n2].getText()) / f2;
                            map.put(isodoseOverlay, Float.valueOf(f3));
                        } else {
                            map.put(isodoseOverlay, Float.valueOf(0.0f));
                        }
                        ++n2;
                    }
                }
                ArrayList<ImageFrame> arrayList = new ArrayList<ImageFrame>();
                for (ImageFrame imageFrame : this.k.keySet()) {
                    Map<IsodoseOverlay, Float> map = this.k.get(imageFrame);
                    ArrayList<IsodoseOverlay> arrayList2 = new ArrayList<IsodoseOverlay>();
                    for (IsodoseOverlay isodoseOverlay : map.keySet()) {
                        if (((Float)map.get(isodoseOverlay)).floatValue() != 0.0f) continue;
                        arrayList2.add(isodoseOverlay);
                    }
                    for (IsodoseOverlay isodoseOverlay : arrayList2) {
                        map.remove(isodoseOverlay);
                    }
                    if (map.size() != 0) continue;
                    arrayList.add(imageFrame);
                }
                for (ImageFrame imageFrame : arrayList) {
                    this.k.remove(imageFrame);
                }
                Dose4DAccmulationCommand.this.e = this.j.isSelected();
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(ao.Q().O(), WorkflowCommand.m.b("DOSEACCUMULATION_INPUT_INVALID"), WorkflowCommand.m.b("DOSEACCUMULATION_INPUT_INVALID_TITLE"), 0);
                return false;
            }
        }
    }
}

