/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow.dose;

import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.Units;
import com.mimvista.dose.constraints.ComparisonType;
import com.mimvista.dose.constraints.DVConstraint;
import com.mimvista.dose.constraints.DVConstraintState;
import com.mimvista.dose.constraints.DoseConstraint;
import com.mimvista.dose.constraints.DoseContourConstraintType;
import com.mimvista.dose.constraints.MinMeanMaxConstraint;
import com.mimvista.dose.constraints.MinMeanMaxConstraintState;
import com.mimvista.dose.constraints.units.DoseUnit;
import com.mimvista.dose.constraints.units.VolumeUnit;
import com.mimvista.internals.ad;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.util.Messages;
import com.mimvista.workflow.gui.args.a;
import com.mimvista.workflow.gui.c;
import java.util.List;

@e(e="dose_constraint", f="dose_constraint", b="dose_constraint_name", a="Commands", h="set_dose_constraints", k=MIMFeatureCategory.DOSE, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.CONTOURING_CORE_WITHOUT_BRACHYCORE, LicenseOption.HARMONY, LicenseOption.BRACHYTHERAPY, LicenseOption.ENAD_BASE, LicenseOption.SURE_PLAN})
public class DoseConstraintValueCommand
extends WorkflowCommand {
    private static final int a = 2;
    private static final int b = 3;
    private static final int c = 4;
    private static final int d = 5;
    private static final int e = 6;
    private final IsodoseOverlay f;
    private final List<AbstractContourOverlayish> g;
    private final DoseContourConstraintType h;
    private final DoseUnit i;
    private final VolumeUnit j;
    private final MinMeanMaxConstraint.MinMeanMax k;
    private final Float l;

    public DoseConstraintValueCommand(IsodoseOverlay isodoseOverlay, List<AbstractContourOverlayish> list, DoseContourConstraintType doseContourConstraintType, MinMeanMaxConstraint.MinMeanMax minMeanMax, Float f2, DoseUnit doseUnit, VolumeUnit volumeUnit) {
        this.f = isodoseOverlay;
        this.g = list;
        this.h = doseContourConstraintType;
        this.i = doseUnit;
        this.j = volumeUnit;
        this.k = minMeanMax;
        this.l = f2;
    }

    @Override
    public Float execute() {
        if (this.checkPreconditions()) {
            DoseVolumeHistogram doseVolumeHistogram = this.f.h().c((VolumetricContourOverlayish)this.g.get(0));
            DoseConstraint.DoseContourConstraint doseContourConstraint = this.getConstraint();
            Double d2 = doseContourConstraint.getValue((ad)this.f, doseVolumeHistogram);
            if (d2 != null) {
                return Float.valueOf(d2.floatValue());
            }
            this.error(Messages.a("Commands", "DOSE_CONSTRAINT_NO_VALUE"));
        }
        return null;
    }

    private boolean checkPreconditions() {
        String string = null;
        if (this.f == null) {
            string = Messages.a("Commands", "DOSE_CONSTRAINT_NULL_DOSE");
        }
        if (this.g == null || this.g.isEmpty()) {
            string = Messages.a("Commands", "DOSE_CONSTRAINT_NULL_CONTOUR");
        }
        if (this.g.size() > 1) {
            string = Messages.a("Commands", "DOSE_CONSTRAINT_MULTIPLE_CONTOURS");
        }
        if (!(this.g.get(0) instanceof VolumetricContourOverlayish)) {
            string = Messages.a("Commands", "DOSE_CONSTRAINT_WRONG_TYPE");
        }
        if (string != null) {
            this.error(string);
            return false;
        }
        return true;
    }

    private DoseConstraint.DoseContourConstraint getConstraint() {
        if (this.h == DoseContourConstraintType.c) {
            MinMeanMaxConstraintState minMeanMaxConstraintState = new MinMeanMaxConstraintState(this.k, ComparisonType.c, this.l == null ? Float.NaN : this.l.floatValue(), this.getReturnedDoseUnit() == null ? DoseUnit.a : this.getReturnedDoseUnit());
            return new MinMeanMaxConstraint(minMeanMaxConstraintState);
        }
        DVConstraintState dVConstraintState = new DVConstraintState(DVConstraint.DVType.a(this.h), this.l.floatValue(), this.getReturnedVolumeUnits(), ComparisonType.c, this.l.floatValue(), this.getReturnedDoseUnit());
        return new DVConstraint(dVConstraintState);
    }

    private VolumeUnit getReturnedVolumeUnits() {
        if (this.h == DoseContourConstraintType.b) {
            return VolumeUnit.a;
        }
        return this.j;
    }

    private DoseUnit getReturnedDoseUnit() {
        if (this.h == DoseContourConstraintType.a || this.h == DoseContourConstraintType.c) {
            if (DoseValue.doseUnit == Units.Gy) {
                return DoseUnit.a;
            }
            return DoseUnit.b;
        }
        return this.i;
    }

    @Override
    public a<WorkflowCommand>[] createArgumentViews(c<WorkflowCommand> c2) {
        a<WorkflowCommand>[] aArray = super.createArgumentViews(c2);
        aArray[2].b(DoseContourConstraintType.a, aArray[4], aArray[6]);
        aArray[2].a((Object)DoseContourConstraintType.a, aArray[3], aArray[5]);
        aArray[2].b(DoseContourConstraintType.b, aArray[4], aArray[5]);
        aArray[2].a((Object)DoseContourConstraintType.b, aArray[3], aArray[6]);
        aArray[2].b(DoseContourConstraintType.c, aArray[3]);
        aArray[2].a((Object)DoseContourConstraintType.c, aArray[4], aArray[6], aArray[5]);
        return aArray;
    }
}

