/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow.dose;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.commands.workflow.dose.DvhCaptureParam;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHDisplay;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DoseNormType;
import com.mimvista.dicom.rtdose.gui.DvhAnnotationType;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.internals.DynamicVolumeRef3D;
import com.mimvista.mui.captures.Capture;
import com.mimvista.mui.captures.CaptureStorage;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.report.gui.content.common.filter.DvhDisplayInfoFilter;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.workflow.gui.args.a;
import com.mimvista.workflow.gui.args.b;
import com.mimvista.workflow.gui.args.c;
import java.util.ArrayList;
import java.util.List;

@e(e="capture_dvh", f="capture_dvh", b="capture_dvh_name", a="Commands", h="dvh", k=MIMFeatureCategory.DOSE, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.MAESTRO_OR_SYMPHONY, LicenseOption.ENAD_BASE, LicenseOption.SURE_PLAN})
public class DvhCaptureCommand
extends WorkflowCommand {
    final List<DvhCaptureParam> a;
    final boolean b;
    final DoseNormType c;
    final float d;

    public DvhCaptureCommand(List<DvhCaptureParam> list, boolean bl2, DoseNormType doseNormType, float f2) {
        this.a = list;
        this.b = bl2;
        this.c = doseNormType;
        this.d = f2;
    }

    @Override
    public Capture execute() {
        ArrayList arrayList = Lists.newArrayList();
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Multimap<IsodoseOverlay, DvhCaptureParam> multimap = this.groupByDose(this.a);
        this.q.a(multimap.size());
        this.q.a();
        for (IsodoseOverlay isodoseOverlay : multimap.keySet()) {
            DVHCollection dVHCollection = new DVHCollection(DynamicVolumeRef3D.a(isodoseOverlay.t()), isodoseOverlay.C(), isodoseOverlay.J(), 0);
            arrayList.add(dVHCollection);
            Multimap<VolumetricContourOverlayish, DvhCaptureParam> multimap2 = this.groupByContour(multimap.get((Object)isodoseOverlay));
            for (VolumetricContourOverlayish volumetricContourOverlayish : multimap2.keySet()) {
                DoseVolumeHistogram doseVolumeHistogram = isodoseOverlay.h().c(volumetricContourOverlayish);
                DvhDisplayInfo dvhDisplayInfo = new DvhDisplayInfo(doseVolumeHistogram);
                dVHCollection.add(dvhDisplayInfo);
                arrayListMultimap.putAll((Object)dvhDisplayInfo, (Iterable)multimap2.get((Object)volumetricContourOverlayish));
            }
            this.q.N_();
        }
        DVHDisplay dVHDisplay = this.createDvhDisplay(arrayList, (Multimap<DvhDisplayInfo, DvhCaptureParam>)arrayListMultimap);
        this.q.b();
        return this.makeCapture(dVHDisplay);
    }

    private Capture makeCapture(DVHDisplay dVHDisplay) {
        Capture capture = dVHDisplay.makeCapture();
        if (this.allowGui()) {
            CaptureStorage.a(this.p, capture);
        }
        return capture;
    }

    private Multimap<IsodoseOverlay, DvhCaptureParam> groupByDose(List<DvhCaptureParam> list) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (DvhCaptureParam dvhCaptureParam : list) {
            arrayListMultimap.put((Object)dvhCaptureParam.dose, (Object)dvhCaptureParam);
        }
        return arrayListMultimap;
    }

    private Multimap<VolumetricContourOverlayish, DvhCaptureParam> groupByContour(Iterable<DvhCaptureParam> iterable) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (DvhCaptureParam dvhCaptureParam : iterable) {
            if (dvhCaptureParam.contours != null && !dvhCaptureParam.contours.isEmpty()) {
                for (AbstractContourOverlayish abstractContourOverlayish : dvhCaptureParam.contours) {
                    if (abstractContourOverlayish == null || !abstractContourOverlayish.w()) continue;
                    arrayListMultimap.put((Object)abstractContourOverlayish.G(), (Object)dvhCaptureParam);
                }
                continue;
            }
            ay.c((Object)("One of DVH parameters did not have any contours for it's input : " + this.a.indexOf(dvhCaptureParam)), this);
        }
        return arrayListMultimap;
    }

    private DVHDisplay createDvhDisplay(List<DVHCollection> list, Multimap<DvhDisplayInfo, DvhCaptureParam> multimap) {
        DVHDisplayParams dVHDisplayParams = this.createDisplayParams(list);
        DVHDisplay dVHDisplay = new DVHDisplay(dVHDisplayParams);
        dVHDisplay.getChartPanel().setSize(600, 600);
        this.prepareDvhsForDisplay(multimap, dVHDisplay);
        return dVHDisplay;
    }

    private DVHDisplayParams createDisplayParams(List<DVHCollection> list) {
        Cloneable cloneable;
        DVHDisplayParams dVHDisplayParams = new DVHDisplayParams();
        dVHDisplayParams.setReportMode(true);
        dVHDisplayParams.setNormalizedVolume(this.b);
        dVHDisplayParams.setDoseNormType(this.c);
        dVHDisplayParams.setUseDoseCap(true);
        if (this.d != -1.0f) {
            cloneable = new DoseValue();
            ((DoseValue)cloneable).setValueInGy(this.d);
            dVHDisplayParams.setDoseCap((DoseValue)cloneable);
        }
        dVHDisplayParams.setRxDose(this.a.get((int)0).dose.getRxDose());
        cloneable = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DVHCollection dVHCollection : list) {
            cloneable.addAll(dVHCollection.getDvhDisplayInfo());
            for (DvhDisplayInfo dvhDisplayInfo : dVHCollection.getDvhDisplayInfo()) {
                arrayList.add(dvhDisplayInfo.toString());
            }
        }
        DvhDisplayInfoFilter dvhDisplayInfoFilter = dVHDisplayParams.getDDIFilter();
        dvhDisplayInfoFilter.a(cloneable, true);
        dvhDisplayInfoFilter.a(dvhDisplayInfoFilter.a((List<String>)arrayList));
        dVHDisplayParams.addDVHCollection(list);
        return dVHDisplayParams;
    }

    private void prepareDvhsForDisplay(Multimap<DvhDisplayInfo, DvhCaptureParam> multimap, DVHDisplay dVHDisplay) {
        for (DvhDisplayInfo dvhDisplayInfo : multimap.keySet()) {
            for (DvhCaptureParam dvhCaptureParam : multimap.get((Object)dvhDisplayInfo)) {
                this.applyCaptureParameter(dvhDisplayInfo, dvhCaptureParam, dVHDisplay.getChartPanel());
            }
        }
        dVHDisplay.updateColors();
        dVHDisplay.updateStrokes();
    }

    private void applyCaptureParameter(DvhDisplayInfo dvhDisplayInfo, DvhCaptureParam dvhCaptureParam, DVHChartPanel dVHChartPanel) {
        if (dvhCaptureParam.annotationType == DvhAnnotationType.NONE) {
            if (dvhCaptureParam.color != null && dvhCaptureParam.color.color != null) {
                dvhDisplayInfo.setColor(dvhCaptureParam.color.color, true);
            }
            dvhDisplayInfo.setLineStyle(dvhCaptureParam.lineStyle);
        } else {
            try {
                dVHChartPanel.addAnnotation(dvhDisplayInfo, dvhCaptureParam.annotationValue.floatValue(), dvhCaptureParam.annotationType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ay.d((Object)("Error adding annotation: " + dvhCaptureParam.annotationValue + " " + dvhCaptureParam.annotationType), this);
            }
        }
    }

    @Override
    public a<WorkflowCommand>[] createArgumentViews(com.mimvista.workflow.gui.c<WorkflowCommand> c2) {
        a[] aArray = super.createArgumentViews(c2);
        c c3 = (c)DvhCaptureCommand.getArg(aArray, 0);
        c3.a(com.mimvista.workflow.gui.args.c.b("CAPTURE_DVH_SINGLE_LINE", "CAPTURE_DVH_MULTI_LINE"));
        aArray[1] = new b<WorkflowCommand>(c2, 1){

            @Override
            protected String h_() {
                return Messages.a("Commands", "CAPTURE_DVH_NORM_VOL");
            }

            @Override
            protected String i_() {
                return Messages.a("Commands", "CAPTURE_DVH_DONT_NORM_VOL");
            }
        };
        return aArray;
    }
}

