/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow.dose;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureInfo;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.f;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.d;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.l;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.dose.IsodoseSetting;
import com.mimvista.internals.dose.IsodoseSettingContext;
import com.mimvista.internals.dose.IsodoseSettingData;
import com.mimvista.mui.Session;
import com.mimvista.mui.ak;
import com.mimvista.mui.overlays.DoseSidePanel;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.workflow.backend.s;
import com.mimvista.workflow.backend.t;
import com.mimvista.workflow.gui.args.a;
import com.mimvista.workflow.gui.args.m;
import com.mimvista.workflow.gui.args.w;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import javax.swing.Icon;

@e(e="ISODOSE_SETTING", f="ISODOSE_SETTING", b="ISODOSE_SETTING_COMMAND", a="Commands", h="isodose_color", k=MIMFeatureCategory.DOSE, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.MAESTRO_OR_SYMPHONY, LicenseOption.HARMONY, LicenseOption.ENAD_BASE, LicenseOption.SURE_PLAN})
public class IsodoseSettingCommand
extends WorkflowCommand {
    private final String a;
    private DoseRenderOption[] b;

    public IsodoseSettingCommand(@d String string, DoseRenderOption[] doseRenderOptionArray) {
        this.a = cn.i(string);
        this.b = doseRenderOptionArray;
    }

    @Override
    public Object execute() {
        Serializable serializable;
        IsodoseSettingData isodoseSettingData = IsodoseSettingCommand.getSelectedSettingData(this.o, this.p, this.a);
        if (isodoseSettingData == null) {
            ay.d((Object)"Could not find the selected isodose settings", this);
            return null;
        }
        boolean bl2 = this.isOptionSelected(DoseRenderOption.a);
        boolean bl3 = this.isOptionSelected(DoseRenderOption.b);
        boolean bl4 = this.isOptionSelected(DoseRenderOption.c);
        Object object = this.getAllDoseVolumesInSession().iterator();
        while (object.hasNext()) {
            serializable = object.next();
            IsodoseSetting isodoseSetting = new IsodoseSetting(isodoseSettingData, (IsodoseOverlay)serializable);
            isodoseSetting.e(bl2);
            isodoseSetting.c(bl3);
            isodoseSetting.d(bl4);
            ((IsodoseOverlay)serializable).a(isodoseSetting);
            ((IsodoseOverlay)serializable).x();
            ((IsodoseOverlay)serializable).w();
        }
        this.p.Q();
        if (!this.p.T() && (object = ak.c()) != null && (serializable = ((ak)object).k()) != null) {
            ((DoseSidePanel)serializable).a(isodoseSettingData, bl2, bl4, bl3);
        }
        return null;
    }

    @Override
    public a<WorkflowCommand>[] createArgumentViews(com.mimvista.workflow.gui.c<WorkflowCommand> c2) {
        a<WorkflowCommand>[] aArray = super.createArgumentViews(c2);
        aArray[0] = IsodoseSettingCommand.createArgumentViewForIsodoseSetting(c2, 0, IsodoseSettingCommand.getIsodoseSettings());
        aArray[1] = new m(c2, 1, (Enum[])DoseRenderOption.values(), (Enum[])new DoseRenderOption[]{DoseRenderOption.b});
        return aArray;
    }

    private Collection<IsodoseOverlay> getAllDoseVolumesInSession() {
        HashSet hashSet = Sets.newHashSet();
        for (ImageFrame imageFrame : this.p.ap()) {
            if (imageFrame == null || imageFrame.n() == null) continue;
            hashSet.addAll(imageFrame.n().L());
        }
        return hashSet;
    }

    private boolean isOptionSelected(DoseRenderOption doseRenderOption) {
        for (DoseRenderOption doseRenderOption2 : this.b) {
            if (doseRenderOption2 != doseRenderOption) continue;
            return true;
        }
        return false;
    }

    public static IsodoseSettingData getSelectedSettingData(s s2, Session session, String string) {
        com.mimvista.internals.dose.a a2 = IsodoseSettingCommand.getIsodoseSettings();
        IsodoseSettingData isodoseSettingData = a2.a(string);
        if (isodoseSettingData == null) {
            isodoseSettingData = !session.T() ? a2.a(IsodoseSettingCommand.getUserInput(session, a2)) : a2.a(IsodoseSettingContext.a);
        }
        if (isodoseSettingData == null) {
            String string2 = Messages.a("Commands", "ISODOSE_SETTING_INPUT_ERR");
            ay.d((Object)string2, IsodoseSettingCommand.class);
            s2.d(string2);
        }
        return isodoseSettingData;
    }

    private static String getUserInput(Session session, com.mimvista.internals.dose.a a2) {
        ArrayList arrayList = Lists.newArrayList();
        for (IsodoseSettingData object2 : a2.a()) {
            arrayList.add(object2.name);
        }
        MIMFeatureInfo mIMFeatureInfo = f.b(IsodoseSettingCommand.class);
        InputNotification inputNotification = new InputNotification(new Notification.a(session), mIMFeatureInfo.c(), mIMFeatureInfo.t());
        inputNotification.addTextAreaAsLabel(Messages.a("Commands", "ISODOSE_SETTING_INPUT_MSG"));
        final l<String> l2 = inputNotification.addComboBox("", arrayList.toArray(new String[0]));
        inputNotification.setShowReset(false);
        inputNotification.setIsDismissable(false);
        final String[] stringArray = new String[]{null};
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        inputNotification.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                stringArray[0] = (String)l2.b();
                countDownLatch.countDown();
            }
        });
        inputNotification.setCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                countDownLatch.countDown();
            }
        });
        inputNotification.addToGrandNotifier();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return stringArray[0];
    }

    public static a<WorkflowCommand> createArgumentViewForIsodoseSetting(com.mimvista.workflow.gui.c<WorkflowCommand> c2, int n2, com.mimvista.internals.dose.a a2) {
        ArrayList arrayList = Lists.newArrayList();
        for (IsodoseSettingData isodoseSettingData : a2.a()) {
            Pair<String, String> pair = Pair.get(isodoseSettingData.name, isodoseSettingData.name);
            arrayList.add(pair);
        }
        return new w<WorkflowCommand>(c2, n2, arrayList, null);
    }

    public static com.mimvista.internals.dose.a getIsodoseSettings() {
        File file = c.d().a(CascadeSubfolder.a, "isodose.xml");
        com.mimvista.internals.dose.a a2 = null;
        a2 = IsodoseSettingData.a(file);
        a2.c();
        return a2;
    }

    public static enum DoseRenderOption implements t
    {
        a(Messages.a("Dose").b("SETTING_DIALOG_SHOW_COLORLBL")),
        b(Messages.a("Dose").b("DOSE_PANEL_ISODOSE")),
        c(Messages.a("Dose").b("DOSE_PANEL_COLORWASH"));

        private final String name;

        private DoseRenderOption(String string2) {
            this.name = string2;
        }

        @Override
        public String getExternalizedString() {
            return this.name;
        }

        @Override
        public Icon getIcon(int n2) {
            return null;
        }
    }
}

