/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow.dose;

import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.f;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.d;
import com.mimvista.exodus.MIM;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.u;
import com.mimvista.internals.ViewController;
import com.mimvista.report.automated.ARTAssistSessionState;
import com.mimvista.report.automated.service.TreatmentInfoFinder;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.CountDownLatch;

@e(e="treatment_info", f="treatment_info", b="treatment_info_name", a="Commands", h="calendar", k=MIMFeatureCategory.DOSE, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.CONTOURING_ADVANCED, LicenseOption.ENAD_FULL, LicenseOption.SURE_PLAN})
public class TreatmentInfoCommand
extends WorkflowCommand {
    private ViewController a;
    private final TreatmentInfoFinder.TreatmentInfoType b;

    public TreatmentInfoCommand(ViewController viewController, TreatmentInfoFinder.TreatmentInfoType treatmentInfoType) {
        this.a = viewController;
        this.b = treatmentInfoType;
    }

    @Override
    public Float execute() {
        TreatmentInfoFinder treatmentInfoFinder = new TreatmentInfoFinder(this.a);
        Number number = treatmentInfoFinder.c(this.b);
        if (this.isValueInvalid(treatmentInfoFinder, number)) {
            number = this.askForTreatmentValue();
            if (this.isUserValueInvalid(number)) {
                number = null;
            } else {
                ARTAssistSessionState aRTAssistSessionState = this.getSessionState();
                aRTAssistSessionState.setManualTreatmentInfo(this.a, this.b, number);
            }
        }
        if (number == null) {
            this.error(Messages.a("Commands", "TREATMENT_INFO_ERR"));
            return null;
        }
        return Float.valueOf(number.floatValue());
    }

    private ARTAssistSessionState getSessionState() {
        return this.a.g().a(ARTAssistSessionState.class);
    }

    private boolean isUserValueInvalid(Number number) {
        return this.isValueInvalid(null, number);
    }

    private boolean isValueInvalid(@d TreatmentInfoFinder treatmentInfoFinder, Number number) {
        if (number == null || number.doubleValue() < 0.0) {
            ay.d((Object)("Treatment value could not be found or is negative: " + this.b.name() + "=" + String.valueOf(number)), this);
            return true;
        }
        if (this.b == TreatmentInfoFinder.TreatmentInfoType.g || this.b == TreatmentInfoFinder.TreatmentInfoType.h) {
            if (number.intValue() < 0) {
                ay.d((Object)("Fractions delivered last plan must be non-negative: " + this.b.name() + "=" + String.valueOf(number)), this);
                return true;
            }
            return false;
        }
        if (this.b == TreatmentInfoFinder.TreatmentInfoType.e) {
            if (number.intValue() < 1) {
                ay.d((Object)("Total fractions must be greater than zero: " + this.b.name() + "=" + String.valueOf(number)), this);
                return true;
            }
            return false;
        }
        if (this.b == TreatmentInfoFinder.TreatmentInfoType.f) {
            if (number.floatValue() <= 0.0f) {
                ay.d((Object)("Rx dose must be greater than 0: " + this.b.name() + "=" + String.valueOf(number)), this);
                return true;
            }
            return false;
        }
        if (this.b == TreatmentInfoFinder.TreatmentInfoType.a) {
            if (number.intValue() <= 0) {
                ay.d((Object)("Fraction number cannot be <= 0: " + this.b.name() + "=" + String.valueOf(number)), this);
                return true;
            }
            return false;
        }
        if (this.b == TreatmentInfoFinder.TreatmentInfoType.c) {
            if (number.intValue() < 0) {
                ay.d((Object)("Fractions since last image can't be < 0: " + this.b.name() + "=" + String.valueOf(number)), this);
                return true;
            }
            return false;
        }
        if (this.b == TreatmentInfoFinder.TreatmentInfoType.b) {
            if (number.intValue() < 0) {
                ay.d((Object)("Delivery number cannot be <= 0: " + this.b.name() + "=" + String.valueOf(number)), this);
                return true;
            }
            return false;
        }
        if (this.b == TreatmentInfoFinder.TreatmentInfoType.e || this.b == TreatmentInfoFinder.TreatmentInfoType.d) {
            if (treatmentInfoFinder != null) {
                Integer n2 = treatmentInfoFinder.a(TreatmentInfoFinder.TreatmentInfoType.e);
                if (n2 == null) {
                    ay.d((Object)("Unable to determine total fractions: " + this.b.name() + "=" + String.valueOf(number)), this);
                    return true;
                }
                if (number.intValue() > n2) {
                    ay.d((Object)("Remaining or current fraction is greater than the total fractions: " + this.b.name() + "=" + String.valueOf(number)), this);
                    return true;
                }
                if (number.equals(n2) && this.b == TreatmentInfoFinder.TreatmentInfoType.d) {
                    ay.d((Object)("Remaining fractions should not be the same as total fractions: " + this.b.name() + "=" + String.valueOf(number)), this);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private Number askForTreatmentValue() {
        if (MIM.isHeadless()) {
            return null;
        }
        InputNotification inputNotification = new InputNotification(new Notification.a(this.a), f.b(TreatmentInfoCommand.class).c(), f.b(TreatmentInfoCommand.class).t());
        inputNotification.addTitle(Messages.a("Commands", "TREATMENT_INFO_NAME"));
        TreatmentInfoFinder treatmentInfoFinder = new TreatmentInfoFinder(this.a);
        Number number = treatmentInfoFinder.c(this.b);
        u<Float> u2 = null;
        u<Integer> u3 = null;
        if (this.b == TreatmentInfoFinder.TreatmentInfoType.f) {
            u2 = inputNotification.addFloatField(MIMFormat.a(Messages.a("Commands", "TREATMENT_INFO_ENTER_VALUE_FIELD"), this.b.getExternalizedString()));
            if (number != null) {
                u2.c(Float.valueOf(number.floatValue()));
            }
        } else {
            u3 = inputNotification.addIntegerField(MIMFormat.a(Messages.a("Commands", "TREATMENT_INFO_ENTER_VALUE_FIELD"), this.b.getExternalizedString()));
            if (number != null) {
                u3.c(number.intValue());
            }
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        inputNotification.setDismissActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                countDownLatch.countDown();
            }
        });
        inputNotification.addToGrandNotifier();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (u2 != null) {
            return (Number)u2.b();
        }
        if (u3 != null) {
            return (Number)u3.b();
        }
        return null;
    }
}

