/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow.math;

import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.response.StatisticDerivationType;
import com.mimvista.util.Messages;
import com.mimvista.workflow.backend.t;
import javax.swing.Icon;

public enum MathOperator implements t
{
    a("add_bronze", 2, doubleArray -> doubleArray[0] + doubleArray[1], "+"),
    b("subtract_bronze", 2, doubleArray -> doubleArray[0] - doubleArray[1], "-"),
    c("x_white_alpha_70", 2, doubleArray -> doubleArray[0] * doubleArray[1], "*"),
    d("divide", 2, doubleArray -> doubleArray[0] / doubleArray[1], "/"),
    e("absolute_value", 1, doubleArray -> Math.abs(doubleArray[0]), "abs"),
    f("log_base_10", 1, doubleArray -> Math.log10(doubleArray[0]), "log"),
    g("log", 1, doubleArray -> Math.log(doubleArray[0]), "ln"),
    h("exponential", 1, doubleArray -> Math.exp(doubleArray[0]), "exp"),
    i("power", 2, doubleArray -> Math.pow(doubleArray[0], doubleArray[1]), "^"),
    j("square_root", 1, doubleArray -> Math.sqrt(doubleArray[0]), "sqrt"),
    k("subtract_bronze", 1, doubleArray -> -doubleArray[0].doubleValue(), "-"),
    l("min", 2, doubleArray -> Math.min(doubleArray[0], doubleArray[1]), "min"),
    m("max", 2, doubleArray -> Math.max(doubleArray[0], doubleArray[1]), "max");

    private final String iconName;
    private final String displayText;
    private final int arguments;
    private final StatisticDerivationType.a evaluator;
    private final String formulaSymbol;

    private MathOperator(String string2, int n3, StatisticDerivationType.a a2, String string3) {
        this.iconName = string2;
        this.displayText = Messages.a("Commands", "EQUATION_OP_" + this.name());
        this.arguments = n3;
        this.evaluator = a2;
        this.formulaSymbol = string3;
    }

    public double a(Double ... doubleArray) {
        if (doubleArray == null) {
            throw new NullPointerException("Arguments were null");
        }
        for (Double d2 : doubleArray) {
            if (d2 != null) continue;
            throw new NullPointerException("Input value was null");
        }
        if (doubleArray.length != this.arguments) {
            throw new IllegalArgumentException("Different number of arguments than expected");
        }
        return this.evaluator.evaluate(doubleArray);
    }

    public int a() {
        return this.arguments;
    }

    public boolean b() {
        return this.arguments == 1;
    }

    public String c() {
        return this.formulaSymbol;
    }

    @Override
    public Icon getIcon(int n2) {
        if (this.iconName == null) {
            return null;
        }
        return ImageManipulator.c(this.iconName, n2);
    }

    @Override
    public String getExternalizedString() {
        return this.displayText;
    }
}

