/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow.nmproc;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.i;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.dicom.read.RadionuclideCodeValueMapping;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.nukes.NmProcessing;
import com.mimvista.numerics.MathUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import com.mimvista.workflow.gui.args.a;
import com.mimvista.workflow.gui.args.b;
import com.mimvista.workflow.gui.args.w;
import com.mimvista.workflow.gui.c;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@e(e="decay_correct", f="decay_correct", b="decay_correct_name", a="Commands", h="decay_correction", l={MIMFeatureType.Workflow}, i={i.class}, j={LicenseOption.ENCORE, LicenseOption.SURE_PLAN}, n={SessionPredicate.NonNull})
public class DecayCorrectionCommand
extends WorkflowCommand {
    private final String a = "AUTO_DETECT_ISOTOPE";
    private List<ViewController> b;
    private boolean c;
    private String d;
    private float e;

    public DecayCorrectionCommand(List<ViewController> list, boolean bl2, String string, float f2) {
        this.b = list;
        this.c = bl2;
        this.d = string;
        this.e = f2;
    }

    public static Double calculateDecayCorrectionLambdaInMs(RadionuclideCodeValueMapping.Isotope isotope) {
        Double d2 = isotope.halfLifeInSeconds;
        if (d2 == null) {
            ay.c((Object)("We don't know the halflife of " + isotope.codeMeaning + ", will not decay correct."), DecayCorrectionCommand.class);
            return null;
        }
        return DecayCorrectionCommand.calculateDecayCorrectionLambdaInMs(d2);
    }

    public static double calculateDecayCorrectionLambdaInMs(double d2) {
        double d3 = d2 * 1000.0;
        return Math.log(0.5) / d3;
    }

    private RadionuclideCodeValueMapping.Isotope autodetectIsotope(List<ImageFrame> list) {
        List list2 = list.stream().map(imageFrame -> NmProcessing.a(imageFrame)).distinct().collect(Collectors.toList());
        if (list2.contains(null)) {
            this.o.d(Messages.a("Commands", "DECAY_CORRECT_AUTO_DETECT_MISSING_ISOTOPE"));
            return null;
        }
        if (list2.size() > 1) {
            this.o.d(MIMFormat.a(Messages.a("Commands", "DECAY_CORRECT_AUTO_DETECT_TOO_MANY_ISOS"), list2));
            return null;
        }
        String string = (String)list2.get(0);
        RadionuclideCodeValueMapping.Isotope isotope = RadionuclideCodeValueMapping.getIsotopeForMeaning(string);
        if (isotope == null) {
            this.o.d(MIMFormat.a(Messages.a("Commands", "DECAY_CORRECT_AUTO_DETECT_UNKNOWN_HALF_LIFE"), string));
            return null;
        }
        if (isotope.halfLifeInSeconds == null) {
            this.o.d(MIMFormat.a(Messages.a("Commands", "DECAY_CORRECT_AUTO_DETECT_UNKNOWN_HALF_LIFE"), string));
            return null;
        }
        return isotope;
    }

    @Override
    public Object execute() {
        String string;
        double d2;
        Object object;
        List<ImageFrame> list = this.b.stream().flatMap(viewController -> viewController.au().l().stream()).collect(Collectors.toList());
        if (list.size() < 2) {
            this.o.d(Messages.a("Commands", "DECAY_CORRECT_NOT_ENOUGH_IMAGES"));
            return null;
        }
        long l2 = list.stream().map(imageFrame -> imageFrame.getUncopiedMutableInfo().a((SimpleImageFrame)imageFrame)).min((Comparator<Date>)Ordering.natural()).get().getTime();
        if (!this.c) {
            if ("AUTO_DETECT_ISOTOPE".equals(this.d)) {
                object = this.autodetectIsotope(list);
                if (object == null) {
                    return null;
                }
            } else {
                object = RadionuclideCodeValueMapping.getIsotopeForMeaning(this.d);
            }
            d2 = DecayCorrectionCommand.calculateDecayCorrectionLambdaInMs((RadionuclideCodeValueMapping.Isotope)object);
            string = ((RadionuclideCodeValueMapping.Isotope)object).getExternalizedString();
        } else {
            d2 = DecayCorrectionCommand.calculateDecayCorrectionLambdaInMs(this.e);
            string = Messages.a("Commands", "DECAY_CORRECT_CUSTOM_HALF_LIFE");
        }
        object = Lists.newArrayList();
        for (ImageFrame imageFrame2 : list) {
            SeriesInfo seriesInfo = imageFrame2.getUncopiedMutableInfo();
            long l3 = seriesInfo.a(imageFrame2).getTime();
            long l4 = l3 - l2;
            float f2 = (float)(1.0 / Math.exp((double)l4 * d2));
            boolean bl2 = this.checkAlreadyCorrected(imageFrame2.getUncopiedMutableInfo(), f2, string);
            if (bl2) {
                this.o.d(MIMFormat.a(Messages.a("Commands", "DECAY_CORRECT_ALREADY_CORRECTED"), imageFrame2.getUncopiedMutableInfo().u().g()));
                return null;
            }
            ((ArrayList)object).add(Float.valueOf(f2));
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ImageFrame imageFrame2;
            imageFrame2 = list.get(i2);
            imageFrame2.getUncopiedMutableInfo().u().a(((Float)((ArrayList)object).get(i2)).floatValue(), l2, string, "TODO");
            imageFrame2.an_();
        }
        return null;
    }

    private boolean checkAlreadyCorrected(SeriesInfo seriesInfo, float f2, String string) {
        if (!seriesInfo.X()) {
            return false;
        }
        if (seriesInfo.Y()) {
            return true;
        }
        UnitHelper unitHelper = seriesInfo.u();
        boolean bl2 = unitHelper.g() != null && !string.equals(unitHelper.g());
        return bl2 |= (double)unitHelper.h() != 1.0 && !MathUtils.a(f2, unitHelper.h(), 1.0E-5f);
    }

    @Override
    public a<WorkflowCommand>[] createArgumentViews(c<WorkflowCommand> c2) {
        a[] aArray = super.createArgumentViews(c2);
        b b2 = (b)aArray[1];
        b2.f(Messages.a("Commands", "DECAY_CORRECT_ARG2_TRUE"));
        b2.g(Messages.a("Commands", "DECAY_CORRECT_ARG2_FALSE"));
        b2.c(false);
        ArrayList arrayList = Lists.newArrayList();
        Pair<String, String> pair = Pair.get("AUTO_DETECT_ISOTOPE", Messages.a("Commands", "DECAY_CORRECT_AUTO_DETECT"));
        arrayList.add(pair);
        Object object = RadionuclideCodeValueMapping.getIsotopesWithKnownHalfLifes().iterator();
        while (object.hasNext()) {
            RadionuclideCodeValueMapping.Isotope isotope = object.next();
            arrayList.add(Pair.get(isotope.codeMeaning, isotope.getExternalizedString()));
        }
        aArray[2] = object = new w<WorkflowCommand>(c2, 2, arrayList, (String)pair.x);
        b2.a(() -> {
            boolean bl2 = (Boolean)b2.k_().a();
            aArray[2].n().setVisible(!bl2);
            aArray[3].n().setVisible(bl2);
        });
        return aArray;
    }
}

