/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.commands.workflow.nmproc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.commands.workflow.nmproc.CreateTableCommand;
import com.mimvista.commands.workflow.nmproc.MutableTableCellSpec;
import com.mimvista.commands.workflow.nmproc.a;
import com.mimvista.d;
import com.mimvista.internals.statistics.GeneralStatistic;
import com.mimvista.internals.statistics.Statistician;
import com.mimvista.internals.statistics.i;
import com.mimvista.mui.Session;
import com.mimvista.mui.SessionKey;
import com.mimvista.mui.SizableImage;
import com.mimvista.mui.layout.CustomViewSignature;
import com.mimvista.nukes.general.SingleStatSpec;
import com.mimvista.response.StatsManager;
import com.mimvista.swing.widgets.InvertableJPanel;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ag;
import com.mimvista.util.bi;
import com.mimvista.util.serialize.XmlSerializationWrapper;
import java.awt.GridLayout;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TableViewSpec
implements a,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SessionKey sessKey;
    public final String uniqueId;
    public final int widthInCols;
    public final int heightInRows;
    private final TableCellSpec[][] cells;

    public TableViewSpec(Session session, TableCellSpec[][] tableCellSpecArray) {
        this.sessKey = session.H();
        StatsManager statsManager = session.Z();
        this.uniqueId = statsManager.c();
        statsManager.a(this);
        this.widthInCols = tableCellSpecArray.length;
        this.heightInRows = tableCellSpecArray[0].length;
        this.cells = new TableCellSpec[this.widthInCols][this.heightInRows];
        for (int i2 = 0; i2 < this.widthInCols; ++i2) {
            if (tableCellSpecArray[i2].length != this.heightInRows) {
                throw new IllegalArgumentException("Non rectangular table.");
            }
            for (int i3 = 0; i3 < this.heightInRows; ++i3) {
                this.cells[i2][i3] = tableCellSpecArray[i2][i3];
            }
        }
    }

    public Stream<TableCellSpec> a() {
        return Arrays.stream(this.cells).flatMap(tableCellSpecArray -> Arrays.stream(tableCellSpecArray)).filter(tableCellSpec -> tableCellSpec != null);
    }

    public TableCellSpec a(int n2, int n3) {
        TableCellSpec tableCellSpec = this.cells[n2][n3];
        if (tableCellSpec.originX != n2 || tableCellSpec.originY != n3) {
            return null;
        }
        return tableCellSpec;
    }

    public TableCellSpec b(int n2, int n3) {
        return this.cells[n2][n3];
    }

    @Override
    public CustomViewSignature b() {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("general_table_id_param", this.uniqueId);
        XmlSerializationWrapper<Map<String, String>> xmlSerializationWrapper = XmlSerializationWrapper.a(hashMap);
        return new CustomViewSignature("general_table", xmlSerializationWrapper);
    }

    private static String b(String string, TableCellSpec tableCellSpec) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 30);
        stringBuilder.append("<html><p");
        if (tableCellSpec != null) {
            stringBuilder.append(" align");
            stringBuilder.append(tableCellSpec.horizAlign);
        }
        stringBuilder.append(">").append(string).append("</p></html>");
        return stringBuilder.toString();
    }

    public static enum TableCellVertAlignment implements ag
    {
        a(1),
        b(0),
        c(3);

        public final int swingConst;

        private TableCellVertAlignment(int n3) {
            this.swingConst = n3;
        }

        @Override
        public String getExternalizedString() {
            return Messages.a("Commands", "CREATE_TABLE_CELL_CONTENT_ALIGN_V_" + this.name());
        }
    }

    public static enum TableCellHorizAlignment implements ag
    {
        a(2),
        b(0),
        c(4);

        public final int swingConst;

        private TableCellHorizAlignment(int n3) {
            this.swingConst = n3;
        }

        @Override
        public String getExternalizedString() {
            return Messages.a("Commands", "CREATE_TABLE_CELL_CONTENT_ALIGN_H_" + this.name());
        }
    }

    public static class TableCellSpec
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int originX;
        public final int originY;
        public final int widthInCols;
        public final int heightInRows;
        public final TableCellHorizAlignment horizAlign;
        public final TableCellVertAlignment vertAlign;
        public final TableCellContentProvider content;

        public TableCellSpec(MutableTableCellSpec mutableTableCellSpec, CreateTableCommand createTableCommand) {
            this(mutableTableCellSpec.originX, mutableTableCellSpec.originY, mutableTableCellSpec.widthInCols, mutableTableCellSpec.heightInRows, mutableTableCellSpec.horizAlign, mutableTableCellSpec.vertAlign, mutableTableCellSpec.buildContentProvider(createTableCommand));
        }

        public TableCellSpec(int n2, int n3, int n4, int n5, TableCellHorizAlignment tableCellHorizAlignment, TableCellVertAlignment tableCellVertAlignment, @d TableCellContentProvider tableCellContentProvider) {
            this.originX = n2;
            this.originY = n3;
            this.widthInCols = n4;
            this.heightInRows = n5;
            this.horizAlign = tableCellHorizAlignment;
            this.vertAlign = tableCellVertAlignment;
            this.content = tableCellContentProvider;
        }
    }

    public static class ImageCellContentProvider
    implements TableCellContentProvider {
        private static final long serialVersionUID = 7596772532960056784L;
        SizableImage image;

        public ImageCellContentProvider(SizableImage sizableImage) {
            this.image = sizableImage;
        }

        @Override
        public JComponent a(TableCellSpec tableCellSpec) {
            JLabel jLabel = new JLabel(this.image.c());
            InvertableJPanel.InversionImmuneJPanel inversionImmuneJPanel = new InvertableJPanel.InversionImmuneJPanel(new GridLayout(1, 1));
            inversionImmuneJPanel.add(jLabel);
            return inversionImmuneJPanel;
        }

        @Override
        public String b() {
            return this.image.a();
        }

        @Override
        public void a(CreateTableCommand createTableCommand) {
        }
    }

    public static class StatCellContentProvider
    implements TableCellContentProvider {
        private static final long serialVersionUID = 1L;
        private SingleStatSpec stat;
        private TableCellSpec cell;
        private transient GeneralStatistic.d a;
        private transient List<WeakReference<JLabel>> b;
        private transient Statistician.d<Statistician> c;
        private String rawContent;

        public StatCellContentProvider(SingleStatSpec singleStatSpec) {
            this.stat = singleStatSpec;
        }

        @Override
        public void a(CreateTableCommand createTableCommand) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<JLabel> a() {
            ArrayList arrayList = Lists.newArrayList();
            List<WeakReference<JLabel>> list = this.b;
            synchronized (list) {
                for (int i2 = 0; i2 < this.b.size(); ++i2) {
                    JLabel jLabel = (JLabel)this.b.get(i2).get();
                    if (jLabel == null) {
                        this.b.remove(i2--);
                        continue;
                    }
                    arrayList.add(jLabel);
                }
            }
            return arrayList;
        }

        private void a(String string) {
            this.a(string, null);
        }

        private void a(String string, @d String string2) {
            String string3 = TableViewSpec.b(string, this.cell);
            this.a().forEach(jLabel -> {
                jLabel.setText(string3);
                jLabel.setToolTipText(string2);
            });
            this.rawContent = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void c() {
            this.a(Messages.a("Nukes", "STAT_DISPLAY_COMPUTING"));
            GeneralStatistic.d d2 = this.a;
            synchronized (d2) {
                if (!this.a.b.c(this.a.a)) {
                    this.a.b.e(this.a.a);
                }
            }
        }

        private void a(Statistician.e e2) {
            Object t2 = e2.a(this.a.a);
            if (t2 == null) {
                this.c();
                return;
            }
            if (!((i)t2).d()) {
                this.a(Messages.a("Commands", "CREATE_TABLE_CELL_NON_NUMERIC_RESULT"));
                return;
            }
            Number number = ((i)t2).e().d;
            if (number == null) {
                this.a(Messages.a("Commands", "CREATE_TABLE_CELL_STAT_BAD_OR_MISSING_RESULT"), bi.b("Commands", "CREATE_TABLE_CELL_STAT_NO_VALUE_TIP", new Object[0]));
                return;
            }
            String string = null;
            if (Double.isNaN(number.doubleValue())) {
                string = bi.b("Commands", "CREATE_TABLE_CELL_STAT_NAN_TIP", new Object[0]);
            }
            this.a(NumberFormatFactory.a().format(number.doubleValue()), string);
        }

        private Statistician.d<Statistician> d() {
            return new Statistician.d<Statistician>(){

                @Override
                public void a(Statistician statistician, Set<GeneralStatistic.c> set) {
                    if (set == null || set.contains(((StatCellContentProvider)this).a.a)) {
                        this.c();
                    }
                }

                @Override
                public void a(Statistician statistician, Statistician.e e2) {
                    this.a(e2);
                }
            };
        }

        private void e() {
            if (this.c != null && this.a != null) {
                return;
            }
            this.b = Lists.newArrayList();
            this.c = this.d();
            this.a = this.stat.d();
            if (this.a.b == null) {
                throw new IllegalArgumentException("Stat cell content must specify an explicit statter.");
            }
            this.a.b.a(this.c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JComponent a(TableCellSpec tableCellSpec) {
            this.cell = tableCellSpec;
            this.e();
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalAlignment(tableCellSpec.horizAlign.swingConst);
            jLabel.setVerticalAlignment(tableCellSpec.vertAlign.swingConst);
            List<WeakReference<JLabel>> list = this.b;
            synchronized (list) {
                this.b.add(new WeakReference<JLabel>(jLabel));
            }
            this.a(this.a.b.D());
            return jLabel;
        }

        @Override
        public String b() {
            if (this.rawContent != null) {
                return this.rawContent;
            }
            return "";
        }
    }

    public static class FloatCellContentProvider
    implements TableCellContentProvider {
        private static final long serialVersionUID = 1L;
        @d
        Float val;

        public FloatCellContentProvider(Float f2) {
            this.val = f2;
        }

        @Override
        public JComponent a(TableCellSpec tableCellSpec) {
            JLabel jLabel = new JLabel(NumberFormatFactory.a(this.val));
            jLabel.setHorizontalAlignment(tableCellSpec.horizAlign.swingConst);
            jLabel.setVerticalAlignment(tableCellSpec.vertAlign.swingConst);
            return jLabel;
        }

        @Override
        public String b() {
            return "" + this.val;
        }

        @Override
        public void a(CreateTableCommand createTableCommand) {
        }
    }

    public static class StringCellContentProvider
    implements TableCellContentProvider {
        private static final long serialVersionUID = 1L;
        private String content;
        private boolean editable;

        public StringCellContentProvider(String string, boolean bl2) {
            this.content = string;
            this.editable = bl2;
        }

        @Override
        public JComponent a(TableCellSpec tableCellSpec) {
            JComponent jComponent;
            if (this.editable) {
                jComponent = new JTextField(this.content);
                jComponent.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        content = ((JTextField)jComponent).getText();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        content = ((JTextField)jComponent).getText();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        content = ((JTextField)jComponent).getText();
                    }
                });
            } else {
                jComponent = new JLabel(TableViewSpec.b(this.content, tableCellSpec));
                ((JLabel)jComponent).setHorizontalAlignment(tableCellSpec.horizAlign.swingConst);
                ((JLabel)jComponent).setVerticalAlignment(tableCellSpec.vertAlign.swingConst);
            }
            return jComponent;
        }

        @Override
        public void a(CreateTableCommand createTableCommand) {
        }

        @Override
        public String b() {
            return this.content;
        }
    }

    public static interface TableCellContentProvider
    extends Serializable {
        public JComponent a(TableCellSpec var1);

        public String b();

        public void a(CreateTableCommand var1);
    }
}

