/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dataparallel.probe;

import com.google.common.collect.Lists;
import com.mimvista.ExternallyVisible;
import com.mimvista.dataparallel.e;
import com.mimvista.dataparallel.probe.a;
import com.mimvista.file.Path;
import com.mimvista.file.PathUtils;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.preferencesNew.ThreeDeePrefs;
import com.mimvista.util.MIMContext;
import com.mimvista.util.ay;
import com.mimvista.util.bv;
import com.mimvista.util.logging.r;
import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.bridj.Pointer;

@ExternallyVisible
public class OpenCLDeviceDriverPoker {
    private static final int a = 159;
    private static final int b = -49;

    public static boolean doValidationOnEachDevice() {
        boolean bl2 = false;
        CLPlatform[] cLPlatformArray = JavaCL.listPlatforms();
        block4: for (int i2 = 0; i2 < cLPlatformArray.length; ++i2) {
            CLDevice[] cLDeviceArray = null;
            try {
                cLDeviceArray = cLPlatformArray[i2].listAllDevices(false);
            }
            catch (CLException cLException) {
                ay.c((Object)("Error querying OpenCL devices for " + cLPlatformArray[i2].toString()), (Throwable)cLException, "OpenCL");
            }
            if (cLDeviceArray == null) continue;
            for (int i3 = 0; i3 < cLDeviceArray.length; ++i3) {
                try {
                    bv bv2 = OpenCLDeviceDriverPoker.a(i2, i3);
                    Integer n2 = bv2.a(2L, TimeUnit.MINUTES);
                    if (n2 == null) {
                        ay.b((Object)"Open CL device specific validation timed out so we'll assume it's no good.", "OpenCL");
                    }
                    if (n2 == 159) {
                        bl2 = true;
                        break block4;
                    }
                    if (n2 == -49) {
                        ay.b((Object)"OpenCL tests failed to run on a specific device", "OpenCL");
                        continue;
                    }
                    ay.b((Object)"OpenCL tests failed to run on a specific device due to system errors (like segfault)", "OpenCL");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bl2;
    }

    private static bv a(int n2, int n3) throws IOException {
        String string = "-Xmx128m";
        String string2 = "-Djava.awt.headless=true";
        String string3 = System.getProperty("java.class.path");
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(PathUtils.getJrePath());
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add("-cp");
        arrayList.add(string3);
        if (LicenseTransformer.isDevelopment()) {
            arrayList.add("-Xdebug");
            arrayList.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=1044");
        }
        arrayList.add("-Dlog.configpath=services/opencl_startup_probe/lib");
        arrayList.add("-DMIM" + (MIMContext.j() ? "VIEWER" : "") + "_SERVICE=true");
        arrayList.add(OpenCLDeviceDriverPoker.class.getCanonicalName());
        arrayList.add(Integer.toString(n2));
        arrayList.add(Integer.toString(n3));
        bv bv2 = new bv(arrayList);
        bv2.a(true, "DEVICEPROBE");
        bv2.b();
        return bv2;
    }

    public static void main(String[] stringArray) {
        MIMContext.a();
        r.a(false, "opencl_device_probe.log");
        OpenCLDeviceDriverPoker.initOpenClWithWorkaroundForSpacesInUserDir();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        ay.b((Object)("starting device prober with the following argument: " + stringBuilder), com.mimvista.dataparallel.probe.a.d);
        if (stringArray.length == 2) {
            Object object;
            String string;
            int n2 = -1;
            int n3 = -1;
            try {
                object = stringArray[0];
                n2 = Integer.parseInt((String)object);
                object = stringArray[1];
                n3 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                ay.d((Object)"invalid arguments passed into device validator.  platform and device were not numbers.", com.mimvista.dataparallel.probe.a.d);
                System.exit(-49);
            }
            object = JavaCL.listPlatforms();
            if (n2 < 0 || n2 >= ((CLPlatform[])object).length) {
                ay.d((Object)"platform provided in argument is out of range of platforms available.", com.mimvista.dataparallel.probe.a.d);
                System.exit(-49);
            }
            string = object[n2];
            CLDevice[] cLDeviceArray = string.listAllDevices(false);
            if (n3 < 0 || n3 >= cLDeviceArray.length) {
                ay.d((Object)"device provided in argument is out of range of devices available.", com.mimvista.dataparallel.probe.a.d);
                System.exit(-49);
            }
            CLDevice cLDevice = cLDeviceArray[n3];
            ay.b((Object)("the device being tested is " + cLDevice.getName()), com.mimvista.dataparallel.probe.a.d);
            if (ThreeDeePrefs.isBlacklistedDevice(cLDevice.getName())) {
                ay.b((Object)"the device was found to be blacklisted", com.mimvista.dataparallel.probe.a.d);
                System.exit(-49);
            }
            OpenCLDeviceDriverPoker.a(cLDevice);
            OpenCLDeviceDriverPoker.b(cLDevice);
        } else {
            ay.d((Object)"invalid arguments passed into device validator.", com.mimvista.dataparallel.probe.a.d);
            System.exit(-49);
        }
        ay.b((Object)"test concluded successfully", com.mimvista.dataparallel.probe.a.d);
        System.exit(159);
    }

    public static void initOpenClWithWorkaroundForSpacesInUserDir() {
        String string = System.getProperty("user.home");
        String string2 = Path.getWin32ShortPathName(string);
        try {
            System.setProperty("user.home", string2);
            JavaCL javaCL = new JavaCL();
        }
        finally {
            System.setProperty("user.home", string);
        }
    }

    private static void a(CLDevice cLDevice) {
        ay.b((Object)"testing byte orders...", com.mimvista.dataparallel.probe.a.d);
        try {
            ByteOrder byteOrder = Pointer.allocateFloats((long)4L).order();
            ByteOrder byteOrder2 = cLDevice.getByteOrder();
            if (byteOrder == null || byteOrder2 == null) {
                System.exit(-49);
                return;
            }
            if (byteOrder.equals(byteOrder2)) {
                ay.b((Object)("Byte order for " + cLDevice.getName() + " is incorrect...but proceding anyway..."), com.mimvista.dataparallel.probe.a.d);
                return;
            }
            ay.d((Object)("Byte order for " + cLDevice.getName() + " is incorrect...but proceding anyway..."), com.mimvista.dataparallel.probe.a.d);
            System.exit(-49);
        }
        catch (Throwable throwable) {
            System.exit(-49);
        }
    }

    private static void b(CLDevice cLDevice) {
        ay.b((Object)"testing basic kernel run...", com.mimvista.dataparallel.probe.a.d);
        try {
            CLContext cLContext = JavaCL.createContext(null, (CLDevice[])new CLDevice[]{cLDevice});
            CLQueue cLQueue = cLContext.createDefaultQueue(new CLDevice.QueueProperties[0]);
            String string = e.a(true, "testKernels.cl")[0];
            CLProgram cLProgram = cLContext.createProgram(new String[]{string}).build();
            CLBuffer cLBuffer = null;
            CLBuffer cLBuffer2 = null;
            cLBuffer = cLContext.createLongBuffer(CLMem.Usage.Input, Pointer.pointerToLongs((long[])new long[]{5L, 6L, 8L, 2L}).order(cLContext.getByteOrder()), true);
            cLBuffer2 = cLContext.createLongBuffer(CLMem.Usage.InputOutput, 4L);
            CLKernel cLKernel = null;
            cLKernel = cLProgram.createKernel("testLongRead", new Object[0]);
            int[] nArray = new int[]{4};
            cLKernel.setArg(0, (CLMem)cLBuffer);
            cLKernel.setArg(1, (CLMem)cLBuffer2);
            CLEvent cLEvent = cLKernel.enqueueNDRange(cLQueue, nArray, new CLEvent[0]);
            cLEvent.waitFor();
            cLKernel.release();
        }
        catch (CLException cLException) {
            ay.d((Object)"CLException caught when testing for legitimacy of hardware drivers, device will be banned", (Throwable)cLException, "OpenCL");
            System.exit(-49);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Exception caught when testing for legitimacy of hardware drivers, device will be banned", throwable, "OpenCL");
            System.exit(-49);
        }
    }
}

