/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.NameFormatter;
import com.mimvista.archive.gui.SeriesColumnEnum;
import com.mimvista.archive.gui.StudyGroupingType;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.DcmStudyGrouping;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.dicom.factories.DcmStudyFactory;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.u;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class BasicDcmStudyGrouping
implements DcmStudyGrouping {
    public static Messages props = Messages.a("PropertyCollectionFactory");
    protected static final int STUDYPANEL_COLUMN_WIDTH = 200;
    protected String name;
    protected String compName;
    protected String compID;
    protected String compDate;
    protected String prettyName;

    public static String getCleanStudyDate(DcmStudy dcmStudy) {
        String string = dcmStudy.getStringProperty(524320);
        if (string != null && string.endsWith("00:00:00")) {
            string = string.replace("00:00:00", "");
            string = string.trim();
        }
        return string;
    }

    @Override
    public String getUberPrettyName() {
        String string = new String(this.prettyName);
        string = string.replaceAll(" ", "&nbsp;");
        return string;
    }

    @Override
    public String getUberPrettyID() {
        String string = new String(this.compID);
        string = string.replaceAll(" ", "&nbsp;");
        return string;
    }

    @Override
    public String getUberPrettyDate() {
        String string;
        if (!cn.g(this.compDate) && (string = DateUtils.a().format(DateUtils.i(this.compDate))) != null) {
            return string;
        }
        return this.compDate;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        String string = this.getCompareString();
        n3 = 31 * n3 + (string == null ? 0 : string.hashCode());
        n3 = 31 * n3 + (this.needCompareName() ? 1 : 0);
        if (this.needCompareName()) {
            n3 = 31 * n3 + (this.compName == null ? 0 : this.compName.hashCode());
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BasicDcmStudyGrouping basicDcmStudyGrouping = (BasicDcmStudyGrouping)object;
        String string = this.getCompareString();
        String string2 = basicDcmStudyGrouping.getCompareString();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        if (this.needCompareName() != basicDcmStudyGrouping.needCompareName()) {
            return false;
        }
        return !this.needCompareName() || !(this.compName == null ? basicDcmStudyGrouping.compName != null : !SeriesIdentifier.compareSanitizedCrunchedPatientNames(this.compName, basicDcmStudyGrouping.compName));
    }

    protected boolean needCompareName() {
        return true;
    }

    @Override
    public void prepare(DcmStudy dcmStudy) {
        String string;
        if (dcmStudy == null) {
            return;
        }
        this.prettyName = dcmStudy.getFormattedName();
        this.name = dcmStudy.getStringProperty(0x100010);
        this.compName = ArchivePrefs.strictPatientNameCompare.getValue() != false ? SeriesIdentifier.sanitizeName(NameFormatter.a(this.name, Integer.MAX_VALUE)) : SeriesIdentifier.sanitizeName(NameFormatter.d(this.name));
        this.compID = dcmStudy.getStringProperty(0x100020);
        this.compDate = string = BasicDcmStudyGrouping.getCleanStudyDate(dcmStudy);
    }

    @Override
    public boolean isFast(List<DcmStudy> list) {
        return true;
    }

    @Override
    public String getGroupColumnHeader() {
        return this.getName();
    }

    @Override
    public List<DcmStudy> formStudyGroups(List<QueryResult> list, Progress progress, SearchSource searchSource, Searchable.a a2) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        u u2 = new u(progress, progress.g());
        u2.a(list.size());
        for (QueryResult queryResult : list) {
            DcmStudy dcmStudy = DcmStudyFactory.getDcmStudyFromArchiveDirectory(queryResult.path);
            DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesWithInfoAdded(searchSource, queryResult);
            if (!"null".equals(dcmSeries.getModality())) {
                StudyGroupingType studyGroupingType = StudyGroupingType.f();
                DcmStudyGrouping dcmStudyGrouping = studyGroupingType.a(dcmStudy);
                dcmStudy.setGrouping(dcmStudyGrouping);
                DcmStudy dcmStudy2 = (DcmStudy)linkedHashMap.get(dcmStudyGrouping);
                if (dcmStudy2 == null) {
                    linkedHashMap.put(dcmStudyGrouping, dcmStudy);
                } else {
                    dcmStudy = dcmStudy2;
                }
                dcmStudy.addSeries(dcmSeries);
                dcmSeries.setStudy(dcmStudy);
            }
            u2.N_();
            if (progress.n() != Progress.Status.e && !a2.b()) continue;
            return Lists.newArrayList();
        }
        ArrayList arrayList = Lists.newArrayList(linkedHashMap.values());
        return arrayList;
    }

    @Override
    public List<DcmStudy> formStudyGroups(Collection<DcmSeries> collection, Progress progress, Searchable.a a2) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        LinkedList linkedList = Lists.newLinkedList();
        u u2 = new u(progress, progress.g());
        u2.a(collection.size());
        HashMap hashMap = Maps.newHashMap();
        for (DcmSeries dcmSeries : collection) {
            u2.N_();
            if (progress.n() == Progress.Status.e || a2.b()) {
                return Lists.newArrayList();
            }
            if (!dcmSeries.isEmbedded()) {
                hashMap.put(dcmSeries.getPrimaryKey(), dcmSeries);
                this.createStudyAndGroup(linkedHashMap, dcmSeries);
                continue;
            }
            linkedList.add(dcmSeries);
        }
        for (DcmSeries dcmSeries : linkedList) {
            DcmSeries dcmSeries2 = (DcmSeries)hashMap.get(dcmSeries.getEmbedParentId());
            if (dcmSeries2 != null && dcmSeries2.getStudy() != null) {
                this.groupIntoStudy(linkedHashMap, dcmSeries, dcmSeries2.getStudy());
                continue;
            }
            this.createStudyAndGroup(linkedHashMap, dcmSeries);
        }
        ArrayList arrayList = Lists.newArrayList(linkedHashMap.values());
        return arrayList;
    }

    private void createStudyAndGroup(Map<DcmStudyGrouping, DcmStudy> map, DcmSeries dcmSeries) {
        DcmStudy dcmStudy = this.createUngroupedStudy(dcmSeries);
        this.groupIntoStudy(map, dcmSeries, dcmStudy);
    }

    private void groupIntoStudy(Map<DcmStudyGrouping, DcmStudy> map, DcmSeries dcmSeries, DcmStudy dcmStudy) {
        if (!"null".equals(dcmSeries.getModality())) {
            StudyGroupingType studyGroupingType = StudyGroupingType.f();
            DcmStudyGrouping dcmStudyGrouping = studyGroupingType.a(dcmStudy);
            dcmStudy.setGrouping(dcmStudyGrouping);
            DcmStudy dcmStudy2 = map.get(dcmStudyGrouping);
            if (dcmStudy2 == null) {
                dcmStudy.setSeries(new ArrayList<DcmSeries>());
                map.put(dcmStudyGrouping, dcmStudy);
            } else {
                dcmStudy = dcmStudy2;
            }
            dcmStudy.addSeries(dcmSeries);
        }
    }

    private DcmStudy createUngroupedStudy(DcmSeries dcmSeries) {
        DcmStudy dcmStudy = null;
        if (dcmSeries.getCloudSeriesItem() != null) {
            dcmStudy = DcmStudyFactory.updateDcmStudyForCloudGrouping(dcmSeries);
        } else {
            dcmStudy = DcmStudyFactory.getDcmStudyFromDCMSeries(dcmSeries);
            if (dcmSeries.getStudy() == null) {
                dcmSeries.setStudy(dcmStudy);
                dcmStudy.addSeries(dcmSeries);
            }
        }
        return dcmStudy;
    }

    public static class StudyFractionGrouping
    extends BasicDcmStudyGrouping {
        @Override
        public String getPrettyString() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public List<SeriesColumnEnum> getSeriesColumns() {
            return null;
        }

        @Override
        public String getCompareString() {
            return null;
        }

        @Override
        public List<DcmStudy> formStudyGroups(Collection<DcmSeries> collection, Progress progress, Searchable.a a2) {
            HashMap hashMap = Maps.newHashMap();
            for (DcmSeries dcmSeries : collection) {
                Date date = dcmSeries.getSeriesOrStudyDateTime(false);
                if (date == null) continue;
                if (hashMap.get(date) == null) {
                    hashMap.put(date, new DcmStudy());
                }
                ((DcmStudy)hashMap.get(date)).addSeries(dcmSeries);
            }
            return Lists.newArrayList(hashMap.values());
        }
    }

    public static class StudyInstanceUIDGrouping
    extends BasicDcmStudyGrouping {
        private String uid;

        @Override
        protected boolean needCompareName() {
            return false;
        }

        @Override
        public String getCompareString() {
            return this.uid;
        }

        @Override
        public String getPrettyString() {
            String string = this.getUberPrettyID();
            return "<html><table cellpadding=2 style='width:200px;'><tr><td><strong>" + string + "</strong></td></tr>" + "</table>" + "</html>";
        }

        @Override
        public String getName() {
            return props.getProperty("PROPERTYCOLL_FACT_GS_A");
        }

        @Override
        public List<SeriesColumnEnum> getSeriesColumns() {
            return Lists.newArrayList(SeriesColumnEnum.a());
        }

        @Override
        public void prepare(DcmStudy dcmStudy) {
            if (dcmStudy == null) {
                return;
            }
            super.prepare(dcmStudy);
            this.uid = dcmStudy.getStringProperty(0x20000D);
        }

        @Override
        public List<DcmStudy> formStudyGroups(List<QueryResult> list, Progress progress, SearchSource searchSource, Searchable.a a2) {
            ArrayList arrayList = Lists.newArrayList();
            u u2 = new u(progress, progress.g());
            u2.a(list.size());
            for (QueryResult queryResult : list) {
                DcmStudy dcmStudy = DcmStudyFactory.getDcmStudyFromArchiveDirectory(queryResult.path);
                DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesWithInfoAdded(searchSource, queryResult);
                arrayList.add(dcmStudy);
                dcmStudy.addSeries(dcmSeries);
                dcmSeries.setStudy(dcmStudy);
                u2.N_();
                if (progress.n() != Progress.Status.e && !a2.b()) continue;
                return Lists.newArrayList();
            }
            return arrayList;
        }

        @Override
        public List<DcmStudy> formStudyGroups(Collection<DcmSeries> collection, Progress progress, Searchable.a a2) {
            ArrayList arrayList = Lists.newArrayList();
            u u2 = new u(progress, progress.g());
            u2.a(collection.size());
            for (DcmSeries dcmSeries : collection) {
                DcmStudy dcmStudy = DcmStudyFactory.getDcmStudyFromDCMSeries(dcmSeries);
                dcmStudy.addSeries(dcmSeries);
                if (dcmSeries.getStudy() == null) {
                    dcmSeries.setStudy(dcmStudy);
                }
                arrayList.add(dcmStudy);
                u2.N_();
                if (progress.n() != Progress.Status.e && !a2.b()) continue;
                return Lists.newArrayList();
            }
            return arrayList;
        }
    }

    public static class IDGrouping
    extends BasicDcmStudyGrouping {
        @Override
        protected boolean needCompareName() {
            return false;
        }

        @Override
        public String getCompareString() {
            return this.compID;
        }

        @Override
        public String getPrettyString() {
            String string = this.getUberPrettyID();
            return "<html><table cellpadding=2 style='width:200px;'><tr><td><strong>" + string + "</strong></td></tr>" + "</table>" + "</html>";
        }

        @Override
        public String getName() {
            return props.getProperty("PROPERTYCOLL_FACT_GS_D");
        }

        @Override
        public List<SeriesColumnEnum> getSeriesColumns() {
            ArrayList arrayList = Lists.newArrayList(SeriesColumnEnum.a());
            arrayList.remove((Object)SeriesColumnEnum.i);
            return arrayList;
        }
    }

    public static class NameIDDateGrouping
    extends BasicDcmStudyGrouping {
        @Override
        public String getCompareString() {
            return this.compID + "|" + this.compDate;
        }

        @Override
        public String getPrettyString() {
            String string = this.getUberPrettyName();
            String string2 = this.getUberPrettyID();
            String string3 = this.getUberPrettyDate();
            return "<html><table cellpadding=2 style='width:200px;'><tr><td><strong>" + string + "</strong></td></tr>" + "<tr><td>" + string2 + "</td></tr>" + "<tr><td>" + string3 + "</td></tr>" + "</table>" + "</html>";
        }

        @Override
        public String getName() {
            return props.getProperty("PROPERTYCOLL_FACT_GS_C");
        }

        @Override
        public List<SeriesColumnEnum> getSeriesColumns() {
            ArrayList arrayList = Lists.newArrayList(SeriesColumnEnum.a());
            arrayList.remove((Object)SeriesColumnEnum.f);
            arrayList.remove((Object)SeriesColumnEnum.i);
            return arrayList;
        }
    }

    public static class NameIDGrouping
    extends BasicDcmStudyGrouping {
        @Override
        public String getCompareString() {
            return this.compID;
        }

        @Override
        public String getPrettyString() {
            String string = this.getUberPrettyName();
            String string2 = this.getUberPrettyID();
            return "<html><table cellpadding=2 style='width:200px;'><tr><td><strong>" + string + "</strong></td></tr>" + "<tr><td>" + string2 + "</td></tr>" + "</table></html>";
        }

        @Override
        public String getName() {
            return props.getProperty("PROPERTYCOLL_FACT_GS_B");
        }

        @Override
        public List<SeriesColumnEnum> getSeriesColumns() {
            ArrayList arrayList = Lists.newArrayList(SeriesColumnEnum.a());
            arrayList.remove((Object)SeriesColumnEnum.f);
            arrayList.remove((Object)SeriesColumnEnum.i);
            return arrayList;
        }
    }
}

