/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import java.awt.color.ColorSpace;

public class CIELab
extends ColorSpace {
    private static final long serialVersionUID = 5027741380892134289L;
    private static final ColorSpace CIEXYZ = ColorSpace.getInstance(1001);
    private static final double N = 0.13793103448275862;

    public static CIELab getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        double d2 = CIELab.f(fArray[1]);
        double d3 = 116.0 * d2 - 16.0;
        double d4 = 500.0 * (CIELab.f(fArray[0]) - d2);
        double d5 = 200.0 * (d2 - CIELab.f(fArray[2]));
        return new float[]{(float)d3, (float)d4, (float)d5};
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        float[] fArray2 = CIEXYZ.fromRGB(fArray);
        return this.fromCIEXYZ(fArray2);
    }

    @Override
    public float getMaxValue(int n2) {
        return 128.0f;
    }

    @Override
    public float getMinValue(int n2) {
        return n2 == 0 ? 0.0f : -128.0f;
    }

    @Override
    public String getName(int n2) {
        return String.valueOf("Lab".charAt(n2));
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        double d2 = ((double)fArray[0] + 16.0) * 0.008620689655172414;
        double d3 = CIELab.fInv(d2 + (double)fArray[1] * 0.002);
        double d4 = CIELab.fInv(d2);
        double d5 = CIELab.fInv(d2 - (double)fArray[2] * 0.005);
        return new float[]{(float)d3, (float)d4, (float)d5};
    }

    @Override
    public float[] toRGB(float[] fArray) {
        float[] fArray2 = this.toCIEXYZ(fArray);
        return CIEXYZ.toRGB(fArray2);
    }

    CIELab() {
        super(1, 3);
    }

    private static double f(double d2) {
        if (d2 > 0.008856451679035631) {
            return Math.cbrt(d2);
        }
        return 7.787037037037037 * d2 + 0.13793103448275862;
    }

    private static double fInv(double d2) {
        if (d2 > 0.20689655172413793) {
            return d2 * d2 * d2;
        }
        return 0.12841854934601665 * (d2 - 0.13793103448275862);
    }

    private Object readResolve() {
        return CIELab.getInstance();
    }

    private static class Holder {
        static final CIELab INSTANCE = new CIELab();

        private Holder() {
        }
    }
}

