/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.jayway.jsonpath.JsonPath;
import com.mimvista.dicom.AbstractDicomSeries;
import com.mimvista.dicom.CoercingJsonDicomSeriesInterface;
import com.mimvista.dicom.JsonPathUtil;
import com.mimvista.util.ay;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dcm4che2.util.DateUtils;

public abstract class CoercingJsonDicomSeries
extends AbstractDicomSeries
implements CoercingJsonDicomSeriesInterface,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient ConcurrentHashMap<Key, Object> cache = new ConcurrentHashMap();
    private static final Object NULL = new Object();
    private static Function<Object, Object> F_COERCE_STRING = new Function<Object, Object>(){

        public Object apply(Object object) {
            if (object != null) {
                if (object instanceof Date) {
                    Date date = (Date)object;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    object = calendar.get(1) == 1970 ? DateUtils.formatTM((Date)date) : (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0 ? DateUtils.formatDA((Date)date) : DateUtils.formatDT((Date)date));
                } else if (byte[].class.isAssignableFrom(object.getClass())) {
                    byte[] byArray = (byte[])object;
                    object = new String(byArray);
                } else {
                    object = object.toString();
                }
            }
            return object;
        }
    };
    private static Function<Object, Object> F_COERCE_DOUBLE = new Function<Object, Object>(){

        public Object apply(Object object) {
            if (object != null && !(object instanceof Double)) {
                try {
                    object = Double.valueOf((String)object);
                }
                catch (Throwable throwable) {
                    object = null;
                }
            }
            return object;
        }
    };
    private static Function<Object, Object> F_COERCE_FLOAT = new Function<Object, Object>(){

        public Object apply(Object object) {
            if (object != null && !(object instanceof Float)) {
                try {
                    object = Float.valueOf((String)object);
                }
                catch (Throwable throwable) {
                    object = null;
                }
            }
            return object;
        }
    };
    private static Function<Object, Object> F_COERCE_INTEGER = new Function<Object, Object>(){

        public Object apply(Object object) {
            if (object != null && !(object instanceof Integer)) {
                try {
                    object = Integer.valueOf((String)object);
                }
                catch (Throwable throwable) {
                    object = null;
                }
            }
            return object;
        }
    };
    private static Function<Object, Object> F_COERCE_DATE_TYPES = new Function<Object, Object>(){

        public Object apply(Object object) {
            if (object != null && !(object instanceof Date)) {
                String string = (String)object;
                object = string.length() == 6 || string.length() == 10 && string.indexOf(".") == string.lastIndexOf(".") ? F_COERCE_TIME.apply(object) : F_COERCE_DATE_TIME.apply(object);
            }
            return object;
        }
    };
    private static Function<Object, Object> F_COERCE_DATE_TIME = new Function<Object, Object>(){

        public Object apply(Object object) {
            if (object != null && object instanceof String) {
                object = DateUtils.parseDT((String)((String)object), (boolean)false);
            }
            return object;
        }
    };
    private static Function<Object, Object> F_COERCE_TIME = new Function<Object, Object>(){

        public Object apply(Object object) {
            if (object != null && object instanceof String) {
                object = com.mimvista.util.DateUtils.j((String)object);
            }
            return object;
        }
    };
    private static Function<Object, Object> F_COERCE_DATE = new Function<Object, Object>(){

        public Object apply(Object object) {
            if (object != null && object instanceof String) {
                object = DateUtils.parseDA((String)((String)object), (boolean)false);
            }
            return object;
        }
    };
    private static Map<Class, Function<Object, Object>> converters = ImmutableMap.builder().put(String.class, F_COERCE_STRING).put(Number.class, F_COERCE_DOUBLE).put(Double.class, F_COERCE_DOUBLE).put(Float.class, F_COERCE_FLOAT).put(Integer.class, F_COERCE_INTEGER).put(Date.class, F_COERCE_DATE_TYPES).build();

    public static Iterable<Class> getSupportedConversions() {
        return Iterables.unmodifiableIterable(converters.keySet());
    }

    public static Function<Object, Object> getConverterFor(Class clazz) {
        return converters.get(clazz);
    }

    public static Function<Object, Object> getConverterForDate(boolean bl2, boolean bl3) {
        if (bl3) {
            if (bl2) {
                return F_COERCE_DATE_TIME;
            }
            return F_COERCE_TIME;
        }
        return F_COERCE_DATE;
    }

    public <T> T getTagValue(int n2, Class<T> clazz) {
        return this.getTagValue(JsonPathUtil.forTag(n2), clazz);
    }

    @Override
    public <T> T getTagValue(JsonPath jsonPath, Class<T> clazz) {
        Key key = new Key(jsonPath.getPath(), clazz, false);
        Object object = this.cache.get(key);
        if (object == NULL) {
            return null;
        }
        if (object != null) {
            return (T)object;
        }
        object = String.class.equals(clazz) ? this.getTagValue(jsonPath) : this.getTagValue(jsonPath, String.class);
        if (object != null) {
            object = converters.get(key.type).apply(object);
        }
        if (object != null) {
            this.cache.put(key, object);
            return (T)object;
        }
        this.cache.put(key, NULL);
        return null;
    }

    public <T> ImmutableList<T> getTagValues(int n2, Class<T> clazz) {
        return this.getTagValues(JsonPathUtil.forTag(n2), clazz);
    }

    @Override
    public <T> ImmutableList<T> getTagValues(JsonPath jsonPath, Class<T> clazz) {
        Key key = new Key(jsonPath.getPath(), clazz, true);
        Object object = this.cache.get(key);
        if (object != null) {
            return object;
        }
        object = String.class.equals(clazz) ? this.getTagValues(jsonPath) : this.getTagValues(jsonPath, String.class);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (object != null) {
            Function<Object, Object> function = converters.get(key.type);
            Iterable iterable = (Iterable)object;
            for (Object t2 : iterable) {
                builder.add(function.apply(t2));
            }
            object = builder.build();
        }
        if (object != null) {
            this.cache.put(key, object);
            return object;
        }
        this.cache.put(key, ImmutableList.of());
        return null;
    }

    protected CoercingJsonDicomSeries clone() {
        try {
            CoercingJsonDicomSeries coercingJsonDicomSeries = (CoercingJsonDicomSeries)super.clone();
            coercingJsonDicomSeries.cache = new ConcurrentHashMap();
            return coercingJsonDicomSeries;
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error trying to clone a CoercingJsonDicomSeries", throwable, this);
            return null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap();
        }
    }

    private static class Key {
        final String path;
        final Class type;
        final boolean list;

        public Key(String string, Class clazz, boolean bl2) {
            this.path = string;
            this.type = clazz;
            this.list = bl2;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.list ? 1231 : 1237);
            n3 = 31 * n3 + (this.path == null ? 0 : this.path.hashCode());
            n3 = 31 * n3 + (this.type == null ? 0 : this.type.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Key key = (Key)object;
            if (this.list != key.list) {
                return false;
            }
            if (this.path == null ? key.path != null : !this.path.equals(key.path)) {
                return false;
            }
            return !(this.type == null ? key.type != null : !this.type.equals(key.type));
        }
    }
}

