/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mimvista.dicom.Modality;
import java.util.Locale;

public class DataUnitUtils {
    public static final CanonDataUnit COUNTS_CANON_ = new CanonDataUnit("CNTS", "Counts");
    public static final CanonDataUnit KILO_COUNTS_CANON_ = new CanonDataUnit("kCounts", new String[0]);
    public static final CanonDataUnit CPS_CANON_ = new CanonDataUnit("cps", new String[0]);
    public static final CanonDataUnit CPS_PER_ML_CANON_ = new CanonDataUnit("cps/ml", new String[0]);
    public static final CanonDataUnit KILO_CPS_CANON_ = new CanonDataUnit("kcps", new String[0]);
    public static final CanonDataUnit BQML_CANON_ = new CanonDataUnit("BQML", "bq/ml");
    public static final CanonDataUnit SUV_CANON_ = new CanonDataUnit("SUV", new String[0]);
    public static final CanonDataUnit UNKNOWN_CANON_ = new CanonDataUnit("UNKNOWN", new String[0]);
    public static final CanonDataUnit NONE_CANON_ = new CanonDataUnit("", new String[]{"NONE"}){

        @Override
        public boolean matchesUnit(String string) {
            if (string == null) {
                return true;
            }
            return super.matchesUnit(string);
        }
    };
    private static final ImmutableList<CanonDataUnit> CANON_UNITS = ImmutableList.of((Object)COUNTS_CANON_, (Object)KILO_COUNTS_CANON_, (Object)CPS_CANON_, (Object)CPS_PER_ML_CANON_, (Object)KILO_CPS_CANON_, (Object)BQML_CANON_, (Object)SUV_CANON_, (Object)NONE_CANON_);
    private static ImmutableBiMap<String, String> realWorldValueMap = new ImmutableBiMap.Builder().put((Object)"[hnsf'U]", (Object)"HU").put((Object)"{counts}", (Object)DataUnitUtils.COUNTS_CANON_.canonicalUnit).put((Object)"{counts}/s", (Object)DataUnitUtils.CPS_CANON_.canonicalUnit).put((Object)"{SUVbw}g/ml", (Object)"SUVbw").put((Object)"{SUVlbm}g/ml", (Object)"SUVlbm").put((Object)"{SUVbsa}cm2/ml", (Object)"SUVbsa").put((Object)"{SUVibw}g/ml", (Object)"SUVibw").put((Object)"{propcounts}", (Object)"PROPCNTS").put((Object)"{propcounts}/s", (Object)"PROPCPS").put((Object)"%", (Object)"PCNT").put((Object)"Bq/ml", (Object)DataUnitUtils.BQML_CANON_.canonicalUnit).build();
    private static ImmutableMap<String, UnitCodeInfo> codeInfoMap = new ImmutableMap.Builder().put((Object)"[hnsf'U]", (Object)new UnitCodeInfo("83", "20080123", "Hounsfield unit")).put((Object)"{counts}", (Object)new UnitCodeInfo("84", "20121105", "Counts")).put((Object)"{counts}/s", (Object)new UnitCodeInfo("84", "20121105", "Counts per second")).put((Object)"{SUVbw}g/ml", (Object)new UnitCodeInfo("84", "20121105", "Standardized Uptake Value body weight")).put((Object)"{SUVlbm}g/ml", (Object)new UnitCodeInfo("84", "20121105", "Standardized Uptake Value lean body mass")).put((Object)"{SUVbsa}cm2/ml", (Object)new UnitCodeInfo("84", "20121105", "Standardized Uptake Value body surface area")).put((Object)"{SUVibw}g/ml", (Object)new UnitCodeInfo("84", "20121105", "Standardized Uptake Value ideal body weight")).put((Object)"{propcounts}", (Object)new UnitCodeInfo("84", "20121105", "Proportional to counts")).put((Object)"{propcounts}/s", (Object)new UnitCodeInfo("84", "20121105", "Proportional to counts per second")).put((Object)"cm2", (Object)new UnitCodeInfo("84", "20121105", "Centimeter**2")).put((Object)"%", (Object)new UnitCodeInfo("84", "20121105", "Percent")).put((Object)"Bq/ml", (Object)new UnitCodeInfo("84", "20121105", "Becquerels/milliliter")).put((Object)"mg/min/ml", (Object)new UnitCodeInfo("84", "20121105", "Milligrams/minute/milliliter")).put((Object)"umol/min/ml", (Object)new UnitCodeInfo("84", "20121105", "Micromole/minute/milliliter")).put((Object)"ml/min/g", (Object)new UnitCodeInfo("84", "20121105", "Milliliter/minute/gram")).put((Object)"ml/g", (Object)new UnitCodeInfo("84", "20121105", "Milliliter/gram")).put((Object)"/cm", (Object)new UnitCodeInfo("84", "20121105", "/Centimeter")).put((Object)"umol/ml", (Object)new UnitCodeInfo("84", "20121105", "Micromole/milliliter")).build();

    public static CanonDataUnit getCanonicalUnitOrUnknown(String string, String string2) {
        if (NONE_CANON_.matchesUnit(string) && Modality.NM.isSameModality(string2)) {
            if (Modality.NM.isSameModality(string2)) {
                return COUNTS_CANON_;
            }
            return NONE_CANON_;
        }
        for (CanonDataUnit canonDataUnit : CANON_UNITS) {
            if (!canonDataUnit.matchesUnit(string)) continue;
            return canonDataUnit;
        }
        return UNKNOWN_CANON_;
    }

    public static String getCanonicalUnit(String string, String string2) {
        CanonDataUnit canonDataUnit = DataUnitUtils.getCanonicalUnitOrUnknown(string, string2);
        if (canonDataUnit != UNKNOWN_CANON_) {
            return canonDataUnit.canonicalUnit;
        }
        return string;
    }

    public static String convertRealWorldValueMappingUnitCode(String string) {
        String string2 = (String)realWorldValueMap.get((Object)string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static String getCodeValueForUnit(String string, String string2) {
        String string3;
        if (string != null && (string3 = DataUnitUtils.getCanonicalUnit(string, string2)) != null) {
            return (String)realWorldValueMap.inverse().get((Object)string3);
        }
        return string;
    }

    public static UnitCodeInfo getInfoForCode(String string) {
        if (string != null) {
            return (UnitCodeInfo)codeInfoMap.get((Object)string);
        }
        return null;
    }

    public static class UnitCodeInfo {
        public final String codeMeaning;
        public final String contextID;
        public final String contextGroupVersion;

        private UnitCodeInfo(String string, String string2, String string3) {
            this.contextID = string;
            this.contextGroupVersion = string2;
            this.codeMeaning = string3;
        }
    }

    public static class CanonDataUnit {
        public final String canonicalUnit;
        public final ImmutableSet<String> uppercasedAliases;

        public CanonDataUnit(String string, String ... stringArray) {
            this.canonicalUnit = string;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String string2 : stringArray) {
                builder.add((Object)string2.toUpperCase(Locale.ENGLISH));
            }
            this.uppercasedAliases = builder.build();
        }

        public boolean matchesUnit(String string) {
            if (string == null) {
                return false;
            }
            String string2 = string.toUpperCase(Locale.ENGLISH);
            if (string2.equals(this.canonicalUnit.toUpperCase(Locale.ENGLISH))) {
                return true;
            }
            return this.uppercasedAliases.contains((Object)string2);
        }
    }
}

