/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.read.Dicom2DLoader;
import com.mimvista.dicom.read.DicomVolumeLoaderFactory;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.file.PathUtils;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.internals.MimPlanarImage;
import com.mimvista.preferencesNew.DcmSecondaryCapturePrefs;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.a;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.b.d;
import com.mimvista.util.progress.o;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.workflow.backend.x;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DcmCaptureToImageConverter {
    public static Messages dicomprops = Messages.a("Dicom");
    public static String PNAME_FORMAT1 = dicomprops.getProperty("DCM_CAP_TO_A");
    public static String PNAME_FORMAT2 = dicomprops.getProperty("DCM_CAP_TO_B");
    public static String PNAME_FORMAT3 = dicomprops.getProperty("DCM_CAP_TO_C");
    public static String PNAME_FORMAT4 = dicomprops.getProperty("DCM_CAP_TO_D");
    public static String PNAME_FORMAT5 = dicomprops.getProperty("DCM_CAP_TO_E");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean convert(DcmSeries dcmSeries, SearchSource searchSource, String string, String string2, String string3) {
        String string4 = searchSource.a(dcmSeries, new o());
        Dicom2DLoader<MimPlanarImage> dicom2DLoader = DicomVolumeLoaderFactory.getDefault2DLoader();
        dicom2DLoader.load(o.o(), new LoaderDataProvider.FileBasedLoaderDataProvider(new File(string4).listFiles()));
        boolean bl2 = true;
        String string5 = null;
        int n2 = 0;
        for (MimPlanarImage mimPlanarImage : dicom2DLoader.getImages()) {
            File file;
            block7: {
                string5 = string2 == null || string2.trim().length() == 0 ? DcmCaptureToImageConverter.getUniqueFilename(mimPlanarImage.getUncopiedMutableInfo()) : string2;
                file = null;
                file = dicom2DLoader.getImages().size() == 1 ? new File(string, string5 + "." + string3) : new File(string, string5 + "_" + DcmCaptureToImageConverter.getFileNumber(n2, dicom2DLoader.getImages().size()) + "." + string3);
                ++n2;
                try {
                    bl2 = d.a(mimPlanarImage.f(), string3, file);
                    if (bl2) continue;
                    if (mimPlanarImage.getUncopiedMutableInfo().bitsAlloc != 16 || string3.equalsIgnoreCase("png") || string3.equalsIgnoreCase("tiff")) break block7;
                }
                catch (Exception exception) {
                    block8: {
                        try {
                            ay.d((Object)exception, DcmCaptureToImageConverter.class);
                            bl2 = false;
                            if (bl2) continue;
                            if (mimPlanarImage.getUncopiedMutableInfo().bitsAlloc != 16 || string3.equalsIgnoreCase("png") || string3.equalsIgnoreCase("tiff")) break block8;
                        }
                        catch (Throwable throwable) {
                            if (!bl2) {
                                if (mimPlanarImage.getUncopiedMutableInfo().bitsAlloc == 16 && !string3.equalsIgnoreCase("png") && !string3.equalsIgnoreCase("tiff")) {
                                    ay.d((Object)("Image " + n2 + " of " + dcmSeries.getArchiveDir() + " is of 16 bits, and cannot be saved into ." + string3 + " image"), DcmCaptureToImageConverter.class);
                                    u.b().c(new a(BasicNotification.NotificationType.a.a(), BasicNotification.NotificationType.a.b(), dcmSeries, string3){
                                        final /* synthetic */ DcmSeries val$series;
                                        final /* synthetic */ String val$type;
                                        {
                                            this.val$series = dcmSeries;
                                            this.val$type = string3;
                                            super(string, string2);
                                        }

                                        @Override
                                        public boolean shouldPopInfo() {
                                            return true;
                                        }

                                        @Override
                                        public Container getContent() {
                                            JPanel jPanel = new JPanel(new FlowLayout(0, 20, 10));
                                            jPanel.add(new JLabel(ImageManipulator.c(BasicNotification.NotificationType.a.b(), 25)));
                                            String string = MIMFormat.a(Messages.a("Archive").getProperty("CAP_ERROR_16_BITS"), this.val$series.getSeriesDescription(), this.val$type.toUpperCase());
                                            JLabel jLabel = new JLabel("<html>" + string + "</html>");
                                            jLabel.setPreferredSize(new Dimension(300, 70));
                                            jPanel.add(jLabel);
                                            return jPanel;
                                        }
                                    });
                                    bl2 = true;
                                }
                                file.delete();
                            }
                            throw throwable;
                        }
                        ay.d((Object)("Image " + n2 + " of " + dcmSeries.getArchiveDir() + " is of 16 bits, and cannot be saved into ." + string3 + " image"), DcmCaptureToImageConverter.class);
                        u.b().c(new /* invalid duplicate definition of identical inner class */);
                        bl2 = true;
                    }
                    file.delete();
                    continue;
                }
                ay.d((Object)("Image " + n2 + " of " + dcmSeries.getArchiveDir() + " is of 16 bits, and cannot be saved into ." + string3 + " image"), DcmCaptureToImageConverter.class);
                u.b().c(new /* invalid duplicate definition of identical inner class */);
                bl2 = true;
            }
            file.delete();
        }
        return bl2;
    }

    private static String getFileNumber(int n2, int n3) {
        int n4 = new Integer(n3).toString().length();
        int n5 = new Integer(n2).toString().length();
        String string = "";
        for (int i2 = 0; i2 < n4 - n5; ++i2) {
            string = "0" + string;
        }
        return string + n2;
    }

    public static boolean convert(DcmSeries dcmSeries, SearchSource searchSource, String string, String string2) {
        return DcmCaptureToImageConverter.convert(dcmSeries, searchSource, string, null, string2);
    }

    public static String getUniqueFilename(SeriesInfo seriesInfo) {
        String string = DcmCaptureToImageConverter.getNameString(seriesInfo);
        String string2 = DcmCaptureToImageConverter.getIdString(seriesInfo);
        String string3 = DcmCaptureToImageConverter.getDateString(seriesInfo);
        String string4 = DcmCaptureToImageConverter.getDescString(seriesInfo);
        String string5 = seriesInfo.ag();
        return DcmCaptureToImageConverter.getUniqueFilename(string, string2, string3, string4, string5);
    }

    public static String getUniqueFilename(String string, String string2, String string3, String string4, String string5) {
        String string6;
        String string7 = "";
        if (string != null) {
            string7 = string7 + string;
        }
        if (string2 != null) {
            if (string7.length() > 0) {
                string7 = string7 + "_";
            }
            string7 = string7 + string2;
        }
        if (string3 != null) {
            if (string7.length() > 0) {
                string7 = string7 + "_";
            }
            string7 = string7 + string3;
        }
        if (string4 != null) {
            if (string7.length() > 0) {
                string7 = string7 + "_";
            }
            string7 = string7 + string4;
        }
        if (string5 != null && string5.length() > 0 && string7.indexOf(string6 = string5.substring(string5.length() - 4)) == -1) {
            string7 = string7 + "#" + string6;
        }
        return PathUtils.safeFilename(string7, true);
    }

    public static String getNameString(SeriesInfo seriesInfo) {
        if (!DcmSecondaryCapturePrefs.captureUsePname.getValue().booleanValue()) {
            return null;
        }
        return DcmCaptureToImageConverter.getNameStringDefinitely(seriesInfo);
    }

    public static String getNameStringDefinitely(SeriesInfo seriesInfo) {
        String string = seriesInfo.patientNameRaw;
        String[] stringArray = string.split("\\^");
        String string2 = stringArray.length > 1 ? stringArray[1] : "";
        String string3 = stringArray.length > 0 ? stringArray[0] : "";
        String string4 = "";
        String string5 = DcmSecondaryCapturePrefs.capturePnameFormat.getValue();
        if (string5.equalsIgnoreCase(PNAME_FORMAT5)) {
            if (string2 != null && string2.length() > 0) {
                string4 = string4 + string2.charAt(0);
            }
            if (string3 != null && string3.length() > 0) {
                string4 = string4 + string3.charAt(0);
            }
        } else {
            string4 = string5.equalsIgnoreCase(PNAME_FORMAT2) ? string3 + "," + string2 : (string5.equalsIgnoreCase(PNAME_FORMAT3) ? string2 : (string5.equalsIgnoreCase(PNAME_FORMAT4) ? string3 : string3 + "^" + string2));
        }
        return string4;
    }

    public static String getIdString(SeriesInfo seriesInfo) {
        if (!DcmSecondaryCapturePrefs.captureUsePid.getValue().booleanValue()) {
            return null;
        }
        return PathUtils.safeFilename(seriesInfo.patientId);
    }

    public static String getDateString(SeriesInfo seriesInfo) {
        if (!DcmSecondaryCapturePrefs.captureUseDate.getValue().booleanValue()) {
            return null;
        }
        String string = "";
        if (seriesInfo.acqDate != null) {
            string = DateUtils.a().format(seriesInfo.acqDate);
        } else if (seriesInfo.M() != null && seriesInfo.M().length() > 0) {
            try {
                Date date = new SimpleDateFormat("yyyymmdd").parse(seriesInfo.M());
                string = DateUtils.a().format(date);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        } else {
            try {
                Date date = new SimpleDateFormat("yyyymmdd").parse(seriesInfo.N());
                string = DateUtils.a().format(date);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        return string;
    }

    public static String getDescString(SeriesInfo seriesInfo) {
        if (!DcmSecondaryCapturePrefs.captureUseDesc.getValue().booleanValue()) {
            return null;
        }
        String string = PathUtils.safeFilename(seriesInfo.seriesDesc);
        if (string.length() > 25) {
            string = string.substring(0, 25);
        }
        return string;
    }

    public static String getSimpleFolderName(SeriesInfo seriesInfo) {
        String string = DcmCaptureToImageConverter.getNameStringDefinitely(seriesInfo);
        String string2 = DcmSecondaryCapturePrefs.captureDirectoryIncludePatientID.getValue() != false ? seriesInfo.patientId : null;
        return DcmCaptureToImageConverter.getUniqueFilename(string, string2, null, null, null);
    }

    public static File makePatientFolder(SeriesInfo seriesInfo, File file) {
        String string = DcmCaptureToImageConverter.getSimpleFolderName(seriesInfo);
        File file2 = file;
        if (string != null) {
            if (DcmSecondaryCapturePrefs.saveInAbcFolders.getValue().booleanValue()) {
                String string2 = x.c(seriesInfo.patientNameRaw);
                string2 = "".equals(string2) ? "_" : string2.substring(0, 1);
                file2 = new File(file2, string2.toUpperCase());
            }
            string = x.c(string);
            file2 = new File(file2, string);
        }
        file2.mkdirs();
        return file2;
    }
}

