/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.mimvista.util.ay;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.DicomObjectToStringParam;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.dcm4che2.media.ApplicationProfile;
import org.dcm4che2.media.DicomDirReader;
import org.dcm4che2.media.DicomDirWriter;
import org.dcm4che2.media.FileSetInformation;
import org.dcm4che2.media.StdGenJPEGApplicationProfile;

public class DcmDir {
    private static final int DEF_MAX_WIDTH = 78;
    private static final int MIN_MAX_WIDTH = 32;
    private static final int MAX_MAX_WIDTH = 512;
    private static final int DEF_MAX_VAL_LEN = 64;
    private static final int MIN_MAX_VAL_LEN = 16;
    private static final int MAX_MAX_VAL_LEN = 512;
    private static final String USAGE = "dcmdir -{acdptz} <dicomdir> [Options] [<file>..][<directory>..]";
    private static final String DESCRIPTION = "Dump/Create/Update/Compact DICOM directory file\nOptions:";
    private static final String EXAMPLE = "--\nExample 1: to dump content of DICOMDIR to stdout:\n$ dicomdir -t /media/cdrom/DICOMDIR\n--\nExample 2: to create a new directory file with specified File-set ID and Descriptor File, referencing all DICOM Files in directory disk99/DICOM:\n$ dicomdir -c disk99/DICOMDIR -id DISK99 -desc disk99/README disk99/DICOM\n\n--\nExample 3: to add directory records referencing all DICOM files in directory disk99/DICOM/CT1 to existing directory file:\n$ dicomdir -a disk99/DICOMDIR disk99/DICOM/CT1\n--\nExample 4: to delete/deactivate directory records referencing DICOM files in directory disk99/DICOM/CT2:\n$ dicomdir -d disk99/DICOMDIR disk99/DICOM/CT2\n--\nExample 5: to purge directory records without child records referencing any DICOM file:\n$ dicomdir -p disk99/DICOMDIR\n--\nExample 6: to compact DICOMDIR by removing inactive records:\n$ dicomdir -z disk99/DICOMDIR";
    private final File file;
    private DicomDirReader dicomdir;
    private FileSetInformation fsinfo;
    private ApplicationProfile ap = new StdGenJPEGApplicationProfile();
    private int maxValLen = 64;
    private int maxWidth = 78;
    private boolean checkDuplicate = false;

    public DcmDir(File file) {
        this.file = file;
    }

    private DicomDirWriter writer() {
        return (DicomDirWriter)this.dicomdir;
    }

    public final void setMaxValLen(int n2) {
        this.maxValLen = n2;
    }

    public final void setMaxWidth(int n2) {
        this.maxWidth = n2;
    }

    public final void setCheckDuplicate(boolean bl2) {
        this.checkDuplicate = bl2;
    }

    public final void fsinfo(FileSetInformation fileSetInformation) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        fileSetInformation.getDicomObject().copyTo((DicomObject)basicDicomObject, false);
        this.fsinfo = new FileSetInformation((DicomObject)basicDicomObject);
    }

    public FileSetInformation fsinfo() {
        if (this.fsinfo == null) {
            this.fsinfo = new FileSetInformation();
            this.fsinfo.init();
        }
        return this.fsinfo;
    }

    public void create() throws IOException {
        this.dicomdir = new DicomDirWriter(this.file, this.fsinfo());
    }

    public void openRO() throws IOException {
        this.dicomdir = new DicomDirReader(this.file);
        this.fsinfo = this.dicomdir.getFileSetInformation();
    }

    public void open() throws IOException {
        this.dicomdir = new DicomDirWriter(this.file);
        this.fsinfo = this.dicomdir.getFileSetInformation();
    }

    public void setShowInactiveRecords(boolean bl2) {
        this.dicomdir.setShowInactiveRecords(bl2);
    }

    public void dump() throws IOException {
        DicomObjectToStringParam dicomObjectToStringParam = new DicomObjectToStringParam(true, this.maxValLen, Integer.MAX_VALUE, this.maxWidth, Integer.MAX_VALUE, "", System.getProperty("line.separator", "\n"));
        StringBuffer stringBuffer = new StringBuffer(512);
        FileSetInformation fileSetInformation = this.dicomdir.getFileSetInformation();
        fileSetInformation.getDicomObject().toStringBuffer(stringBuffer, dicomObjectToStringParam);
        System.out.println(stringBuffer.toString());
        this.dump(this.dicomdir.findFirstRootRecord(), dicomObjectToStringParam, "", stringBuffer);
    }

    private void dump(DicomObject dicomObject, DicomObjectToStringParam dicomObjectToStringParam, String string, StringBuffer stringBuffer) throws IOException {
        int n2 = 1;
        DicomObject dicomObject2 = dicomObject;
        while (dicomObject2 != null) {
            stringBuffer.setLength(0);
            dicomObject2.toStringBuffer(stringBuffer, dicomObjectToStringParam);
            System.out.println("" + dicomObject2.getItemOffset() + ": " + dicomObject2.getString(267312) + " - " + string + n2);
            System.out.println(stringBuffer.toString());
            this.dump(this.dicomdir.findFirstChildRecord(dicomObject2), dicomObjectToStringParam, string + n2 + '.', stringBuffer);
            dicomObject2 = this.dicomdir.findNextSiblingRecord(dicomObject2);
            ++n2;
        }
    }

    public int purge() throws IOException {
        return this.writer().purge();
    }

    public void setSpecificCharacterSetofFileSetDescriptorFile(String string) {
        this.fsinfo().setSpecificCharacterSetofFileSetDescriptorFile(string);
    }

    public void setFileSetDescriptorFileID(String string) {
        this.fsinfo().setFileSetDescriptorFile(new File(string), this.file.getParentFile());
    }

    public void setMediaStorageSOPInstanceUID(String string) {
        this.fsinfo().setMediaStorageSOPInstanceUID(string);
    }

    public void setFileSetID(String string) {
        this.fsinfo().setFileSetID(string);
    }

    public void setExplicitItemLength(boolean bl2) {
        this.writer().setExplicitItemLength(bl2);
    }

    public void setExplicitSequenceLength(boolean bl2) {
        this.writer().setExplicitSequenceLength(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addFile(File file) {
        int n2 = 0;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                n2 += this.addFile(fileArray[i2]);
            }
            return n2;
        }
        if (file.getName().equalsIgnoreCase("mimfancycache.mim")) {
            return 0;
        }
        DicomInputStream dicomInputStream = null;
        try {
            String string;
            String string2;
            dicomInputStream = new DicomInputStream(file);
            dicomInputStream.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
            DicomObject dicomObject = dicomInputStream.readDicomObject();
            DicomObject dicomObject2 = this.ap.makePatientDirectoryRecord(dicomObject);
            DicomObject dicomObject3 = this.ap.makeStudyDirectoryRecord(dicomObject);
            DicomObject dicomObject4 = this.ap.makeSeriesDirectoryRecord(dicomObject);
            DicomObject dicomObject5 = null;
            String string3 = dicomObject.getString(131074, (String)null);
            if (string3 != null) {
                dicomObject5 = this.ap.makeInstanceDirectoryRecord(dicomObject, this.dicomdir.toFileID(file));
            } else {
                string2 = dicomObject.getString(524310, (String)null);
                if (string2 != null) {
                    dicomObject5 = this.getAltInstanceRecord(dicomObject, string2, this.dicomdir.toFileID(file));
                }
            }
            string2 = this.writer().addPatientRecord(dicomObject2);
            if (string2 == dicomObject2) {
                ++n2;
            }
            if ((string2 = this.writer().addStudyRecord((DicomObject)string2, dicomObject3)) == dicomObject3) {
                ++n2;
            }
            if ((string2 = this.writer().addSeriesRecord((DicomObject)string2, dicomObject4)) == dicomObject4) {
                ++n2;
            }
            if (n2 == 0 && this.checkDuplicate && this.dicomdir.findInstanceRecord((DicomObject)string2, string = dicomObject.getString(131075)) != null) {
                System.out.print('D');
                int n3 = 0;
                return n3;
            }
            if (dicomObject5 != null) {
                this.writer().addChildRecord((DicomObject)string2, dicomObject5);
            }
        }
        catch (IOException iOException) {
            ay.d((Object)iOException, this);
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, this);
        }
        finally {
            try {
                if (dicomInputStream != null) {
                    dicomInputStream.close();
                }
            }
            catch (IOException iOException) {
                ay.d((Object)iOException, this);
            }
        }
        return n2 + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int delFile(File file) throws IOException {
        if (file.isDirectory()) {
            int n2 = 0;
            File[] fileArray = file.listFiles();
            int n3 = 0;
            while (n3 < fileArray.length) {
                n2 += this.delFile(fileArray[n3]);
                ++n3;
            }
            return n2;
        }
        DicomInputStream dicomInputStream = null;
        try {
            dicomInputStream = new DicomInputStream(file);
            dicomInputStream.setHandler((DicomInputHandler)new StopTagInputHandler(0x20000F));
            DicomObject dicomObject = dicomInputStream.readDicomObject();
            String string = dicomObject.getString(0x100020);
            DicomObject dicomObject2 = this.dicomdir.findPatientRecord(string);
            if (dicomObject2 == null) {
                int n4 = 0;
                return n4;
            }
            String string2 = dicomObject.getString(0x20000D);
            DicomObject dicomObject3 = this.dicomdir.findStudyRecord(dicomObject2, string2);
            if (dicomObject3 == null) {
                int n5 = 0;
                return n5;
            }
            String string3 = dicomObject.getString(0x20000E);
            DicomObject dicomObject4 = this.dicomdir.findSeriesRecord(dicomObject3, string3);
            if (dicomObject4 == null) {
                int n6 = 0;
                return n6;
            }
            String string4 = dicomObject.getString(131075);
            DicomObject dicomObject5 = this.dicomdir.findInstanceRecord(dicomObject4, string4);
            if (dicomObject5 == null) {
                int n7 = 0;
                return n7;
            }
            this.writer().deleteRecord(dicomObject5);
            System.out.print('x');
            int n8 = 1;
            return n8;
        }
        finally {
            if (dicomInputStream != null) {
                try {
                    dicomInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void copyFrom(DcmDir dcmDir) throws IOException {
        DicomDirReader dicomDirReader = dcmDir.dicomdir;
        DicomObject dicomObject = dicomDirReader.findFirstRootRecord();
        while (dicomObject != null) {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomObject.copyTo((DicomObject)basicDicomObject, false);
            this.writer().addRootRecord((DicomObject)basicDicomObject);
            this.copyChildRecords(dicomDirReader, dicomObject, (DicomObject)basicDicomObject);
            dicomObject = dicomDirReader.findNextSiblingRecord(dicomObject);
        }
    }

    private void copyChildRecords(DicomDirReader dicomDirReader, DicomObject dicomObject, DicomObject dicomObject2) throws IOException {
        DicomObject dicomObject3 = dicomDirReader.findFirstChildRecord(dicomObject);
        while (dicomObject3 != null) {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomObject3.copyTo((DicomObject)basicDicomObject, false);
            this.writer().addChildRecord(dicomObject2, (DicomObject)basicDicomObject);
            this.copyChildRecords(dicomDirReader, dicomObject3, (DicomObject)basicDicomObject);
            dicomObject3 = dicomDirReader.findNextSiblingRecord(dicomObject3);
        }
    }

    public void close() throws IOException {
        this.dicomdir.close();
    }

    private static CommandLine parse(String[] stringArray) {
        Package package_;
        Options options = new Options();
        OptionGroup optionGroup = new OptionGroup();
        OptionBuilder.withArgName((String)"dicomdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"create new directory file <dicomdir> for DICOM file-set specified by file.. or directory.. arguments");
        optionGroup.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withArgName((String)"dicomdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"read directory file <dicomdir> and dump content to stdout");
        optionGroup.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withArgName((String)"dicomdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"add references to specified files to existing directory file <dicomdir>");
        optionGroup.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withArgName((String)"dicomdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"delete references to specified files from existing directory file <dicomdir>");
        optionGroup.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"dicomdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"purge records without file references from directory file <dicomdir>.");
        optionGroup.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withArgName((String)"dicomdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"compact existing directory file <dicomdir> by removing unused entries");
        optionGroup.addOption(OptionBuilder.create((String)"z"));
        options.addOptionGroup(optionGroup);
        OptionBuilder.withArgName((String)"txtfile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify File-set Descriptor File");
        options.addOption(OptionBuilder.create((String)"desc"));
        OptionBuilder.withArgName((String)"code");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Character Set used in File-set Descriptor File(\"ISO_IR 100\" = ISO Latin 1).");
        options.addOption(OptionBuilder.create((String)"desccs"));
        OptionBuilder.withArgName((String)"id");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify File-set ID");
        options.addOption(OptionBuilder.create((String)"id"));
        OptionBuilder.withArgName((String)"uid");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify File-set UID");
        options.addOption(OptionBuilder.create((String)"uid"));
        OptionBuilder.withArgName((String)"max");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"maximal number of characters per line, by default: 80");
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withArgName((String)"max");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"limit value prompt to <maxlen> characters, by default: 64");
        options.addOption(OptionBuilder.create((String)"W"));
        options.addOption("inactive", false, "dump also inactive records.");
        options.addOption("S", false, "encode Sequences with undefined length,encode with explicit length by default.");
        options.addOption("I", false, "encode Sequence Items with undefined length,encode with explicit length by default.");
        options.addOption("h", "help", false, "print this message");
        options.addOption("V", "version", false, "print the version information and exit");
        CommandLine commandLine = null;
        try {
            commandLine = new GnuParser().parse(options, stringArray);
        }
        catch (ParseException parseException) {
            DcmDir.exit("dcmdir: " + parseException.getMessage());
        }
        if (commandLine.hasOption('V')) {
            package_ = DcmDir.class.getPackage();
            System.out.println("dcmdir v" + package_.getImplementationVersion());
            System.exit(0);
        }
        if (commandLine.hasOption('h')) {
            package_ = new HelpFormatter();
            package_.printHelp(USAGE, DESCRIPTION, options, EXAMPLE);
            System.exit(0);
        }
        if (!(commandLine.hasOption("a") || commandLine.hasOption("c") || commandLine.hasOption("d") || commandLine.hasOption("p") || commandLine.hasOption("t") || commandLine.hasOption("z"))) {
            DcmDir.exit("dcmdir: You must specify one of the -acdptz options");
        }
        return commandLine;
    }

    private static void exit(String string) {
        System.err.println(string);
        System.err.println("Try 'dcmdir -h' for more information.");
        System.exit(1);
    }

    private static int parseInt(String string, String string2, int n2, int n3) {
        try {
            int n4 = Integer.parseInt(string);
            if (n4 >= n2 && n4 <= n3) {
                return n4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        DcmDir.exit("illegal argument for option -" + string2);
        throw new RuntimeException();
    }

    public static void main(String[] stringArray) throws IOException {
        CommandLine commandLine = DcmDir.parse(stringArray);
        List list = commandLine.getArgList();
        long l2 = System.currentTimeMillis();
        if (commandLine.hasOption("t")) {
            DcmDir dcmDir = new DcmDir(new File(commandLine.getOptionValue("t")));
            if (commandLine.hasOption("w")) {
                dcmDir.setMaxWidth(DcmDir.parseInt(commandLine.getOptionValue("w"), "w", 32, 512));
            }
            if (commandLine.hasOption("W")) {
                dcmDir.setMaxValLen(DcmDir.parseInt(commandLine.getOptionValue("W"), "W", 16, 512));
            }
            dcmDir.openRO();
            dcmDir.setShowInactiveRecords(commandLine.hasOption("inactive"));
            dcmDir.dump();
            dcmDir.close();
        } else if (commandLine.hasOption("p")) {
            String string = commandLine.getOptionValue("p");
            File file = new File(string);
            DcmDir dcmDir = new DcmDir(file);
            dcmDir.open();
            int n2 = dcmDir.purge();
            dcmDir.close();
            long l3 = System.currentTimeMillis();
            System.out.println("Purge " + n2 + " directory records from " + file + " in " + (l3 - l2) + "ms.");
        } else if (commandLine.hasOption("z")) {
            String string = commandLine.getOptionValue("z");
            File file = new File(string);
            File file2 = new File(string + ".NEW");
            File file3 = new File(string + "~");
            DcmDir dcmDir = new DcmDir(file);
            dcmDir.openRO();
            DcmDir dcmDir2 = new DcmDir(file2);
            dcmDir2.fsinfo(dcmDir.fsinfo());
            DcmDir.createDicomDir(dcmDir2, commandLine);
            dcmDir2.copyFrom(dcmDir);
            dcmDir2.close();
            dcmDir.close();
            if (!file.renameTo(file3)) {
                throw new IOException("Failed to rename " + file + " to " + file3);
            }
            if (!file2.renameTo(file)) {
                throw new IOException("Failed to rename " + file2 + " to " + file);
            }
            long l4 = System.currentTimeMillis();
            System.out.println("Compact " + file + " from " + file3.length() + " to " + file.length() + " bytes in " + (l4 - l2) + "ms.");
        } else if (commandLine.hasOption("d")) {
            File file = new File(commandLine.getOptionValue("d"));
            DcmDir dcmDir = new DcmDir(file);
            dcmDir.open();
            int n3 = 0;
            int n4 = list.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                n3 += dcmDir.delFile(new File((String)list.get(i2)));
            }
            dcmDir.close();
            long l5 = System.currentTimeMillis();
            System.out.println();
            System.out.println("Remove " + n3 + " references from " + file + " in " + (l5 - l2) + "ms.");
        } else {
            DcmDir dcmDir;
            File file;
            if (commandLine.hasOption("c")) {
                file = new File(commandLine.getOptionValue("c"));
                dcmDir = new DcmDir(file);
                DcmDir.createDicomDir(dcmDir, commandLine);
                dcmDir.setCheckDuplicate(false);
            } else {
                file = new File(commandLine.getOptionValue("a"));
                dcmDir = new DcmDir(file);
                dcmDir.open();
                dcmDir.setCheckDuplicate(true);
            }
            int n5 = 0;
            int n6 = list.size();
            for (int i3 = 0; i3 < n6; ++i3) {
                n5 += dcmDir.addFile(new File((String)list.get(i3)));
            }
            dcmDir.close();
            long l6 = System.currentTimeMillis();
            System.out.println();
            System.out.println("Add " + n5 + (commandLine.hasOption("c") ? " directory records to new directory file " : " directory records to existing directory file ") + file + " in " + (l6 - l2) + "ms.");
        }
    }

    private static void createDicomDir(DcmDir dcmDir, CommandLine commandLine) throws IOException {
        if (commandLine.hasOption("id")) {
            dcmDir.setFileSetID(commandLine.getOptionValue("id"));
        }
        if (commandLine.hasOption("uid")) {
            dcmDir.setMediaStorageSOPInstanceUID(commandLine.getOptionValue("uid"));
        }
        if (commandLine.hasOption("desc")) {
            dcmDir.setFileSetDescriptorFileID(commandLine.getOptionValue("desc"));
            if (commandLine.hasOption("desccs")) {
                dcmDir.setSpecificCharacterSetofFileSetDescriptorFile(commandLine.getOptionValue("desccs"));
            }
        }
        dcmDir.create();
        dcmDir.setExplicitSequenceLength(!commandLine.hasOption("S"));
        dcmDir.setExplicitItemLength(!commandLine.hasOption("I"));
    }

    private DicomObject getAltInstanceRecord(DicomObject dicomObject, String string, String[] stringArray) {
        if ("1.2.840.10008.5.1.4.1.1.66".equals(string)) {
            return this.ap.makeRawDataDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.67".equals(string)) {
            return this.ap.makeRealWorldValueMappingDirectorRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.104.1".equals(string)) {
            return this.ap.makeEncapsulatedDocumentDirectorRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.481.2".equals(string)) {
            return this.ap.makeRTDoseDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.481.3".equals(string)) {
            return this.ap.makeRTStructuredSetDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.481.4".equals(string)) {
            return this.ap.makeRTTreatmentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.481.5".equals(string)) {
            return this.ap.makeRTPlanDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.481.6".equals(string)) {
            return this.ap.makeRTTreatmentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.481.7".equals(string)) {
            return this.ap.makeRTTreatmentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.481.8".equals(string)) {
            return this.ap.makeRTPlanDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.481.9".equals(string)) {
            return this.ap.makeRTTreatmentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.88.11".equals(string)) {
            return this.ap.makeSRDocumentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.88.22".equals(string)) {
            return this.ap.makeSRDocumentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.88.33".equals(string)) {
            return this.ap.makeSRDocumentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.88.40".equals(string)) {
            return this.ap.makeSRDocumentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.88.50".equals(string)) {
            return this.ap.makeSRDocumentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.88.59".equals(string)) {
            return this.ap.makeKeyObjectDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.88.65".equals(string)) {
            return this.ap.makeSRDocumentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.88.67".equals(string)) {
            return this.ap.makeSRDocumentDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.9.1.1".equals(string)) {
            return this.ap.makeWaveformDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.9.1.2".equals(string)) {
            return this.ap.makeWaveformDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.9.1.3".equals(string)) {
            return this.ap.makeWaveformDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.9.2.1".equals(string)) {
            return this.ap.makeWaveformDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.9.3.1".equals(string)) {
            return this.ap.makeWaveformDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.9.4.1".equals(string)) {
            return this.ap.makeWaveformDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.4.2".equals(string)) {
            return this.ap.makeSpectroscopyDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.11.1".equals(string)) {
            return this.ap.makePresentationStateDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.11.2".equals(string)) {
            return this.ap.makePresentationStateDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.11.3".equals(string)) {
            return this.ap.makePresentationStateDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.11.4".equals(string)) {
            return this.ap.makePresentationStateDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.66.1".equals(string)) {
            return this.ap.makeRegistrationDirectoryRecord(dicomObject, stringArray);
        }
        if ("1.2.840.10008.5.1.4.1.1.66.2".equals(string)) {
            return this.ap.makeFiducialDirectoryRecord(dicomObject, stringArray);
        }
        return this.ap.makeImageDirectoryRecord(dicomObject, stringArray);
    }
}

