/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.jayway.jsonpath.JsonPath;
import com.mimvista.ExternallyVisible;
import com.mimvista.archive.Parser;
import com.mimvista.archive.search.AppSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.pro.q;
import com.mimvista.cloud.crypto.common.a.e;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeriesDateComparator;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.DicomSeriesStatic;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.JsonPathUtil;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesEqualityHasher;
import com.mimvista.dicom.SeriesGroup;
import com.mimvista.dicom.SeriesGroupable;
import com.mimvista.dicom.SeriesStatusInfo;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.file.MIMFile;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMDateFormat;
import com.mimvista.util.MutableMapView;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.workflow.backend.g;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.dcm4che2.data.DicomObject;
import org.eclipse.jetty.servlet.ServletContextHandler;

@ExternallyVisible
public class DcmSeries
extends JsonDicomSeries
implements SeriesGroupable,
g,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Date bogusThreshold = new Date(-2339971200L);
    public static Comparator<DcmSeries> DATE_COMPARATOR = new DcmSeriesDateComparator(false);
    public static Comparator<DcmSeries> SERIES_INSTANCE_DATE_TIME_COMPARE = new DcmSeriesDateComparator(true);
    private q.e ownerIfSpawnedViaNewApi;
    private ServletContextHandler.Decorator decorator;
    private String archiveDir = "";
    private String localDir = null;
    private AtomicLoadUnit.DataProviderWrapper dataProvider = new AtomicLoadUnit.DataProviderWrapper(null);
    private DcmStudy study;
    private SearchSource source;
    private int numSeriesRelatedInstancesFromPath;
    private Integer lastResortImageCount;
    private Date newlyReceived;
    private Date recentlyViewed;
    private DateFormat format = new MIMDateFormat("yyyy-MM-dd HH:mm:ss");
    private Multimap<DcmSeriesReference.ReferenceSource, DcmSeriesReference> refSeries;
    private com.mimvista.cloud.crypto.common.a.d cloudSeriesItem;
    private Map<String, String> rtPlanMap = null;
    private String rplName;
    private List<SeriesStatusInfo> viewStatus = new ArrayList<SeriesStatusInfo>();
    private SeriesStatusInfo workflowStatus = null;
    private long metabasePK = -1L;
    private List<UIDContainer.SOPInstanceUID> manuallyFetchedSops;
    private List<File> files = null;
    private boolean isTemporary = false;
    private transient DcmSeries remoteSourceForBurning;

    public DcmSeries(DicomObject dicomObject, q.e e2) {
        super(dicomObject);
        this.ownerIfSpawnedViaNewApi = e2;
    }

    public DcmSeries(Map<String, Object> map, q.e e2) {
        super(map);
        this.ownerIfSpawnedViaNewApi = e2;
    }

    public DcmSeries(DicomObject dicomObject) {
        this(dicomObject, null);
    }

    public DcmSeries(Map<String, Object> map) {
        this(map, null);
    }

    public void setFiles(List<File> list) {
        this.files = list;
    }

    public List<File> getFiles() {
        if (this.files == null) {
            return null;
        }
        return new ArrayList<File>(this.files);
    }

    public long getSizeInBytes() throws IOException {
        long l2 = 0L;
        if (this.files != null) {
            for (File file : this.files) {
                l2 += file.length();
            }
        } else {
            MIMFile mIMFile = new MIMFile(this.archiveDir);
            if (mIMFile.exists()) {
                Vector<File> vector = mIMFile.b();
                for (File file : vector) {
                    l2 += file.length();
                }
            } else {
                throw new IOException();
            }
        }
        return l2;
    }

    public void addFile(File file) {
        this.files.add(file);
    }

    public void setSearchSource(SearchSource searchSource) {
        this.source = searchSource;
        if (this.refSeries != null) {
            for (DcmSeriesReference dcmSeriesReference : this.refSeries.values()) {
                Set<DcmSeries> set = dcmSeriesReference.getReferencedDcmSeries();
                if (set == null) continue;
                for (DcmSeries dcmSeries : set) {
                    dcmSeries.setSearchSource(this.source);
                }
            }
        }
    }

    public void setOwnerIfSpawnedViaNewApi(q.e e2) {
        this.ownerIfSpawnedViaNewApi = e2;
    }

    public q.e getOwnerIfSpawnedViaNewApi() {
        return this.ownerIfSpawnedViaNewApi;
    }

    public void setRemoteSourceForBurning(DcmSeries dcmSeries) {
        this.remoteSourceForBurning = dcmSeries;
    }

    public DcmSeries getRemoteSourceForBurning() {
        return this.remoteSourceForBurning;
    }

    public SearchSource getSearchSource() {
        return this.source;
    }

    public DcmStudy getStudy() {
        return this.study;
    }

    public void setStudy(DcmStudy dcmStudy) {
        this.study = dcmStudy;
    }

    public int getEmbedIdx() {
        Map map = (Map)this.json.get("mimdata");
        if (map == null) {
            return -1;
        }
        return ((Number)map.get("embedIdx")).intValue();
    }

    public Long getEmbedParentId() {
        Map map = (Map)this.json.get("mimdata");
        if (map == null) {
            return null;
        }
        Object v2 = map.get("parentId");
        if (v2 != null) {
            return ((Number)v2).longValue();
        }
        return null;
    }

    public List<Long> getChildIds() {
        Map map = (Map)this.json.get("mimdata");
        if (map == null || !map.containsKey("childIds")) {
            return Lists.newArrayList();
        }
        ArrayList arrayList = Lists.newArrayList();
        for (Object t2 : (Iterable)map.get("childIds")) {
            arrayList.add(((Number)t2).longValue());
        }
        return arrayList;
    }

    public boolean isEmbedded() {
        if (this.json == null) {
            return false;
        }
        Map map = (Map)this.json.get("mimdata");
        return map != null && map.containsKey("embedIdx");
    }

    public void setArchiveDir(String string) {
        this.setArchiveDir(string, true);
    }

    public void setArchiveDir(String string, boolean bl2) {
        this.archiveDir = string;
        if (bl2) {
            this.numSeriesRelatedInstancesFromPath = Parser.getNumSeriesRelatedInstances(string);
        }
    }

    public String getRealParentDirectory() {
        String string = this.getArchiveDir();
        if (this.isEmbedded()) {
            int n2 = string.lastIndexOf(126);
            if (n2 < 0) {
                ay.c((Object)("Unexpected embedded archive dir string: " + string), this);
                return string;
            }
            return string.substring(0, n2);
        }
        return string;
    }

    public String getArchiveDir() {
        return this.archiveDir;
    }

    public void setNewlyReceived(Date date) {
        this.newlyReceived = date;
    }

    public void setRecentlyViewed(Date date) {
        this.recentlyViewed = date;
    }

    @Deprecated
    public void setNewlyReceived(String string) {
        Date date = null;
        try {
            date = this.format.parse(string);
        }
        catch (ParseException parseException) {
            ay.d((Object)"Error parsing newly received", (Throwable)parseException, this.getClass());
        }
        this.newlyReceived = date;
    }

    public Date getNewlyReceived() {
        try {
            if (this.newlyReceived == null) {
                JsonPath jsonPath = JsonPathUtil.normalize("mimdata.dateAdded");
                this.newlyReceived = (Date)this.getTagValue(jsonPath);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.newlyReceived;
    }

    @Deprecated
    public void setRecentlyViewed(String string) {
        Date date = null;
        try {
            date = this.format.parse(string);
        }
        catch (ParseException parseException) {
            ay.d((Object)"Error parsing recently viewed", (Throwable)parseException, this.getClass());
        }
        this.recentlyViewed = date;
    }

    public Date getRecentlyViewed() {
        return this.recentlyViewed;
    }

    public void setLastResortImageCount(int n2) {
        this.lastResortImageCount = n2;
    }

    public Integer getLastResortImageCount() {
        return this.lastResortImageCount;
    }

    public String getEqualityHash() {
        Map map = (Map)this.json.get("mimdata");
        if (map == null) {
            return null;
        }
        return (String)map.get("equalityHash");
    }

    public boolean equals(Object object) {
        boolean bl2;
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DcmSeries dcmSeries = (DcmSeries)object;
        boolean bl3 = !cn.h(this.archiveDir);
        boolean bl4 = bl2 = !cn.h(dcmSeries.archiveDir);
        if (bl3 && bl2) {
            return this.archiveDir.equals(dcmSeries.archiveDir);
        }
        if (bl3 != bl2) {
            return false;
        }
        String string = this.getSeriesInstanceUID();
        String string2 = dcmSeries.getSeriesInstanceUID();
        return string != null && string2 != null && string.equals(string2);
    }

    public int hashCode() {
        if (!cn.h(this.archiveDir)) {
            return this.archiveDir.hashCode();
        }
        String string = this.getSeriesInstanceUID();
        if (string != null) {
            return string.hashCode();
        }
        return System.identityHashCode(this);
    }

    public e getCloudStudyItem() {
        if (this.study != null) {
            return this.study.getCloudStudyItem();
        }
        return null;
    }

    public List<Object> getMimdataList(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map map = (Map)this.json.get("mimdata");
        if (map != null && map.containsKey(string)) {
            Collection collection = (Collection)map.get(string);
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public List<SeriesStatusInfo> getViewStatus() {
        if (this.viewStatus != null) {
            return Lists.newArrayList(this.viewStatus);
        }
        return null;
    }

    public List<String> getViewStatusNames() {
        List<SeriesStatusInfo> list = this.getViewStatus();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (SeriesStatusInfo seriesStatusInfo : list) {
            arrayList.add(seriesStatusInfo.getName());
        }
        return arrayList;
    }

    public SeriesStatusInfo getWorkflowStatus() {
        return this.workflowStatus;
    }

    public String getWorkflowStatusName() {
        if (this.getWorkflowStatus() == null) {
            return "";
        }
        return this.getWorkflowStatus().getName();
    }

    public boolean hasStatus(String string) {
        return this.getViewStatusNames().contains(string) || this.getWorkflowStatusName().equals(string);
    }

    public void setViewStatus(String string) {
        String[] stringArray;
        this.viewStatus.clear();
        if (string == null || "".equals(string)) {
            return;
        }
        for (String string2 : stringArray = string.split("~!~")) {
            SeriesStatusInfo seriesStatusInfo = new SeriesStatusInfo(string2);
            this.viewStatus.add(seriesStatusInfo);
        }
    }

    public void setViewStatus(List<SeriesStatusInfo> list) {
        this.viewStatus.clear();
        if (list == null) {
            return;
        }
        this.viewStatus.addAll(list);
    }

    public void setWorkflowStatus(String string) {
        SeriesStatusInfo seriesStatusInfo;
        this.workflowStatus = null;
        if (string == null || "".equals(string)) {
            return;
        }
        this.workflowStatus = seriesStatusInfo = new SeriesStatusInfo(string);
    }

    public void setWorkflowStatus(SeriesStatusInfo seriesStatusInfo) {
        this.workflowStatus = seriesStatusInfo;
    }

    public long getPrimaryKey() {
        return this.metabasePK;
    }

    public void setPrimaryKey(long l2) {
        this.metabasePK = l2;
    }

    public String getRplName() {
        String string = null;
        if (this.source != null) {
            string = this.source.x();
        }
        if (string != null) {
            return string;
        }
        return this.rplName;
    }

    public void setRplName(String string) {
        this.rplName = string;
    }

    public String getLocalDir() {
        return this.localDir;
    }

    public void setLocalDir(String string) {
        this.localDir = string;
    }

    public synchronized LoaderDataProvider getDataProvider() {
        LoaderDataProvider loaderDataProvider = this.dataProvider.get();
        if (loaderDataProvider == null) {
            loaderDataProvider = this.source != null ? this.source.d(this) : AppSearchSource.c(this);
            this.dataProvider.set(loaderDataProvider);
        }
        return loaderDataProvider;
    }

    @Deprecated
    public AtomicLoadUnit.DataProviderWrapper _getDataProviderRef() {
        return this.dataProvider;
    }

    @Override
    public String getPatientName() {
        String string = (String)this.getTagValue(0x100010);
        if (this.study != null && cn.g(string)) {
            string = this.study.getStringProperty(0x100010);
        }
        return string;
    }

    public String getPatientBirthdate() {
        SeriesInfo seriesInfo;
        String string = DateUtils.a((Date)this.getTagValue(0x100030));
        if (string == null && (seriesInfo = this.getDataProvider().getUncopiedMutableInfoIfAlreadyLoaded()) != null) {
            string = seriesInfo.birthDate;
        }
        return string;
    }

    public String getSeriesInstanceUID() {
        return (String)this.getTagValue(0x20000E);
    }

    public String getOneOfMySOPInstanceUIDs() {
        Iterable iterable;
        String string = (String)this.getTagValue(524312);
        if (!cn.h(string)) {
            return string;
        }
        Map map = (Map)this.json.get("mimdata");
        if (map != null && (iterable = (Iterable)map.get("sopInstanceUids")) != null) {
            for (Object t2 : iterable) {
                if (t2 == null) continue;
                return t2.toString();
            }
        }
        return null;
    }

    @d
    public List<UIDContainer.SOPInstanceUID> getAllSopInstanceUids() {
        Iterable iterable;
        Map map = (Map)this.json.get("mimdata");
        if (map != null && (iterable = (Iterable)map.get("sopInstanceUids")) != null) {
            ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)Iterables.size((Iterable)iterable));
            for (Object t2 : iterable) {
                if (t2 == null) continue;
                arrayList.add(new UIDContainer.SOPInstanceUID(t2.toString()));
            }
            Collections.sort(arrayList);
            return arrayList;
        }
        if (this.manuallyFetchedSops != null) {
            return Lists.newArrayList(this.manuallyFetchedSops);
        }
        return null;
    }

    public List<UIDContainer.SOPInstanceUID> getAllSopInstanceUidsImWillingToWait() {
        List<UIDContainer.SOPInstanceUID> list = this.getAllSopInstanceUids();
        if (list != null) {
            return list;
        }
        ay.c((Object)"No SOP info available; falling back to slow streaming method.", this);
        LoaderDataProvider loaderDataProvider = this.getDataProvider();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : loaderDataProvider.getFilenames()) {
            DicomObject dicomObject = DicomReader.readStreamIntoDicomObject(loaderDataProvider.getStream(string), 524313);
            if (dicomObject == null) continue;
            String string2 = dicomObject.getString(524312, "");
            arrayList.add(new UIDContainer.SOPInstanceUID(string2));
        }
        this.manuallyFetchedSops = Lists.newArrayList((Iterable)arrayList);
        return arrayList;
    }

    public String getFrameOfReferenceUID() {
        return (String)this.getTagValue(0x200052);
    }

    @Override
    public String getPatientID() {
        String string = (String)this.getTagValue(0x100020);
        if (this.study != null && (string == null || "".equals(string))) {
            string = this.study.getStringProperty(0x100020);
        }
        return string;
    }

    @Override
    public String getModality() {
        return this.getDisplayModality();
    }

    public String getActualModality() {
        Object t2 = this.getTagValue(524384);
        if (t2 == null) {
            return "";
        }
        return t2.toString();
    }

    public String getDisplayModality() {
        String string = this.getActualModality();
        if (Modality.RTST.isSameModality(string)) {
            return "RTst";
        }
        if (this.isSession()) {
            return "SESSION";
        }
        if (this.isBxPlan()) {
            return "BXplan";
        }
        if (!cn.h(cn.a(this.getTagValue(930291986), "")) || Modality.RAW.isSameModality(string) && this.getTagValue(930283796) != null) {
            return "BXplan";
        }
        return string;
    }

    public boolean isBxPlan() {
        return Modality.RAW.isSameModality(this.getActualModality()) && this.getTagValue(930291986) != null;
    }

    public boolean isSession() {
        return Modality.RAW.isSameModality(this.getActualModality()) && this.getTagValue(1253424) != null;
    }

    @Override
    public String getNumberOfImages() {
        String string;
        Object t2 = this.getTagValue(1253536);
        if (t2 != null && Integer.valueOf(string = String.valueOf(t2)) > 0) {
            return string;
        }
        if (this.numSeriesRelatedInstancesFromPath > 0) {
            return Integer.toString(this.numSeriesRelatedInstancesFromPath);
        }
        string = this.getTagValue(2101769);
        if (string != null) {
            return String.valueOf(string);
        }
        if (this.lastResortImageCount != null) {
            return String.valueOf(this.lastResortImageCount);
        }
        return "";
    }

    public Date getDisplayDate() {
        return this.getDisplayDateTag("searchDate", 524321, 524320, 805699592, 805961734, 524322, 524306);
    }

    public Date getDisplayTime() {
        return this.getDisplayDateTag("searchTime", 524338, 524337, 524336, 805699593, 805961735, 524307);
    }

    private Date getDisplayDateTag(String string, int ... nArray) {
        Date date = (Date)DicomSeriesStatic.findFirst((DicomSeries)this, nArray);
        if (date != null) {
            return date;
        }
        try {
            Map map = (Map)this.json.get("mimdata");
            date = (Date)map.get(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return date;
    }

    @Override
    public String getDate() {
        return DateUtils.a(this.getSeriesOrStudyDateTime(true));
    }

    @Override
    public Date getDateTime() {
        Date date = this.getDisplayDate();
        Date date2 = this.getDisplayTime();
        if (date == null) {
            return null;
        }
        long l2 = date.getTime();
        if (date2 != null) {
            l2 += date2.getTime();
        }
        return new Date(l2);
    }

    @d
    public Date getSeriesOrStudyDateTime(boolean bl2) {
        if (bl2) {
            return DicomSeriesStatic.findFirstDateTime((DicomSeries)this, 524321, 524320);
        }
        return DicomSeriesStatic.findFirstDateTime((DicomSeries)this, 524320, 524321);
    }

    @Override
    public String getSeriesDescription() {
        return (String)this.getTagValue(528446);
    }

    @Override
    public String getStudyDescription() {
        String string = (String)this.getTagValue(528432);
        if (this.study != null && string == null) {
            string = this.study.getStringProperty(528432);
        }
        return string;
    }

    @Override
    public <T> T getTagValue(int n2) {
        Object t2 = super.getTagValue(n2);
        if (t2 != null) {
            return t2;
        }
        if (n2 == 524320 && this.study != null) {
            return (T)this.study.getStudyDateFromFolderPath();
        }
        return null;
    }

    @Override
    public <T> ImmutableList<T> getTagValues(int n2) {
        Date date;
        ImmutableList immutableList = super.getTagValues(n2);
        if (immutableList.isEmpty() && n2 == 524320 && this.study != null && (date = this.study.getStudyDateFromFolderPath()) != null) {
            return ImmutableList.of((Object)date);
        }
        return immutableList;
    }

    @Override
    @Deprecated
    public boolean is2D() {
        return false;
    }

    public String getSeriesNumber() {
        return (String)this.getTagValue(0x200011);
    }

    @Override
    public String getTime() {
        Date date = this.getDisplayTime();
        if (date == null) {
            return null;
        }
        return DateUtils.e(date);
    }

    public void setRtPlanMap(HashMap<String, String> hashMap) {
        this.rtPlanMap = hashMap;
    }

    public HashMap<String, String> getRtPlanMap() {
        if (this.rtPlanMap == null) {
            return null;
        }
        return new HashMap<String, String>(this.rtPlanMap);
    }

    @Override
    public String getWorkflowDisplayName() {
        return "";
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean bl2) {
        this.isTemporary = bl2;
    }

    public String getIdentifier() {
        if (this.source == null) {
            return null;
        }
        if (this.source.I() == 1) {
            return this.getLocalDir();
        }
        if (this.source.I() == 2) {
            if (this.metabasePK > -1L) {
                return String.valueOf(this.metabasePK);
            }
            return this.getArchiveDir();
        }
        return null;
    }

    @Override
    public DcmSeries clone() {
        return (DcmSeries)super.clone();
    }

    public DcmSeries duplicate() {
        DcmSeries dcmSeries = this.clone();
        return dcmSeries;
    }

    @Override
    public String toString() {
        return "[" + this.getModality() + " seriesUID: " + this.getSeriesInstanceUID() + "]";
    }

    @Deprecated
    public void setDataProvider(LoaderDataProvider loaderDataProvider) {
        this.dataProvider.set(loaderDataProvider);
    }

    @Deprecated
    public void clearDataProvider() {
        this.dataProvider.set(null);
    }

    public static void removeAll(List<DcmSeries> list, List<DcmSeries> list2) {
        block0: for (DcmSeries dcmSeries : list2) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2) != dcmSeries) continue;
                list.remove(i2);
                continue block0;
            }
        }
    }

    public void setCloudSeriesItem(com.mimvista.cloud.crypto.common.a.d d2) {
        this.cloudSeriesItem = d2;
        try {
            this.numSeriesRelatedInstancesFromPath = d2.a().getDecryptedDetails().e();
        }
        catch (NullPointerException nullPointerException) {
            this.numSeriesRelatedInstancesFromPath = 1;
        }
    }

    public com.mimvista.cloud.crypto.common.a.d getCloudSeriesItem() {
        return this.cloudSeriesItem;
    }

    @d
    public Multimap<DcmSeriesReference.ReferenceSource, DcmSeriesReference> getReferencedSeries() {
        return this.refSeries == null ? null : LinkedHashMultimap.create(this.refSeries);
    }

    public void setReferencedSeries(Multimap<DcmSeriesReference.ReferenceSource, DcmSeriesReference> multimap) {
        this.refSeries = multimap;
    }

    @Override
    public DicomSeries getDicomSeries() {
        return this;
    }

    @Override
    public SeriesGroup asSeriesGroup() {
        return new SeriesGroup(this);
    }

    @d
    public DcmSeries getSopInstance(String string) {
        Preconditions.checkNotNull((Object)string);
        if (string.equals(this.getTagValue(524312))) {
            return this.createSingleSopSeries(string, Collections.<String, Object>emptyMap());
        }
        if (!this.json.containsKey("mimdata")) {
            return null;
        }
        Map map = (Map)this.json.get("mimdata");
        if (!map.containsKey("sopInstanceUids")) {
            return null;
        }
        Iterable iterable = (Iterable)map.get("sopInstanceUids");
        if (!Iterables.contains((Iterable)iterable, (Object)string)) {
            return null;
        }
        if (!map.containsKey("sops")) {
            return this.createSingleSopSeries(string, Collections.<String, Object>emptyMap());
        }
        String string2 = MetabaseKeys.fromTag(524312);
        Iterable iterable2 = (Iterable)map.get("sops");
        for (Map map2 : iterable2) {
            if (!string.equals(map2.get(string2))) continue;
            return this.createSingleSopSeries(string, map2);
        }
        return null;
    }

    private DcmSeries createSingleSopSeries(String string, Map<String, Object> map) {
        MutableMapView<String, Object> mutableMapView = MutableMapView.a(this.json);
        mutableMapView.putAll(map);
        mutableMapView.put(MetabaseKeys.fromTag(524312), string);
        MutableMapView<String, Object> mutableMapView2 = MutableMapView.a((Map)this.json.get("mimdata"));
        mutableMapView2.remove("sops");
        String string2 = (String)mutableMapView.get(MetabaseKeys.fromTag(524312));
        mutableMapView2.put("sopInstanceUids", Lists.newArrayList((Object[])new String[]{string2}));
        mutableMapView2.put("sopCount", 1);
        mutableMapView2.put("equalityHash", SeriesEqualityHasher.hashSopUidStrings(Lists.newArrayList((Object[])new String[]{string})).toString());
        mutableMapView.put("mimdata", mutableMapView2);
        DcmSeries dcmSeries = new DcmSeries(mutableMapView);
        dcmSeries.setSearchSource(this.getSearchSource());
        dcmSeries.setArchiveDir(this.getArchiveDir());
        dcmSeries.setLocalDir(this.getLocalDir());
        dcmSeries.setPrimaryKey(this.getPrimaryKey());
        dcmSeries.setViewStatus(this.getViewStatus());
        dcmSeries.setWorkflowStatus(this.getWorkflowStatus());
        return dcmSeries;
    }

    public UniqueSeriesPointer getUniqueSeriesPointer() {
        return new UniqueSeriesPointer(this.getSeriesInstanceUID(), this.getEqualityHash());
    }

    public static final class PlansAsFirstRTFunction<SeriesType extends g>
    implements Function<SeriesType, String> {
        public String apply(SeriesType SeriesType) {
            String string = SeriesType.getModality();
            if (string.toLowerCase().startsWith("rt") && !Modality.RTPLAN.isSameModality(string)) {
                return Modality.RTPLAN.get() + "zzzzzzzz";
            }
            return string;
        }
    }
}

