/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.mimvista.dicom.DcmSeries;
import com.mimvista.util.cn;
import java.util.Comparator;

public final class DcmSeriesDateComparator
implements Comparator<DcmSeries> {
    private final boolean useInstanceDateTime;

    public DcmSeriesDateComparator(boolean bl2) {
        this.useInstanceDateTime = bl2;
    }

    @Override
    public int compare(DcmSeries dcmSeries, DcmSeries dcmSeries2) {
        int n2 = this.getRank(dcmSeries);
        int n3 = this.getRank(dcmSeries2);
        if (n2 == 1 && n3 == 1) {
            int n4 = this.compareDate(dcmSeries, dcmSeries2);
            if (n4 != 0) {
                return n4;
            }
            int n5 = this.compare(dcmSeries, dcmSeries2, 524337);
            if (n5 != 0) {
                return n5;
            }
            if (this.useInstanceDateTime) {
                int n6 = this.compare(dcmSeries, dcmSeries2, 524306);
                if (n6 == 0) {
                    int n7 = this.compare(dcmSeries, dcmSeries2, 524307);
                    return n7;
                }
                return n6;
            }
            return 0;
        }
        return n2 - n3;
    }

    private int compareDate(DcmSeries dcmSeries, DcmSeries dcmSeries2) {
        String string = cn.i(dcmSeries.getDate());
        String string2 = cn.i(dcmSeries2.getDate());
        return string.compareTo(string2);
    }

    private int compareTime(DcmSeries dcmSeries, DcmSeries dcmSeries2) {
        return this.compare(dcmSeries, dcmSeries2, 524337);
    }

    private int getRank(DcmSeries dcmSeries) {
        if (dcmSeries == null) {
            return 4;
        }
        if (dcmSeries.getDate() == null) {
            return 3;
        }
        if (cn.h(dcmSeries.getDate())) {
            return 2;
        }
        return 1;
    }

    private int compare(DcmSeries dcmSeries, DcmSeries dcmSeries2, int n2) {
        String string = this.lookupValue(dcmSeries, n2);
        String string2 = this.lookupValue(dcmSeries2, n2);
        return string.compareTo(string2);
    }

    private String lookupValue(DcmSeries dcmSeries, int n2) {
        if (dcmSeries == null || dcmSeries.getDataProvider() == null) {
            return "";
        }
        String string = dcmSeries.getDataProvider().getValueForDicomTag(n2);
        return cn.i(string);
    }
}

