/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mimvista.dicom.DcmSeries;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class DcmSeriesReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<DcmSeries> resolvedRef = Sets.newHashSet();
    private Map<ReferenceUidType, String> refs = Maps.newHashMap();
    private ReferenceSource source = null;
    private boolean searched = false;

    public static Multimap<ReferenceSource, DcmSeriesReference> extractSeriesReferences(DicomObject dicomObject) {
        Object object;
        DicomObject dicomObject2;
        int n2;
        DicomElement dicomElement;
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        DcmSeriesReference.handleSOPInstanceSequence(dicomObject, ReferenceSource.ReferencedStructureSetSequence, (Multimap<ReferenceSource, DcmSeriesReference>)linkedHashMultimap);
        DcmSeriesReference.handleSOPInstanceSequence(dicomObject, ReferenceSource.ReferencedRTPlanSequence, (Multimap<ReferenceSource, DcmSeriesReference>)linkedHashMultimap);
        DcmSeriesReference.handleSOPInstanceSequence(dicomObject, ReferenceSource.ReferencedDoseSequence, (Multimap<ReferenceSource, DcmSeriesReference>)linkedHashMultimap);
        DcmSeriesReference.handleReferencedFrameOfReferenceSequence(dicomObject, (Multimap<ReferenceSource, DcmSeriesReference>)linkedHashMultimap);
        if (dicomObject.contains(930283796)) {
            dicomElement = dicomObject.get(930283796);
            for (n2 = 0; n2 < dicomElement.countItems(); ++n2) {
                dicomObject2 = dicomElement.getDicomObject(n2);
                if (!dicomObject2.contains(806092896)) continue;
                object = dicomObject2.get(806092896);
                DcmSeriesReference.handleSOPInstanceSequence((DicomElement)object, ReferenceSource.ReferencedStructureSetSequence, (Multimap<ReferenceSource, DcmSeriesReference>)linkedHashMultimap);
            }
        }
        if (dicomObject.contains(528661)) {
            dicomElement = dicomObject.get(528661);
            for (n2 = 0; n2 < dicomElement.countItems(); ++n2) {
                dicomObject2 = dicomElement.getDicomObject(n2);
                if (!dicomObject2.contains(0x20000E) || (object = dicomObject2.getString(0x20000E, (String)null)) == null || ((String)object).isEmpty()) continue;
                linkedHashMultimap.put((Object)ReferenceSource.ReferencedSeriesSequence, (Object)new DcmSeriesReference(ReferenceSource.ReferencedSeriesSequence, ReferenceUidType.SeriesInstanceUID, (String)object));
            }
        }
        return linkedHashMultimap;
    }

    private static void handleSOPInstanceSequence(DicomObject dicomObject, ReferenceSource referenceSource, Multimap<ReferenceSource, DcmSeriesReference> multimap) {
        if (dicomObject.contains(referenceSource.getSequenceTag())) {
            DicomElement dicomElement = dicomObject.get(referenceSource.getSequenceTag());
            DcmSeriesReference.handleSOPInstanceSequence(dicomElement, referenceSource, multimap);
        }
    }

    private static void handleSOPInstanceSequence(DicomElement dicomElement, ReferenceSource referenceSource, Multimap<ReferenceSource, DcmSeriesReference> multimap) {
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            String string;
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            if (!dicomObject.contains(528725) || (string = dicomObject.getString(528725, (String)null)) == null || string.isEmpty()) continue;
            multimap.put((Object)referenceSource, (Object)new DcmSeriesReference(referenceSource, ReferenceUidType.SOPInstanceUID, string));
        }
    }

    private static void handleReferencedFrameOfReferenceSequence(DicomObject dicomObject, Multimap<ReferenceSource, DcmSeriesReference> multimap) {
        if (dicomObject.contains(805699600)) {
            DicomElement dicomElement = dicomObject.get(805699600);
            for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                String string = null;
                if (dicomObject2.contains(0x200052)) {
                    string = dicomObject2.getString(0x200052, (String)null);
                }
                if (!dicomObject2.contains(805699602)) continue;
                DicomElement dicomElement2 = dicomObject2.get(805699602);
                for (int i3 = 0; i3 < dicomElement2.countItems(); ++i3) {
                    DicomObject dicomObject3 = dicomElement2.getDicomObject(i3);
                    if (!dicomObject3.contains(805699604)) continue;
                    DicomElement dicomElement3 = dicomObject3.get(805699604);
                    for (int i4 = 0; i4 < dicomElement3.countItems(); ++i4) {
                        String string2;
                        DicomObject dicomObject4 = dicomElement3.getDicomObject(i4);
                        if (!dicomObject4.contains(0x20000E) || (string2 = dicomObject4.getString(0x20000E, (String)null)) == null || string2.isEmpty()) continue;
                        HashMap hashMap = Maps.newHashMap();
                        hashMap.put(ReferenceUidType.SeriesInstanceUID, string2);
                        if (string != null && !string.isEmpty()) {
                            hashMap.put(ReferenceUidType.FrameOfReferenceUID, string);
                        }
                        multimap.put((Object)ReferenceSource.ReferencedFrameOfReferenceSequence, (Object)new DcmSeriesReference(ReferenceSource.ReferencedFrameOfReferenceSequence, hashMap));
                    }
                }
            }
        }
    }

    public DcmSeriesReference() {
    }

    public DcmSeriesReference(ReferenceSource referenceSource) {
        this.source = referenceSource;
    }

    public DcmSeriesReference(ReferenceSource referenceSource, ReferenceUidType referenceUidType, String string) {
        this.source = referenceSource;
        this.refs.put(referenceUidType, string);
    }

    public DcmSeriesReference(ReferenceSource referenceSource, Map<ReferenceUidType, String> map) {
        this.source = referenceSource;
        this.refs.putAll(map);
    }

    public void setSource(ReferenceSource referenceSource) {
        this.source = referenceSource;
    }

    public ReferenceSource getSource() {
        return this.source;
    }

    public void addReference(ReferenceUidType referenceUidType, String string) {
        this.refs.put(referenceUidType, string);
    }

    public Map<ReferenceUidType, String> getReferences() {
        return Maps.newHashMap(this.refs);
    }

    public boolean wasSearched() {
        return this.searched;
    }

    public Set<DcmSeries> getReferencedDcmSeries() {
        return Sets.newHashSet(this.resolvedRef);
    }

    public void setReferencedDcmSeries(Collection<? extends DcmSeries> collection) {
        this.resolvedRef.clear();
        this.resolvedRef.addAll(collection);
        this.searched = true;
    }

    public void addReferencedDcmSeries(DcmSeries dcmSeries) {
        this.resolvedRef.add(dcmSeries);
        this.searched = true;
    }

    public String toString() {
        return String.valueOf(this.refs);
    }

    public static enum ReferenceSource {
        ReferencedStructureSetSequence(806092896),
        ReferencedRTPlanSequence(806092802),
        ReferencedDoseSequence(806092928),
        ReferencedFrameOfReferenceSequence(805699600),
        ReferencedSeriesSequence(528661),
        SCORIS(528896),
        DocAndSRDerivedSeries(1245186),
        MimdataSpecialTag(0),
        ReferencedImageSequence(528704);

        private int tag;

        private ReferenceSource(int n3) {
            this.tag = n3;
        }

        public int getSequenceTag() {
            return this.tag;
        }
    }

    public static enum ReferenceUidType {
        SeriesInstanceUID,
        SOPInstanceUID,
        FrameOfReferenceUID;


        public static ReferenceUidType fromTag(int n2) {
            switch (n2) {
                case 0x20000E: {
                    return SeriesInstanceUID;
                }
                case 524312: {
                    return SOPInstanceUID;
                }
                case 0x200052: {
                    return FrameOfReferenceUID;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

