/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.NameFormatter;
import com.mimvista.cloud.crypto.common.a.e;
import com.mimvista.d;
import com.mimvista.dicom.BasicDcmStudyGrouping;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmStudyGrouping;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DcmStudy
implements Serializable,
Iterable<DcmSeries> {
    private static final long serialVersionUID = 3390500223125260833L;
    private TreeMap<Integer, String> fields = new TreeMap();
    private String formattedName = "";
    private List<DcmSeries> series = Lists.newArrayList();
    private e cloudStudyItem;
    private boolean cloudUndecryptable;
    private DcmStudyGrouping grouping = null;

    public static DcmStudy shallowCopy(DcmStudy dcmStudy) {
        DcmStudy dcmStudy2 = new DcmStudy();
        dcmStudy2.fields = dcmStudy.fields;
        dcmStudy2.formattedName = dcmStudy.formattedName;
        dcmStudy2.series = dcmStudy.series;
        dcmStudy2.cloudStudyItem = dcmStudy.cloudStudyItem;
        dcmStudy2.cloudUndecryptable = dcmStudy.cloudUndecryptable;
        return dcmStudy2;
    }

    public String getStringProperty(Integer n2) {
        if (this.fields.get(n2) != null) {
            return this.fields.get(n2);
        }
        return "";
    }

    public void setStringProperty(Integer n2, String string) {
        this.fields.put(n2, string);
        if (n2 == 0x100010) {
            this.setFormattedName(NameFormatter.a(string));
        }
    }

    @d
    public Date getStudyDate() {
        Date date = null;
        for (DcmSeries dcmSeries : this.series) {
            date = (Date)dcmSeries.getTagValue(524320);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    @d
    public Date getStudyDateFromFolderPath() {
        return DateUtils.i(this.getStringProperty(524320));
    }

    public void addSeries(DcmSeries dcmSeries) {
        String string = dcmSeries.getModality();
        if (this.getStringProperty(524385).indexOf(string) == -1) {
            this.setStringProperty(524385, this.getStringProperty(524385) + " " + string + " ");
        }
        this.series.add(dcmSeries);
    }

    public e getCloudStudyItem() {
        return this.cloudStudyItem;
    }

    public void setCloudStudyItem(e e2) {
        this.cloudStudyItem = e2;
    }

    public List<DcmSeries> getSeries() {
        return this.series;
    }

    public void setSeries(List<DcmSeries> list) {
        this.setStringProperty(524385, "");
        this.series = new ArrayList<DcmSeries>();
        for (DcmSeries dcmSeries : list) {
            this.addSeries(dcmSeries);
        }
    }

    public DcmSeries getSeries(int n2) {
        return this.series.get(n2);
    }

    public void setGrouping(DcmStudyGrouping dcmStudyGrouping) {
        this.grouping = dcmStudyGrouping;
    }

    public DcmStudyGrouping getGrouping() {
        if (this.grouping == null) {
            BasicDcmStudyGrouping.StudyInstanceUIDGrouping studyInstanceUIDGrouping = new BasicDcmStudyGrouping.StudyInstanceUIDGrouping();
            studyInstanceUIDGrouping.prepare(this);
            this.setGrouping(studyInstanceUIDGrouping);
        }
        return this.grouping;
    }

    public String getFormattedName() {
        return this.formattedName;
    }

    public void setFormattedName(String string) {
        this.formattedName = string;
    }

    public boolean equals(Object object) {
        if (object instanceof DcmStudy) {
            return this.getGrouping().equals(((DcmStudy)object).getGrouping());
        }
        return false;
    }

    public int hashCode() {
        return this.getGrouping().hashCode();
    }

    @d
    public static Date getDateAndTimeFromSeries(DcmSeries dcmSeries, DcmStudy dcmStudy) {
        Date date = dcmSeries.getSeriesOrStudyDateTime(true);
        if (date == null) {
            return null;
        }
        try {
            boolean bl2 = true;
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(Pair.get(new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM-ddHH-mm-ss")));
            arrayList.add(Pair.get(new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyyMMddHHmmss")));
            for (Pair pair : arrayList) {
                String string = ((SimpleDateFormat)pair.x).format(date);
                boolean bl3 = ArchivePrefs.useSeriesDateAndTime.getValue();
                string = string + DcmStudy.getStringTimeFromSeriesAndStudyLeaveFormatAlone(dcmSeries, dcmStudy, bl3);
                if (cn.h(dcmSeries.getTime())) continue;
                try {
                    date = ((SimpleDateFormat)pair.y).parse(string);
                    bl2 = true;
                    break;
                }
                catch (ParseException parseException) {
                }
            }
            if (!bl2) {
                ay.d((Object)("Could not parse date for/time series " + dcmSeries.getArchiveDir()), dcmSeries);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)("Could not parse date for/time series, time is busted " + dcmSeries.getArchiveDir()), dcmSeries);
        }
        return date;
    }

    public static String getStringTimeFromSeriesAndStudy(DcmSeries dcmSeries, DcmStudy dcmStudy) {
        boolean bl2 = ArchivePrefs.useSeriesDateAndTime.getValue();
        return DcmStudy.getStringTimeFromSeriesAndStudy(dcmSeries, dcmStudy, bl2);
    }

    public static String getStringTimeFromSeriesAndStudy(DcmSeries dcmSeries, DcmStudy dcmStudy, boolean bl2) {
        String string = DcmStudy.getStringTimeFromSeriesAndStudyLeaveFormatAlone(dcmSeries, dcmStudy, bl2);
        return DateUtils.a(string, "HHmmss", "HH:mm:ss");
    }

    public static String getStringTimeFromSeriesAndStudyLeaveFormatAlone(DcmSeries dcmSeries, DcmStudy dcmStudy, boolean bl2) {
        Date date = (Date)dcmSeries.getTagValue(524338);
        if (date == null) {
            if (bl2) {
                date = (Date)dcmSeries.getTagValue(524337);
            }
            if (date == null) {
                return dcmStudy.getStringProperty(524336);
            }
        }
        return DateUtils.a(date, "HH:mm:ss");
    }

    public String getStudyInstanceUID() {
        return this.getStringProperty(0x20000D);
    }

    public String getPatientName() {
        return this.getStringProperty(0x100010);
    }

    public String getPatientID() {
        if (this.series.isEmpty()) {
            return null;
        }
        return this.series.get(0).getPatientID();
    }

    public Map<String, Integer> getModalityCounts() {
        HashMap hashMap = Maps.newHashMap();
        for (DcmSeries dcmSeries : this.series) {
            String string = dcmSeries.getModality();
            Integer n2 = (Integer)hashMap.get(string);
            if (n2 == null) {
                hashMap.put(string, 1);
                continue;
            }
            hashMap.put(string, n2 + 1);
        }
        return hashMap;
    }

    @Override
    public Iterator<DcmSeries> iterator() {
        return this.series.iterator();
    }

    public void setUnDecryptableCloudStudy(boolean bl2) {
        this.cloudUndecryptable = bl2;
    }

    public boolean isUnDecryptableCloudStudy() {
        return this.cloudUndecryptable;
    }
}

