/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

public class DicomColorUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/ColorUtilities.java,v 1.2 2013/10/05 15:54:37 dclunie Exp $";

    private DicomColorUtilities() {
    }

    public static int[] getIntegerScaledCIELabFromCIELab(float[] fArray) {
        int[] nArray = new int[]{Math.round(fArray[0] * 65535.0f / 100.0f), Math.round((fArray[1] + 128.0f) * 65535.0f / 255.0f), Math.round((fArray[2] + 128.0f) * 65535.0f / 255.0f)};
        return nArray;
    }

    public static float[] getCIELabPCSFromIntegerScaledCIELabPCS(int[] nArray) {
        float[] fArray = new float[]{(float)((double)nArray[0] / 65535.0 * 100.0), (float)((double)nArray[1] / 65535.0 * 255.0 - 128.0), (float)((double)nArray[2] / 65535.0 * 255.0 - 128.0)};
        return fArray;
    }

    public static float[] getCIELabFromXYZ(float[] fArray) {
        double d2 = (double)fArray[0] / 95.047;
        double d3 = (double)fArray[1] / 100.0;
        double d4 = (double)fArray[2] / 108.883;
        d2 = d2 > 0.008856 ? Math.pow(d2, 0.3333333333333333) : 7.787 * d2 + 0.13793103448275862;
        d3 = d3 > 0.008856 ? Math.pow(d3, 0.3333333333333333) : 7.787 * d3 + 0.13793103448275862;
        d4 = d4 > 0.008856 ? Math.pow(d4, 0.3333333333333333) : 7.787 * d4 + 0.13793103448275862;
        float[] fArray2 = new float[]{(float)(116.0 * d3 - 16.0), (float)(500.0 * (d2 - d3)), (float)(200.0 * (d3 - d4))};
        return fArray2;
    }

    public static float[] getCIEXYZFromLAB(float[] fArray) {
        double d2 = (fArray[0] + 16.0f) / 116.0f;
        double d3 = (double)(fArray[1] / 500.0f) + d2;
        double d4 = d2 - (double)(fArray[2] / 200.0f);
        double d5 = Math.pow(d2, 3.0);
        double d6 = Math.pow(d3, 3.0);
        double d7 = Math.pow(d4, 3.0);
        d2 = d5 > 0.008856 ? d5 : (d2 - 0.13793103448275862) / 7.787;
        d3 = d6 > 0.008856 ? d6 : (d3 - 0.13793103448275862) / 7.787;
        d4 = d7 > 0.008856 ? d7 : (d4 - 0.13793103448275862) / 7.787;
        float[] fArray2 = new float[]{(float)(95.047 * d3), (float)(100.0 * d2), (float)(108.883 * d4)};
        return fArray2;
    }

    public static float[] getCIEXYZPCSFromSRGB(int[] nArray) {
        double d2 = (double)nArray[0] / 255.0;
        double d3 = (double)nArray[1] / 255.0;
        double d4 = (double)nArray[2] / 255.0;
        d2 = d2 > 0.04045 ? Math.pow((d2 + 0.055) / 1.055, 2.4) : (d2 /= 12.92);
        d3 = d3 > 0.04045 ? Math.pow((d3 + 0.055) / 1.055, 2.4) : (d3 /= 12.92);
        d4 = d4 > 0.04045 ? Math.pow((d4 + 0.055) / 1.055, 2.4) : (d4 /= 12.92);
        float[] fArray = new float[]{(float)((d2 *= 100.0) * 0.4124 + (d3 *= 100.0) * 0.3576 + (d4 *= 100.0) * 0.1805), (float)(d2 * 0.2126 + d3 * 0.7152 + d4 * 0.0722), (float)(d2 * 0.0193 + d3 * 0.1192 + d4 * 0.9505)};
        return fArray;
    }

    public static int[] getSRGBFromCIEXYZPCS(float[] fArray) {
        double d2 = fArray[0] / 100.0f;
        double d3 = fArray[1] / 100.0f;
        double d4 = fArray[2] / 100.0f;
        double d5 = d2 * 3.2406 + d3 * -1.5372 + d4 * -0.4986;
        double d6 = d2 * -0.9689 + d3 * 1.8758 + d4 * 0.0415;
        double d7 = d2 * 0.0557 + d3 * -0.204 + d4 * 1.057;
        d5 = d5 > 0.0031308 ? 1.055 * Math.pow(d5, 0.4166666666666667) - 0.055 : 12.92 * d5;
        d6 = d6 > 0.0031308 ? 1.055 * Math.pow(d6, 0.4166666666666667) - 0.055 : 12.92 * d6;
        d7 = d7 > 0.0031308 ? 1.055 * Math.pow(d7, 0.4166666666666667) - 0.055 : 12.92 * d7;
        int[] nArray = new int[]{(int)Math.round(d5 * 255.0), (int)Math.round(d6 * 255.0), (int)Math.round(d7 * 255.0)};
        return nArray;
    }

    public static float[] getCIELabPCSFromSRGB(int[] nArray) {
        return DicomColorUtilities.getCIELabFromXYZ(DicomColorUtilities.getCIEXYZPCSFromSRGB(nArray));
    }

    public static int[] getIntegerScaledCIELabPCSFromSRGB(int[] nArray) {
        return DicomColorUtilities.getIntegerScaledCIELabFromCIELab(DicomColorUtilities.getCIELabPCSFromSRGB(nArray));
    }

    public static int[] getSRGBFromCIELabPCS(float[] fArray) {
        return DicomColorUtilities.getSRGBFromCIEXYZPCS(DicomColorUtilities.getCIEXYZFromLAB(fArray));
    }

    public static int[] getSRGBFromIntegerScaledCIELabPCS(int[] nArray) {
        return DicomColorUtilities.getSRGBFromCIELabPCS(DicomColorUtilities.getCIELabPCSFromIntegerScaledCIELabPCS(nArray));
    }
}

