/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.mimvista.archive.Archiver;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.remote.RemoteQueryServer;
import com.mimvista.archive.remote.c.e;
import com.mimvista.archive.search.AbstractRemoteSearchSource;
import com.mimvista.archive.search.DicomSearchSource;
import com.mimvista.archive.search.FolderSearchSource;
import com.mimvista.archive.search.ImportSearchSource;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DicomTestJDialog;
import com.mimvista.dicom.MIMDcmUrl;
import com.mimvista.dicom.config.DcmConfigReader;
import com.mimvista.dicom.gui.DcmPullTransfer;
import com.mimvista.dicom.gui.DcmPushTransfer;
import com.mimvista.gui.a.b;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.metabase.s;
import com.mimvista.mimcloud.MIMcloudSearchSource;
import com.mimvista.mimcloud.g;
import com.mimvista.mui.ak;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.properties.Property;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class DicomDestination
extends SendToDestination {
    public static Messages props = Messages.a("Dicom");
    private DicomLocationsPrefs.a dcmLoc;
    private boolean shouldDelete = false;

    public DicomDestination() {
        this.name = "New Destination";
        this.dcmLoc = new DicomLocationsPrefs.a();
        this.dcmLoc.setDescription(this.name);
        this.dcmLoc.setAllowSend(true);
    }

    public DicomDestination(DicomLocationsPrefs.a a2) {
        this.name = a2.getDescription();
        this.dcmLoc = a2;
        this.setDescription(a2.getDescription());
        this.setHostname(a2.getHost());
        this.setPort(a2.getPort());
        this.setAeTitle(a2.getAeTitle());
        this.setAllowQuery(a2.isAllowQuery());
        this.setIsMITRAReportQueryable(a2.isAllowMitraReportQuery());
        this.setUseSpecificCharacterSet(a2.isUseSpecificCharacterSet());
        boolean bl2 = a2.isAllowSend();
        this.setAllowSend(bl2);
        if (bl2) {
            this.setAllowCommit(a2.isAllowCommit());
        } else {
            this.setAllowCommit(false);
        }
        this.setAllowReceive(a2.isAllowReceive());
    }

    @Deprecated
    public DicomDestination(com.mimvista.properties.ay ay2) {
        this.dcmLoc = new DicomLocationsPrefs.a();
        this.dcmLoc.setDescription(this.name);
        this.dcmLoc.setAllowSend(true);
        List<Property> list = ay2.l();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Property property = list.get(i2);
            if (property.C().startsWith("DESCRIPTION_")) {
                this.setDescription(property.ac_());
                this.name = property.ac_();
                continue;
            }
            if (property.C().startsWith("HOST_")) {
                this.setHostname(property.ac_());
                continue;
            }
            if (property.C().startsWith("PORT_")) {
                this.setPort(property.ac_());
                continue;
            }
            if (!property.C().startsWith("AETITLE_")) continue;
            this.setAeTitle(property.ac_());
        }
        this.setAllowQuery(true);
        this.setAllowSend(true);
        this.setAllowReceive(true);
    }

    public DicomLocationsPrefs.a getHost() {
        return this.dcmLoc;
    }

    public void setHost(DicomLocationsPrefs.a a2) {
        this.dcmLoc = a2;
    }

    public boolean isShouldDelete() {
        return this.shouldDelete;
    }

    public boolean isAllowSend() {
        return this.dcmLoc.isAllowSend();
    }

    public void setAllowSend(boolean bl2) {
        this.dcmLoc.setAllowSend(bl2);
        if (!bl2) {
            this.dcmLoc.setAllowCommit(false);
        }
    }

    public boolean isAllowCommit() {
        return this.dcmLoc.isAllowCommit();
    }

    public void setAllowCommit(boolean bl2) {
        this.dcmLoc.setAllowCommit(bl2);
        if (!this.dcmLoc.isAllowSend()) {
            this.dcmLoc.setAllowCommit(false);
        }
    }

    public boolean isAllowReceive() {
        return this.dcmLoc.isAllowReceive();
    }

    public void setAllowReceive(boolean bl2) {
        this.dcmLoc.setAllowReceive(bl2);
    }

    public boolean isAllowQuery() {
        return this.dcmLoc.isAllowQuery();
    }

    public void setAllowQuery(boolean bl2) {
        this.dcmLoc.setAllowQuery(bl2);
    }

    public void setIsMITRAReportQueryable(boolean bl2) {
        this.dcmLoc.setAllowMitraReportQuery(bl2);
    }

    public boolean getIsMITRAReportQueryable() {
        return this.dcmLoc.isAllowMitraReportQuery();
    }

    public void setUseSpecificCharacterSet(boolean bl2) {
        this.dcmLoc.setUseSpecificCharacterSet(bl2);
    }

    public boolean isUseSpecificCharacterSet() {
        return this.dcmLoc.isUseSpecificCharacterSet();
    }

    public String getHostname() {
        return this.dcmLoc.getHost();
    }

    public void setHostname(String string) {
        this.dcmLoc.setHost(string);
    }

    public String getPort() {
        return this.dcmLoc.getPort();
    }

    public void setPort(String string) {
        this.dcmLoc.setPort(string);
    }

    public String getAeTitle() {
        return this.dcmLoc.getAeTitle();
    }

    public void setAeTitle(String string) {
        this.dcmLoc.setAeTitle(string);
    }

    public void setDescription(String string) {
        this.dcmLoc.setDescription(string);
    }

    public String getDescription() {
        return this.dcmLoc.getDescription();
    }

    @Override
    public String getIconName() {
        return "monitor_network";
    }

    @Override
    public boolean matches(SearchSource searchSource) {
        if (searchSource instanceof DicomSearchSource) {
            DicomSearchSource dicomSearchSource = (DicomSearchSource)searchSource;
            DicomLocationsPrefs.a a2 = dicomSearchSource.a();
            return a2.toDcmUrl().toString().equals(this.getHost().toDcmUrl().toString());
        }
        return false;
    }

    public static ArrayList<DicomDestination> loadDestinations() {
        ArrayList<DicomDestination> arrayList = new ArrayList<DicomDestination>();
        Iterator iterator = ((ArrayList)DicomLocationsPrefs.dicomLocations.getValue()).iterator();
        while (iterator.hasNext()) {
            DicomLocationsPrefs.a a2 = (DicomLocationsPrefs.a)iterator.next();
            arrayList.add(new DicomDestination(a2));
        }
        return arrayList;
    }

    public MIMDcmUrl toURL() {
        String string = this.dcmLoc.getAeTitle();
        String string2 = this.dcmLoc.getHost();
        return new MIMDcmUrl("dicom://" + string + ":" + DcmConfigReader.getServerAETitle() + "@" + string2 + ":" + this.getIntPort());
    }

    private int getIntPort() {
        try {
            int n2 = Integer.parseInt(this.dcmLoc.getPort());
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void runTest(JDialog jDialog) {
        new DicomTestJDialog(jDialog, this).open();
    }

    public boolean valuesMissing() {
        return this.dcmLoc.getDescription().length() == 0 || this.dcmLoc.getHost().length() == 0 || this.getIntPort() == 0 || this.dcmLoc.getAeTitle().length() == 0;
    }

    public boolean validate() {
        String string = this.dcmLoc.getDescription();
        if (string.length() == 0) {
            this.message(props.getProperty("DCM_DEST_FAIL_EMPTY"));
            return false;
        }
        if (string.indexOf(124) > -1 || string.indexOf(42) > -1) {
            this.message(props.getProperty("DCM_DEST_FAIL_CHAR"));
            return false;
        }
        if (this.dcmLoc.getAeTitle().length() == 0) {
            this.message(props.getProperty("DCM_DEST_FAIL_AE"));
            return false;
        }
        try {
            int n2 = Integer.parseInt(this.dcmLoc.getPort());
            if (n2 < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.message(props.getProperty("DCM_DEST_FAIL_PORT"));
            return false;
        }
        if (this.dcmLoc.getHost().length() == 0) {
            this.message(props.getProperty("DCM_DEST_FAIL_HOST"));
            return false;
        }
        return true;
    }

    private void message(String string) {
        int n2 = JOptionPane.showConfirmDialog(ak.b().O(), string + props.getProperty("DCM_DEST_DISCARD"), props.getProperty("DCM_DEST_LOC"), 0, 3);
        if (n2 == 0) {
            this.shouldDelete = true;
        }
    }

    @Override
    protected boolean canRetrieveFrom(LocalSearchSource localSearchSource) {
        return true;
    }

    @Override
    protected boolean canRetrieveFrom(MIMcloudSearchSource mIMcloudSearchSource) {
        return true;
    }

    @Override
    protected boolean canRetrieveFrom(ImportSearchSource importSearchSource) {
        return true;
    }

    @Override
    protected boolean canRetrieveFrom(AbstractRemoteSearchSource abstractRemoteSearchSource) {
        if (DicomLocationsPrefs.a.isLocalHost(abstractRemoteSearchSource.a())) {
            return true;
        }
        return !DicomLocationsPrefs.a.isLocalHost(this.dcmLoc.getHost());
    }

    @Override
    protected void retrieveFrom(MIMcloudSearchSource mIMcloudSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        g.a(mIMcloudSearchSource, (SendToDestination)this, list, bl2, m2);
    }

    @Override
    protected boolean canRetrieveFrom(DicomSearchSource dicomSearchSource) {
        return this.isAllowReceive();
    }

    @Override
    protected void retrieveFrom(LocalSearchSource localSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.performDicomExport(list, false, bl2, m2);
    }

    @Override
    protected void retrieveFrom(FolderSearchSource folderSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.performDicomExport(list, folderSearchSource.o(), bl2, m2);
    }

    @Override
    protected void retrieveFrom(AbstractRemoteSearchSource abstractRemoteSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        try {
            RemoteQueryServer remoteQueryServer = s.a((RemoteSearchSource)abstractRemoteSearchSource);
            for (DcmSeries dcmSeries : list) {
                e e2 = new e(remoteQueryServer, dcmSeries, ((RemoteSearchSource)abstractRemoteSearchSource).B(), this);
                e2.push(bl2, m2);
            }
        }
        catch (Exception exception) {
            ay.d((Object)("Exception while exporting from RemoteSearchSource " + abstractRemoteSearchSource.j() + ": "), (Throwable)exception, this);
        }
    }

    @Override
    protected void retrieveFrom(DicomSearchSource dicomSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        DicomSearchSource.a a2 = new DicomSearchSource.a(list);
        DcmPullTransfer dcmPullTransfer = new DcmPullTransfer(a2, dicomSearchSource.a(), this.getHost().getAeTitle());
        b.a(dcmPullTransfer, m2);
        if (bl2) {
            dcmPullTransfer.blockUntilTransferIsOver();
        }
    }

    @Override
    protected void retrieveFrom(ImportSearchSource importSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.performDicomExport(list, false, bl2, m2);
    }

    public void performDicomExport(final List<DcmSeries> list, final boolean bl2, final boolean bl3, final @d FuncUtils.m<Progress.Status> m2) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                for (DcmSeries dcmSeries : list) {
                    Vector<String> vector = new Vector<String>();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    File[] fileArray = new File(Archiver.getDirContainingSeriesFiles(dcmSeries)).listFiles();
                    if (fileArray != null) {
                        for (File file : fileArray) {
                            arrayList.add(file);
                        }
                    } else if (dcmSeries.getFiles() != null) {
                        arrayList.addAll(dcmSeries.getFiles());
                    }
                    if (arrayList.isEmpty()) {
                        // empty if block
                    }
                    for (File file : arrayList) {
                        vector.add(file.getAbsolutePath());
                    }
                    String[] stringArray = cn.a(vector);
                    DcmPushTransfer dcmPushTransfer = new DcmPushTransfer(stringArray, bl2 || dcmSeries.isEmbedded(), DicomDestination.this.getHost());
                    dcmPushTransfer.push(DicomDestination.this, bl3, m2);
                }
            }
        }, "Retrieving series for 'Send to'");
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.dcmLoc == null ? 0 : this.dcmLoc.hashCode());
        n3 = 31 * n3 + (this.shouldDelete ? 1231 : 1237);
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DicomDestination dicomDestination = (DicomDestination)object;
        if (this.dcmLoc == null ? dicomDestination.dcmLoc != null : !this.dcmLoc.equals(dicomDestination.dcmLoc)) {
            return false;
        }
        return this.shouldDelete == dicomDestination.shouldDelete;
    }

    @Override
    public String getIdentifier() {
        return this.dcmLoc.getHost() + " " + this.dcmLoc.getPort() + " " + this.dcmLoc.getAeTitle();
    }
}

