/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.mimvista.dicom.util.DicomRLEDecompressor;
import com.mimvista.dicom.util.jpeg.DicomJpegDecompressor;
import com.mimvista.numerics.ColorSpaceUtility;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.WeakHashMap;
import javax.imageio.ImageTypeSpecifier;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DicomImageConverter {
    private static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private static final ImageTypeSpecifier RGB_PLANE = ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 0, false, false);
    private static final ImageTypeSpecifier RGB_PIXEL = ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2}, 0, false, false);
    private static final byte[] P2D_IDENTITY = new byte[256];

    public static boolean needsDecompressed(DicomObject dicomObject) {
        String string = dicomObject.getString(131088);
        return DicomRLEDecompressor.isRLECompressed(string) || DicomJpegDecompressor.isJpegCompressed(string);
    }

    public static DicomObject decompress(DicomObject dicomObject) {
        String string = dicomObject.getString(131088);
        if (DicomJpegDecompressor.isJpegCompressed(string)) {
            dicomObject = DicomJpegDecompressor.decompress(dicomObject);
        }
        if (DicomRLEDecompressor.isRLECompressed(string)) {
            DicomRLEDecompressor.get(dicomObject).mutate();
        }
        return dicomObject;
    }

    public static BufferedImage toBufferedImage(DicomObject dicomObject) {
        return DicomImageConverter.toBufferedImage(dicomObject, 1);
    }

    public static BufferedImage toBufferedImage(DicomObject dicomObject, int n2) {
        Object object;
        BufferedImage bufferedImage;
        int n3;
        boolean bl2;
        int n4;
        int n5;
        ByteBuffer byteBuffer;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        block27: {
            String string;
            block26: {
                ByteOrder byteOrder;
                n10 = dicomObject.getInt(2621457, -1);
                n9 = dicomObject.getInt(2621456, -1);
                if (n10 == -1 || n9 == -1) {
                    return new BufferedImage(1, 1, 5);
                }
                n8 = dicomObject.getInt(2621696, -1);
                n7 = dicomObject.getInt(2621697, -1);
                n6 = dicomObject.getInt(2621698, -1);
                int n11 = dicomObject.getInt(2621699, -1);
                DicomElement dicomElement = dicomObject.get(2145386512);
                ByteOrder byteOrder2 = byteOrder = dicomElement.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                if (DicomImageConverter.needsDecompressed(dicomObject)) {
                    dicomObject = DicomImageConverter.decompress(dicomObject);
                }
                byteBuffer = ByteBuffer.wrap(dicomObject.getBytes(2145386512, byteOrder == ByteOrder.BIG_ENDIAN));
                DicomImageConverter.adjustRGBFormat(byteBuffer, byteOrder, dicomObject);
                string = dicomObject.getString(2621444, (String)null);
                n5 = dicomObject.getInt(0x280002, -1);
                n4 = dicomObject.getInt(2621446, -1);
                if (n8 == -1 || n7 == -1 || n6 == -1 || n11 == -1 || string == null || n5 == -1 || n4 == -1 && n5 > 1 || byteBuffer == null) {
                    throw new IllegalStateException("Missing required Image Pixel Module attributes");
                }
                byteBuffer.order(byteOrder);
                if (!(string.equals("RGB") && n5 == 3 || string.equals("PALETTE COLOR") && n5 == 1 || string.equals("MONOCHROME1") && n5 == 1 || string.equals("MONOCHROME2") && n5 == 1)) {
                    throw new IllegalStateException("Invalid Photometric Interpretation (" + string + ") and Samples per Pixel (" + n5 + ") configuration");
                }
                boolean bl3 = bl2 = n11 == 1;
                if (n4 == -1) {
                    n4 = 1;
                }
                if (n8 == 8) {
                    n3 = 0;
                } else if (n8 == 16) {
                    n3 = 1;
                } else {
                    throw new IllegalStateException("Bits Allocated must be 8 or 16, " + n8 + " is not supported");
                }
                if (n6 != n7 - 1) {
                    throw new IllegalStateException("High bit must be Bits Stored - 1 " + n6 + " is not supported");
                }
                bufferedImage = null;
                if (!string.equals("RGB")) break block26;
                switch (n4) {
                    case 0: {
                        bufferedImage = RGB_PIXEL.createBufferedImage(n10, n9);
                        break block27;
                    }
                    case 1: {
                        bufferedImage = RGB_PLANE.createBufferedImage(n10, n9);
                        break block27;
                    }
                    default: {
                        throw new IllegalStateException("Invalid Planar Configuration for RGB");
                    }
                }
            }
            if (string.equals("MONOCHROME1") || string.equals("MONOCHROME2") || string.equals("PALETTE COLOR")) {
                object = new ColorModelFactory();
                bufferedImage = new ImageTypeSpecifier(((ColorModelFactory)object).getColorModel(((ColorModelFactory)object).makeParam(dicomObject)), new PixelInterleavedSampleModel(n3, 1, 1, 1, 1, new int[]{0})).createBufferedImage(n10, n9);
            }
        }
        object = bufferedImage.getRaster().getDataBuffer();
        Object[] objectArray = null;
        if (n4 == 0) {
            switch (n3) {
                case 0: {
                    objectArray = ((DataBufferByte)object).getData();
                    break;
                }
                case 1: {
                    objectArray = ((DataBufferUShort)object).getData();
                }
            }
            DicomImageConverter.readPixelData(byteBuffer, objectArray, n3, n2, n8, n7, n6, bl2, n5, n10, n9);
        } else {
            for (int i2 = 0; i2 < n5; ++i2) {
                switch (n3) {
                    case 0: {
                        objectArray = ((DataBufferByte)object).getData(i2);
                        break;
                    }
                    case 1: {
                        objectArray = ((DataBufferUShort)object).getData(i2);
                    }
                }
                DicomImageConverter.readPixelData(byteBuffer, objectArray, n3, n2, n8, n7, n6, bl2, 1, n10, n9);
            }
        }
        return bufferedImage;
    }

    private static void readPixelData(ByteBuffer byteBuffer, Object object, int n2, int n3, int n4, int n5, int n6, boolean bl2, int n7, int n8, int n9) {
        int n10 = n8 * n9 * n7;
        int n11 = n10 * (n4 / 8);
        int n12 = 0;
        if (n3 * n11 > byteBuffer.limit()) {
            throw new IllegalArgumentException("Bad frame number: " + n3);
        }
        byteBuffer.position(n11 * --n3);
        switch (n2) {
            case 0: {
                byte[] byArray = (byte[])object;
                while (n12 < n10) {
                    byArray[n12++] = byteBuffer.get();
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                while (n12 < n10) {
                    sArray[n12++] = byteBuffer.getShort();
                }
                break;
            }
        }
    }

    public static void putBufferedImage(DicomObject dicomObject, BufferedImage bufferedImage) {
        DicomImageConverter.putBufferedImage(dicomObject, bufferedImage, null, true);
    }

    public static void putBufferedImage(DicomObject dicomObject, BufferedImage bufferedImage, Rectangle rectangle) {
        DicomImageConverter.putBufferedImage(dicomObject, bufferedImage, rectangle, true);
    }

    public static void putBufferedImage(DicomObject dicomObject, BufferedImage bufferedImage, Rectangle rectangle, boolean bl2) {
        boolean bl3;
        int n2 = bufferedImage.getType();
        boolean bl4 = bl3 = n2 == 10 || n2 == 11;
        if (bl3) {
            DicomImageConverter.putBufferedImageAsMonochrome(dicomObject, bufferedImage, rectangle, true);
        } else {
            boolean bl5;
            boolean bl6 = bl5 = !bl2 || !(bufferedImage.getColorModel() instanceof IndexColorModel);
            if (bl5) {
                DicomImageConverter.putBufferedImageAsRgb(dicomObject, bufferedImage, rectangle);
            } else {
                DicomImageConverter.putBufferedImageAsPaletteColor(dicomObject, bufferedImage, rectangle);
            }
        }
    }

    private static void putUS(DicomObject dicomObject, int n2, int n3) {
        dicomObject.putInt(n2, VR.US, n3);
    }

    private static void putCS(DicomObject dicomObject, int n2, String string) {
        dicomObject.putString(n2, VR.CS, string);
    }

    private static void putIS(DicomObject dicomObject, int n2, int[] nArray) {
        dicomObject.putInts(n2, VR.IS, nArray);
    }

    private static void putSS(DicomObject dicomObject, int n2, int n3) {
        dicomObject.putInt(n2, VR.SS, n3);
    }

    private static void putDS(DicomObject dicomObject, int n2, float f2) {
        dicomObject.putFloat(n2, VR.DS, f2);
    }

    private static void putDS(DicomObject dicomObject, int n2, String[] stringArray) {
        dicomObject.putStrings(n2, VR.DS, stringArray);
    }

    public static void putBufferedImageAsRgb(DicomObject dicomObject, BufferedImage bufferedImage, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        Rectangle rectangle3 = rectangle == null ? rectangle2 : rectangle2.intersection(rectangle);
        if (rectangle3.isEmpty()) {
            throw new IllegalArgumentException("Source region is empty." + dicomObject);
        }
        int n2 = rectangle3.width;
        int n3 = rectangle3.height;
        boolean bl2 = false;
        int n4 = 8;
        int n5 = 8;
        int n6 = 7;
        DicomImageConverter.putUS(dicomObject, 0x280002, 3);
        DicomImageConverter.putUS(dicomObject, 2621696, n4);
        DicomImageConverter.putUS(dicomObject, 2621697, n5);
        DicomImageConverter.putUS(dicomObject, 2621698, n6);
        DicomImageConverter.putCS(dicomObject, 2621444, "RGB");
        DicomImageConverter.putUS(dicomObject, 2621456, n3);
        DicomImageConverter.putUS(dicomObject, 2621457, n2);
        DicomImageConverter.putUS(dicomObject, 2621699, bl2 ? 1 : 0);
        DicomImageConverter.putUS(dicomObject, 2621446, 0);
        DicomImageConverter.putIS(dicomObject, 2621492, new int[]{1, 1});
        byte[] byArray = new byte[n2 * n3 * 3];
        int n7 = bufferedImage.getData().getDataBuffer().getDataType();
        ColorModel colorModel = bufferedImage.getColorModel();
        int[] nArray = bufferedImage.getRGB(rectangle3.x, rectangle3.y, n2, n3, null, 0, n2);
        int n8 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            byArray[n8++] = (byte)(nArray[i2] >> 16 & 0xFF);
            byArray[n8++] = (byte)(nArray[i2] >> 8 & 0xFF);
            byArray[n8++] = (byte)(nArray[i2] & 0xFF);
        }
        dicomObject.putBytes(2145386512, VR.OB, byArray);
    }

    public static void putBufferedImageAsMonochrome(DicomObject dicomObject, BufferedImage bufferedImage, Rectangle rectangle, boolean bl2) {
        int n2;
        int n3;
        int n4;
        Rectangle rectangle2 = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        Rectangle rectangle3 = rectangle == null ? rectangle2 : rectangle2.intersection(rectangle);
        if (rectangle3.isEmpty()) {
            throw new IllegalArgumentException("Source region is empty." + dicomObject);
        }
        int n5 = bufferedImage.getType();
        int n6 = rectangle3.width;
        int n7 = rectangle3.height;
        boolean bl3 = false;
        int n8 = n4 = n5 == 10 ? 8 : 16;
        int n9 = n8 - 1;
        DicomImageConverter.putUS(dicomObject, 0x280002, 1);
        if (bl2) {
            DicomImageConverter.putCS(dicomObject, 2621444, "MONOCHROME2");
        } else {
            DicomImageConverter.putCS(dicomObject, 2621444, "MONOCHROME1");
        }
        DicomImageConverter.putUS(dicomObject, 2621456, n7);
        DicomImageConverter.putUS(dicomObject, 2621457, n6);
        DicomImageConverter.putUS(dicomObject, 2621696, n4);
        DicomImageConverter.putUS(dicomObject, 2621697, n8);
        DicomImageConverter.putUS(dicomObject, 2621698, n9);
        DicomImageConverter.putUS(dicomObject, 2621699, bl3 ? 1 : 0);
        DicomImageConverter.putIS(dicomObject, 2621492, new int[]{1, 1});
        int[] nArray = bufferedImage.getRaster().getPixels(rectangle3.x, rectangle3.y, n6, n7, (int[])null);
        int n10 = n3 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            int n11 = nArray[i2];
            if (n11 > n3) {
                n3 = n11;
                continue;
            }
            if (n11 >= n10) continue;
            n10 = n11;
        }
        if (n4 <= 8) {
            byte[] byArray = new byte[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                byArray[n2] = (byte)(nArray[n2] & 0xFF);
            }
            dicomObject.putBytes(2145386512, VR.OW, byArray);
        } else {
            byte[] byArray = new byte[nArray.length * 2];
            n2 = 0;
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                byArray[n2++] = (byte)(nArray[i3] >> 8 & 0xFF);
                byArray[n2++] = (byte)(nArray[i3] & 0xFF);
            }
            dicomObject.putBytes(2145386512, VR.OW, byArray);
        }
        DicomImageConverter.putSS(dicomObject, 2621702, n10);
        DicomImageConverter.putSS(dicomObject, 2621703, n3);
        float f2 = dicomObject.getFloat(2625619, 1.0f);
        float f3 = dicomObject.getFloat(2625618, 0.0f);
        if (!dicomObject.contains(2625618)) {
            DicomImageConverter.putDS(dicomObject, 2625618, f3);
            DicomImageConverter.putDS(dicomObject, 2625619, f2);
            dicomObject.putString(2625620, VR.LO, "PIXELVALUE");
        }
        if (!dicomObject.contains(2625616)) {
            String[] stringArray = new String[]{Float.toString(f2 * (float)(n3 + n10) / 2.0f + f3)};
            DicomImageConverter.putDS(dicomObject, 2625616, stringArray);
            String[] stringArray2 = new String[]{Float.toString(f2 * (float)(n3 - n10) / 2.0f)};
            DicomImageConverter.putDS(dicomObject, 2625617, stringArray2);
        }
    }

    public static void putBufferedImageAsPaletteColor(DicomObject dicomObject, BufferedImage bufferedImage, Rectangle rectangle) {
        int n2;
        Rectangle rectangle2 = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        Rectangle rectangle3 = rectangle == null ? rectangle2 : rectangle2.intersection(rectangle);
        if (rectangle3.isEmpty()) {
            throw new IllegalArgumentException("Source region is empty." + dicomObject);
        }
        int n3 = bufferedImage.getData().getDataBuffer().getDataType();
        ColorModel colorModel = bufferedImage.getColorModel();
        if (!(colorModel instanceof IndexColorModel)) {
            throw new IllegalArgumentException("BufferedImage's ColorModel must be an IndexColorModel to represent as a \"PALETTE COLOR\" DICOM image");
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        int n4 = 65536;
        int n5 = indexColorModel.getMapSize();
        int n6 = indexColorModel.getPixelSize();
        if (n5 > 65536) {
            throw new IllegalArgumentException("BufferedImage contains a palette that is too large to be encoded as a DICOM Color LUT (" + n5 + ")");
        }
        if (n6 == 0 || n6 > 16) {
            throw new UnsupportedOperationException("BufferedImages with a pixel size of " + n6 + " bits are not supported, only 1 to 16 bits are supported");
        }
        int n7 = rectangle3.width;
        int n8 = rectangle3.height;
        boolean bl2 = false;
        int n9 = n2 = n6 <= 8 ? 8 : 16;
        int n10 = n9 - 1;
        DicomImageConverter.putUS(dicomObject, 0x280002, 1);
        DicomImageConverter.putCS(dicomObject, 2621444, "PALETTE COLOR");
        DicomImageConverter.putUS(dicomObject, 2621456, n8);
        DicomImageConverter.putUS(dicomObject, 2621457, n7);
        DicomImageConverter.putUS(dicomObject, 2621696, n2);
        DicomImageConverter.putUS(dicomObject, 2621697, n9);
        DicomImageConverter.putUS(dicomObject, 2621698, n10);
        DicomImageConverter.putUS(dicomObject, 2621699, bl2 ? 1 : 0);
        DicomImageConverter.putIS(dicomObject, 2621492, new int[]{1, 1});
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.putShort((short)(n5 == 65536 ? 0 : n5));
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)8);
        dicomObject.putBytes(2625793, VR.US, byteBuffer.array());
        dicomObject.putBytes(2625794, VR.US, byteBuffer.array());
        dicomObject.putBytes(2625795, VR.US, byteBuffer.array());
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n5);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(n5);
        ByteBuffer byteBuffer4 = ByteBuffer.allocate(n5);
        for (int i2 = 0; i2 < n5; i2 += 2) {
            byteBuffer2.putShort((short)((byArray[i2 + 1] << 8) + (byArray[i2] & 0xFF)));
            byteBuffer3.putShort((short)((byArray2[i2 + 1] << 8) + (byArray2[i2] & 0xFF)));
            byteBuffer4.putShort((short)((byArray3[i2 + 1] << 8) + (byArray3[i2] & 0xFF)));
        }
        dicomObject.putBytes(2626049, VR.OW, byteBuffer2.array());
        dicomObject.putBytes(2626050, VR.OW, byteBuffer3.array());
        dicomObject.putBytes(2626051, VR.OW, byteBuffer4.array());
        int[] nArray = bufferedImage.getRaster().getPixels(rectangle3.x, rectangle3.y, n7, n8, (int[])null);
        int n11 = 0;
        if (n6 <= 8) {
            byte[] byArray4 = new byte[n7 * n8];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                byArray4[i3] = (byte)(nArray[i3 % 2 == 0 ? i3 + 1 : i3 - 1] & 0xFF);
            }
            dicomObject.putBytes(2145386512, VR.OW, byArray4);
        } else if (n6 > 8 && n6 <= 16) {
            byte[] byArray5 = new byte[n7 * n8 * 2];
            for (int i4 = 0; i4 < nArray.length; ++i4) {
                byArray5[n11++] = (byte)(nArray[i4] >> 8 & 0xFF);
                byArray5[n11++] = (byte)(nArray[i4] & 0xFF);
            }
            dicomObject.putBytes(2145386512, VR.OW, byArray5);
        }
    }

    public static ByteBuffer adjustRGBFormat(ByteBuffer byteBuffer, ByteOrder byteOrder, int n2, int n3, int n4, String string) {
        Object object;
        if (n2 != 3 || n3 != 8) {
            return byteBuffer;
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        if (n4 != 0) {
            object = new byte[byteBuffer.capacity()];
            int n5 = byteBuffer.capacity() / 3;
            byteBuffer.rewind();
            int n6 = 0;
            for (int i2 = 0; i2 < n5; ++i2) {
                object[n6++] = byteBuffer.get(i2);
                object[n6++] = byteBuffer.get(i2 + n5);
                object[n6++] = byteBuffer.get(i2 + n5 * 2);
            }
            byteBuffer2 = ByteBuffer.wrap(object);
        }
        byteBuffer2.order(byteOrder);
        try {
            object = (Object)ColorSpaceUtility.ColorSpace.valueOf(string);
            if (object != ColorSpaceUtility.ColorSpace.a) {
                byteBuffer2.rewind();
                ColorSpaceUtility.a(byteBuffer2, (ColorSpaceUtility.ColorSpace)((Object)object), ColorSpaceUtility.ColorSpace.a);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byteBuffer2.rewind();
        return byteBuffer2;
    }

    public static ByteBuffer adjustRGBFormat(ByteBuffer byteBuffer, ByteOrder byteOrder, DicomObject dicomObject) {
        int n2 = dicomObject.getInt(0x280002);
        int n3 = dicomObject.getInt(2621696);
        int n4 = dicomObject.getInt(2621446);
        String string = dicomObject.getString(2621444);
        return DicomImageConverter.adjustRGBFormat(byteBuffer, byteOrder, n2, n3, n4, string);
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            DicomImageConverter.P2D_IDENTITY[i2] = (byte)i2;
        }
    }

    public static interface ColorModelParam {
        public ColorModel newColorModel();

        public ColorModelParam update(float var1, float var2, boolean var3);

        public float getRescaleSlope();

        public float getRescaleIntercept();

        public float getWindowCenter(int var1);

        public float getWindowWidth(int var1);

        public int getNumberOfWindows();

        public float toMeasureValue(int var1);

        public int toPixelValue(float var1);

        public int toSampleValue(int var1);

        public int toPixelValueRaw(int var1);

        public boolean isInverse();

        public boolean isCacheable();

        public boolean isMonochrome();
    }

    static final class PaletteColorParam
    extends BasicColorModelParam {
        private final byte[] r;
        private final byte[] g;
        private final byte[] b;

        public PaletteColorParam(DicomObject dicomObject) {
            super(dicomObject);
            if (this.min < 0) {
                throw new UnsupportedOperationException("Signed PALETTE COLOR not supported!");
            }
            this.r = PaletteColorParam.generate(this.size, dicomObject, 2625793, 2626049, 0x281221);
            this.g = PaletteColorParam.generate(this.size, dicomObject, 2625794, 2626050, 0x281222);
            this.b = PaletteColorParam.generate(this.size, dicomObject, 2625795, 2626051, 2626083);
        }

        @Override
        public ColorModel newColorModel() {
            return new IndexColorModel(this.bits, this.size, this.r, this.g, this.b);
        }

        private static void throwLengthMismatch(int n2, int n3) {
            throw new IllegalArgumentException("LUT Data length: " + n2 + " mismatch entry value: " + n3 + " in LUT Descriptor");
        }

        private static byte[] generate(int n2, DicomObject dicomObject, int n3, int n4, int n5) {
            int[] nArray = dicomObject.getInts(n3);
            if (nArray == null) {
                throw new IllegalArgumentException("Missing LUT Descriptor!");
            }
            if (nArray.length != 3) {
                throw new IllegalArgumentException("Illegal LUT Descriptor: " + nArray);
            }
            int n6 = nArray[0] == 0 ? 65536 : nArray[0];
            int n7 = nArray[1];
            if (n6 < 0) {
                throw new IllegalArgumentException("Illegal LUT Descriptor: len=" + n6);
            }
            if (n7 < 0) {
                throw new IllegalArgumentException("off: " + n7);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(dicomObject.getBytes(n4));
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(dicomObject.getBytes(n5));
            if (byteBuffer == null && byteBuffer2 == null) {
                throw new IllegalArgumentException("Missing LUT Data!");
            }
            byte[] byArray = new byte[n2];
            switch (nArray[2]) {
                case 16: {
                    if (byteBuffer != null) {
                        if (byteBuffer.limit() != n6 * 2) {
                            PaletteColorParam.throwLengthMismatch(byteBuffer.limit(), n6);
                        }
                        byteBuffer.rewind();
                        int n8 = n7;
                        while (byteBuffer.hasRemaining()) {
                            byArray[n8] = (byte)(byteBuffer.getShort() >> 8);
                            ++n8;
                        }
                        break;
                    }
                    PaletteColorParam.inflate(byteBuffer2, byArray, n7, n6);
                    break;
                }
                case 8: {
                    if (byteBuffer != null) {
                        if (byteBuffer.limit() != n6) {
                            PaletteColorParam.throwLengthMismatch(byteBuffer.limit(), n6);
                        }
                        byteBuffer.rewind();
                        int n9 = n7;
                        while (byteBuffer.hasRemaining()) {
                            short s2 = byteBuffer.getShort();
                            byArray[n9++] = (byte)(s2 & 0xFF);
                            byArray[n9++] = (byte)(s2 >> 8 & 0xFF);
                        }
                        break;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Illegal LUT Descriptor: bits=" + nArray[2]);
                }
            }
            Arrays.fill(byArray, 0, n7, byArray[n7]);
            Arrays.fill(byArray, n7 + n6, n2, byArray[n7 + n6 - 1]);
            return byArray;
        }

        private static void inflate(ByteBuffer byteBuffer, byte[] byArray, int n2, int n3) {
            int n4 = n2;
            int n5 = 0;
            byteBuffer.rewind();
            block9: while (byteBuffer.hasRemaining()) {
                short s2 = byteBuffer.getShort();
                int n6 = byteBuffer.getShort() & 0xFFFF;
                switch (s2) {
                    case 0: {
                        int n7;
                        for (n7 = 0; n7 < n6; ++n7) {
                            int n8 = n4++;
                            n5 = byteBuffer.getShort() & 0xFFFF;
                            byArray[n8] = (byte)(n5 >> 8);
                        }
                        continue block9;
                    }
                    case 1: {
                        int n9 = byteBuffer.getShort() & 0xFFFF;
                        int n10 = n9 - n5;
                        int n7 = 0;
                        while (n7 < n6) {
                            byArray[n4++] = (byte)(n5 + n10 * ++n7 / n6 >> 8);
                        }
                        n5 = n9;
                        break;
                    }
                    case 2: {
                        int n10;
                        int n9;
                        int n7 = byteBuffer.getShort() & 0xFFFF | byteBuffer.getShort() << 16;
                        byteBuffer.mark();
                        byteBuffer.position(n7);
                        block12: for (int i2 = 0; i2 < n6; ++i2) {
                            short s3 = byteBuffer.getShort();
                            int n11 = byteBuffer.getShort() & 0xFFFF;
                            switch (s3) {
                                case 0: {
                                    int n12;
                                    for (n12 = 0; n12 < n11; ++n12) {
                                        int n13 = n4++;
                                        n5 = byteBuffer.getShort() & 0xFFFF;
                                        byArray[n13] = (byte)(n5 >> 8);
                                    }
                                    continue block12;
                                }
                                case 1: {
                                    n9 = byteBuffer.getShort() & 0xFFFF;
                                    n10 = n9 - n5;
                                    int n12 = 0;
                                    while (n12 < n11) {
                                        byArray[n4++] = (byte)(n5 + n10 * ++n12 / n11 >> 8);
                                    }
                                    n5 = n9;
                                    continue block12;
                                }
                                default: {
                                    throw new IllegalArgumentException("illegal op code:" + s3 + ", index:" + (byteBuffer.position() - 4));
                                }
                            }
                        }
                        byteBuffer.reset();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal op code:" + s2 + ", index:" + (byteBuffer.position() - 4));
                    }
                }
            }
            if (n4 - n2 != n3) {
                PaletteColorParam.throwLengthMismatch(n4 - n2, n3);
            }
        }

        @Override
        public ColorModelParam update(float f2, float f3, boolean bl2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getRescaleSlope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getRescaleIntercept() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getWindowCenter(int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getWindowWidth(int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getNumberOfWindows() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMonochrome() {
            return false;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean isInverse() {
            return false;
        }

        @Override
        public float toMeasureValue(int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int toPixelValue(float f2) {
            throw new UnsupportedOperationException();
        }
    }

    static class MonochromeParam
    extends BasicColorModelParam {
        private final int inverse;
        private final float slope;
        private final float intercept;
        private final float[] center;
        private final float[] width;
        private final int hashcode;
        private final byte[] pv2dll;
        private final int andmask;
        private final int pvBits;
        private final int rshift;
        private final int lshift;
        private static final float[] EMPTY = new float[0];

        private static final float[] nullToEmpty(float[] fArray) {
            return fArray == null ? EMPTY : fArray;
        }

        private static final float correctZeroSlope(float f2) {
            return f2 == 0.0f ? 1.0f : f2;
        }

        private static final int inBits(int n2) {
            int n3 = 8;
            int n4 = 256;
            while (n3 <= 16) {
                if (n4 == n2) {
                    return n3;
                }
                ++n3;
                n4 <<= 1;
            }
            throw new IllegalArgumentException("pv2dll length: " + n2);
        }

        public MonochromeParam(DicomObject dicomObject, boolean bl2, byte[] byArray) {
            super(dicomObject);
            this.inverse = bl2 ? -1 : 0;
            this.slope = MonochromeParam.correctZeroSlope(dicomObject.getFloat(2625619, 1.0f));
            this.intercept = dicomObject.getFloat(2625618, 0.0f);
            this.center = MonochromeParam.nullToEmpty(dicomObject.getFloats(2625616));
            this.width = MonochromeParam.nullToEmpty(dicomObject.getFloats(2625617));
            for (int i2 = 0; i2 < this.width.length; ++i2) {
                if (!(this.width[i2] <= 0.0f)) continue;
                this.width[i2] = (float)(this.max - this.min) / this.slope;
            }
            this.pv2dll = byArray;
            this.pvBits = MonochromeParam.inBits(byArray.length);
            this.andmask = (1 << this.pvBits) - 1;
            if (this.bits > this.pvBits) {
                this.rshift = this.bits - this.pvBits;
                this.lshift = 0;
            } else {
                this.lshift = this.pvBits - this.bits;
                this.rshift = 0;
            }
            this.hashcode = MonochromeParam.hashcode(this.dataType, this.inverse, this.min, this.max, this.slope, this.intercept, this.center, this.width, byArray);
        }

        private static int hashcode(int n2, int n3, int n4, int n5, float f2, float f3, float[] fArray, float[] fArray2, byte[] byArray) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n2).append(n3).append(n4).append(n5).append(f2).append(f3).append(byArray);
            if (Math.min(fArray.length, fArray2.length) != 0) {
                stringBuffer.append(fArray[0]).append(fArray2[0]);
            }
            return stringBuffer.toString().hashCode();
        }

        private MonochromeParam(MonochromeParam monochromeParam, float f2, float f3, boolean bl2) {
            super(monochromeParam);
            this.inverse = bl2 ? -1 : 0;
            this.slope = monochromeParam.slope;
            this.intercept = monochromeParam.intercept;
            this.center = new float[]{f2};
            this.width = new float[]{f3};
            this.pv2dll = monochromeParam.pv2dll;
            this.pvBits = monochromeParam.pvBits;
            this.andmask = monochromeParam.andmask;
            this.lshift = monochromeParam.lshift;
            this.rshift = monochromeParam.rshift;
            this.hashcode = MonochromeParam.hashcode(this.dataType, this.inverse, this.min, this.max, this.slope, this.intercept, this.center, this.width, this.pv2dll);
        }

        @Override
        public boolean isMonochrome() {
            return true;
        }

        @Override
        public ColorModelParam update(float f2, float f3, boolean bl2) {
            if (f3 < 0.0f) {
                throw new IllegalArgumentException("width: " + f3);
            }
            return new MonochromeParam(this, f2, f3, bl2);
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof MonochromeParam)) {
                return false;
            }
            MonochromeParam monochromeParam = (MonochromeParam)object;
            if (this.getNumberOfWindows() == 0 ? monochromeParam.getNumberOfWindows() != 0 : monochromeParam.getNumberOfWindows() == 0 || this.center[0] != monochromeParam.center[0] || this.width[0] != monochromeParam.width[0]) {
                return false;
            }
            return this.inverse == monochromeParam.inverse && this.intercept == monochromeParam.intercept && this.slope == monochromeParam.slope && this.max == monochromeParam.max && this.min == monochromeParam.min && this.pv2dll == monochromeParam.pv2dll;
        }

        @Override
        public final float getRescaleSlope() {
            return this.slope;
        }

        @Override
        public final float getRescaleIntercept() {
            return this.intercept;
        }

        @Override
        public final float getWindowCenter(int n2) {
            return this.center[n2];
        }

        @Override
        public final float getWindowWidth(int n2) {
            return this.width[n2];
        }

        @Override
        public final int getNumberOfWindows() {
            return Math.min(this.center.length, this.width.length);
        }

        @Override
        public final boolean isCacheable() {
            return true;
        }

        @Override
        public final boolean isInverse() {
            return this.inverse != 0;
        }

        @Override
        public final float toMeasureValue(int n2) {
            return (float)this.toSampleValue(n2) * this.slope + this.intercept;
        }

        @Override
        public final int toPixelValue(float f2) {
            return (int)((f2 - this.intercept) / this.slope);
        }

        private static int toARGB(byte by2) {
            int n2 = by2 & 0xFF;
            return 0xFF000000 | n2 << 16 | n2 << 8 | n2;
        }

        @Override
        public ColorModel newColorModel() {
            int[] nArray = new int[this.size];
            if (this.getNumberOfWindows() == 0) {
                if (this.min == 0) {
                    for (int i2 = 0; i2 < this.size; ++i2) {
                        nArray[i2] = MonochromeParam.toARGB(this.pv2dll[(i2 >> this.rshift << this.lshift ^ this.inverse) & this.andmask]);
                    }
                } else {
                    int n2 = 0;
                    int n3 = this.size >> 1;
                    while (n3 < this.size) {
                        nArray[n2] = MonochromeParam.toARGB(this.pv2dll[(n3 >> this.rshift << this.lshift ^ this.inverse) & this.andmask]);
                        nArray[n3] = MonochromeParam.toARGB(this.pv2dll[(n2 >> this.rshift << this.lshift ^ this.inverse) & this.andmask]);
                        ++n3;
                        ++n2;
                    }
                }
            } else {
                this.createCMAP(nArray, (int)((this.center[0] - this.intercept) / this.slope), (int)(this.width[0] / this.slope));
            }
            return new IndexColorModel(this.bits, this.size, nArray, 0, false, -1, this.dataType);
        }

        private void createCMAP(int[] nArray, int n2, int n3) {
            int n4;
            int n5 = n2 - (n3 >> 1);
            int n6 = n5 + n3;
            int n7 = MonochromeParam.toARGB(this.pv2dll[0]);
            int n8 = MonochromeParam.toARGB(this.pv2dll[this.pv2dll.length - 1]);
            if (n5 > 0) {
                Arrays.fill(nArray, 0, Math.min(n5, this.max), this.inverse == 0 ? n7 : n8);
            }
            if (n6 < this.max) {
                Arrays.fill(nArray, Math.max(0, n6), this.max, this.inverse == 0 ? n8 : n7);
            }
            int n9 = Math.min(n6, this.max);
            for (n4 = Math.max(0, n5); n4 < n9; ++n4) {
                nArray[n4] = MonochromeParam.toARGB(this.pv2dll[((n4 - n5 << this.pvBits) / n3 ^ this.inverse) & this.andmask]);
            }
            if (this.min == 0) {
                return;
            }
            if (n5 > this.min) {
                Arrays.fill(nArray, this.size >> 1, Math.min(n5 + this.size, this.size), this.inverse == 0 ? n7 : n8);
            }
            if (n6 < 0) {
                Arrays.fill(nArray, Math.max(n6 + this.size, this.size >> 1), this.size, this.inverse == 0 ? n8 : n7);
            }
            n9 = Math.min(n6, 0);
            for (n4 = Math.max(this.min, n5); n4 < n9; ++n4) {
                nArray[n4 + this.size] = MonochromeParam.toARGB(this.pv2dll[((n4 - n5 << this.pvBits) / n3 ^ this.inverse) & this.andmask]);
            }
        }
    }

    static abstract class BasicColorModelParam
    implements ColorModelParam {
        protected final int dataType;
        protected final int size;
        protected final int bits;
        protected final int min;
        protected final int max;
        protected final int shiftmask;
        protected final int alloc;
        protected final int hBit;

        protected BasicColorModelParam(DicomObject dicomObject) {
            this.alloc = dicomObject.getInt(2621696, 8);
            if (this.alloc <= 8) {
                this.dataType = 0;
            } else if (this.alloc <= 16) {
                this.dataType = 1;
            } else {
                if (this.alloc <= 32) {
                    throw new IllegalArgumentException(this.alloc + " Bits Allocated not supported for Java BufferedImages");
                }
                throw new IllegalArgumentException("Bits allocated " + this.alloc + " not supported");
            }
            this.bits = dicomObject.getInt(2621697, 8);
            this.hBit = dicomObject.getInt(2621698, this.bits - 1);
            this.size = 1 << this.bits;
            if (dicomObject.getInt(2621699, 0) == 0) {
                this.min = 0;
                this.max = this.size;
            } else {
                this.max = this.size >> 1;
                this.min = -this.max;
            }
            this.shiftmask = 32 - this.bits;
        }

        protected BasicColorModelParam(BasicColorModelParam basicColorModelParam) {
            this.alloc = basicColorModelParam.alloc;
            this.hBit = basicColorModelParam.hBit;
            this.dataType = basicColorModelParam.dataType;
            this.size = basicColorModelParam.size;
            this.bits = basicColorModelParam.bits;
            this.min = basicColorModelParam.min;
            this.max = basicColorModelParam.max;
            this.shiftmask = basicColorModelParam.shiftmask;
        }

        @Override
        public final int toSampleValue(int n2) {
            return this.min != 0 ? n2 << this.shiftmask >> this.shiftmask : n2 << this.shiftmask >>> this.shiftmask;
        }

        @Override
        public final int toPixelValueRaw(int n2) {
            int n3 = (1 << this.bits) - 1;
            int n4 = (n2 & n3) << this.hBit - this.bits + 1;
            return n4;
        }
    }

    public static class ColorModelFactory {
        private static final WeakHashMap cache = new WeakHashMap();

        public ColorModel getColorModel(ColorModelParam colorModelParam) {
            if (!colorModelParam.isCacheable()) {
                return colorModelParam.newColorModel();
            }
            ColorModel colorModel = (ColorModel)cache.get(colorModelParam);
            if (colorModel == null) {
                colorModel = colorModelParam.newColorModel();
                cache.put(colorModelParam, colorModel);
            }
            return colorModel;
        }

        public ColorModelParam makeParam(DicomObject dicomObject) {
            return this.makeParam(dicomObject, null);
        }

        public ColorModelParam makeParam(DicomObject dicomObject, byte[] byArray) {
            String string = dicomObject.getString(2621444, "MONOCHROME2");
            if ("PALETTE COLOR".equals(string)) {
                return new PaletteColorParam(dicomObject);
            }
            boolean bl2 = "MONOCHROME1".equals(string);
            if (!bl2 && !"MONOCHROME2".equals(string)) {
                throw new UnsupportedOperationException("pmi: " + string);
            }
            String string2 = dicomObject.getString(0x20500020);
            return new MonochromeParam(dicomObject, string2 == null ? bl2 : "INVERSE".equals(string2), byArray == null ? P2D_IDENTITY : byArray);
        }
    }
}

