/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.dicom.SerializableDicomObject;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.util.ay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

class DicomObjectMapAdapter
implements Serializable,
Map<String, Object> {
    private static final long serialVersionUID = 1L;
    private SerializableDicomObject wrapper;

    public DicomObjectMapAdapter(DicomObject dicomObject) {
        this.wrapper = new SerializableDicomObject(dicomObject);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.wrapper.dob.containsValue(this.keyToTag(object));
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        final HashSet<Map.Entry<String, Object>> hashSet = new HashSet<Map.Entry<String, Object>>();
        this.wrapper.dob.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement dicomElement) {
                hashSet.add(new DicomObjectMapEntry(DicomObjectMapAdapter.this.getKey(dicomElement), DicomObjectMapAdapter.this.parseValueFromDicom(dicomElement)));
                return true;
            }
        });
        return hashSet;
    }

    @Override
    public Object get(Object object) {
        return this.parseValueFromDicom(this.wrapper.dob.get(this.keyToTag(object)));
    }

    @Override
    public boolean isEmpty() {
        return this.wrapper.dob.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        final HashSet hashSet = Sets.newHashSet();
        this.wrapper.dob.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement dicomElement) {
                hashSet.add(DicomObjectMapAdapter.this.getKey(dicomElement));
                return true;
            }
        });
        return hashSet;
    }

    @Override
    public Object put(String string, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.wrapper.dob.size();
    }

    @Override
    public Collection<Object> values() {
        final ArrayList arrayList = Lists.newArrayList();
        this.wrapper.dob.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement dicomElement) {
                arrayList.add(DicomObjectMapAdapter.this.parseValueFromDicom(dicomElement));
                return true;
            }
        });
        return arrayList;
    }

    private int keyToTag(Object object) {
        try {
            return Integer.parseInt(object.toString(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private String getKey(DicomElement dicomElement) {
        return MetabaseKeys.fromTag(dicomElement.tag());
    }

    private Object parseValueFromDicom(DicomElement dicomElement) {
        if (dicomElement == null) {
            return null;
        }
        VR vR = dicomElement.vr();
        int n2 = dicomElement.vm(null);
        try {
            if (vR == VR.AE || vR == VR.AS || vR == VR.CS || vR == VR.LO || vR == VR.LT || vR == VR.PN || vR == VR.SH || vR == VR.ST || vR == VR.UI || vR == VR.UT) {
                if (n2 > 1) {
                    ArrayList arrayList = Lists.newArrayListWithCapacity((int)n2);
                    for (String string : dicomElement.getStrings(this.wrapper.dob.getSpecificCharacterSet(), false)) {
                        arrayList.add(string);
                    }
                    return arrayList;
                }
                return dicomElement.getString(this.wrapper.dob.getSpecificCharacterSet(), false);
            }
            if (vR == VR.AT || vR == VR.IS || vR == VR.SS || vR == VR.US || vR == VR.SL) {
                if (n2 > 1) {
                    ArrayList arrayList = Lists.newArrayListWithCapacity((int)n2);
                    for (int n3 : dicomElement.getInts(false)) {
                        arrayList.add(n3);
                    }
                    return arrayList;
                }
                return dicomElement.getInt(false);
            }
            if (vR == VR.DA || vR == VR.DT || vR == VR.TM) {
                if (n2 > 1) {
                    ArrayList arrayList = Lists.newArrayListWithCapacity((int)n2);
                    for (Date date : dicomElement.getDates(false)) {
                        arrayList.add(date);
                    }
                    return arrayList;
                }
                return dicomElement.getDate(false);
            }
            if (vR == VR.UL) {
                if (n2 > 1) {
                    ArrayList arrayList = Lists.newArrayListWithCapacity((int)n2);
                    for (int n4 : dicomElement.getInts(false)) {
                        arrayList.add((long)n4 & 0xFFFFFFFFL);
                    }
                    return arrayList;
                }
                return (long)dicomElement.getInt(false) & 0xFFFFFFFFL;
            }
            if (vR == VR.FL || vR == VR.FD || vR == VR.DS) {
                if (n2 > 1) {
                    ArrayList arrayList = Lists.newArrayListWithCapacity((int)n2);
                    for (double d2 : dicomElement.getDoubles(false)) {
                        arrayList.add(d2);
                    }
                    return arrayList;
                }
                return dicomElement.getDouble(false);
            }
            if (vR == VR.SQ) {
                ArrayList arrayList = Lists.newArrayListWithCapacity((int)dicomElement.countItems());
                for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                    arrayList.add(new DicomObjectMapAdapter(dicomElement.getDicomObject(i2)));
                }
                return arrayList;
            }
            if (dicomElement.hasFragments()) {
                ArrayList arrayList = Lists.newArrayList();
                for (int i3 = 0; i3 < dicomElement.countItems(); ++i3) {
                    arrayList.add(dicomElement.getFragment(i3));
                }
                return arrayList;
            }
            if (vR == VR.OB || vR == VR.OF || vR == VR.OW || vR == VR.UN || vR == VR.UN_SIEMENS) {
                return dicomElement.getBytes();
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)("Unable to parse DicomObject Tag: " + this.getKey(dicomElement) + " with VR: " + vR.getClass().getSimpleName() + " with VM: " + n2), throwable, this);
        }
        return null;
    }

    private static class DicomObjectMapEntry
    implements Map.Entry<String, Object> {
        private String key;
        private Object value;

        public DicomObjectMapEntry(String string, Object object) {
            this.key = string;
            this.value = object;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object object) {
            this.value = object;
            return this.value;
        }
    }
}

