/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.dicom.DicomSeries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DicomSeriesMapAdapter
implements Map<String, Object> {
    private DicomSeries series;

    public DicomSeriesMapAdapter(DicomSeries dicomSeries) {
        this.series = dicomSeries;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.series.exists(this.keyToTag(object));
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object object) {
        ImmutableList immutableList = this.series.getTagValues(this.keyToTag(object));
        return this.convertToReturnType(immutableList);
    }

    private Object convertToReturnType(ImmutableList<Object> immutableList) {
        if (immutableList.size() > 0 && immutableList.get(0) instanceof DicomSeries) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object e2 : immutableList) {
                builder.add((Object)new DicomSeriesMapAdapter((DicomSeries)e2));
            }
            immutableList = builder.build();
        } else if (immutableList.size() == 0) {
            immutableList = null;
        }
        return immutableList;
    }

    @Override
    public boolean isEmpty() {
        return this.series.getTagKeys().length == 0;
    }

    @Override
    public Set<String> keySet() {
        HashSet hashSet = Sets.newHashSet();
        for (int n2 : this.series.getTagKeys()) {
            Object object = this.convertToReturnType(this.series.getTagValues(n2));
            if (object == null) continue;
            hashSet.add(Integer.toHexString(n2));
        }
        return hashSet;
    }

    @Override
    public Object put(String string, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.series.getTagKeys().length;
    }

    @Override
    public Collection<Object> values() {
        ArrayList arrayList = Lists.newArrayList();
        for (int n2 : this.series.getTagKeys()) {
            Object object = this.convertToReturnType(this.series.getTagValues(n2));
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    private int keyToTag(Object object) {
        return Integer.parseInt(object.toString(), 16);
    }
}

