/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.mimvista.d;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.ImageOrientation;
import com.mimvista.dicom.IsocentricImageOrientation;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.numerics.IOP;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.DateUtils;
import com.mimvista.util.as;
import com.mimvista.util.ay;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DicomSeriesStatic {
    public static int findNextTagsIndex(DicomSeries dicomSeries, int n2, int ... nArray) {
        if (dicomSeries == null || nArray == null || n2 == -1) {
            return -1;
        }
        for (int i2 = n2; i2 < nArray.length; ++i2) {
            if (!dicomSeries.exists(nArray[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static <T> T findFirst(DicomSeries dicomSeries, Collection<Integer> collection) {
        for (int n2 : collection) {
            Object t2 = dicomSeries.getTagValue(n2);
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }

    public static <T> T findFirst(DicomSeries dicomSeries, int ... nArray) {
        return DicomSeriesStatic.findFirst(dicomSeries, Ints.asList((int[])nArray));
    }

    public static List<Integer> getDisplayDateTags() {
        return Lists.newArrayList((Object[])new Integer[]{524321, 524320, 805699592, 805961734, 524322, 524306});
    }

    public static List<Integer> getDisplayTimeTags() {
        return Lists.newArrayList((Object[])new Integer[]{524338, 524337, 524336, 805699593, 805961735, 524307});
    }

    @d
    public static Date findFirstDateTime(DicomSeries dicomSeries, int ... nArray) {
        return DicomSeriesStatic.findFirstDateTime(dicomSeries, Ints.asList((int[])nArray));
    }

    @d
    public static Date findFirstDateTime(DicomSeries dicomSeries, Collection<Integer> collection) {
        for (int n2 : collection) {
            Integer n3 = RawDicomUtils.getTimeTagForDateTag(n2);
            Date date = null;
            date = n3 != null ? DicomSeriesStatic.getDateTime(dicomSeries, n2, n3) : DicomSeriesStatic.getDate(dicomSeries, n2);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    @d
    public static Integer getInt(DicomSeries dicomSeries, final int n2) {
        final Object t2 = dicomSeries.getTagValue(n2);
        if (t2 == null) {
            return null;
        }
        if (t2 instanceof Number) {
            return ((Number)t2).intValue();
        }
        if (t2 instanceof String) {
            try {
                return Integer.parseInt((String)t2);
            }
            catch (NumberFormatException numberFormatException) {
                FuncUtils.a(new Runnable(){

                    @Override
                    public void run() {
                        String string = String.format("Couldn't parse the string value for tag %x (%s) as an Integer: \"%s\"", n2, TagUtils.getTagName(n2), t2);
                        ay.d((Object)string, (Throwable)numberFormatException, DicomSeriesStatic.class);
                    }
                }, 1000L);
                return null;
            }
        }
        final RuntimeException runtimeException = new RuntimeException(String.format("Can't convert %s to an Integer", t2.getClass().getName()));
        FuncUtils.a(new Runnable(){

            @Override
            public void run() {
                ay.d((Object)String.format("Error converting tag %x (%s) to an Integer", n2, TagUtils.getTagName(n2)), (Throwable)runtimeException, DicomSeriesStatic.class);
            }
        }, 1000L);
        return null;
    }

    @d
    public static Long getLong(DicomSeries dicomSeries, final int n2) {
        final Object t2 = dicomSeries.getTagValue(n2);
        if (t2 == null) {
            return null;
        }
        if (t2 instanceof Number) {
            return ((Number)t2).longValue();
        }
        if (t2 instanceof String) {
            try {
                Long l2 = Long.parseLong((String)t2);
                if (l2 != null) {
                    return l2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                FuncUtils.a(new Runnable(){

                    @Override
                    public void run() {
                        String string = String.format("Couldn't parse the string value for tag %x (%s) as a Long: \"%s\"", n2, TagUtils.getTagName(n2), t2);
                        ay.d((Object)string, DicomSeriesStatic.class);
                    }
                }, 1000L);
            }
            return null;
        }
        final RuntimeException runtimeException = new RuntimeException(String.format("Can't convert %s to a Long", t2.getClass().getName()));
        FuncUtils.a(new Runnable(){

            @Override
            public void run() {
                ay.d((Object)String.format("Error converting tag %x (%s) to a Long", n2, TagUtils.getTagName(n2)), (Throwable)runtimeException, DicomSeriesStatic.class);
            }
        }, 1000L);
        return null;
    }

    @d
    public static Double getDouble(DicomSeries dicomSeries, final int n2) {
        Serializable serializable;
        final Object t2 = dicomSeries.getTagValue(n2);
        if (t2 == null) {
            return null;
        }
        if (t2 instanceof Number) {
            return ((Number)t2).doubleValue();
        }
        if (t2 instanceof String) {
            try {
                serializable = Double.parseDouble((String)t2);
                if (serializable != null) {
                    return serializable;
                }
            }
            catch (NumberFormatException numberFormatException) {
                FuncUtils.a(new Runnable(){

                    @Override
                    public void run() {
                        String string = String.format("Couldn't parse the string value for tag %x (%s) as a Double: \"%s\"", n2, TagUtils.getTagName(n2), t2);
                        ay.d((Object)string, (Throwable)numberFormatException, DicomSeriesStatic.class);
                    }
                }, 1000L);
            }
        }
        serializable = new RuntimeException(String.format("Can't convert %s to a Double", t2.getClass().getName()));
        FuncUtils.a(new Runnable((Exception)serializable){
            final /* synthetic */ Exception val$ex;
            {
                this.val$ex = exception;
            }

            @Override
            public void run() {
                ay.d((Object)String.format("Error converting tag %x (%s) to a Double", n2, TagUtils.getTagName(n2)), (Throwable)this.val$ex, DicomSeriesStatic.class);
            }
        }, 1000L);
        return null;
    }

    @d
    public static Date getDate(DicomSeries dicomSeries, final int n2) {
        Object t2 = dicomSeries.getTagValue(n2);
        if (t2 == null) {
            return null;
        }
        if (t2 instanceof Date) {
            return (Date)t2;
        }
        if (t2 instanceof String) {
            return DateUtils.i((String)t2);
        }
        final RuntimeException runtimeException = new RuntimeException(String.format("Can't convert %s to a Date", t2.getClass().getName()));
        FuncUtils.a(new Runnable(){

            @Override
            public void run() {
                ay.d((Object)String.format("Error converting tag %x (%s) to a Date", n2, TagUtils.getTagName(n2)), (Throwable)runtimeException, DicomSeriesStatic.class);
            }
        }, 1000L);
        return null;
    }

    @d
    public static Date getTime(DicomSeries dicomSeries, final int n2) {
        Object t2 = dicomSeries.getTagValue(n2);
        if (t2 == null) {
            return null;
        }
        if (t2 instanceof Date) {
            return (Date)t2;
        }
        if (t2 instanceof String) {
            return DateUtils.j((String)t2);
        }
        final RuntimeException runtimeException = new RuntimeException(String.format("Can't convert %s to a Date", t2.getClass().getName()));
        FuncUtils.a(new Runnable(){

            @Override
            public void run() {
                ay.d((Object)String.format("Error converting tag %x (%s) to a Date", n2, TagUtils.getTagName(n2)), (Throwable)runtimeException, DicomSeriesStatic.class);
            }
        }, 1000L);
        return null;
    }

    @d
    public static Date getDateTime(DicomSeries dicomSeries, final int n2) {
        Object t2 = dicomSeries.getTagValue(n2);
        if (t2 == null) {
            return null;
        }
        if (t2 instanceof Date) {
            return (Date)t2;
        }
        if (t2 instanceof String) {
            return DateUtils.k((String)t2);
        }
        final RuntimeException runtimeException = new RuntimeException(String.format("Can't convert %s to a Date", t2.getClass().getName()));
        FuncUtils.a(new Runnable(){

            @Override
            public void run() {
                ay.d((Object)String.format("Error converting tag %x (%s) to a Date", n2, TagUtils.getTagName(n2)), (Throwable)runtimeException, DicomSeriesStatic.class);
            }
        }, 1000L);
        return null;
    }

    @d
    public static Date getDateTime(DicomSeries dicomSeries, int n2, int n3) {
        Date date = DicomSeriesStatic.getDate(dicomSeries, n2);
        if (date != null) {
            return DateUtils.b(date, DicomSeriesStatic.getTime(dicomSeries, n3));
        }
        return null;
    }

    @d
    public static ImageOrientation getImageOrientationPatient(DicomSeries dicomSeries) {
        try {
            Object object;
            Object object2 = dicomSeries.getTagValues(2097207);
            if (object2.size() != 6 && !SeriesIdentifier.is2D(dicomSeries) && "1.2.840.10008.5.1.4.1.1.20".equals(dicomSeries.getTagValue(524310)) && (object = (DicomSeries)dicomSeries.getTagValue(5505058)) != null) {
                object2 = dicomSeries.getTagValues(2097207);
            }
            if (object2.size() != 6 && (object = SimpleOrientationHelper.a(dicomSeries)) != null) {
                object2 = IOP.a((IOP)object);
            }
            return new ImageOrientation((Collection<? extends Number>)object2);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @d
    public static IsocentricImageOrientation getIsocentricImageOrientation(DicomSeries dicomSeries) {
        try {
            Double d2 = (Double)dicomSeries.getTagValue(805962014);
            Object object = dicomSeries.getTagValues(805962028);
            if (object == null || object.isEmpty()) {
                object = Doubles.asList((double[])new double[]{0.0, 0.0, 0.0});
            }
            return new IsocentricImageOrientation(d2, (Collection<? extends Number>)object);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean isProjectionImage(DicomSeries dicomSeries) {
        ImmutableList immutableList = dicomSeries.getTagValues(524296);
        return immutableList != null && as.b(immutableList, "projection image");
    }

    public static String getNumberOfImages(DicomSeries dicomSeries) {
        String string;
        Object t2 = dicomSeries.getTagValue(1253536);
        if (t2 != null && Integer.valueOf(string = String.valueOf(t2)) > 0) {
            return string;
        }
        string = dicomSeries.getTagValue(2101769);
        if (string != null) {
            return String.valueOf(string);
        }
        return "";
    }

    private DicomSeriesStatic() {
    }
}

